#ifndef __DESKTOP_H
#define __DESKTOP_H
//----------------------------------------------------------------------------
#include "Container.h"
#include "Resource.h"
#include "Action.h"
//----------------------------------------------------------------------------
class Timer;
class Trash;
class ScreenCapture;
//----------------------------------------------------------------------------
class Desktop: public Resource, public Container, public ActionControl {
private:
	vector<Link*> items;
	Timer *timer;
	Trash *trash;
	ScreenCapture *capturer;

	bool shutdown;
public:
	static Desktop *Instance;

	Desktop();
	~Desktop();

	void Load();
	void Save();
	void Arrange();
	void Refresh();
	void Reload();
	void SetLock( bool l );

	void Add( Link *l );
	void Delete( Link *l );

	void Process();
	void Perform( int id );

	static void ProcessEvent( XEvent *e );
private:
	void CreateMenu();
	void DeleteMenu();
};

//----------------------------------------------------------------------------
// DESKTOP EVENTS
enum {
	DESKTOP_LINK	= 0,
	DESKTOP_REFRESH	= 2,
	DESKTOP_RELOAD	= 3,
	DESKTOP_LOCK	= 4,
	DESKTOP_CAPTURE	= 6,
	DESKTOP_SETTING = 8,
	DESKTOP_ABOUT	= 9,
	DESKTOP_EXIT	= 11,
};

//----------------------------------------------------------------------------
#endif
