#include <stdlib.h>		/* for alloca() */
#include <stddef.h>		/* for offsetof() */
#include <string.h>
#include <stdio.h>

#include "misc_functions.h"
#include "gtk1_patches.h"

#ifdef GTK1
/* Patch control */
static void patch_install (GtkObjectClass *klass, size_t offset,
								GtkFunction func, GtkFunction * old_func_ptr);
static void patch_restore (GtkObjectClass *klass, size_t offset,
								GtkFunction func, GtkFunction old_func);

/* Patches */
static void _vscale_draw_trough (GtkRange *);
static void _hscale_draw_trough (GtkRange *);
static void _vscale_draw_slider (GtkRange *);
static void _hscale_draw_slider (GtkRange *);

static gint _vscale_expose_event(GtkWidget *, GdkEventExpose *);
static void _vscale_draw_focus (GtkWidget *);
static gint _hscale_expose_event(GtkWidget *, GdkEventExpose *);
static void _hscale_draw_focus (GtkWidget *);

#if PANEDPATCH
static void _vpaned_realize (GtkWidget *);
static void _hpaned_realize (GtkWidget *);
static void _vpaned_size_allocate(GtkWidget *, GtkAllocation *);
static void _hpaned_size_allocate(GtkWidget *, GtkAllocation *);

static gint _vpaned_enter_notify_event (GtkWidget *, GdkEventCrossing *);
static gint _hpaned_enter_notify_event (GtkWidget *, GdkEventCrossing *);
static gint _vpaned_leave_notify_event (GtkWidget *, GdkEventCrossing *);
static gint _hpaned_leave_notify_event (GtkWidget *, GdkEventCrossing *);
#endif

static void _spin_button_size_allocate (GtkWidget *, GtkAllocation *);
static void _spin_button_changed (GtkEditable *);
static void _spin_button_realize (GtkWidget *);
static gint _spin_button_button_press_event (GtkWidget *, GdkEventButton *);

/*
 *	Original (or previous) functions and values
 */
#if PANEDPATCH
static void (* old_vpaned_size_allocate)(GtkWidget *, GtkAllocation *);
static void (* old_hpaned_size_allocate)(GtkWidget *, GtkAllocation *);
static void (* old_vpaned_realize)(GtkWidget *);
static void (* old_hpaned_realize)(GtkWidget *);

static gint (* old_vpaned_enter_notify_event)(GtkWidget *, GdkEventCrossing *);
static gint (* old_hpaned_enter_notify_event)(GtkWidget *, GdkEventCrossing *);
static gint (* old_vpaned_leave_notify_event)(GtkWidget *, GdkEventCrossing *);
static gint (* old_hpaned_leave_notify_event)(GtkWidget *, GdkEventCrossing *);
#endif

static void (* old_hscale_draw_trough)(GtkRange *);
static void (* old_hscale_draw_slider)(GtkRange *);
static gint (* old_hscale_expose_event)(GtkWidget *, GdkEventExpose *);
static void (* old_hscale_draw_focus)(GtkWidget *);

static void (* old_vscale_draw_trough)(GtkRange *);
static void (* old_vscale_draw_slider)(GtkRange *);
static gint (* old_vscale_expose_event)(GtkWidget *, GdkEventExpose *);
static void (* old_vscale_draw_focus)(GtkWidget *);

static void (* old_spin_button_size_allocate)(GtkWidget *, GtkAllocation *);
static void (* old_spin_button_changed)(GtkEditable *);
static void (* old_spin_button_realize)(GtkWidget *);
static gint (* old_spin_button_button_press_event)(GtkWidget *, GdkEventButton *);

static GtkWidgetClass * spin_button_parent_class = NULL;

static gint old_scrollbar_spacing;

static gint patch_count = 0;

/*
	Install and Remove
*/

#define PATCH_INSTALL(klass, type, name, field) \
	patch_install ((GtkObjectClass *)klass, offsetof(type, field), \
						(GtkFunction) _ ## name ## _ ## field, (GtkFunction *) &old_ ## name ## _ ## field)

#define PATCH_RESTORE(klass, type, name, field) \
	patch_restore ((GtkObjectClass *)klass, offsetof(type, field), \
						(GtkFunction) _ ## name ## _ ## field, (GtkFunction) old_ ## name ## _ ## field)
#endif

/* remember what is patched */

guint16 patch_config	= PATCH_DEFAULT;

void patches_install () {
#ifdef GTK1
	GtkWidgetClass	*widget_class;
	const char *config, *token;
	int n, mod, invert;
	
	/* Test if we should install patches */
	if (patch_count++ != 0)
		return;
	
	config = getenv("THEME_PATCH");
	if (config) {
		/* scan */
		patch_config = 0;
		token = config;
		invert = 0;
		while(1) {
			while (*token == ' ')
				++token;
			
			if ((n = strcspn(token, " _\n")) == 0)
				break;
			
			if (strncasecmp(token, "NOT ", 4) == 0) {
				invert ^= 1;
			} else {
				mod = 0;
				
				if (strncasecmp(token, "GTK", 3) == 0)
					token += 3;
				
				if (strncasecmp(token, "SCALE", 5) == 0) {
					mod = PATCH_SCALE;
				#if PANEDPATCH
				} else if (strncasecmp(token, "PANE", 4) == 0 || strncasecmp(token, "RESIZE", 6) == 0) {
					mod = PATCH_PANED;
				#endif	
				} else if (strncasecmp(token, "SPIN", 4) == 0 || strncasecmp(token, "NUM", 3) == 0) {
					mod = PATCH_SPIN_BUTTON;
				} else if (   strncasecmp(token, "ALL", 3) == 0
						   || strncasecmp(token, "YES", 3) == 0
						   || strncasecmp(token, "TRUE", 4) == 0)
				{
					mod = PATCH_ALL;
				} else if (strncasecmp(token, "DEFAULT", 3) == 0) {
					mod = PATCH_DEFAULT;
				} else if (   strncasecmp(token, "NO", 2) == 0
						   || strncasecmp(token, "FALSE", 6) == 0)
				{
					invert ^= 1;
					mod = PATCH_ALL;
				}
				
				if (invert) {
					patch_config &= ~mod;
					invert = 0;
				} else {
					patch_config |= mod;
				}
			}
			
			token += n;
		}
	}
	
	/* Make entire panes sensitive */
	#if PANEDPATCH
	if (patch_config & PATCH_PANED) {
		widget_class = (GtkWidgetClass *)gtk_type_class(gtk_vpaned_get_type());
		
		PATCH_INSTALL(widget_class, GtkWidgetClass, vpaned, size_allocate);
		PATCH_INSTALL(widget_class, GtkWidgetClass, vpaned, realize);
		PATCH_INSTALL(widget_class, GtkWidgetClass, vpaned, enter_notify_event);
		PATCH_INSTALL(widget_class, GtkWidgetClass, vpaned, leave_notify_event);
		
		widget_class = (GtkWidgetClass *)gtk_type_class(gtk_hpaned_get_type());
		PATCH_INSTALL(widget_class, GtkWidgetClass, hpaned, size_allocate);
		PATCH_INSTALL(widget_class, GtkWidgetClass, hpaned, realize);
		PATCH_INSTALL(widget_class, GtkWidgetClass, hpaned, enter_notify_event);
		PATCH_INSTALL(widget_class, GtkWidgetClass, hpaned, leave_notify_event);
	}
	#endif

	/* Draw sliders differently */
	if (patch_config & PATCH_SCALE) {
		widget_class = (GtkWidgetClass *)gtk_type_class(gtk_hscale_get_type());
		PATCH_INSTALL(widget_class, GtkRangeClass, hscale, draw_trough);
		PATCH_INSTALL(widget_class, GtkRangeClass, hscale, draw_slider);
		PATCH_INSTALL(widget_class, GtkWidgetClass, hscale, expose_event);
		PATCH_INSTALL(widget_class, GtkWidgetClass, hscale, draw_focus);
		
		widget_class = (GtkWidgetClass *)gtk_type_class(gtk_vscale_get_type());
		PATCH_INSTALL(widget_class, GtkRangeClass, vscale, draw_trough);
		PATCH_INSTALL(widget_class, GtkRangeClass, vscale, draw_slider);
		PATCH_INSTALL(widget_class, GtkWidgetClass, vscale, expose_event);
		PATCH_INSTALL(widget_class, GtkWidgetClass, vscale, draw_focus);
	}
	
	/* GtkSpinButton */
	if (patch_config & PATCH_SPIN_BUTTON) {
		widget_class = (GtkWidgetClass *)gtk_type_class(gtk_spin_button_get_type());
		PATCH_INSTALL(widget_class, GtkWidgetClass, spin_button, size_allocate);
		PATCH_INSTALL(widget_class, GtkWidgetClass, spin_button, realize);
		PATCH_INSTALL(widget_class, GtkEditableClass, spin_button, changed);
		PATCH_INSTALL(widget_class, GtkWidgetClass, spin_button, button_press_event);
		spin_button_parent_class = GTK_WIDGET_CLASS(gtk_type_parent_class(gtk_spin_button_get_type()));
	}
#endif
}


void patches_uninstall () {
#ifdef GTK1

	GtkWidgetClass	*widget_class;
	
	if (patch_count == 0)
		return;
	
	patch_count = 0;

	/* GtkSpinButton */
	if (patch_config & PATCH_SPIN_BUTTON) {
		widget_class = (GtkWidgetClass *)gtk_type_class(gtk_spin_button_get_type());
		PATCH_RESTORE(widget_class, GtkWidgetClass, spin_button, button_press_event);
		PATCH_RESTORE(widget_class, GtkEditableClass, spin_button, changed);
		PATCH_RESTORE(widget_class, GtkWidgetClass, spin_button, realize);
		PATCH_RESTORE(widget_class, GtkWidgetClass, spin_button, size_allocate);
	}

	/* GtkVScale, GtkHScale */
	if (patch_config & PATCH_SCALE) {
		widget_class = (GtkWidgetClass *)gtk_type_class(gtk_vscale_get_type());
		PATCH_RESTORE(widget_class, GtkWidgetClass, vscale, draw_focus);
		PATCH_RESTORE(widget_class, GtkWidgetClass, vscale, expose_event);
		PATCH_RESTORE(widget_class, GtkRangeClass, vscale, draw_slider);
		PATCH_RESTORE(widget_class, GtkRangeClass, vscale, draw_trough);

		widget_class = (GtkWidgetClass *)gtk_type_class(gtk_hscale_get_type());
		PATCH_RESTORE(widget_class, GtkWidgetClass, hscale, draw_focus);
		PATCH_RESTORE(widget_class, GtkWidgetClass, hscale, expose_event);
		PATCH_RESTORE(widget_class, GtkRangeClass, hscale, draw_slider);
		PATCH_RESTORE(widget_class, GtkRangeClass, hscale, draw_trough);
	}

	/* GtkVPaned, GtkHPaned.. they suck btw, use my new paned table class and be happy!
	   You can find it at <http://www.obsession.se/johan/gtk.html>.
	*/
        #if PANEDPATCH
	if (patch_config & PATCH_PANED) {
		widget_class = (GtkWidgetClass *)gtk_type_class(gtk_hpaned_get_type());
		PATCH_RESTORE(widget_class, GtkWidgetClass, hpaned, leave_notify_event);
		PATCH_RESTORE(widget_class, GtkWidgetClass, hpaned, enter_notify_event);
		PATCH_RESTORE(widget_class, GtkWidgetClass, hpaned, realize);
		PATCH_RESTORE(widget_class, GtkWidgetClass, hpaned, size_allocate);
	
		widget_class = (GtkWidgetClass *)gtk_type_class(gtk_vpaned_get_type());
		PATCH_RESTORE(widget_class, GtkWidgetClass, vpaned, leave_notify_event);
		PATCH_RESTORE(widget_class, GtkWidgetClass, vpaned, enter_notify_event);
		PATCH_RESTORE(widget_class, GtkWidgetClass, vpaned, realize);
		PATCH_RESTORE(widget_class, GtkWidgetClass, vpaned, size_allocate);
	}
	#endif
#endif
}
#ifdef GTK1



/*
 *	Patch Control
 */
void patch_install (GtkObjectClass *klass, size_t offset,
						 GtkFunction func, GtkFunction * old_func_ptr)
{
	GtkFunction	*ptr;
	
	ptr = (GtkFunction *)((guchar *)klass + offset);
	
	*old_func_ptr = *ptr;
	if (*ptr == func) {
	}
	
	*ptr = func;
}


void patch_restore (GtkObjectClass *klass, size_t offset,
						 GtkFunction func, GtkFunction old_func)
{
	GList		*child;
	GtkFunction	*ptr;

	ptr = (GtkFunction *)((guchar *)klass + offset);
	if (*ptr == func)
		*ptr = old_func;

	for (child = gtk_type_children_types(klass->type); child; child = child->next)
		patch_restore (gtk_type_class(GPOINTER_TO_UINT(child->data)),
							offset, func, old_func);
}


/*
 * Patched functions
 */
#define RANGE_CLASS(widget) \
	GTK_RANGE_CLASS(GTK_OBJECT(widget)->klass)

/* Panes */
#if PANEDPATCH
static void 
_hpaned_realize (GtkWidget *widget) {
	GdkCursor *crsr;
	
	g_return_if_fail (widget != NULL);
	g_return_if_fail (GTK_IS_HPANED(widget));

	old_hpaned_realize(widget);
		crsr = gdk_cursor_new(GDK_SB_H_DOUBLE_ARROW);
		gdk_window_set_cursor(GTK_PANED(widget)->handle, crsr);
		gdk_cursor_destroy(crsr);
		gdk_window_set_events(GTK_PANED(widget)->handle,
							    gdk_window_get_events(GTK_PANED(widget)->handle)
							  | GDK_ENTER_NOTIFY_MASK | GDK_LEAVE_NOTIFY_MASK);
		_hpaned_size_allocate (widget, &(widget->allocation));
}

static void 
_hpaned_size_allocate (GtkWidget *widget, GtkAllocation *allocation) {
	GtkPaned	*paned;
	gint		x, width, bw;
	
	g_return_if_fail (widget != NULL);
	g_return_if_fail (GTK_IS_HPANED(widget));

		paned = ((GtkPaned*)widget);
		paned->handle_size = paned->gutter_size;
	
		old_hpaned_size_allocate (widget, allocation);
		if (GTK_WIDGET_REALIZED(widget)) {
			gdk_window_get_geometry(paned->handle, &x, NULL, &width, NULL, NULL);
			bw = ((GtkContainer *)widget)->border_width;
			gdk_window_move_resize (paned->handle,
									x + (paned->handle_size - 6)/2,
									bw,
									6,
									widget->allocation.height - bw - bw);
		}
		gtk_widget_queue_draw(widget);
}

static void _vpaned_realize (GtkWidget *widget) {
	GdkCursor *crsr;
	
	g_return_if_fail (widget != NULL);
	g_return_if_fail (GTK_IS_VPANED(widget));

	old_vpaned_realize(widget);
		crsr = gdk_cursor_new(GDK_SB_V_DOUBLE_ARROW);
		gdk_window_set_cursor(GTK_PANED(widget)->handle, crsr);
		gdk_cursor_destroy(crsr);
		gdk_window_set_events(GTK_PANED(widget)->handle,
							    gdk_window_get_events(GTK_PANED(widget)->handle)
							  | GDK_ENTER_NOTIFY_MASK | GDK_LEAVE_NOTIFY_MASK);
		_vpaned_size_allocate (widget, &(widget->allocation));
}

static void 
_vpaned_size_allocate (GtkWidget *widget, GtkAllocation *allocation) {
	GtkPaned	*paned;
	gint		y, height, bw;
	
	g_return_if_fail (widget != NULL);
	g_return_if_fail (GTK_IS_VPANED(widget));

		paned = ((GtkPaned*)widget);
		paned->handle_size = paned->gutter_size;
	
		old_vpaned_size_allocate (widget, allocation);
		if (GTK_WIDGET_REALIZED(widget)) {
			gdk_window_get_geometry(paned->handle, NULL, &y, NULL, &height, NULL);
			bw = ((GtkContainer *)widget)->border_width;
			gdk_window_move_resize (paned->handle,
									bw,
									y + (paned->handle_size - 6)/2,
									widget->allocation.width - bw - bw,
									6);
		}
		gtk_widget_queue_draw(widget);
}

static void paned_fake_event (GtkWidget *widget) {
	GdkEventExpose event;
	gint width, height;
	
	g_return_if_fail (widget != NULL);
	g_return_if_fail (GTK_IS_PANED(widget));
	
	event.type = GDK_EXPOSE;
	event.send_event = 1;
	event.window = GTK_PANED(widget)->handle;
	gdk_window_get_size (event.window, &width, &height);
	event.area.x = event.area.y = 0;
	event.area.width = width;
	event.area.height = height;
	event.count = 0;
	
	gdk_event_put ((GdkEvent *)&event);
}

static gint 
_vpaned_enter_notify_event (GtkWidget *widget, GdkEventCrossing *event) {
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	g_return_val_if_fail (GTK_IS_VPANED(widget), FALSE);
	
	paned_fake_event(widget);
	return TRUE;
}

static gint 
_vpaned_leave_notify_event (GtkWidget *widget, GdkEventCrossing *event) {
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	g_return_val_if_fail (GTK_IS_VPANED(widget), FALSE);
	
	paned_fake_event(widget);
	return TRUE;
}

static gint 
_hpaned_enter_notify_event (GtkWidget *widget, GdkEventCrossing *event) {
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	g_return_val_if_fail (GTK_IS_HPANED(widget), FALSE);

	paned_fake_event(widget);
	return TRUE;
}

static gint 
_hpaned_leave_notify_event (GtkWidget *widget, GdkEventCrossing *event) {
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	g_return_val_if_fail (GTK_IS_HPANED(widget), FALSE);
	
	paned_fake_event(widget);
	return TRUE;
}

#endif

/* GtkScale */

static gint 
_hscale_expose_event(GtkWidget *widget, GdkEventExpose *event) {
	return _vscale_expose_event(widget, event);
}

static gint 
_vscale_expose_event(GtkWidget *widget, GdkEventExpose *event) {
	GtkRange *range;
	
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (GTK_IS_SCALE (widget), FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	
	range = GTK_RANGE (widget);
	
	if (event->window == range->trough) {
		/* no declining to draw */
		gtk_range_draw_trough(range);
	} else if (event->window == range->slider) {
		gtk_range_draw_slider(range);
	} else if (event->window == range->step_forw) {
		gtk_range_draw_step_forw(range);
	} else if (event->window == range->step_back) {
		gtk_range_draw_step_back(range);
	} else if (event->window == widget->window) {
		gtk_range_draw_background(range);
	}
	return FALSE;
}

static void 
_hscale_draw_focus (GtkWidget *widget) {
	_vscale_draw_focus(widget);
}

static void 
_vscale_draw_focus (GtkWidget *widget) {
	g_return_if_fail (widget != NULL);
	g_return_if_fail (GTK_IS_SCALE (widget));
	
	if (GTK_WIDGET_DRAWABLE (widget))
		gtk_range_draw_slider (GTK_RANGE (widget));
}


/* GtkHScale */
static void _hscale_draw_trough (GtkRange *range) {
	GtkStyle *style;
	int trough_y, trough_width, trough_height, xt, yt;
	
	g_return_if_fail (range != NULL);
	g_return_if_fail (GTK_IS_HSCALE (range));
	
	if (range->trough) {
		style = ((GtkWidget *)range)->style;
		
		gtk_paint_flat_box (((GtkWidget *)range)->parent->style, range->trough,
							((GtkWidget *)range)->parent->state, GTK_SHADOW_NONE, NULL,
							(GtkWidget *)range, "scale trough", 0, 0, -1, -1);
		gtk_paint_box (style, range->trough,
					   ((GtkWidget*)range)->state==GTK_STATE_INSENSITIVE
					   ? GTK_STATE_INSENSITIVE
					   : GTK_STATE_ACTIVE,
					   GTK_SHADOW_IN, NULL,
					   (GtkWidget *)range, "trough", 0, 0, -1, -1);
	}
}

static void 
_hscale_draw_slider (GtkRange *range) {
	GtkStateType state_type;
	
	g_return_if_fail (range != NULL);
	g_return_if_fail (GTK_IS_HSCALE (range));
	
	if (range->slider) {
		if ((range->in_child == RANGE_CLASS (range)->slider) ||
			(range->click_child == RANGE_CLASS (range)->slider))
			state_type = GTK_STATE_PRELIGHT;
		else
			state_type = GTK_STATE_NORMAL;
		
		gtk_paint_slider (GTK_WIDGET (range)->style, range->slider, state_type, 
						  GTK_SHADOW_OUT, NULL, GTK_WIDGET (range), "hscale",
						  0, 0, -1, -1, GTK_ORIENTATION_HORIZONTAL);
	}
}

/* GtkVScale */

static void 
_vscale_draw_trough (GtkRange *range) {
	GtkStyle *style;

	g_return_if_fail (range != NULL);
	g_return_if_fail (GTK_IS_VSCALE (range));
	
	if (range->trough) {
		style = ((GtkWidget *)range)->style;
			
		gtk_paint_flat_box (((GtkWidget *)range)->parent->style, range->trough,
							((GtkWidget *)range)->parent->state, GTK_SHADOW_NONE, NULL,
							(GtkWidget *)range, "scale trough", 0, 0, -1, -1);
		gtk_paint_box (style, range->trough,
					   ((GtkWidget*)range)->state==GTK_STATE_INSENSITIVE
					   ? GTK_STATE_INSENSITIVE
					   : GTK_STATE_ACTIVE,
					   GTK_SHADOW_IN, NULL,
					   (GtkWidget *)range, "trough", 0, 0, -1, -1);
	}
}

static void 
_vscale_draw_slider (GtkRange *range) {
	GtkStateType state_type;
	
	g_return_if_fail (range != NULL);
	g_return_if_fail (GTK_IS_VSCALE (range));
	
	if (range->slider) {
		if ((range->in_child == RANGE_CLASS (range)->slider) ||
			(range->click_child == RANGE_CLASS (range)->slider))
			state_type = GTK_STATE_PRELIGHT;
		else
			state_type = GTK_STATE_NORMAL;

		gtk_paint_slider (GTK_WIDGET (range)->style, range->slider, state_type,
						  GTK_SHADOW_OUT, NULL, GTK_WIDGET (range), "hscale",
						  0, 0, -1, -1, GTK_ORIENTATION_VERTICAL);
	}
}

/* GtkSpinButton */

static void
_spin_button_changed (GtkEditable *editable)
{
	GtkEntry	*entry;
	gint		text_area_width;
	gint		char_width, text_width;
	
	g_return_if_fail (editable != NULL);
	g_return_if_fail (GTK_IS_ENTRY (editable));
	g_return_if_fail (GTK_IS_SPIN_BUTTON (editable));
	
	entry = GTK_ENTRY(editable);
	
	if (!entry->text_area)
		return;
	
	gdk_window_get_size (entry->text_area, &text_area_width, NULL);
	
	char_width = gdk_char_width (GTK_WIDGET(entry)->style->font, (gchar)'X');
	
	entry->scroll_offset = 0;
	
	/* Right-justify numbers */
	if (entry->text) {
		text_width = gdk_text_width (GTK_WIDGET(entry)->style->font,
									 gtk_entry_get_text (entry),
									 strlen (gtk_entry_get_text(entry)));

		entry->scroll_offset = -(text_area_width - text_width) + 4;
	} else {
		entry->scroll_offset = -text_area_width;
	}
	
	gtk_widget_queue_draw(GTK_WIDGET(entry));
}

static void
_spin_button_size_allocate (GtkWidget		*widget,
								GtkAllocation	*allocation)
{
	g_return_if_fail (widget != NULL);
	g_return_if_fail (GTK_IS_SPIN_BUTTON (widget));
	g_return_if_fail (allocation != NULL);
	
	widget->allocation = *allocation;
	old_spin_button_size_allocate (widget, allocation);
	
	if (GTK_WIDGET_REALIZED (widget))
		_spin_button_changed ((GtkEditable *)widget);
}

static void
_spin_button_realize (GtkWidget *widget) {
	g_return_if_fail (widget != NULL);
	g_return_if_fail (GTK_IS_SPIN_BUTTON(widget));
	
	old_spin_button_realize (widget);
	_spin_button_changed ((GtkEditable *)widget);
}

static gint
_spin_button_button_press_event (GtkWidget *widget, GdkEventButton *event)
{
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (GTK_IS_SPIN_BUTTON(widget), FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	
	if (!GTK_WIDGET_HAS_FOCUS (widget))
		gtk_widget_grab_focus(widget);
	
	return old_spin_button_button_press_event (widget, event);
}
#endif
