#! /bin/sh
# rc.X   launch display manager if the system is going to level 4/5
#
# Origin : from rc.4 of Slackware 9.0
# Rewritten by Eko M. Budi to adapt vlinit system.
#
# GNU GPL (c) Eko M. Budi, 2004
#         (c) Vector Linux, 2004

# This setting will be changed by vxdmset
DISPLAY_MANAGER=WDM

#####################################################
# Don't touch below these. Expert is excepted ;)

KDM_CMD=/opt/kde/bin/kdm
GDM_CMD=/opt/gnome2/bin/gdm
WDM_CMD=/usr/X11R6/bin/wdm
XDM_CMD=/usr/X11R6/bin/xdm

# Tell the viewers what's going to happen...
# /etc/rc.d/rc.sysvinit
echoc "==> rc.X Going to multiuser GUI mode ..." yellow

# Check if respawned less then 1 minute, then go init 2
BOOTX=bootx.status
TEST=`find /tmp -amin -1 -name $BOOTX`
if [ "$TEST" ]; then
  echoc "WARNING: Previous failed attempt is detected." red
  echo "I'm going to put the system back to text mode login"
  echo "Please do the following:"
  echo " - Check your X-Windows setting."
  echo "   Use VASM or manually edit /etc/X11/XF86Config (sigh) !"
  echo " - Test to launch X-Windows from console, call: startx"
  echo " - Check that your display manager ($DISPLAY_MANAGER) is working" 
  echo " - Then you may try again to call: init $RUNLEVEL"
  echo 
  echoc "Canceling GUI login mode" red 
  rm /tmp/$BOOTX
  exec init 2
fi
rm -f /tmp/$BOOTX
echo 'BOOTX="NORMAL"' > /tmp/$BOOTX

for DM in $DISPLAY_MANAGER KDM GDM WDM XDM; do
  case $DM in
  KDM)
    if [ -x $KDM_CMD ]; then
      echo KDE Display Manager
      exec $KDM_CMD -nodaemon
    fi
    ;;
  GDM)
    if [ -x $GDM_CMD ]; then
      echo GNOME Display Manager
      exec $GDM_CMD -nodaemon
    fi
    ;; 
  WDM)
    if [ -x $WDM_CMD ]; then
      echo WING Display Manager
      exec $WDM_CMD -nodaemon > /dev/null
    fi 
    ;;
  XDM)
    if [ -x $XDM_CMD ]; then
      echo XFree86 Display Manager
      exec $XDM_CMD -nodaemon
    fi
    ;;
  esac
done

# error
echo
echo "Hey, you don't have KDM, GDM, WDM, or XDM."
echo "Can't use runlevel 5 without one of those installed, mate."
sleep 30

echoc "Canceling GUI login mode" red 
init 2

# All done.
