/*
 * GQview
 * (C) 2002 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License (GNU GPL).
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */


#ifndef CACHE_H
#define CACHE_H


#include "similar.h"


#define GQVIEW_CACHE_DIR ".thumbnails"
#define GQVIEW_CACHE_THUMB_EXT ".png"
#define GQVIEW_CACHE_SIMIL_EXT ".sim"


typedef struct _CacheData CacheData;
struct _CacheData
{
	gchar *path;
	gint width;
	gint height;
	long checksum;
	ImageSimilarityData *sim;

	gint dimensions;
	gint have_checksum;
	gint similarity;
};


CacheData *cache_sim_data_new(void);
void cache_sim_data_free(CacheData *cd);

gint cache_sim_data_save(CacheData *cd);
CacheData *cache_sim_data_load(const gchar *path);

void cache_sim_data_set_dimensions(CacheData *cd, gint w, gint h);
void cache_sim_data_set_checksum(CacheData *cd, long checksum);
void cache_sim_data_set_similarity(CacheData *cd, ImageSimilarityData *sd);


gint cache_ensure_dir_exists(gchar *path, mode_t mode);
gchar *cache_get_location(const gchar *source, gint include_name, const gchar *ext, mode_t *mode);
gchar *cache_find_location(const gchar *source, const gchar *ext);


#endif


