#include "config.h"
#include "base.h"
#include "yapp.h"
#include "sysdep.h"

char const *ApplicationName = "icewm-session";
char *icewmbg_args[] = { "icewmbg", 0, 0 };
char *icewmtray_args[] = { "icewmtray", 0 };
char *icewm_args[] = { "icewm", 0 };

void runScript(const char *scriptName) {
    char *scriptFile = app->findConfigFile(scriptName, X_OK);
    const char *args[] = { scriptFile, 0, 0 };

    MSG(("Running session script: %s", scriptFile));
    app->runProgram(scriptFile, args);
    delete[] scriptFile;
}

int runIcewmbg() {
    icewmbg_args[1] = 0;
    return app->runProgram(icewmbg_args[0], icewmbg_args);
}

void killIcewmbg() {
    icewmbg_args[1] = "-q";
    app->runProgram(icewmbg_args[0], icewmbg_args);
}

int runIcewmtray() {
    return app->runProgram(icewmtray_args[0], icewmtray_args);
}

void killIcewmtray(int pid) {
    int status;
    kill(pid, SIGTERM);
    waitpid(pid, &status, 0);
}

int runWM() {
    return app->runProgram(icewm_args[0], icewm_args);
}

int main(int argc, char **argv) {

    YApplication xapp(&argc, &argv);

    runIcewmbg();
    int tray_pid = runIcewmtray();
    runScript("startup");

    int wm_pid = runWM();
    for (;;) {
        int status = -1;
        int pid = -1;
	msg("wm_pid=%d", wm_pid);
        pid = waitpid(-1, &status, 0);
        if (pid == wm_pid) {
            msg("status=%X", status);
            if (WIFEXITED(status))
                break;
            if (WEXITSTATUS(status) != 0)
                wm_pid = runWM();
        }
    }

    runScript("shutdown");
    killIcewmbg();
    killIcewmtray(tray_pid);
    return 0;
}
