/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.tr;

final class Priority {
    private final double n;
    private static final Priority[] defaultCache = new Priority[]{new Priority(-0.5), new Priority(-0.25), new Priority(0.0), new Priority(0.5)};

    private Priority(double d) {
        this.n = d;
    }

    public static Priority createDefault(int n) {
        if (n < -2 || n > 1) {
            throw new IllegalArgumentException("bad default");
        }
        return defaultCache[n + 2];
    }

    public static Priority create(String string) throws NumberFormatException {
        if (string == null) {
            return null;
        }
        return new Priority(Double.valueOf(string));
    }

    public int compareTo(Priority priority) {
        if (this.n == priority.n) {
            return 0;
        }
        return this.n < priority.n ? -1 : 1;
    }
}

