/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax;

import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.sax.ExtensionHandlerImpl;
import com.jclark.xsl.sax.MultiNamespaceResult;
import com.jclark.xsl.sax.OutputMethodHandler;
import com.jclark.xsl.sax.ResultBase;
import com.jclark.xsl.sax.XMLProcessorEx;
import com.jclark.xsl.sax.XMLProcessorImpl;
import com.jclark.xsl.sax.XSLProcessor;
import com.jclark.xsl.tr.Engine;
import com.jclark.xsl.tr.EngineImpl;
import com.jclark.xsl.tr.ParameterSet;
import com.jclark.xsl.tr.Sheet;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XSLProcessorImpl
implements XSLProcessor,
Cloneable,
ParameterSet {
    private XMLProcessorEx sourceLoader;
    private XMLProcessorEx sheetLoader;
    private boolean engineMatchesSheetLoader = false;
    private Parser sheetParser;
    private Parser sourceParser;
    private Sheet sheet;
    private Engine engine;
    private InputSource sheetSource;
    private ResultBase result;
    private OutputMethodHandler outputMethodHandler;
    private DocumentHandler documentHandler;
    private ErrorHandler errorHandler;
    private Hashtable params = new Hashtable();

    public void setParser(Parser parser, Parser parser2) {
        this.sourceParser = parser;
        this.sheetParser = parser2;
        this.sourceLoader = new XMLProcessorImpl(parser);
        this.sheetLoader = parser == parser2 ? this.sourceLoader : new XMLProcessorImpl(parser2);
        this.engineMatchesSheetLoader = false;
    }

    public void setParser(XMLProcessorEx xMLProcessorEx) {
        this.sourceParser = null;
        this.sheetParser = null;
        this.sourceLoader = xMLProcessorEx;
        this.sheetLoader = xMLProcessorEx;
        this.engineMatchesSheetLoader = false;
    }

    public void setParser(Parser parser) {
        this.setParser(parser, parser);
    }

    public void setLocale(Locale locale) throws SAXException {
        if (this.sheetParser != null) {
            this.sheetParser.setLocale(locale);
        }
        if (this.sourceParser != null) {
            this.sourceParser.setLocale(locale);
        }
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        if (this.sheetParser != null) {
            this.sheetParser.setEntityResolver(entityResolver);
        }
        if (this.sourceParser != null) {
            this.sourceParser.setEntityResolver(entityResolver);
        }
    }

    public void setOutputMethodHandler(OutputMethodHandler outputMethodHandler) {
        this.outputMethodHandler = outputMethodHandler;
        this.documentHandler = null;
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.documentHandler = documentHandler;
        this.outputMethodHandler = null;
    }

    public void parse(String string) throws SAXException, IOException {
        this.parse(new InputSource(string));
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (this.sheetParser != null) {
            this.sheetParser.setErrorHandler(errorHandler);
        }
        if (this.sourceParser != null) {
            this.sourceParser.setErrorHandler(errorHandler);
        }
        if (this.sheetLoader != null) {
            this.sheetLoader.setErrorHandler(errorHandler);
        }
        if (this.sourceLoader != null) {
            this.sourceLoader.setErrorHandler(errorHandler);
        }
        this.errorHandler = errorHandler;
    }

    public void loadStylesheet(InputSource inputSource) throws SAXException, IOException {
        if (!this.engineMatchesSheetLoader) {
            if (this.sheetLoader == null) {
                throw new Error("loadStylesheet called before setParser");
            }
            this.engine = new EngineImpl(this.sheetLoader, new ExtensionHandlerImpl());
            this.engineMatchesSheetLoader = true;
        }
        try {
            this.phase(1);
            Node node = this.sheetLoader.load(inputSource, 0, this.engine.getSheetLoadContext(), this.engine.getNameTable());
            this.phase(2);
            this.sheet = this.engine.createSheet(node);
        }
        catch (XSLException xSLException) {
            this.handleXSLException(xSLException);
        }
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        try {
            this.result = this.outputMethodHandler != null ? new MultiNamespaceResult(this.outputMethodHandler, this.errorHandler) : (this.documentHandler != null ? new MultiNamespaceResult(this.documentHandler, this.errorHandler) : new MultiNamespaceResult(new HandlerBase(), this.errorHandler));
            this.phase(3);
            Node node = this.sourceLoader.load(inputSource, 0, this.sheet.getSourceLoadContext(), this.engine.getNameTable());
            this.phase(4);
            this.sheet.process(node, this.sourceLoader, this, this.result);
            this.phase(5);
        }
        catch (XSLException xSLException) {
            this.handleXSLException(xSLException);
        }
    }

    void handleXSLException(XSLException xSLException) throws SAXException, IOException {
        Serializable serializable;
        String string = null;
        int n = -1;
        Node node = xSLException.getNode();
        if (node != null) {
            serializable = node.getURL();
            if (serializable != null) {
                string = ((URL)serializable).toString();
            }
            n = node.getLineNumber();
        }
        serializable = xSLException.getException();
        String string2 = xSLException.getMessage();
        if (string != null || n != -1) {
            throw new SAXParseException(string2, null, string, n, -1, (Exception)serializable);
        }
        if (string2 == null) {
            if (serializable instanceof SAXException) {
                throw (SAXException)serializable;
            }
            if (serializable instanceof IOException) {
                throw (IOException)serializable;
            }
        }
        throw new SAXException(string2, (Exception)serializable);
    }

    void phase(int n) {
    }

    public Object clone() {
        try {
            XSLProcessorImpl xSLProcessorImpl = (XSLProcessorImpl)super.clone();
            xSLProcessorImpl.params = (Hashtable)xSLProcessorImpl.params.clone();
            return xSLProcessorImpl;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("unexpected CloneNotSupportedException");
        }
    }

    public Object getParameter(Name name) {
        String string = name.getNamespace();
        string = string == null ? name.getLocalPart() : string + '^' + name.getLocalPart();
        return this.params.get(string);
    }

    public void setParameter(String string, Object object) {
        this.params.put(string, object);
    }
}

