/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax;

import com.jclark.xsl.sax.CommentHandler;
import com.jclark.xsl.sax.Destination;
import com.jclark.xsl.sax.Indenter;
import com.jclark.xsl.sax.OutputDocumentHandler;
import com.jclark.xsl.sax.RawCharactersHandler;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XMLOutputHandler
implements OutputDocumentHandler,
CommentHandler,
RawCharactersHandler {
    private OutputStream out = null;
    private boolean keepOpen;
    private boolean inStartTag = false;
    private boolean omitXmlDeclaration = false;
    private String standalone;
    private static final int DEFAULT_BUF_LENGTH = 8192;
    private byte[] buf = new byte[8192];
    private int bufUsed = 0;
    private String lineSeparator = System.getProperty("line.separator");
    private byte minimize = 1;
    private String doctypeSystem;
    private String doctypePublic;
    private boolean outputDoctype = false;
    public static final byte MINIMIZE_NONE = 0;
    public static final byte MINIMIZE_EMPTY_ELEMENTS = 1;
    public static final byte MINIMIZE_EMPTY_ELEMENTS_HTML = 2;

    public XMLOutputHandler() {
    }

    public XMLOutputHandler(OutputStream outputStream) {
        this();
        this.out = outputStream;
    }

    public DocumentHandler init(Destination destination, AttributeList attributeList) throws IOException {
        this.out = destination.getOutputStream("application/xml", null);
        this.keepOpen = destination.keepOpen();
        if ("yes".equals(attributeList.getValue("omit-xml-declaration"))) {
            this.omitXmlDeclaration = true;
        }
        this.standalone = attributeList.getValue("standalone");
        this.doctypeSystem = attributeList.getValue("doctype-system");
        this.doctypePublic = attributeList.getValue("doctype-public");
        if (this.doctypeSystem != null || this.doctypePublic != null) {
            this.outputDoctype = true;
        }
        if ("yes".equals(attributeList.getValue("indent"))) {
            return new Indenter(this, this);
        }
        return this;
    }

    public void setMinimize(byte by) {
        this.minimize = by;
    }

    public void startDocument() throws SAXException {
        if (!this.omitXmlDeclaration) {
            this.writeRaw("<?xml version=\"1.0\" encoding=\"utf-8\"");
            if (this.standalone != null) {
                this.writeRaw(" standalone=\"");
                this.writeRaw(this.standalone);
                this.put((byte)34);
            }
            this.writeRaw("?>");
            this.writeRaw(this.lineSeparator);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (n2 == 0) {
            return;
        }
        if (this.inStartTag) {
            this.finishStartTag();
        }
        do {
            char c = cArray[n++];
            switch (c) {
                case '\n': {
                    this.writeRaw(this.lineSeparator);
                    break;
                }
                case '&': {
                    this.writeRaw("&amp;");
                    break;
                }
                case '<': {
                    this.writeRaw("&lt;");
                    break;
                }
                case '>': {
                    this.writeRaw("&gt;");
                    break;
                }
                default: {
                    if (c < '\u0080') {
                        this.put((byte)c);
                        break;
                    }
                    try {
                        this.writeMB(c);
                    }
                    catch (CharConversionException charConversionException) {
                        if (n2-- == 0) {
                            throw new SAXException(charConversionException);
                        }
                        this.writeSurrogatePair(cArray[n - 1], cArray[n]);
                        ++n;
                    }
                }
            }
        } while (--n2 > 0);
    }

    public void rawCharacters(String string) throws SAXException {
        if (this.inStartTag) {
            this.finishStartTag();
        }
        this.writeRaw(string);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        while (n2 > 0) {
            this.put((byte)cArray[n]);
            --n2;
            ++n;
        }
    }

    private void writeRaw(String string) throws SAXException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c < '\u0080') {
                this.put((byte)c);
            } else {
                try {
                    this.writeMB(string.charAt(n2));
                }
                catch (CharConversionException charConversionException) {
                    if (++n2 == n) {
                        throw new SAXException(charConversionException.getMessage());
                    }
                    this.writeSurrogatePair(c, string.charAt(n2));
                }
            }
            ++n2;
        }
    }

    private final void writeMB(char c) throws SAXException, CharConversionException {
        switch (c & 0xF800) {
            case 0: {
                this.put((byte)(c >> 6 & 0x1F | 0xC0));
                this.put((byte)(c & 0x3F | 0x80));
                break;
            }
            default: {
                this.put((byte)(c >> 12 & 0xF | 0xE0));
                this.put((byte)(c >> 6 & 0x3F | 0x80));
                this.put((byte)(c & 0x3F | 0x80));
                break;
            }
            case 55296: {
                throw new CharConversionException("invalid surrogate pair");
            }
        }
    }

    private final void writeSurrogatePair(char c, char c2) throws SAXException {
        if ((c & 0xFC00) != 55296 || (c2 & 0xFC00) != 56320) {
            throw new SAXException("invalid surrogate pair");
        }
        int n = (c & 0x3FF) << 10 | c2 & 0x3FF;
        this.put((byte)((n += 65536) >> 18 & 7 | 0xF0));
        this.put((byte)(n >> 12 & 0x3F | 0x80));
        this.put((byte)(n >> 6 & 0x3F | 0x80));
        this.put((byte)(n & 0x3F | 0x80));
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        int n;
        if (this.inStartTag) {
            this.finishStartTag();
        }
        if (this.outputDoctype) {
            this.outputDoctype = false;
            this.writeRaw("<!DOCTYPE ");
            this.writeRaw(string);
            if (this.doctypePublic != null) {
                this.writeRaw(" PUBLIC ");
                n = this.doctypePublic.indexOf(34) >= 0 ? 39 : 34;
                this.put((byte)n);
                this.writeRaw(this.doctypePublic);
                this.put((byte)n);
            } else {
                this.writeRaw(" SYSTEM");
            }
            if (this.doctypeSystem != null) {
                n = this.doctypeSystem.indexOf(34) >= 0 ? 39 : 34;
                this.put((byte)32);
                this.put((byte)n);
                this.writeRaw(this.doctypeSystem);
                this.put((byte)n);
            }
            this.put((byte)62);
            this.writeRaw(this.lineSeparator);
        }
        this.put((byte)60);
        this.writeRaw(string);
        n = attributeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            this.put((byte)32);
            this.writeRaw(attributeList.getName(n2));
            this.put((byte)61);
            this.put((byte)34);
            this.attributeValue(attributeList.getValue(n2));
            this.put((byte)34);
            ++n2;
        }
        this.inStartTag = true;
    }

    protected void attributeValue(String string) throws SAXException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '\n': {
                    this.writeRaw("&#10;");
                    break;
                }
                case '&': {
                    this.writeRaw("&amp;");
                    break;
                }
                case '<': {
                    this.writeRaw("&lt;");
                    break;
                }
                case '\"': {
                    this.writeRaw("&quot;");
                    break;
                }
                case '\r': {
                    this.writeRaw("&#13;");
                    break;
                }
                case '\t': {
                    this.writeRaw("&#9;");
                    break;
                }
                default: {
                    if (c < '\u0080') {
                        this.put((byte)c);
                        break;
                    }
                    try {
                        this.writeMB(c);
                    }
                    catch (CharConversionException charConversionException) {
                        if (++n2 == n) {
                            throw new SAXException(charConversionException.getMessage());
                        }
                        this.writeSurrogatePair(string.charAt(n2 - 1), string.charAt(n2));
                    }
                }
            }
            ++n2;
        }
    }

    private final void finishStartTag() throws SAXException {
        this.inStartTag = false;
        this.put((byte)62);
    }

    public void endElement(String string) throws SAXException {
        if (this.inStartTag) {
            this.inStartTag = false;
            if (this.minimize != 0) {
                if (this.minimize == 2) {
                    this.put((byte)32);
                }
                this.put((byte)47);
                this.put((byte)62);
                return;
            }
            this.put((byte)62);
        }
        this.put((byte)60);
        this.put((byte)47);
        this.writeRaw(string);
        this.put((byte)62);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (string == null) {
            this.comment(string2);
            return;
        }
        if (this.inStartTag) {
            this.finishStartTag();
        }
        this.put((byte)60);
        this.put((byte)63);
        this.writeRaw(string);
        if (string2.length() > 0) {
            this.put((byte)32);
            this.writeMarkup(string2);
        }
        this.put((byte)63);
        this.put((byte)62);
    }

    public void markup(String string) throws SAXException {
        if (this.inStartTag) {
            this.finishStartTag();
        }
        this.writeMarkup(string);
    }

    public void comment(String string) throws SAXException {
        if (this.inStartTag) {
            this.finishStartTag();
        }
        this.writeRaw("<!--");
        this.writeMarkup(string);
        this.writeRaw("-->");
    }

    private void writeMarkup(String string) throws SAXException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\n') {
                this.writeRaw(this.lineSeparator);
            } else if (c < '\u0080') {
                this.put((byte)c);
            } else {
                try {
                    this.writeMB(c);
                }
                catch (CharConversionException charConversionException) {
                    if (++n2 == n) {
                        throw new SAXException(charConversionException);
                    }
                    this.writeSurrogatePair(c, string.charAt(n2));
                }
            }
            ++n2;
        }
    }

    private final void put(byte by) throws SAXException {
        if (this.bufUsed == this.buf.length) {
            this.flushBuf();
        }
        this.buf[this.bufUsed++] = by;
    }

    private final void flushBuf() throws SAXException {
        try {
            this.out.write(this.buf, 0, this.bufUsed);
            this.bufUsed = 0;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void endDocument() throws SAXException {
        if (this.bufUsed != 0) {
            this.flushBuf();
        }
        try {
            if (this.out != null) {
                if (this.keepOpen) {
                    this.out.flush();
                } else {
                    this.out.close();
                }
                this.out = null;
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        this.out = null;
        this.buf = null;
    }
}

