/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.dom;

import com.jclark.xsl.dom.DOMBuilder;
import com.jclark.xsl.dom.DOMExtensions;
import com.jclark.xsl.dom.NodeBase;
import com.jclark.xsl.dom.RootNode;
import com.jclark.xsl.om.NameTable;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.sax.MultiNamespaceResult;
import com.jclark.xsl.sax.XMLProcessorEx;
import com.jclark.xsl.tr.LoadContext;
import com.jclark.xsl.tr.Result;
import java.io.IOException;
import java.net.URL;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class XMLProcessorImpl
implements XMLProcessorEx,
DOMExtensions {
    private ErrorHandler errorHandler;

    public Node load(URL uRL, int n, LoadContext loadContext, NameTable nameTable) throws IOException, XSLException {
        return this.load(new InputSource(uRL.toString()), n, loadContext, nameTable);
    }

    public Node load(InputSource inputSource, int n, LoadContext loadContext, NameTable nameTable) throws IOException, XSLException {
        try {
            Document document = this.load(inputSource);
            return new RootNode(document, this, loadContext, nameTable, inputSource.getSystemId(), n);
        }
        catch (SAXParseException sAXParseException) {
            throw new XSLException(sAXParseException);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception == null) {
                throw new XSLException(sAXException.getMessage());
            }
            if (exception instanceof XSLException) {
                throw (XSLException)sAXException.getException();
            }
            throw new XSLException(exception);
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public abstract Document load(InputSource var1) throws IOException, SAXException;

    public Element getElementById(Document document, String string) {
        return null;
    }

    public Result createResult(Node node, int n, LoadContext loadContext, Node[] nodeArray) throws XSLException {
        if (node == null) {
            throw new XSLException("cannot convert result tree fragment returned by extension function to a node-set with the DOM");
        }
        RootNode rootNode = ((NodeBase)node).root;
        DocumentFragment documentFragment = rootNode.ownerDocument.createDocumentFragment();
        String string = null;
        URL uRL = node.getURL();
        if (uRL != null) {
            string = uRL.toString();
        }
        nodeArray[0] = new RootNode(documentFragment, this, loadContext, node.getNamespacePrefixMap().getNameTable(), string, n);
        return new MultiNamespaceResult(new DOMBuilder(documentFragment), this.errorHandler);
    }
}

