/*
 * Copyright (C) 1995-2005, Index Data ApS
 * See the file LICENSE for details.
 *
 * $Id: srw.h,v 1.23 2005/11/08 15:08:02 adam Exp $
 */
/**
 * \file srw.h
 * \brief Header for SRW/SRU
 */

#ifndef YAZ_SRW_H
#define YAZ_SRW_H

#include <yaz/soap.h>
#include <yaz/zgdu.h>
#include <yaz/diagsrw.h>

YAZ_BEGIN_CDECL

typedef struct {
    int type;
    char *recordReviewCode;
    char *recordReviewNote;
    char *recordId;
    char *nonDupRecordId;
    char *recordLockStatus;
    char *recordOldVersion;
} Z_SRW_extra_record;

typedef struct {
    char *recordSchema;
    int recordPacking;
#define Z_SRW_recordPacking_string 0
#define Z_SRW_recordPacking_XML 1
#define Z_SRW_recordPacking_URL 2
    char *recordData_buf;
    int recordData_len;
    int *recordPosition;
} Z_SRW_record;

typedef struct {
    char *uri;
    char *details;
    char *message;
} Z_SRW_diagnostic;
    
typedef struct {

#define Z_SRW_query_type_cql  1
#define Z_SRW_query_type_xcql 2
#define Z_SRW_query_type_pqf  3
    int query_type;
    union {
        char *cql;
        char *xcql;
        char *pqf;
    } query;

#define Z_SRW_sort_type_none 1
#define Z_SRW_sort_type_sort 2
#define Z_SRW_sort_type_xSort 3
    int sort_type;
    union {
        char *none;
        char *sortKeys;
        char *xSortKeys;
    } sort;
    int *startRecord;
    int *maximumRecords;
    char *recordSchema;
    char *recordPacking;
    char *recordXPath;
    char *database;
    char *stylesheet;
    int *resultSetTTL;
} Z_SRW_searchRetrieveRequest;

typedef struct {
    int * numberOfRecords;
    char * resultSetId;
    int * resultSetIdleTime;
    
    Z_SRW_record *records;
    int num_records;

    Z_SRW_diagnostic *diagnostics;
    int num_diagnostics;
    int *nextRecordPosition;

    Z_SRW_extra_record **extra_records;  /* of size num_records */
} Z_SRW_searchRetrieveResponse;

typedef struct {
    char *recordPacking;
    char *database;
    char *stylesheet;
} Z_SRW_explainRequest;

typedef struct {
    Z_SRW_record record;
    Z_SRW_diagnostic *diagnostics;
    int num_diagnostics;
    Z_SRW_extra_record *extra_record;
} Z_SRW_explainResponse;
    
typedef struct {
    int query_type;
    union {
        char *cql;
        char *xcql;
        char *pqf;
    } scanClause;
    int *responsePosition;
    int *maximumTerms;
    char *stylesheet;
    char *database;
} Z_SRW_scanRequest;

typedef struct {
    char *value;
    int *numberOfRecords;
    char *displayTerm;
    char *whereInList;
} Z_SRW_scanTerm;

typedef struct {
    Z_SRW_scanTerm *terms;
    int num_terms;
    Z_SRW_diagnostic *diagnostics;
    int num_diagnostics;
} Z_SRW_scanResponse;


typedef struct {
    char *database;
    char *operation;
    char *recordId;
    char *recordVersion;
    char *recordOldVersion;
    Z_SRW_record record;
    Z_SRW_extra_record *extra_record;
    char *extraRequestData;
    char *stylesheet;
} Z_SRW_updateRequest;

typedef struct {
    char *operationStatus;
    char *recordId;
    char *recordVersion;
    char *recordChecksum;
    char *extraResponseData;
    Z_SRW_record record;
    Z_SRW_extra_record *extra_record;
    Z_SRW_diagnostic *diagnostics;
    int num_diagnostics;
} Z_SRW_updateResponse;

#define Z_SRW_searchRetrieve_request  1
#define Z_SRW_searchRetrieve_response 2
#define Z_SRW_explain_request 3
#define Z_SRW_explain_response 4
#define Z_SRW_scan_request 5
#define Z_SRW_scan_response 6
#define Z_SRW_update_request 7
#define Z_SRW_update_response 8

typedef struct {
    int which;
    union {
        Z_SRW_searchRetrieveRequest *request;
        Z_SRW_searchRetrieveResponse *response;
        Z_SRW_explainRequest *explain_request;
        Z_SRW_explainResponse *explain_response;
        Z_SRW_scanRequest *scan_request;
        Z_SRW_scanResponse *scan_response;
        Z_SRW_updateRequest *update_request;
        Z_SRW_updateResponse *update_response;
    } u;
    char *srw_version;
} Z_SRW_PDU;

YAZ_EXPORT int yaz_srw_codec(ODR o, void * pptr,
                             Z_SRW_PDU **handler_data,
                             void *client_data, const char *ns);
YAZ_EXPORT int yaz_ucp_codec(ODR o, void * pptr,
                             Z_SRW_PDU **handler_data,
                             void *client_data, const char *ns);
YAZ_EXPORT Z_SRW_PDU *yaz_srw_get(ODR o, int which);
YAZ_EXPORT Z_SRW_extra_record *yaz_srw_get_extra_record(ODR o);

YAZ_EXPORT int yaz_diag_bib1_to_srw (int bib1_code);

YAZ_EXPORT int yaz_diag_srw_to_bib1(int srw_code);

YAZ_EXPORT char *yaz_uri_val(const char *path, const char *name, ODR o);
YAZ_EXPORT void yaz_uri_val_int(const char *path, const char *name,
                                ODR o, int **intp);
YAZ_EXPORT int yaz_srw_decode(Z_HTTP_Request *hreq, Z_SRW_PDU **srw_pdu,
                              Z_SOAP **soap_package, ODR decode, char **charset);
YAZ_EXPORT int yaz_sru_decode(Z_HTTP_Request *hreq, Z_SRW_PDU **srw_pdu,
                              Z_SOAP **soap_package, ODR decode, 
                              char **charset,
                              Z_SRW_diagnostic **, int *num_diagnostic);

YAZ_EXPORT void yaz_add_srw_diagnostic(ODR o, Z_SRW_diagnostic **d,
                                       int *num, int code,
                                       const char *addinfo);
    
YAZ_EXPORT void yaz_mk_std_diagnostic(ODR o, Z_SRW_diagnostic *d, 
                                      int code, const char *details);
YAZ_END_CDECL

#endif
/*
 * Local variables:
 * c-basic-offset: 4
 * indent-tabs-mode: nil
 * End:
 * vim: shiftwidth=4 tabstop=8 expandtab
 */

