#!/bin/sh

#!/bin/sh

PREFIX=/opt/emacs
PKG_NAME=emacs-21.4-i586-1

## Install the info pages
(cd $PREFIX/info
 INFOPATH=$PREFIX/info
 for info in $(ls | sed -e '/^dir$/d' -e '/[0-9]/d')
 do
   install-info $info --info-dir=`pwd` &> /dev/null
 done)

## Compile all the Emacs Lisp files (saves space in the package)
echo "Compiling LISP files; this could take a while..."
for src in $(find $PREFIX -name "*.el")
do
  ## Don't do it if the byte-compiled file already exists, that's dumb
  if [ ! -f $(echo $src | sed -e 's/\.el$/.elc/') ]; then
    echo "Compiling $src..."
    echo "(byte-compile-file \"${src}\")" | \
    $PREFIX/bin/emacs -batch -l /dev/stdin &> /dev/null
    ## Add the new compiled lisp file to the package list
    echo $(echo $src | sed -e 's/\.el$/.elc/' -e 's/^\///') >> \
    /var/log/packages/$PKG_NAME
  fi
done
