#!/bin/sh

# -<colour codes>--------------------------------
PS_BLACK="\[\033[0;30m\]" # Black
PS_DARK="\[\033[1;30m\]"  # Black (Light) / Dark Gray

PS_DRED="\[\033[0;31m\]" # Red (Dark)
PS_RED="\[\033[1;31m\]"  # Red

PS_DGREEN="\[\033[0;32m\]" # Green (Dark)
PS_GREEN="\[\033[1;32m\]"  # Green

PS_BROWN="\[\033[0;33m\]" # Yellow (Dark) / Orange
PS_YELLOW="\[\033[1;33m\]"  # Yellow

PS_DBLUE="\[\033[0;34m\]" # Blue (Dark)
PS_BLUE="\[\033[1;34m\]"  # Blue

PS_DPURPLE="\[\033[0;35m\]" # Purple (Dark)
PS_PURPLE="\[\033[1;35m\]"  # Purple

PS_DCYAN="\[\033[0;36m\]" # Cyan (Dark)
PS_CYAN="\[\033[1;36m\]"  # Cyan

PS_DGRAY="\[\033[0;37m\]" # White (dark) / Light Gray
PS_GRAY="\[\033[1;37m\]"  # White

PS_WHITE="\[\033[0;38m\]" # White 
PS_BWHITE="\[\033[1;38m\]"  # White Bold

PS_NORMAL="\[\033[0;39m\]" # White 
PS_BOLD="\[\033[1;39m\]"  # White Bold
# -</colour codes>-------------------------------

if [ "$UID" = 0 ]; then
   echoc "You are working as root" red
   export CFLAGS="-O2 -march=i586 -mcpu=i686"
   export CXXFLAGS="-O2 -march=i586 -mcpu=i686"
   export PATH="$PATH:/usr/local/sbin:/usr/sbin:/sbin"
   if [ -z "$USER" ] || [ "$USER" != "root" ]; then
      UHOME=`egrep "^$USER:" /etc/passwd | cut -f6 -d:`
      if [ -f $UHOME/.Xauthority ]; then
	 # echo "Enabling X-Window $UHOME/.Xauthority"
	 cp $UHOME/.Xauthority /root
      fi
   fi
   echoc "Frequently used programs:" cyan
   echo "Configuration  : vasm"
   echo "Package manager: vlapt, slapt-get"
else
   echoc "You are working as $USER" green
   echoc "Frequently used programs:" cyan
   echo "Configuration  : vasm"
fi

which mc &>/dev/null && echo "File manager   : mc (press F2 for usefull menu)"
which mc &>/dev/null && echo "Editor         : mcedit"
which mc &>/dev/null && echo "Sound mixer    : alsamixer"

if [ -z "`skill -n X`" ]; then
which startx &>/dev/null        && echo "Default X      : startx"
which starticewm &>/dev/null    && echo "IceWM          : starticewm, starticewm-desk, starticewm-sound"
which startfluxbox &>/dev/null  && echo "Fluxbox        : startfluxbox, startfluxbox-desk"
which startxfce4 &>/dev/null    && echo "XFCE4          : startxfce4"
which startkde &>/dev/null      && echo "KDE            : xinit startkde"
fi

## Set a default shell prompt:
PS1="${PS_BLUE}\h:/\w${PS_NORMAL}\n\u:\\$ "
PS2="> "
