#!/bin/sh
# rc.M		
# This file is executed by init(8) when the system is being initialized 
# for one of the "multi user" run levels (i.e. levels 2 through 5).
# It prepares:
# - More hardware (pcmcia, hotplug, etc..). Not from rc.S since they may hung
# - network loop (localhost)
# - network devices (inet1 ... inet9)
# - firewall
# - mount network file system. Not from sysvinit because they need to be cleanup.
# - setting up basic environment
#
# These, of course, could be done via sysvinit.
# However, there are two concerns:
# - it is too risky because casual users may mess it up easily.
# - it slows down run level switching
# So let them stay here like the classis uncle Slack's way :)
#
# To administrator, If this script hung on booting, boot to single mode
# boot: linux single
# Then fix it by hand. You are good, aren't you ;-) 
#
# Origin: this script is a mix of rc.S, rc.M and rc.inet2 from Slackware 10.0
#
# GNU GPL (c) Eko M. Budi, 2004
#         (c) Vector Linux, 2004
#

# load functions
. /etc/rc.d/functions-display

# Tell the viewers what's going to happen.
echocl "rc.M ==> Going multiuser..." yellow

## Turn ON system logger first
if [ -x /etc/rc.d/rc.syslog ]; then
  echonl "Starting system logger ..."
  /etc/rc.d/rc.syslog start >>$INITLOG 2>&1
  evaluate_retvall
fi

## Hardware initialisation
## kudzu is here, but ... no script yet
echocl "Initialising advanced hardware" cyan
for RC in modules apm pcmcia serial parallel alsa hotplug wireless; do
   if [ -x /etc/rc.d/rc.$RC ]; then
      echonl "Setting up $RC ..."
      /etc/rc.d/rc.$RC start >>$INITLOG 2>&1
      evaluate_retvall
   fi
done

## Setup basic networking
## Note for slackers: this replaces rc.inet1
## On Vector rc.inet? = individual network device
echocl "Initialising network" cyan

## Start Paranoid firewall 
if [ -x /etc/rc.d/rc.paranoid ]; then
  echonl "Closing up the holes ..."
  /etc/rc.d/rc.paranoid start >>$INITLOG 2>&1
  evaluate_retvall
fi

## Set hostname & name server
if grep -qe " *(hostname|dns)=" /proc/cmdline; then
  if [ -x /etc/rc.d/rc.boot-name ]; then
    echonl "Setting name from boot parameters ..."
    /etc/rc.d/rc.boot-name start >>$INITLOG 2>&1
    evaluate_retvall
  fi
fi

## Local host is always ON for multiuser mode
## So I hardcoded it here
echonl "Setting up localhost ..."
ifconfig lo 127.0.0.1 netmask 255.0.0.0 && \
  route add -net 127.0.0.0 netmask 255.0.0.0 lo >> $INITLOG 2>&1
evaluate_retvall

## set other networks
for RC in 0 1 2 3 4 5 6 7 8 9; do
  ## Start network using boot parameter or the default inet script
  ## Boot parameter is useful for UML, e.g. you may boot linux with
  ## linux inet1=eth0,dhcp
  ## linux inet1=eth0,{IP},{NETMASK},{GATEWAY}
  
  if grep -qe " *inet$RC=" /proc/cmdline; then
    echonl "Setting up inet$RC from boot parameters ..."
    /etc/rc.d/rc.boot-inet start inet$RC >>$INITLOG 2>&1
    evaluate_retvall
  elif [ -x /etc/rc.d/rc.inet$RC ]; then
    echonl "Setting up inet$RC ..."
    /etc/rc.d/rc.inet$RC start >>$INITLOG 2>&1
    evaluate_retvall
  fi
done

## routing, gateway and firewall
## rc.route = custom routing 
## rc.firewall = custom firewall
## ip_forward = enable forwarding, if not in the firewall
for RC in route firewall ip_forward; do
   if [ -x /etc/rc.d/rc.$RC ]; then
      echonl "Setting up $RC ..."
      /etc/rc.d/rc.$RC start >>$INITLOG 2>&1
      evaluate_retvall
   fi
done

## at this point, we are ready to talk to The World...
## Here comes the Network file system
## Note for slackers: this is taken from rc.inet2

NFSFSTAB=`grep -v '^#' /etc/fstab | awk '{ if ($3 ~ /^nfs$/ && $4 !~ /noauto/) print $2}'`
SMBFSTAB=`grep -v '^#' /etc/fstab | awk '{ if ($3 ~ /^smbfs$/ && $4 !~ /noauto/) print $2}'`
#NCPFSTAB=`grep -v '^#' /etc/fstab | awk '{ if ($3 ~ /^ncpfs$/ && $4 !~ /noauto/) print $2}'`

if [ "${NFSFSTAB}${SMBFSTAB}" ]; then

  echocl "Mounting network file system ..." cyan
  # Mount remote (NFS) filesystems:
  if [ "$NFSTAB" ]; then
    # Start the RPC portmapper if we find NFS volumes defined in /etc/fstab,
    # since it will need to be running in order to mount them.  If portmap
    # is not running, attempting to mount an NFS partition will cause mount
    # to hang.  Keep this in mind if you plan to mount unlisted partitions...
    if ! /usr/sbin/rpcinfo -p 1> /dev/null 2> /dev/null ; then
      if [ -x /sbin/rpc.portmap ]; then
        echonl "Starting RPC portmapper ..."
        /sbin/rpc.portmap >>$INITLOG 2&>1
	evaluate_retvall
      fi
    fi
    echonl "Mounting remote (NFS) file systems ..."
    /sbin/mount -a -t nfs  >>$INITLOG 2&>1
    evaluate_retvall
  fi

  # Mount remote (SMB) filesystems:
  if [ "$SMBFSTAB" ]; then
    echonl "Mounting remote (SMB) file systems ..."
    /sbin/mount -a -t smbfs >>$INITLOG 2&>1
    evaluate_retvall
  fi

  ## If the new mounted FS is /tmp or /var, 
  ## we need to reset the file system again.
  ## Hmm ... complicated isn't it ?
  ## That's why we should do it here, not via rc.init

  mount | while read LINE; do
     fsystem=`echo $LINE | cut -f5 -d ' '`
     case $fsystem in nfs|smbfs|ncpfs)
       mpoint=`echo $LINE | cut -f3 -d ' '`
       case $mpoint in
         /tmp|/tmp/*) 
	    rm -f /tmp/.X*lock /tmp/core /core &> /dev/null
	    if [ -r /tmp/hunt -o -r /tmp/hunt.stats ]; then
    		rm -f /tmp/hunt*
	    fi
	    # Ensure permission
	    chmod 1777 /tmp 
	   ;;
	 /var|/var/*) 
            # Remove stale locks and junk files
            rm -f /var/lock/* /var/spool/uucp/LCK..*  
	    chmod 1777 /var/tmp
	    ## Create a fresh utmp file:
	    touch /var/run/utmp
	    chown root.utmp /var/run/utmp
	    chmod 664 /var/run/utmp
	    ## restart the syslog
	    /etc/rc.d/rc.syslog restart
	    ;;
	 /usr|/usr/*|/opt|/opt/*)
	    ## Updating libraries
	    ldconfig
           ;;	 
       esac
     esac
  done
fi

echocl "Setting up console, GUI and sound" cyan
for RC in font fc-cache; do
    if [ -x /etc/rc.d/rc.$RC ] ; then
	echonl "Loading $RC ..."
	/etc/rc.d/rc.$RC start >> $INITLOG 2>&1
	evaluate_retvall
    fi
done

## That's all
## Other configurable services will be started by sysvinit/vlinit
