/*************************************************************************

  File Name: OsString.c

  File Description: This file implements all the string/memory utilities.

  ************************************************************************/

/*
 * Copyright (c) 2001 Conexant Systems, Inc.
 * 
 * 1.   Permitted use. Redistribution and use in source and binary forms,
 * with or without modification, are permitted under the terms set forth
 * herein.
 * 
 * 2.   Disclaimer of Warranties. CONEXANT AND OTHER CONTRIBUTORS MAKE NO
 * REPRESENTATION ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.
 * IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTIES OF ANY KIND.
 * CONEXANT AND OTHER CONTRIBUTORS DISCLAIMS ALL WARRANTIES WITH REGARD TO
 * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, GOOD TITLE AND AGAINST INFRINGEMENT.
 * 
 * This software has not been formally tested, and there is no guarantee that
 * it is free of errors including, but not limited to, bugs, defects,
 * interrupted operation, or unexpected results. Any use of this software is
 * at user's own risk.
 * 
 * 3.   No Liability.
 * 
 * (a) Conexant or contributors shall not be responsible for any loss or
 * damage to Company, its customers, or any third parties for any reason
 * whatsoever, and CONEXANT OR CONTRIBUTORS SHALL NOT BE LIABLE FOR ANY
 * ACTUAL, DIRECT, INDIRECT, SPECIAL, PUNITIVE, INCIDENTAL, OR CONSEQUENTIAL
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED, WHETHER IN CONTRACT, STRICT OR OTHER LEGAL THEORY OF
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY
 * WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 * 
 * (b) User agrees to hold Conexant and contributors harmless from any
 * liability, loss, cost, damage or expense, including attorney's fees,
 * as a result of any claims which may be made by any person, including
 * but not limited to User, its agents and employees, its customers, or
 * any third parties that arise out of or result from the manufacture,
 * delivery, actual or alleged ownership, performance, use, operation
 * or possession of the software furnished hereunder, whether such claims
 * are based on negligence, breach of contract, absolute liability or any
 * other legal theory.
 * 
 * 4.   Notices. User hereby agrees not to remove, alter or destroy any
 * copyright, trademark, credits, other proprietary notices or confidential
 * legends placed upon, contained within or associated with the Software,
 * and shall include all such unaltered copyright, trademark, credits,
 * other proprietary notices or confidential legends on or in every copy of
 * the Software.
 * 
 */
#include "oscompat.h"

#include "framewrk.h"

#include "ossysenv.h"

#define MAX_FORMAT_STRING_LEN 200 // for static OsSprintf string

/******************************************************************************
	
	Function Name: OsMemSet.

	Function Description:The function initializes a buffer to a specified character.

	Arguments: Buffer - Pointer to buffer to contain copied characters.
			   c - Character to copy into the buffer.
			   Count - Number of times to copy the character into the buffer.
	
	Return Value: A pointer to Buffer.

******************************************************************************/
PVOID	OsMemSet(PVOID Buffer, UINT32 c, UINT32 Count)
{
		return memset(Buffer, c, Count);
}
 
/******************************************************************************
	
	Function Name: OsMemMove.
 
	Function Description:The memmove function copies count bytes of characters from 
				src to dest. If some regions of the source area and the destination 
				overlap, memmove ensures that the original source bytes in the 
				overlapping region are copied before being overwritten.
	Arguments: dest - Destination object.
			   src - Source object
			   count - NNumber of bytes of characters to copy.
	
	Return Value: memmove returns the value of dest
 
******************************************************************************/
void *OsMemMove( void *dest, const void *src, int count )
{
		return memmove(dest, src, count);
}
/******************************************************************************
	
	Function Name: OsMemCpy.

	Function Description:The function copies a specified number of characters from one 
						 buffer to another. This function may not work correctly if 
						 the buffers overlap. 

	Arguments: BuffDest - Pointer to buffer to contain copied characters.
			   BuffSrc - Pointer to buffer with the characters to copy.
			   Count - Number of characters to copy.
	
	Return Value: A pointer to BuffDest.

******************************************************************************/
PVOID	OsMemCpy(PVOID BuffDest, PVOID BuffSrc, UINT32 Count)
{
		return memcpy(BuffDest, BuffSrc, Count);
}

/******************************************************************************
	
	Function Name: OsMemCmp.

	Function Description:The function compares a specified number of characters from two buffers.

	Arguments: Buff1 - Pointer to first buffer to compare.
			   Buff2 - Pointer to second buffer to compare.
			   Count - Number of characters to compare.
	
	Return Value: Returns one of three values as follows:
														0 if buffers match.
														< 0 if buff1 is less than buff2.
														>0 if buff1 is greater than buff2.

******************************************************************************/
int		OsMemCmp(PVOID Buff1, PVOID Buff2, UINT32 Count)
{
		return memcmp(Buff1, Buff2, Count);
}
	/********************************************************************************
	
	Function Name: OsStrCpy.

	Function Description:The function copies a specified a string from one 
						 buffer to another. This function may not work correctly if 
						 the buffers overlap. 

	Arguments: BuffDest - Pointer to buffer to contain copied string.
			   BuffSrc - Pointer to buffer with the string to copy.
	
	Return Value: A pointer to BuffDest.

	********************************************************************************/
	PVOID	OsStrCpy(OUT PCHAR BuffDest, IN PCHAR BuffSrc)
	{
		int index = 0;
		while (*((char *)BuffSrc+index) != '\0')
		{
			*((char *)BuffDest+index) = *((char *)BuffSrc+index);
			index++;
		}
		*((char *)BuffDest+index) = '\0';
		return (BuffDest);
	}

	/********************************************************************************
	
	Function Name: OsStrnCpy.

	Function Description:The function copies a specified a string from one 
						 buffer to another. The function does not copy more 
						 than MaxSize bytes.The behavior of strncpy is 
						 undefined if the source and destination strings overlap

	Arguments: BuffDest - Pointer to buffer to contain copied string.
			   BuffSrc - Pointer to buffer with the string to copy.
			   MaxSize - Max chars to copy
	
	Return Value: A pointer to BuffDest.

	********************************************************************************/
	PVOID	OsStrnCpy(OUT PCHAR BuffDest, IN PCHAR BuffSrc, int MaxSize)
	{
		int index = 1;
		while ((*((char *)BuffSrc+(index-1)) != '\0') && index <= MaxSize)
		{
			*((char *)BuffDest+(index-1)) = *((char *)BuffSrc+(index-1));
			index++;
		}
		if (index <= MaxSize)
			*((char *)BuffDest+(index-1)) = '\0';
		return (BuffDest);
	}
	/********************************************************************************

	Function Name: OsStrCat.

	Function Description:The function copies a specified a string from one 
						 buffer to another, at its end. This function may not work correctly if 
						 the buffers overlap. 

	Arguments: BuffDest - Pointer to buffer to contain copied string.
			   BuffSrc - Pointer to buffer with the string to copy.

	Return Value: A pointer to BuffDest.

	********************************************************************************/
	PVOID	OsStrCat(OUT PCHAR BuffDest, IN PCHAR BuffSrc)
	{
		int index = 0, offset = 0;
		while (*((char *)BuffDest+offset) != '\0')
		{
			offset++;
		}
		while (*((char *)BuffSrc+index) != '\0')
		{
			*((char *)BuffDest+offset+index) = *((char *)BuffSrc+index);
			index++;
		}
		*((char *)BuffDest+offset+index) = '\0';
		return (BuffDest);
	}
	/********************************************************************************

	Function Name: OsStrnCat.

	Function Description:The function copies a specified a string from one 
	  				 buffer to another, at its end. The function does not copy
					 more than MaxSize bytes.The behavior of strncpy is 
					 undefined if the source and destination strings overlap

	Arguments: BuffDest - Pointer to buffer to contain copied string.
			   BuffSrc - Pointer to buffer with the string to copy.
			   MaxSize - Max chars to copy

	Return Value: A pointer to BuffDest.

	********************************************************************************/
	PVOID	OsStrnCat(OUT PCHAR BuffDest, IN PCHAR BuffSrc, int MaxSize)
	{
		int index = 1, offset = 0;
		while (*((char *)BuffDest+offset) != '\0')
		{
			offset++;
		}
		while ((*((char *)BuffSrc+(index-1)) != '\0') && index <= MaxSize)
		{
			*((char *)BuffDest+offset+(index-1)) = *((char *)BuffSrc+(index-1));
			index++;
		}
		if (index <= MaxSize)
			*((char *)BuffDest+offset+(index-1)) = '\0';
		return (BuffDest);
	}
	/********************************************************************************
	
	Function Name: OsStrCmp.

	Function Description:The strcmp function compares string1 and string2 
			lexicographically and returns a value indicating their relationship

	Arguments: string1 ,string2 - Null terminated strings to compare
	
	Return Value: lexicographic relation of string1 to string2.

	********************************************************************************/
	int	OsStrCmp(const char *string1, char *string2)
	{
		int result = 0;
		int index = 0;
		char char1 = *(string1+index);
		char char2 = *(string2+index);

		result = (int)(char1 - char2);
		while ( (result == 0) && /* Must stop at the first missmatched letter*/
				(char1 != '\0') ) /* ((char2 == '\0')) No need to check char2-
									 if it is like char1, char1 is checked. If
									 it is not like char1, result != 0 */
		{
			index++;
			char1 = *(string1+index);
			char2 = *(string2+index);
			result = (int)(char1 - char2);
		}
		return (result);
	}
	/********************************************************************************
	
	Function Name: OsStrnCmp.

	Function Description:The strcmp function compares string1 and string2 
			lexicographically and returns a value indicating their relationship
	Arguments: string1 ,string2 - Null terminated strings to compare
						MaxSize	- Number of characters to compare
	
	Return Value: lexicographic relation of string1 to string2.

	********************************************************************************/
	int	OsStrnCmp(IN PCHAR string1, IN PCHAR string2, int MaxSize)
	{
		int index = 0;
		char *str1 = (char *) string1;
		char *str2 = (char *) string2;
		char char1 = str1[index];
		char char2 = str2[index];
		int result = (int)(char1 - char2);

		if ( MaxSize <= 0 )
		{
			return 0;
		}

		while ( (++index < MaxSize) &&
				(result == 0) && /* Must stop at the first missmatched letter*/
				(char1 != '\0') ) /* ((char2 == '\0')) No need to check char2 -
									 if it is like char1, char1 is checked. If
									 it is not like char1, result != 0 */
		{
			char1 = str1[index];
			char2 = str2[index];
			result = (int)(char1 - char2);
		}
		return (result);
	}

	/********************************************************************************
	
	Function Name: OsToupper.

	Function Description:converts a charecter c to upper case  

	Arguments: c - charected to be converted to upper case.
	
	Return Value: upper case charecter of c.

	********************************************************************************/
	int	OsToupper(int c)
	{
		if (c >= 'a' && c <= 'z')
			return (c - ('a' - 'A'));
		return (c);
	}
	/********************************************************************************
	
	Function Name: OsTolower.

	Function Description:converts a charecter c to lower case  

	Arguments: c - charected to be converted to lower case.
	
	Return Value: lower case charecter of c.

	********************************************************************************/
	int	OsTolower(int c)
	{
		if (c >= 'A' && c <= 'Z')
			return (c + ('a' - 'A'));
		return (c);
	}
	/********************************************************************************
	
	Function Name: OsIsDigit.

	Function tests if a charecter is a decimal digit. 

	Arguments: c - integer to test.
	
	Return Value: non zero value if c is a decimal digit('0' - '9').

	********************************************************************************/
	int	OsIsDigit(int c)
	{
		return ((c >='0' && c <= '9') ? 1 : 0);
	}

	/********************************************************************************
	
	Function Name: OSSprintfFixedArgs.

	Function Description:The OSSprintfFixedArgs function formats and stores a series of 
							characters and values in buffer. The function recieves the 
							format parameters not on the stack, but using the va_list
							parameter

	Arguments: buffer - Pointer to buffer to contain copied string.
			   format - control string.
			   StartedVaList - va_list that has been started to include the format arguments

	
	Return Value: OsSprintf returns the number of bytes stored in buffer, 
					not counting the terminating null character. 

	********************************************************************************/
int OSSprintfFixedArgs(OUT PCHAR Dest, PCHAR format, PCHAR StartedVaList)
{
	va_list			args	= *(va_list*)StartedVaList		;

	return vsprintf(Dest,format, args);
}
/********************************************************************************

Function Name: OsSprintf.

Function Description:The function returns the length of a null-terminated string.

Arguments: String - Pointer to buffer to contain copied string.

Return Value: int - the length of a null-terminated string.

********************************************************************************/
int	OsSprintf(PCHAR Dest, PCHAR format, ...)
{
	va_list			args			;
	int				RetVal;
	
	va_start (args , format) ;
	RetVal = vsprintf(Dest,format,args);
	va_end (args) ;
	return RetVal;
}

	/********************************************************************************

	Function Name: OsStrLen.

	Function Description:	returns the number of characters in string, not including 
							the terminating null character
	Arguments: string - Null-terminated string


	Return Value:	returns the number of characters in string, excluding the 
					terminal NULL. No return value is reserved to indicate an error.
	********************************************************************************/
	int	OsStrLen(const char * string)
	{
		int index=0;
		while (*(string+index) != '\0')
			index++;
		return (index);
	}

int Osatoi(const PCHAR String)
{
	char *temp_string = String;
	int temp = 0;
	while ( *temp_string )
	{
		temp <<= 4;
		if ( OsIsDigit(*temp_string))
		{
			temp += (*temp_string - '0');
		}
		if (*temp_string <= 'f' && *temp_string >= 'a')
		{
			temp += ((*temp_string - 'a')+10);
		}
		if (*temp_string <= 'F' && *temp_string >= 'A')
		{
			temp += ((*temp_string - 'A')+10);
		}
		temp_string++;	 
	}
	return (temp);
}
 
