/*
 * Copyright (c) 2001 Conexant Systems, Inc.
 * 
 * 1.   Permitted use. Redistribution and use in source and binary forms,
 * with or without modification, are permitted under the terms set forth
 * herein.
 * 
 * 2.   Disclaimer of Warranties. CONEXANT AND OTHER CONTRIBUTORS MAKE NO
 * REPRESENTATION ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.
 * IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTIES OF ANY KIND.
 * CONEXANT AND OTHER CONTRIBUTORS DISCLAIMS ALL WARRANTIES WITH REGARD TO
 * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, GOOD TITLE AND AGAINST INFRINGEMENT.
 * 
 * This software has not been formally tested, and there is no guarantee that
 * it is free of errors including, but not limited to, bugs, defects,
 * interrupted operation, or unexpected results. Any use of this software is
 * at user's own risk.
 * 
 * 3.   No Liability.
 * 
 * (a) Conexant or contributors shall not be responsible for any loss or
 * damage to Company, its customers, or any third parties for any reason
 * whatsoever, and CONEXANT OR CONTRIBUTORS SHALL NOT BE LIABLE FOR ANY
 * ACTUAL, DIRECT, INDIRECT, SPECIAL, PUNITIVE, INCIDENTAL, OR CONSEQUENTIAL
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED, WHETHER IN CONTRACT, STRICT OR OTHER LEGAL THEORY OF
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY
 * WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 * 
 * (b) User agrees to hold Conexant and contributors harmless from any
 * liability, loss, cost, damage or expense, including attorney's fees,
 * as a result of any claims which may be made by any person, including
 * but not limited to User, its agents and employees, its customers, or
 * any third parties that arise out of or result from the manufacture,
 * delivery, actual or alleged ownership, performance, use, operation
 * or possession of the software furnished hereunder, whether such claims
 * are based on negligence, breach of contract, absolute liability or any
 * other legal theory.
 * 
 * 4.   Notices. User hereby agrees not to remove, alter or destroy any
 * copyright, trademark, credits, other proprietary notices or confidential
 * legends placed upon, contained within or associated with the Software,
 * and shall include all such unaltered copyright, trademark, credits,
 * other proprietary notices or confidential legends on or in every copy of
 * the Software.
 * 
 */
#include "oscompat.h"
#include <linux/slab.h>
#include <linux/vmalloc.h>
#include <linux/interrupt.h>
#include <asm/io.h>

#include "framewrk.h"
#include "ossysenv.h"
#include "osmemory_ex.h"
#include "osstring_ex.h"

/******************************************************************************
	
	Function Name: OsPageReserve.

	Function Description:The function decommits a given memory space.

	Arguments: iPages - the base address of the memory space.
			   nPages - number of pages to be commited.
	

	Return Value: a pointer to the reserved memory space.

******************************************************************************/
PVOID OsPageReserve(UINT32 nPages, UINT32 Flags)
{
		PVOID temp = NULL;
		temp = vmalloc(nPages*PAGE_SIZE);
		if (NULL != temp)
			OsMemSet(temp,0,nPages*PAGE_SIZE);
		return (temp);
}
 
/******************************************************************************
	
	Function Name: OsPageFree.

	Function Description:The function frees a given memory space.

	Arguments: iPages - the base address of the memory space.
			   nPages - number of pages to free.
	

	Return Value: BOOL

******************************************************************************/
BOOL OsPageFree(PVOID	pMem, UINT32 nPages)
{
		if ( NULL == pMem )
			return FALSE;
		vfree(pMem);
		return TRUE;
}
 
/******************************************************************************
	
	Function Name: OsHeapAllocate.

	Function Description:The function allocates a given memory space and initializes it to zero.

	Arguments: Size - the size of memory space (heap) to br allocated.
	
	Return Value: a pointer to the allocated memory..

******************************************************************************/
PVOID OsHeapAllocate(UINT32 Size, int flags)
{
	PVOID pMem;

	switch(flags) {
		case OS_PAGED:
		case OS_NON_PAGED:
			flags = in_interrupt() ? GFP_ATOMIC : GFP_KERNEL;
			break;
		default:
			return NULL;
	}

	pMem = kmalloc(Size, flags);

	if ( NULL != pMem )
		memset(pMem, 0, Size);
	return pMem;
}
 
/******************************************************************************
	
	Function Name: OsHeapFree.

	Function Description:The function frees a memory space.

	Arguments: pMem - a pointer to the memory to be frees.
	
	Return Value: None.

******************************************************************************/
void OsHeapFree(PVOID pMem)
{
		kfree(pMem);
}
	
/******************************************************************************
 
	Function Name: OsGetPageSize.

	Function Description:The function returns the size of a page in the specific OS.

	Arguments: None.
	
	Return Value: The size of a page in the specific OS.

******************************************************************************/
UINT32	OsGetPageSize(void)
{
		return (PAGE_SIZE);
}
 
/******************************************************************************
	
	Function Name: OsMemDMAAllocate.

	Function Description:The function allocate a dma.

	Arguments: nPages - number of page to allocate..
			   ppPhysAddr - a pointer to be filled with the physical address of the dma.
			   pMemHandle - a pointer to be filled with the memory handle.
			   ppBuffer - a pointer to be filled with the ring-0 linear memory address.
	
	Return Value: boolean.

******************************************************************************/

//typedef struct *DMAALLOCATION PDMAALLOCATION;

//typedef struct tag_DMA_ALLOCATION 
//{
//	PUINT16 pBuff;
//	struct tag_DMA_ALLOCATION *next;
//}DMAALLOCATION, *PDMAALLOCATION;

BOOL	OsMemDMAAllocate(UINT32 nPages,PUINT16* ppPhysAddr, PHANDLE pMemHandle, PUINT16* ppBuffer)
{
	int count;
	unsigned long allocs[256];

	for ( count = 0 ; count < 256 ; count++  )
	{
		allocs[count] = __get_dma_pages(GFP_KERNEL, nPages);
		if ( !allocs[count] )
		{
			break;
		}

		if ( 0x0 == (((UINT32)(allocs[count])) & 0x0000FFFF) )
		{
			*ppBuffer = (PUINT16)allocs[count];
			*pMemHandle = (PVOID) allocs[count];
			*ppPhysAddr = (PUINT16)virt_to_bus(*ppBuffer);
//			printk("OsMemDMAAllocate success - 0x%x(0x%x) after %d attempts\n",
//				   (int) allocs[count], (int) *ppPhysAddr, count);
			for ( count--; count >= 0; count-- )
			{
				free_pages(allocs[count], nPages);
			}
			return (TRUE);
		}
	}

	printk(KERN_ERR __FUNCTION__": failed (attempt=%d)\n", count);

	for ( count--; count >= 0; count-- )
	{
		free_pages(allocs[count], nPages);
	}
	return (FALSE);
}
 
/******************************************************************************
	
	Function Name: OsMemDMAFree.

	Function Description:The function allocate a dma.

	Arguments: MemHandle - a memory handle.
			   Flags - flags.
	
	Return Value: boolean.

******************************************************************************/
BOOL	OsMemDMAFree(HANDLE MemHandle, UINT32 nPages)
{
		if (NULL == MemHandle)
			return (FALSE);

		ASSERT(nPages > 0);

//		printk( "OsMemDMAFree: freeing 0x%lx (%d pages)\n", MemHandle, nPages );
		free_pages((unsigned long)MemHandle, nPages);
		return (TRUE);
}

