/*
 * Copyright (c) 2001 Conexant Systems, Inc.
 * 
 * 1.   Permitted use. Redistribution and use in source and binary forms,
 * with or without modification, are permitted under the terms set forth
 * herein.
 * 
 * 2.   Disclaimer of Warranties. CONEXANT AND OTHER CONTRIBUTORS MAKE NO
 * REPRESENTATION ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.
 * IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTIES OF ANY KIND.
 * CONEXANT AND OTHER CONTRIBUTORS DISCLAIMS ALL WARRANTIES WITH REGARD TO
 * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, GOOD TITLE AND AGAINST INFRINGEMENT.
 * 
 * This software has not been formally tested, and there is no guarantee that
 * it is free of errors including, but not limited to, bugs, defects,
 * interrupted operation, or unexpected results. Any use of this software is
 * at user's own risk.
 * 
 * 3.   No Liability.
 * 
 * (a) Conexant or contributors shall not be responsible for any loss or
 * damage to Company, its customers, or any third parties for any reason
 * whatsoever, and CONEXANT OR CONTRIBUTORS SHALL NOT BE LIABLE FOR ANY
 * ACTUAL, DIRECT, INDIRECT, SPECIAL, PUNITIVE, INCIDENTAL, OR CONSEQUENTIAL
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED, WHETHER IN CONTRACT, STRICT OR OTHER LEGAL THEORY OF
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY
 * WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 * 
 * (b) User agrees to hold Conexant and contributors harmless from any
 * liability, loss, cost, damage or expense, including attorney's fees,
 * as a result of any claims which may be made by any person, including
 * but not limited to User, its agents and employees, its customers, or
 * any third parties that arise out of or result from the manufacture,
 * delivery, actual or alleged ownership, performance, use, operation
 * or possession of the software furnished hereunder, whether such claims
 * are based on negligence, breach of contract, absolute liability or any
 * other legal theory.
 * 
 * 4.   Notices. User hereby agrees not to remove, alter or destroy any
 * copyright, trademark, credits, other proprietary notices or confidential
 * legends placed upon, contained within or associated with the Software,
 * and shall include all such unaltered copyright, trademark, credits,
 * other proprietary notices or confidential legends on or in every copy of
 * the Software.
 * 
 */

/*************************************************************************
  File Name: ConfigCodes.h
  File Description:
  *************************************************************************/
#ifndef __CONFIGCODES_H__
#define __CONFIGCODES_H__
#include "comtypes.h"
/* //////////////////////////////////////////////////////////////// */
/* Data in AtCmd.c (AtPlusMS) relies on the enum order
 If make any changes in this enum - modify that data as well */
 
typedef enum {
	MODULATION_TYPE_BELL103,
	MODULATION_TYPE_BELL212,		
	MODULATION_TYPE_V21,
	MODULATION_TYPE_V22,		
	MODULATION_TYPE_V22BIS,		
	MODULATION_TYPE_V23,		
	MODULATION_TYPE_V32,		
	MODULATION_TYPE_V32BIS,		
	MODULATION_TYPE_V34,		
	MODULATION_TYPE_K56,		
	MODULATION_TYPE_V90,		
	MODULATION_TYPE_VFC,		
 
	MODULATION_TYPE_K56A,
    MODULATION_TYPE_V34_CLEAR,
    MODULATION_TYPE_V33,
    MODULATION_TYPE_V32BIS_CLEAR,
	MODULATION_TYPE_V29,		
	MODULATION_TYPE_V27,
    MODULATION_TYPE_V21C2, 
    MODULATION_TYPE_V17,
}MODULATION_TYPE;
 
// See DevMgr_Control function + DEVMGR_SET_DAA_STATE control code
typedef enum {
	DEVMGR_GPIO_RELAY_MASK,
	DEVMGR_GPIO_DEFAULT_STATE,
	DEVMGR_OFFHOOK_PHONETOLINE,
	DEVMGR_OFFHOOK_PHONEOFFLINE,
	DEVMGR_ONHOOK_PHONETOLINE_CALLID,
	DEVMGR_ONHOOK_PHONETOLINE_NOCALLID,
	DEVMGR_ONHOOK_PHONEOFFLINE_CALLID,
	DEVMGR_ONHOOK_PHONEOFFLINE_NOCALLID,
	DEVMGR_OFFHOOK_PULSE_MAKE,
	DEVMGR_OFFHOOK_PULSE_BREAK,
	DEVMGR_OFFHOOK_PULSESETUP,
	DEVMGR_OFFHOOK_PULSECLEAR,
	DEVMGR_LAST_RELAY_ENTRY
} DEVMGR_DAA_RELAY_CODE;
 
typedef enum {
	ANSWER_MODE,
	CALLER_MODE
} CALL_MODE;
typedef enum 
{
    CFGMGR_MS_STR,                               /* +ms parameters */
    CFGMGR_MS_PARAMS,                               /* +ms parameters */
    CFGMGR_EC_PARAMS,                               /* PEC_USER_CONFIG EC parameters */
    CFGMGR_COMPRESSION_PARAMS,                      /* PCOMPRESSION_USER_CONFIG compression parameters */
    CFGMGR_COMPRESSION_ENABLE,                      /* UINT8 */
    CFGMGR_RETRAIN_ENABLED,                         /* */
    CFGMGR_K56_USE_ULAW,
    CFGMGR_DCD_ON,
    CFGMGR_CADENCE_PARAMS,                          /* CADENCE_CFG * - params of the cadence */
 
	CFGMGR_ITF_PARAMS,								/* +itf Tx Flow Control Thresholds */
    CFGMGR_V44_PARAMS,								/* PV44_USER_CONFIG  V.44 compression parameters */


    /* AT-parser to LMON */
    CFGMGR_FORCE_RENEG_UP,                          /* UINT8            */
    CFGMGR_FORCE_RENEG_DOWN,                        /* UINT8            */
    CFGMGR_IN_V34FAX,                               /* UINT8            */

    /* S-Registers  - UINT8 */
	CFGMGR_SREG,									/* S0  (14)*/
	CFGMGR_NRINGS_TO_ANSWER     = CFGMGR_SREG+0,	/* Number of rings before modem answers the call */
	CFGMGR_RING_COUNTER         = CFGMGR_SREG+1,    /* Number of rings detected */
	CFGMGR_ESCAPE_CHAR          = CFGMGR_SREG+2,    /* Escape character (+) */
	CFGMGR_CR_CHAR              = CFGMGR_SREG+3,    /* Line Termination character (CR) */
	CFGMGR_LF_CHAR              = CFGMGR_SREG+4,    /* Response Formatting character (LF) */
	CFGMGR_BS_CHAR              = CFGMGR_SREG+5,	/* Command Line Editing character (BS) */
	CFGMGR_BLIND_DIAL_WAIT_TIME = CFGMGR_SREG+6,    /* Time, in seconds, the modem waits before starting to dial 
													   after going off hook when blind dialing. */
	CFGMGR_CARRIER_WAIT_TIME    = CFGMGR_SREG+7,    /* Time, in seconds, the modem waits for carrier.
													   If enabled by country options, time, in seconds, 
													   the modem waits for dialtone after 'W' dial modifier */
	CFGMGR_PAUSE_DELAY_TIME     = CFGMGR_SREG+8,    /* Time, in seconds, the modem waits after ',' dial modifier */
	CFGMGR_CARDET_RESPONSE_TIME = CFGMGR_SREG+9,    /* Time, in 0.1 seconds modem waits before reporting carrier */
	CFGMGR_HANGUP_DELAY_TIME    = CFGMGR_SREG+10,	/* Time, in tenths of a second, the modem waits before 
													   hanging up after a loss of carrier */
	CFGMGR_DTMF_DURATION        = CFGMGR_SREG+11,   /* Duration, in milliseconds, of tones in DTMF dialing */
	CFGMGR_ESCAPE_PROMPT_DELAY  = CFGMGR_SREG+12,   /* Time, in fiftieths of a second, between receiving +++
													   and sending OK to DTE */
	CFGMGR_TEST_TIMER           = CFGMGR_SREG+18,   /* Time, in seconds, that the modem conducts a test (&T1) */
	CFGMGR_FLASH_DELAY_TIME     = CFGMGR_SREG+29,   /* Time, in hundredths of a second, the modem goes on-hook 
													   after flash (!) modifier */
	CFGMGR_INACTIVITY_TIME      = CFGMGR_SREG+30,   /* Time, in tens of seconds, the modem stays online when no
													   data is sent or received */
    CFGMGR_DATA_COMPRESSION     = CFGMGR_SREG+46,   /* Selection of compression */
	CFGMGR_EXTENDED_RESULT_CODES = CFGMGR_SREG+95,/* Bits to override some of the W control options */
    CFGMGR_SREG_LAST = CFGMGR_SREG+255,				/* S-register window end (269)*/


	/* Call Progress control codes */
	CFGMGR_DIALSTRING,								/* Pointer to a dial string     LPCSTR */
	CFGMGR_PULSE_DIAL_CONFIG,						/* Pulse dial parameters    */
	CFGMGR_TONE_DIAL_CONFIG,						/* Tone dial parameters     */
	CFGMGR_DIALTONE_WAIT_TIME,						/* Time in tenths of a second the modem waits for dialtone */
	CFGMGR_DIAL_MODE,								/* Dial mode (tone or pulse      DIAL_MODE */
	CFGMGR_AMPERP,									/* Value of the last at&p command */
	CFGMGR_USE_S7_WHEN_W,							/* if TRUE, use S7 for timeout after W modifier in dial string
													   if FALSE, use CFGMGR_DIALTONE_WAIT_TIME value */
    CFGMGR_INVERT_CALLING_TONE,                     /* If TRUE - invert calling tone fro this call */

    CFGMGR_CALL_PROGRESS_TONE_DEBOUNCE,				/* Debounce times for call progress tones */
	CFGMGR_CALL_MODE,     				            /* CALL_MODE*                   */
    CFGMGR_CALL_PROGRESS_TIMING,					/* TIMING_CONFIG*. Delays       (280)*/
	CFGMGR_CALL_PROGRESS_FLAGS,						/* CALL_PROGRESS_FLAGS*         */
	CFGMGR_V8BIS_CONTROL,							/* V8BIS_OPERATION_CONTROL*		*/
	CFGMGR_V8BIS_RESULT,							/* PV8BIS_RESULT				*/
    CFGMGR_FIRST_CONNECTION_AFTER_TRAINING,         /* ??? */
    CFGMGR_PREFERRED_FLEX_VERSION,                  /* Preferred Flex version       */
    CFGMGR_V90_ENABLED,                             /* V.90 is enabled              */
    CFGMGR_V70_ALLOWED,                             /* V.70 is allowed              */

    /* AtParser Result Messages  - LPCSTR */
    CFGMGR_ATRESULT_OK,                            
    CFGMGR_ATRESULT_CONNECT,
    CFGMGR_ATRESULT_RING,	/* (290) */
    CFGMGR_ATRESULT_NOCARRIER,
    CFGMGR_ATRESULT_ERROR,
    CFGMGR_ATRESULT_NODIALTONE,
    CFGMGR_ATRESULT_BUSY,
    CFGMGR_ATRESULT_NOANSWER,
    CFGMGR_ATRESULT_DELAYED,
    CFGMGR_ATRESULT_BLACKLISTED,
    CFGMGR_ATRESULT_FAX,
    CFGMGR_ATRESULT_DATA,
    CFGMGR_ATRESULT_FCERROR, /* (300) */
 
    /* MCR Messages  - LPCSTR */
    CFGMGR_MCR_B103,
	CFGMGR_MCR_B212,
	CFGMGR_MCR_V21,
	CFGMGR_MCR_V22,
	CFGMGR_MCR_V22B,
	CFGMGR_MCR_V23,
	CFGMGR_MCR_V32,         // = 307
	CFGMGR_MCR_V32B,
	CFGMGR_MCR_V34,
	CFGMGR_MCR_K56,	/* (310) */
	CFGMGR_MCR_V90,

    CFGMGR_ER_NONE,
    CFGMGR_ER_LAPM,
    CFGMGR_ER_ALT,

    CFGMGR_DR_ALT,
    CFGMGR_DR_V42B,
    CFGMGR_DR_NONE,
 
    /* ATIn Messages - LPCSTR */
    CFGMGR_ATMESSAGE_I0,
    CFGMGR_ATMESSAGE_I1,
    CFGMGR_ATMESSAGE_I2,	/* (320) */
    CFGMGR_ATMESSAGE_I3,
    CFGMGR_ATMESSAGE_I4,
    CFGMGR_ATMESSAGE_I5,
    CFGMGR_ATMESSAGE_I6,
    CFGMGR_ATMESSAGE_I7,
    CFGMGR_ATMESSAGE_I8,
    CFGMGR_ATMESSAGE_I9,
    CFGMGR_ATMESSAGE_I10,
    CFGMGR_ATMESSAGE_I11,
    CFGMGR_ATMESSAGE_I12,	/* (330) */

    /* AT+GXX Messages  - LPCSTR    */
    CFGMGR_ATMESSAGE_MANUFACTURER,      /* AT+GMI responce  */
    CFGMGR_ATMESSAGE_MODEL,             /* AT+GMM responce  */
    CFGMGR_ATMESSAGE_REVISION,          /* AT+GMR responce  */
    CFGMGR_ATMESSAGE_SERIAL_NUM,        /* AT+GSN responce  */
    CFGMGR_ATMESSAGE_GOI,               /* AT+GOI responce  */
    CFGMGR_ATMESSAGE_CAPABILITIES,      /* AT+GCAP responce */

    /* DTE configuration    */
    CFGMGR_DTE_ECHO,                    /* UINT8            */
    CFGMGR_DTE_CONFIG,                  /* DTE_USER_CONFIG  */

    CFGMGR_SYNC_MODE,                   /* AT&Q             */

    CFGMGR_RLSD_BEHAVIOR,               /* UINT8          (340)  */
    CFGMGR_DTR_BEHAVIOR,                /* UINT8            */

    /* Speaker Control */
    CFGMGR_SPEAKER_VOLUME,              /* UINT8            */
    CFGMGR_SPEAKER_CONTROL,             /* UINT8            */

    /* Pulse Dial Make/Break Ratio */
    CFGMGR_PULSE_MAKE_BREAK,            /* UINT8            */

    /* Ring burst frequencies */
    CFGMGR_RING_BURST,                  /* PRING_BURST_PARAMS */

    /* Answer tone detector params */
    CFGMGR_ANSWER_TONE_DETECTOR,        /* PANSWER_TONE_PARAMS */
    /* Bell answer (2225) tone detector params */
    CFGMGR_BELL_TONE_DETECTOR,          /* PANSWER_TONE_PARAMS */
    /* DTMF generator parameters */
    CFGMGR_DTMF_GENERATOR,              /* PDTMF_GEN_PARAMS */

    /* Modulation Report    */
    CFGMGR_MODULATION_REPORT,           /* UINT8            */

    /* Cadences */
    CFGMGR_CADENCE_BASE, /* (350) */
    CFGMGR_BUSY_TONE_CADENCE = CFGMGR_CADENCE_BASE,
    CFGMGR_RING_CADENCE,
    CFGMGR_REORDER_TONE_CADENCE,
    CFGMGR_SDIAL_TONE_CADENCE,
    CFGMGR_FAX_CALL_TONE_CADENCE,

    /* FAX Service Class 1 Configuration Values   */
    CFGMGR_FAX_AUTO_ANSWER,

    /*  OEM flags   */
    CFGMGR_OEM_FLAGS,                   /* OEMFlagStructure */
	CFGMGR_OEM_FLAGS2,					/* OEMFlag2Structure        */
    CFGMGR_OEM_FILTERS,                 /* OEMFilterStructure       */
    CFGMGR_OEM_SPKR_MUTE_DELAY,         /* UINT16 SpkrMuteDelay     */
	CFGMGR_OEM_READ_MASK,				/* UINT16 OEMReadMask       (360)*/
    CFGMGR_OEM_THRESHOLD,				/* OEMThresholdStruct       */

    CFGMGR_COUNTRY_CODE,                /* current country code     */
                                        /* Note: DO NOT USE THIS CODE TO CHANGE THE COUNTRY !!! */
                                        /* USE CONFIGMGR_CONTROL_CHANGE_COUNTRY CONTROL CODE INSTEAD */
    CFGMGR_PREVIOUS_COUNTRY_CODE,       /* previous country code    */
    CFGMGR_COUNTRY_NAME,                /* name of current country  */
    CFGMGR_COUNTRY_CODE_LIST,           /* list of supported country codes */
    CFGMGR_COUNTRY_STRUCT,              /* read the whole country structure */
    CFGMGR_COUNTRY_BLIST,              
	CFGMGR_FILTERS,						/* CntryTxlevelStructure    */
	CFGMGR_DTMF,						/* CntryDTMFStructure       */
	CFGMGR_SMART_DTMF,						/* CntryDTMFStructure       */
	CFGMGR_RING_PARAMS ,					/* Ring Detector timing	(370)	*/
	CFGMGR_RLSDOFFSET,					/* RLSDXrthOffset           */
	CFGMGR_THRESHOLD,
	CFGMGR_TXLEVELS,					/* CntryTxlevelStructure    */
	CFGMGR_SMART_TXLEVELS,					/* CntryTxlevelStructure    */
	CFGMGR_RELAYS,						/* Relays[LAST_RELAY_ENTRY] */
	CFGMGR_SMART_RELAYS,						/* Relays[LAST_RELAY_ENTRY] */
	CFGMGR_SPEED_ADJUST,				/* CntryAgressSpeedIndexStructure a.k.a CountrySpeedAdjust */
    CFGMGR_SREG_LIMITS,                 /* limits for S-registers   */
    CFGMGR_PR_IGNORE_TIME,              /* ignore polarity reversal for secified non-zero time (377)*/
 
#ifdef CW_CID_SUPPORTED
    CFGMGR_COUNTRY_CALLERID1,           /* CID type */
	CFGMGR_COUNTRY_CALLERID2,			/* */
	CFGMGR_COUNTRY_CALL_WAITING,		/* */
	CFGMGR_VCID_FORMAT,					/* +VCID settings */
	CFGMGR_VRID_FORMAT,					/* +VRID settings */
	CFGMGR_CALL_WAITING,				/* call waiting info		*/
	CFGMGR_CALLER_ID_INFO,				/* current caller id state  */
 
	CFGMGR_VRID_CRC,					/* stored CID CRC			*/
	CFGMGR_VRID_TYPE,
	CFGMGR_VRID_LENGTH,
	CFGMGR_VRID_DATA,
#endif
 
#ifdef V92_SUPPORTED
	CFGMGR_MOH,							/* MOH info					*/
	CFGMGR_PCMUPSTREAM,					/* PCM upstream configuration */
	CFGMGR_QC,							/* quick connect info		*/
#endif // V92_SUPPORTED

    CFGMGR_PROFILE_STORED,        		/* PPROFILE_DATA            */
    CFGMGR_PROFILE_FACTORY,        		/* PPROFILE_DATA            */

    CFGMGR_POUND_UD,                    /* #UD/#UG structure        (380)*/

    CFGMGR_ATPARSER_ONLINE,              /* UINT8                   */
    CFGMGR_BLACK_LIST,                  /*  Black List structure    */
	CFGMGR_SMARTDAA,					/* SDAA structure           */
 
 
 
	/* Soft Modem Tone configurations */
	CFGMGR_TONE_PRIMARY_PARAMS,				/* SINGLETONEDETECT*	*/	
	CFGMGR_TONE_ALTERNATE_PARAMS,			/* SINGLETONEDETECT*	*/	
	CFGMGR_TONE_ATBEL_PARAMS,				/* SINGLETONEDETECT*	*/	
	CFGMGR_TONE_ATV25_PARAMS,				/* SINGLETONEDETECT*	*/	
	CFGMGR_TONE_1100_PARAMS,				/* SINGLETONEDETECT*	*/	
	CFGMGR_TONE_2130_PARAMS,				/* SINGLETONEDETECT*	*/	
	CFGMGR_TONE_2312_PARAMS,				/* SINGLETONEDETECT*	(390)*/	
	CFGMGR_TONE_2750_PARAMS,				/* SINGLETONEDETECT*	*/	
	CFGMGR_TONE_2912_PARAMS,				/* SINGLETONEDETECT*	*/	
	CFGMGR_VOICETONEACALLPROG_PARAMS,		/* SINGLETONEDETECT*	*/	
	CFGMGR_VOICETONEB_1100_PARAMS,			/* SINGLETONEDETECT*	*/	
	CFGMGR_VOICETONEC_1300_PARAMS,			/* SINGLETONEDETECT*	*/	
	CFGMGR_VOICETONEC_2100_PARAMS,			/* SINGLETONEDETECT*	*/	
	CFGMGR_VOICETONEB_2225_PARAMS,			/* SINGLETONEDETECT*	*/	
	CFGMGR_V8BTONE_2100_PARAMS,				/* SINGLETONEDETECT*	*/	
	CFGMGR_V8BTONE_2225_PARAMS,				/* SINGLETONEDETECT*	*/	
	CFGMGR_CI_CENTER_TONEB_PARAMS,			/* SINGLETONEDETECT*	(400)*/	
	CFGMGR_CI_SIDE_TONEC_PARAMS,			/* SINGLETONEDETECT*	*/	
	CFGMGR_VOICEVIEW_TONEC_2912_PARAMS,		/* SINGLETONEDETECT*	*/	
	CFGMGR_VOICEVIEW_TONEB_2312_PARAMS,		/* SINGLETONEDETECT*	*/	
	CFGMGR_VOICEVIEW_TONEB_2750_PARAMS,		/* SINGLETONEDETECT*	*/	
	CFGMGR_VOICEVIEW_TONEA_2130_PARAMS,		/* SINGLETONEDETECT*	*/	
	CFGMGR_VOICEVIEW_TONEA_NOT_ST_PARAMS,	/* SINGLETONEDETECT*	*/	
	CFGMGR_TONEC_1650_PARAMS,				/* SINGLETONEDETECT*	*/	
	CFGMGR_CReSEG1_2002PARAMS,				/* SINGLETONEDETECT*	*/	
	CFGMGR_TONE_1270_PARAMS,				/* SINGLETONEDETECT*	*/	
	CFGMGR_TONE_AS,					/* TONEGEN_PARAMS*		*/
	CFGMGR_TONE_GEN_1650,					/* TONEGEN_PARAMS*		*/
 
	// Tone generator - constant configurations saved in Configuration manager
	CFGMGR_TONE_GEN_V25CALL,				/* TONEGEN_PARAMS*		*/
	CFGMGR_TONE_GEN_CNG,					/* TONEGEN_PARAMS*			(410)	*/
	CFGMGR_TONE_GEN_CED,					/* TONEGEN_PARAMS*				*/
	CFGMGR_TONE_GEN_CI,						/* TONEGEN_PARAMS*				*/
 
    /** HW - buffer switch delay. **/
    CFGMGR_BUFFERS_DELAY,                   /* UINT16*. */
   	CFGMGR_PCI_DEVICE_ID,	/*(414) */
	CFGMGR_PCI_VENDOR_ID,
 
    CFGMGR_OEM_HWDATA,                   /* HW_DATA */
    CFGMGR_OEM_DAATYPE,                   /* BYTE */
	CFGMGR_OEM_SMARTDAA_PARAMS         ,   /*  CAESAR_PARAMS */
	CFGMGR_HW_ADAPTER_TYPE,                
 	CFGMGR_YUKON_FIRMWARE_DATA,            /* Yukon firmware */
	CFGMGR_YUKON_FIRMWARE_DELETE,          /* Delete Yukon memory allocation */

	/* country parametrs for CtryPrmsStruct */
/*  	CFGMGR_CTRY_INTCODE          ,     Country Name                   (420)*/ 
/*  	CFGMGR_CTRY_PULSE            ,     CntryPulseStructure            */ 
	CFGMGR_CTRY_TONE             ,    /* CntryToneStructure             */
	CFGMGR_CTRY_CADENCE          ,    /* CntryCadenceStructure          */
	CFGMGR_CTRY_CALLERID         ,    /* CntryCallerIDStructure         */ 
 
	CFGMGR_HSFI_TYPE         ,    /* BOOL (TRUE for SmartHSFi, FALSE for HSFi)         */ 
    CFGMGR_LAST

} CFGMGR_CODE;
 
 
 
typedef enum tagHW_TYPE{ // do not change the order for linux inf file sake
	HW_TYPE_NONE = 0, 
	HW_TYPE_BASIC2, 
	HW_TYPE_ICH, 
	HW_TYPE_YUKON, 
	HW_TYPE_LAST,
}HW_TYPE;
 
 
/*****************************************************************
OEM & COUNTRY specific parameters, should be loaded from NVRAM
BEGIN
*****************************************************************/
/* COUNTRY PARAMETRERS  */
 
#define MAX_INTERVALS				4
#define MAX_OEM_STR_LEN				80
/* Number of S-registers limited by entries in the INF file */
#define NUM_LIMITED_SREGS			10
#define NUM_FULL_SREGS              40
#if ( OS_TYPE != OS_LINUX )
#if ( USE_PRAGMA_PACK == 1 )
#pragma pack(1)		/* must be pack */
#endif
#endif
 
 
#define DEFAULT_DC_LOOP_POINTS	5
#define DEFAULT_DC_LOOP_ENTRIES	5
#define IMPEDANCE_VALUES_NUM	4
#define NUM_OF_RESISTANCES		5	
 
 
#if ( OS_TYPE != OS_LINUX )
#if ( USE_PRAGMA_PACK == 1 )
#pragma pack()
#endif
#endif
 
/*****************************************************************
OEM & COUNTRY specific parameters, should be loaded from NVRAM
END
*****************************************************************/

#endif      /* #ifndef __CONFIGCODES_H__ */
