/*
 * Copyright (c) 2001 Conexant Systems, Inc.
 * 
 * 1.   Permitted use. Redistribution and use in source and binary forms,
 * with or without modification, are permitted under the terms set forth
 * herein.
 * 
 * 2.   Disclaimer of Warranties. CONEXANT AND OTHER CONTRIBUTORS MAKE NO
 * REPRESENTATION ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.
 * IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTIES OF ANY KIND.
 * CONEXANT AND OTHER CONTRIBUTORS DISCLAIMS ALL WARRANTIES WITH REGARD TO
 * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, GOOD TITLE AND AGAINST INFRINGEMENT.
 * 
 * This software has not been formally tested, and there is no guarantee that
 * it is free of errors including, but not limited to, bugs, defects,
 * interrupted operation, or unexpected results. Any use of this software is
 * at user's own risk.
 * 
 * 3.   No Liability.
 * 
 * (a) Conexant or contributors shall not be responsible for any loss or
 * damage to Company, its customers, or any third parties for any reason
 * whatsoever, and CONEXANT OR CONTRIBUTORS SHALL NOT BE LIABLE FOR ANY
 * ACTUAL, DIRECT, INDIRECT, SPECIAL, PUNITIVE, INCIDENTAL, OR CONSEQUENTIAL
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED, WHETHER IN CONTRACT, STRICT OR OTHER LEGAL THEORY OF
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY
 * WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 * 
 * (b) User agrees to hold Conexant and contributors harmless from any
 * liability, loss, cost, damage or expense, including attorney's fees,
 * as a result of any claims which may be made by any person, including
 * but not limited to User, its agents and employees, its customers, or
 * any third parties that arise out of or result from the manufacture,
 * delivery, actual or alleged ownership, performance, use, operation
 * or possession of the software furnished hereunder, whether such claims
 * are based on negligence, breach of contract, absolute liability or any
 * other legal theory.
 * 
 * 4.   Notices. User hereby agrees not to remove, alter or destroy any
 * copyright, trademark, credits, other proprietary notices or confidential
 * legends placed upon, contained within or associated with the Software,
 * and shall include all such unaltered copyright, trademark, credits,
 * other proprietary notices or confidential legends on or in every copy of
 * the Software.
 * 
 */
#include "oscompat.h"
#include <linux/slab.h>
#include <linux/pci.h>
#include <linux/time.h>
#include <asm/irq.h>
#include <asm/io.h>
#include <linux/interrupt.h>

#include "ossysenv.h"
#include "linuxres.h"


BOOL	LinuxGetHwPciRes(void **pPciDev, unsigned long *pbaseaddr0, unsigned long *pbaseaddr1, unsigned short DeviceId, unsigned short VendorId)
{
	struct pci_dev *pdev;
#if ( LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0) )
	int err;
#endif

	//printk(KERN_DEBUG "LinuxGetHwPciRes DevId=0x%x VendId=0x%x\n", DeviceId, VendorId );

	if (!pcibios_present())
		return FALSE;


	pdev = pci_find_device(VendorId, DeviceId, NULL);
	if (pdev == NULL)
		return FALSE;

	*pPciDev = pdev;
#if ( LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0) )
	*pbaseaddr0 = pdev->base_address[0];
	*pbaseaddr1 = pdev->base_address[1];
#else
	*pbaseaddr0 = pci_resource_start(pdev, 0);
	*pbaseaddr1 = pci_resource_start(pdev, 1);
  	if ( (err = pci_enable_device(pdev)) ) 
  	{ 

  		printk(KERN_ERR "LinuxGetHwPciRes: pci_enable_device() failed (err=%d), DeviceId=0x%x VendorId=0x%x\n", err, DeviceId, VendorId);
		return FALSE;
  	} 
#endif
 	pci_set_master(pdev); 
			
	// cancel the LSB for io address 
	*pbaseaddr0 = (*pbaseaddr0) & 0xFFFFFFFE;
	*pbaseaddr1 = (*pbaseaddr1) & 0xFFFFFFFE;
 
#if 0
	printk(KERN_DEBUG "LinuxGetHwPciRes: found device, addr0=0x%lx addr1=0x%lx irq=%d\n",
				*pbaseaddr0,
				*pbaseaddr1,
				pdev->irq);
#endif

	return TRUE;
}

BOOL	LinuxHookInterrupt(void *pPciDev, void (*isr)(int irq, void *devidp, void *unused), void *devid)
{
	struct pci_dev *dev = (struct pci_dev *)pPciDev;
	int err;

	err = request_irq(dev->irq,
			/* for efficiency we assume that the isr function passed has the
			 * same calling conventions and arguments as standard Linux
			 * interrupt handlers. If these ever change, a stub-function to
			 * convert would be required.
			 */
			(void (*)(int irq, void *devidp, struct pt_regs *))isr,
			SA_SHIRQ, "hsf", devid); 

  	if (err) {
		printk(KERN_ERR "LinuxHookInterrupt: request for IRQ %d failed\n", dev->irq);
		return FALSE;
	}

	return TRUE;
}

void	LinuxUnhookInterrupt(void *pPciDev, void *devid)
{
	struct pci_dev *dev = (struct pci_dev *)pPciDev;

	free_irq(dev->irq, devid); 
}

void	*LinuxMapPhys(unsigned long offset, unsigned long size)
{
	return ioremap(offset, size);
}

unsigned short LinuxReadw(void *addr)
{
	unsigned short val = readw(addr);
/*  	printk(KERN_DEBUG "LinuxReadw read 0x%x from 0x%x\n",val,addr);  */
	return val;
}

unsigned int LinuxReadl(void *addr)
{
	unsigned int val = readl(addr);
/*  	printk("LinuxRead read 0x%x from 0x%x\n",val,addr); */
	return (val);
}

void	LinuxWritew(void *addr, unsigned short wVal)
{
/*  	printk(KERN_DEBUG "LinuxWritew writes 0x%x to 0x%x\n",wVal,addr); */
	writew(wVal, addr);
}
 
 
void	LinuxWritel(void * addr, unsigned int dwVal)
{
/*  	printk(KERN_DEBUG "LinuxWritel(%x, %x)\n",addr, dwVal); */
	writel(dwVal, addr);
}
 
 
unsigned char LinuxIoReadb(unsigned int port)
{
	unsigned char val = inb(port);
/*  	printk(KERN_DEBUG "LinuxIoReadb read 0x%x from 0x%x\n",val,port);  */
	return val;
}
 
 
unsigned short LinuxIoReadw(unsigned int port)
{
	unsigned short val = inw(port);
/*  	printk(KERN_DEBUG "LinuxIoReadw read 0x%x from 0x%x\n",val,port);  */
	return val;
}
 
unsigned int LinuxIoReadl(unsigned int port)
{
	unsigned int val = inl(port);
/*  	printk(KERN_DEBUG "LinuxIoReadw read 0x%x from 0x%x\n",val,port);  */
	return val;
}
 
 
void	LinuxIoWriteb(unsigned int port, unsigned char bVal)
{
/*  	printk(KERN_DEBUG "LinuxIoWritew writes 0x%x to 0x%x\n",bVal,addr); */
	outb(bVal, port);
}
 
void	LinuxIoWritew(unsigned int port, unsigned short wVal)
{
/*  	printk(KERN_DEBUG "LinuxIoWritew writes 0x%x to 0x%x\n",wVal,addr); */
	outw(wVal, port);
}
 
 
void	LinuxIoWritel(unsigned int port, unsigned int dwVal)
{
/*  	printk(KERN_DEBUG "LinuxIoWritel(%x, %x)\n",addr, dwVal); */
	outl(dwVal, port);
}
 
void LinuxPciReadConfigdw(void *pPciDev, unsigned char Offset, unsigned long *pVal)
{
	pci_read_config_dword(pPciDev, Offset, (unsigned int *)pVal);
}
 
void LinuxPciWriteConfigdw(void *pPciDev, unsigned char Offset, unsigned long Val)
{
	pci_write_config_dword(pPciDev, Offset, Val);
}
 
unsigned long crit_section_start()
{
	unsigned long flags;

	save_flags(flags); cli();

	return flags;
}

void crit_section_end(unsigned long flags)
{
	restore_flags(flags);
}
 
 
unsigned long LinuxCalcCpuRate(void)
{
	struct timeval tv;
	unsigned long Flag;
	unsigned long time1, time2;
	unsigned int target_usec;
	
 
	// first ensure that the tv_usec will not wraparound
	do_gettimeofday( &tv );
 
	if ( tv.tv_usec > 990000 ) {
		do
		{
			do_gettimeofday( &tv );
		} while ( tv.tv_usec > 990000 );
	}
 
	// calc the cpu rate 
	save_flags(Flag); cli();
	do_gettimeofday( &tv );
	rdtscl(time1);
	target_usec = tv.tv_usec + 1000;
	do
	{
		do_gettimeofday( &tv );
	} while ( tv.tv_usec < target_usec );
	rdtscl(time2);
	restore_flags( Flag );
 
	return( ( (time2-time1+500) /1000 ) * 1000000); // to get whole number 
}
 
