
#ifndef __OSSTDIO_H__
#define __OSSTDIO_H__

#ifdef __cplusplus
extern "C"
{
#endif

#if ( UK_MODE == UK_KERNEL )

struct file;

typedef struct file FILE;

#define SEEK_SET		0x00000000
#define SEEK_CUR		0x00000001
#define SEEK_END		0x00000002

#define EOF	(-1)

#ifndef OS_NOREDEFS

#define fopen OsFOpen
#define fread OsFRead
#define fwrite OsFWrite
#define fclose OsFClose
#define fseek OsFSeek

#endif // OS_NOREDEFS

FILE * __cdecl OsFOpen(const char *, const char *);
size_t __cdecl OsFRead(void *, size_t, size_t, FILE *);
size_t __cdecl OsFWrite(const void *, size_t, size_t, FILE *);
int __cdecl OsFClose(FILE *);
int OsFSeek( FILE *stream, long offset, int origin );

#else // ( UK_MODE == UK_KERNEL )

#include <stdio.h>

#define OsFOpen		fopen
#define OsFRead		fread
#define OsFWrite	fwrite
#define OsFClose	fclose
#define OsFSeek		fseek

#endif // UK_MODE == UK_KERNEL

#ifdef __cplusplus
}
#endif

#endif /* __OSSTDIO_H__ */
