/*
 * osmissing.h - header file for missing functions.
 */

/*
 * Copyright (c) 2001 Conexant Systems, Inc.
 * 
 * 1.   Permitted use. Redistribution and use in source and binary forms,
 * with or without modification, are permitted under the terms set forth
 * herein.
 * 
 * 2.   Disclaimer of Warranties. CONEXANT AND OTHER CONTRIBUTORS MAKE NO
 * REPRESENTATION ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.
 * IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTIES OF ANY KIND.
 * CONEXANT AND OTHER CONTRIBUTORS DISCLAIMS ALL WARRANTIES WITH REGARD TO
 * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, GOOD TITLE AND AGAINST INFRINGEMENT.
 * 
 * This software has not been formally tested, and there is no guarantee that
 * it is free of errors including, but not limited to, bugs, defects,
 * interrupted operation, or unexpected results. Any use of this software is
 * at user's own risk.
 * 
 * 3.   No Liability.
 * 
 * (a) Conexant or contributors shall not be responsible for any loss or
 * damage to Company, its customers, or any third parties for any reason
 * whatsoever, and CONEXANT OR CONTRIBUTORS SHALL NOT BE LIABLE FOR ANY
 * ACTUAL, DIRECT, INDIRECT, SPECIAL, PUNITIVE, INCIDENTAL, OR CONSEQUENTIAL
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED, WHETHER IN CONTRACT, STRICT OR OTHER LEGAL THEORY OF
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY
 * WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 * 
 * (b) User agrees to hold Conexant and contributors harmless from any
 * liability, loss, cost, damage or expense, including attorney's fees,
 * as a result of any claims which may be made by any person, including
 * but not limited to User, its agents and employees, its customers, or
 * any third parties that arise out of or result from the manufacture,
 * delivery, actual or alleged ownership, performance, use, operation
 * or possession of the software furnished hereunder, whether such claims
 * are based on negligence, breach of contract, absolute liability or any
 * other legal theory.
 * 
 * 4.   Notices. User hereby agrees not to remove, alter or destroy any
 * copyright, trademark, credits, other proprietary notices or confidential
 * legends placed upon, contained within or associated with the Software,
 * and shall include all such unaltered copyright, trademark, credits,
 * other proprietary notices or confidential legends on or in every copy of
 * the Software.
 * 
 */
#ifndef _OSMISSING_H_
#define _OSMISSING_H_

#if ( OCT_SW_MODEM == 0 ) || ( (UK_MODE == UK_KERNEL) && defined(BATCH_INCLUDE) )
#include <sys/cdefs.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#if ( OCT_SW_MODEM == 0 )

/* The following are taken from octopus/osspecific/ostime.h, and are here if
   we are only not using octopus... */
	int OSFloatPrefix( void );
	BOOL OSFloatSuffix( int Id );
	BOOL IsTSOn( void );
	void ClearTS( void );

	/* Copy N bytes of SRC to DEST.  */
	__ptr_t memcpy __P ((__ptr_t __restrict __dest,
						 __const __ptr_t __restrict __src, size_t __n));

	/* Copy N bytes of SRC to DEST, guaranteeing
	   correct behavior for overlapping strings.  */
	__ptr_t memmove __P ((__ptr_t __dest, __const __ptr_t __src,
						  size_t __n));

	/* Set N bytes of S to C.  */
	__ptr_t memset __P ((__ptr_t __s, int __c, size_t __n));

	/* Copy SRC to DEST.  */
	char *strcpy __P ((char *__restrict __dest,
					   __const char *__restrict __src));

	/* Copy no more than N characters of SRC to DEST.  */
	char *strncpy __P ((char *__restrict __dest,
						__const char *__restrict __src, size_t __n));

	/* Append SRC onto DEST.  */
	char *strcat __P ((char *__restrict __dest,
					   __const char *__restrict __src));

	/* Append no more than N characters from SRC onto DEST.  */
	char *strncat __P ((char *__restrict __dest,
						__const char *__restrict __src, size_t __n));

	/* Compare N characters of S1 and S2.  */
	int strncmp __P ((__const char *__s1, __const char *__s2, size_t __n));

#endif /* ( OCT_SW_MODEM == 0 ) */

#ifdef __cplusplus
}
#endif



/* Just for the v34batch in shell mode (not kernel): */
#if ( (UK_MODE == UK_KERNEL) && defined(BATCH_INCLUDE) )

#include <stdio.h>

extern FILE *stdin;

int _IO_getc( FILE *__file );

/* Open a file and create a new stream for it.  */
FILE *fopen __P ((__const char *__restrict __filename,
				  __const char *__restrict __modes));

/* Close STREAM.  */
int fclose __P ((FILE *__stream));

/* Read chunks of generic data from STREAM.  */
size_t fread __P ((void *__restrict __ptr, size_t __size,
				   size_t __n, FILE *__restrict __stream));

/* Write chunks of generic data to STREAM.  */
size_t fwrite __P ((__const void *__restrict __ptr, size_t __size,
					size_t __n, FILE *__restrict __s));

#endif /* ( (UK_MODE == UK_KERNEL) && defined(BATCH_INCLUDE) ) */


#endif


