
include $(TOP)/config.mak

# Configure compiler (on some systems, kgcc must be used to compile kernel code)
#
# Use kgcc to compile kernel modules if present, else gcc
CC = $(shell which kgcc >/dev/null 2>&1 && echo kgcc || echo gcc)
#CC= kgcc
#CC= gcc

# Configure location of current 2.4 kernel source directory for compiling
KERNELSRC= /usr/src/linux

KERNELVER= $(shell echo UTS_RELEASE | gcc -E -I${KERNELSRC}/include -include ${KERNELSRC}/include/linux/version.h - | grep '^"' | tr -d '" 	')

KMODS_DIR= /lib/modules/$(KERNELVER)

IMPORTED = $(TOP)/imported

CFLAGS = -I$(IMPORTED)/include -I$(TOP)/modules/osspec/include
CFLAGS += $(IMPORTED_COMPILATION_FLAGS)
CFLAGS += $(IMPORTED_FRAMEWORK_DEFS) -imacros $(IMPORTED)/include/framewrk.h
CFLAGS += $(IMPORTED_GENERAL_DEFS)
CFLAGS += $(IMPORTED_DEBUG_DEFS)

CFLAGS += $(OTHER_INCLUDES)

# Configure various machine specific CFLAGS for compiling kernel modules
#CFLAGS+= -mpreferred-stack-boundary=2
#CFLAGS+= -fomit-frame-pointer
CFLAGS+= -Wall -Wstrict-prototypes -O2 -I$(KERNELSRC)/include
CFLAGS+= -D__KERNEL__ -DMODULE

CFLAGS+= -DOS_NOREDEFS

CFLAGS += -DHSFSERIALMAJOR=$(HSFSERIALMAJOR) -DHSFCALOUTMAJOR=$(HSFCALOUTMAJOR)
CFLAGS += -DHSFSERIALMINOR=$(HSFSERIALMINOR)

CFLAGS += -DHSFSCRDMPMAJOR=$(HSFSCRDMPMAJOR)

CONFIG_MODVERSIONS= $(shell echo CONFIG_MODVERSIONS | gcc -E -I${KERNELSRC}/include -include ${KERNELSRC}/include/linux/config.h - | grep -q 'CONFIG_MODVERSIONS' && echo n || echo y)
ifeq ($(CONFIG_MODVERSIONS),y)
MODVERFLAGS= -DMODVERSIONS -include $(KERNELSRC)/include/linux/modversions.h
endif

CFLAGS+= -include $(KERNELSRC)/include/linux/config.h
CFLAGS+= $(MODVERFLAGS)

## END OF CONFIGURATION SECTION
## no changes should be necessary beyond this point
#####################################################################

.PHONY: default
default: all

-include $(IMPORTED)/makeflags.mak

.c.o:
	@echo "* Compiling $<"
	@$(COMPILE.c) $(OUTPUT_OPTION) $<

.cpp.o:
	@echo "* Compiling $<"
	@$(COMPILE.cc) $(OUTPUT_OPTION) $<

ifdef SUBDIRS
.PHONY: $(SUBDIRS)
$(SUBDIRS):
	$(MAKE) -C $@ all
endif

CLEAN= *.o

.PHONY: clean
clean::
	rm -f $(CLEAN)
ifdef SUBDIRS
	@for subdir in $(SUBDIRS); do \
		$(MAKE) -C $$subdir $@; \
	done
endif


