/*
 * Copyright (c) 2001 Conexant Systems, Inc.
 * 
 * 1.   Permitted use. Redistribution and use in source and binary forms,
 * with or without modification, are permitted under the terms set forth
 * herein.
 * 
 * 2.   Disclaimer of Warranties. CONEXANT AND OTHER CONTRIBUTORS MAKE NO
 * REPRESENTATION ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.
 * IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTIES OF ANY KIND.
 * CONEXANT AND OTHER CONTRIBUTORS DISCLAIMS ALL WARRANTIES WITH REGARD TO
 * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, GOOD TITLE AND AGAINST INFRINGEMENT.
 * 
 * This software has not been formally tested, and there is no guarantee that
 * it is free of errors including, but not limited to, bugs, defects,
 * interrupted operation, or unexpected results. Any use of this software is
 * at user's own risk.
 * 
 * 3.   No Liability.
 * 
 * (a) Conexant or contributors shall not be responsible for any loss or
 * damage to Company, its customers, or any third parties for any reason
 * whatsoever, and CONEXANT OR CONTRIBUTORS SHALL NOT BE LIABLE FOR ANY
 * ACTUAL, DIRECT, INDIRECT, SPECIAL, PUNITIVE, INCIDENTAL, OR CONSEQUENTIAL
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED, WHETHER IN CONTRACT, STRICT OR OTHER LEGAL THEORY OF
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY
 * WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 * 
 * (b) User agrees to hold Conexant and contributors harmless from any
 * liability, loss, cost, damage or expense, including attorney's fees,
 * as a result of any claims which may be made by any person, including
 * but not limited to User, its agents and employees, its customers, or
 * any third parties that arise out of or result from the manufacture,
 * delivery, actual or alleged ownership, performance, use, operation
 * or possession of the software furnished hereunder, whether such claims
 * are based on negligence, breach of contract, absolute liability or any
 * other legal theory.
 * 
 * 4.   Notices. User hereby agrees not to remove, alter or destroy any
 * copyright, trademark, credits, other proprietary notices or confidential
 * legends placed upon, contained within or associated with the Software,
 * and shall include all such unaltered copyright, trademark, credits,
 * other proprietary notices or confidential legends on or in every copy of
 * the Software.
 * 
 */

/*
 * Copyright (c) 2001 Conexant Systems, Inc.
 * 
 * 1.   Permitted use. Redistribution and use in source and binary forms,
 * with or without modification, are permitted under the terms set forth
 * herein.
 * 
 * 2.   Disclaimer of Warranties. CONEXANT AND OTHER CONTRIBUTORS MAKE NO
 * REPRESENTATION ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.
 * IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTIES OF ANY KIND.
 * CONEXANT AND OTHER CONTRIBUTORS DISCLAIMS ALL WARRANTIES WITH REGARD TO
 * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, GOOD TITLE AND AGAINST INFRINGEMENT.
 * 
 * This software has not been formally tested, and there is no guarantee that
 * it is free of errors including, but not limited to, bugs, defects,
 * interrupted operation, or unexpected results. Any use of this software is
 * at user's own risk.
 * 
 * 3.   No Liability.
 * 
 * (a) Conexant or contributors shall not be responsible for any loss or
 * damage to Company, its customers, or any third parties for any reason
 * whatsoever, and CONEXANT OR CONTRIBUTORS SHALL NOT BE LIABLE FOR ANY
 * ACTUAL, DIRECT, INDIRECT, SPECIAL, PUNITIVE, INCIDENTAL, OR CONSEQUENTIAL
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED, WHETHER IN CONTRACT, STRICT OR OTHER LEGAL THEORY OF
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY
 * WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 * 
 * (b) User agrees to hold Conexant and contributors harmless from any
 * liability, loss, cost, damage or expense, including attorney's fees,
 * as a result of any claims which may be made by any person, including
 * but not limited to User, its agents and employees, its customers, or
 * any third parties that arise out of or result from the manufacture,
 * delivery, actual or alleged ownership, performance, use, operation
 * or possession of the software furnished hereunder, whether such claims
 * are based on negligence, breach of contract, absolute liability or any
 * other legal theory.
 * 
 * 4.   Notices. User hereby agrees not to remove, alter or destroy any
 * copyright, trademark, credits, other proprietary notices or confidential
 * legends placed upon, contained within or associated with the Software,
 * and shall include all such unaltered copyright, trademark, credits,
 * other proprietary notices or confidential legends on or in every copy of
 * the Software.
 * 
 */
/*************************************************************************

  File Name: RTMgrE.h

  File Description:

  *************************************************************************/

#ifndef __RT_MGR_E_H__
#define __RT_MGR_E_H__

#include "comtypes.h"
#include "intfctrl_ex.h"

#if ( USE_PRAGMA_PACK == 1 )
#pragma pack(push,1)   // Packing compatible with WinAC
#endif

#define HRTMGR HANDLE
#define HRTCLIENT HANDLE
#define HASYNCCALL HANDLE


#define	RT_MGR_MAJOR_VERSION	((UINT32)0)
#define	RT_MGR_MINOR_VERSION	((UINT32)2)

#define RT_MGR_VERSION ((UINT32)(((RT_MGR_MAJOR_VERSION) << 16) | (RT_MGR_MINOR_VERSION)))

typedef enum 
{
	RTMGR_CONFIG_LAST /* Dummy */
} RTMGR_CONFIG_CODE;

typedef enum 
{
	RTMGR_MONITOR_TIME_STAMP,						/* UINT32 * - time stamp in milliseconds */
	RTMGR_MONITOR_LAST /* Dummy */
} RTMGR_MONITOR_CODE;
	
typedef enum 
{
	RTMGR_CONTROL_LAST /* Dummy */
} RTMGR_CONTROL_CODE;

/*********************** Run time Manager Exported types :********************/
typedef enum {
	DPC_IRQL,
	PASSIVE_IRQL,
	TIME_CRITICAL_IRQL,
	LAST_IRQL
} TIMER_IRQL_TYPE;


typedef enum ASYNC_CALL_TYPE_TAG{
	ASYNC_CALL_ONE_SHOT, 
	ASYNC_CALL_PERIODIC
} ASYNC_CALL_TYPE_T;

#define ASYNC_CALL_CONFIG ASYNC_CALL_CONFIG_T

typedef struct ASYNC_CALL_CONFIG_TAG{
	ASYNC_CALL_TYPE_T	Type;
	int 				TimeOut;
	PUINT32				pStack;				
	UINT32				StackSize;		
	PCBFUNC     		pFuncAsyncCall;
	PVOID				pParam;
}ASYNC_CALL_CONFIG_T, *PASYNC_CALL_CONFIG_T;

typedef struct RUN_TIME_CLIENT_CONFIG_TAG
{
	int					TimerResolution; /* Defines the requred system timer resolution*/
}RUN_TIME_CLIENT_CONFIG_T, *PRUN_TIME_CLIENT_CONFIG_T;

typedef struct CALL_CONFIG_TAG
{
	PUINT32		pStack;
	UINT32		StackSize;
	PCBFUNC		pFunc;
	PVOID		FuncParams;
}CALL_CONFIG_T, *PCALL_CONFIG_T;
/********************************************************************************
Function Name: RTMgrGetInterface.

Function Description:Return pointer to RunTime Manager interface.

rguments: None.

Return Value: Pointer to RunTime interface function table.

********************************************************************************/
GLOBAL	PVOID	RTMgrGetInterface(void);


typedef struct I_RT_MGR_TAG{
	
	/************ Common Interface functions. ************/
	/********************************************************************************
	Function Name: GetInterfaceVersion.

	Function Description:The function returns the interface compilation version.
						 The function should be called before any other function 
						 in the function table in order to verify that the calling 
						 code and the block code are compatible.
	
	Arguments: None.
	
	Return Value: The interface compilation version.

	********************************************************************************/
	UINT32		(__stdcall *GetInterfaceVersion)(	void);

	/********************************************************************************

	Function Name: Create.

	Function Description: The function creates a block instance.
	
	Arguments: None.
	
	Return Value: An handle to the created instance. (this handle will passed as an 
				  argument to all other functions to identify the block instance).
				  (in case of error it returns NULL).

	********************************************************************************/
	HANDLE		(__stdcall *Create)(				IN PSYSTEM_INSTANCES_T	pSystemInstances);			

	/********************************************************************************

	Function Name: Destroy.

	Function Description: The function destroy the block instance identify by the hBlock
						  handle. After the destroying this handle becomes invalid. 
	
	Arguments: hblock - a handle to the block to destroy. (this handle was returned by 
						the create function when we created this block instance).
	
	Return Value: COM_STATUS (COM_STATUS_SUCCESS if the block instance was successfully 
				  destroyed).

	********************************************************************************/
	COM_STATUS	(__stdcall *Destroy)(	IN HANDLE			hBlock);

	/********************************************************************************

	Function Name: Init.

	Function Description: The function initialize the block identified by the hBlock 
						  parameter.
	
	Arguments: a handle to the block to initialize.
	
	Return Value: COM_STATUS (COM_STATUS_SUCCESS if the block instance was successfully
				  initialized). Close function should be called even when init failed.

	********************************************************************************/
	COM_STATUS	(__stdcall *Init)(	IN	HANDLE			hBlock);

	/********************************************************************************

	Function Name: Close.

	Function Description: The function closes the block identified by the hBlock handle.
						  After the instance was closed, its handle can be destroyed by 
						  the destroy function.
	
	Arguments: a handle to the block to close.
	
	Return Value: COM_STATUS (COM_STATUS_SUCCESS if the block instance was successfully
				  closed).

	********************************************************************************/
	COM_STATUS	(__stdcall *Close)(	IN	HANDLE			hBlock);		


	/************ Specific Interface functions. ************/

	
	/********************************************************************************
	
	Function Name:RegisterClient
	  
	Function Description: The function registers a client to the Run Time Manager identified
						  by hRunTime. 

	Arguments: hRunTime - a handle for the Run Time Manager instance.
			   pClientConfig - a pointer to a structure containing all the client 
			   registration parameters.

	Return Value: a handle (identifier) for the new client. This handle should be used as
				  a parameter for the functions: UnregisterClient, AsyncCall, BeginBlockRT,
				  CancelAsyncCall and EndBlockRT.(in case of error it returns NULL).

	********************************************************************************/
	HANDLE	(__stdcall *RegisterClient)(IN	HANDLE						hRunTime,
										IN	PRUN_TIME_CLIENT_CONFIG_T	pClientConfig);
	
	/********************************************************************************
	
	Function Name:SetClientTimerResolution
	  
	Function Description: Updates the timer resolution required by the 
						  Client. 

	Arguments:	hRunTime - a handle for the Run Time Manager instance.
				hClient	- handle to the client
			   TimerResolution - New client reqired timer resolution

	Return Value: COM_STAUTS_SUCCESS when client resolution is successfuly 
					updated, else failure code.

	********************************************************************************/
	COM_STATUS	(__stdcall *SetClientTimerResolution)(	IN	HANDLE		hClient,
														IN	int			TimerResolution);
	/********************************************************************************
	
	Function Name: UnregisterClient
	  
	Function Description: The function unregisters a client from the RunTime manager.

	Arguments: hRunTime - a handle for the Run Time Manager instance.
			   hClient - a handle for the specific RunTIme client (which returns from the 
			   RegisterClient function).

	Return Value: COM_STATUS (COM_STATUS_SUCCESS if the client was successfully unregistered)

	********************************************************************************/
	COM_STATUS	(__stdcall *UnregisterClient)(	IN	HANDLE		hClient);

	/********************************************************************************
	Function Name: CreateAsyncCall
	  
	Function Description: Creates a non schedules async call.
	Arguments: hRunTime - a handle for the Run Time Manager instance.

	Return Value: a handle to the AsyncCall. (in case of error it returns NULL).

	********************************************************************************/
	HANDLE	(__stdcall *CreateAsyncCall)(	IN	HANDLE					hRunTime);

	/********************************************************************************
	Function Name: SetAsyncCall
	  
	Function Description: This function is a request to the run time manager to schedule 
						  an async call as discribed in the hAsyncCall structure.
						  After the timeout is over the function that was sent as a parameter 
						  in the pConfig will get a run-time. (the timer an be one-shot 
						  or periodic).

	Arguments: hRunTime - a handle for the Run Time Manager instance.
			   hClient - a handle for the specific RunTIme client (which returns from the 
			   RegisterClient function).
			   hAsyncCall - a handle to the AsyncCall that was returned from the CreateAsyncCall
			   pRefData - Reference data to be passed to the async callback function
			   pConfig - a pointer to a structure containing the data about the request
			   for the async call .

	Return Value: COM_STATUS_SUCCES on success, else error code.

	********************************************************************************/
	COM_STATUS	(__stdcall *SetAsyncCall)(IN	HANDLE					hAsyncCall,
										  IN	PASYNC_CALL_CONFIG_T	pConfig);

	/********************************************************************************
	Function Name: RestartAsyncCall
	  
	Function Description:	Sets an async call with configuration passed in
							a previous SetAsyncCall of the specified hAsyncCall.
							If the async call was not set previously the 
							behaviour is not defined.

	Arguments: hRunTime - a handle for the Run Time Manager instance.
			   hClient - a handle for the specific RunTIme client (which returns from the 
			   RegisterClient function).
			   hAsyncCall - a handle to the AsyncCall that was returned from the CreateAsyncCall
			   pRefData - Reference data to be passed to the async callback function

	Return Value: COM_STATUS_SUCCES on success, else error code.

	********************************************************************************/
	COM_STATUS	(__stdcall *RestartAsyncCall)(IN	HANDLE					hAsyncCall);

	/********************************************************************************

	Function Name: CancelAsyncCall
	  
	Function Description: The function cancels the AsyncCall identified by the hAsyncCall
						  handle from scheduler. The async call can be rescheduled through 
						  SetAsyncCall function, or destroyed with DestroyAsyncCall function.

	Arguments: hRunTime - a handle for the Run Time Manager instance.
			   hClient - a handle for the specific RunTIme client (which returns from the 
			   RegisterClient function).
			   hAsyncCall - a handle to the AsyncCall that was returned from the CreateAsyncCall
			   function.

	Return Value: COM_STATUS (COM_STATUS_SUCCESS if the AsyncCall was successfully canceled)

	********************************************************************************/
	COM_STATUS	(__stdcall *CancelAsyncCall)(	IN	HANDLE		hAsyncCall);
	/********************************************************************************

	Function Name: DestroyAsyncCall
	  
	Function Description: The function destroys the AsyncCall identified by the hAsyncCall
						  handle.The async call handle becomes unusable.

	Arguments: hRunTime - a handle for the Run Time Manager instance.
			   hClient - a handle for the specific RunTIme client (which returns from the 
			   RegisterClient function).
			   hAsyncCall - a handle to the AsyncCall that was returned from the CreateAsyncCall
			   function.

	Return Value: COM_STATUS (COM_STATUS_SUCCESS if the AsyncCall was successfully canceled)

	********************************************************************************/
	COM_STATUS	(__stdcall *DestroyAsyncCall)(	IN	HANDLE		hAsyncCall);

	/********************************************************************************
	
	Function Name:RegisterClientWrap
	  
	Function Description: The wrapper function to RegisterClient.

	Arguments: hRunTime - a handle for the Run Time Manager instance.
			   TimerResolution - New client reqired timer resolution


	Return Value: a handle (identifier) for the new client. This handle should be used as
				  a parameter for the functions: UnregisterClient, AsyncCall, BeginBlockRT,
				  CancelAsyncCall and EndBlockRT.(in case of error it returns NULL).

	********************************************************************************/
	HANDLE	(__stdcall *RegisterClientWrap)(IN	HANDLE	hRunTime,
											IN	UINT32	TimerResolution);

} I_RT_MGR_T, *PI_RT_MGR_T;

#define RTMGR_GetInterfaceVersion(      pSys)                           pSys->pftRtMgr->GetInterfaceVersion        ()
#define RTMGR_Create(                   pSys)                           pSys->pftRtMgr->Create                     (pSys)
#define RTMGR_Destroy(                  pSys)                           pSys->pftRtMgr->Destroy                    (pSys->hRtMgr)
#define RTMGR_Open(                     pSys)                           pSys->pftRtMgr->Init                       (pSys->hRtMgr)
#define RTMGR_Close(                    pSys)		                    pSys->pftRtMgr->Close                      (pSys->hRtMgr)
#define RTMGR_RegisterClient(           pSys, TimerResolution)          pSys->pftRtMgr->RegisterClientWrap             (pSys->hRtMgr, TimerResolution)
#define RTMGR_SetClientTimerResolution( pSys, hClient, TimerResolution) pSys->pftRtMgr->SetClientTimerResolution   (hClient, TimerResolution)
#define RTMGR_UnregisterClient(         pSys, hClient)                  pSys->pftRtMgr->UnregisterClient           (hClient)
#define RTMGR_CreateAsyncCall(          pSys)                           pSys->pftRtMgr->CreateAsyncCall            (pSys->hRtMgr)
#define RTMGR_SetAsyncCall(             pSys, hAsyncCall, pConfig)      pSys->pftRtMgr->SetAsyncCall               (hAsyncCall, pConfig)
#define RTMGR_RestartAsyncCall(         pSys, hAsyncCall)               pSys->pftRtMgr->RestartAsyncCall           (hAsyncCall)
#define RTMGR_CancelAsyncCall(          pSys, hAsyncCall)               pSys->pftRtMgr->CancelAsyncCall            (hAsyncCall)
#define RTMGR_DestroyAsyncCall(         pSys, hAsyncCall)               pSys->pftRtMgr->DestroyAsyncCall           (hAsyncCall)

#if ( USE_PRAGMA_PACK == 1 )
#pragma pack(pop)   // Packing compatible with our VXDs
#endif

#endif /* __RT_MGR_E_H__ */
