/*
 * Copyright (c) 2001 Conexant Systems, Inc.
 * 
 * 1.   Permitted use. Redistribution and use in source and binary forms,
 * with or without modification, are permitted under the terms set forth
 * herein.
 * 
 * 2.   Disclaimer of Warranties. CONEXANT AND OTHER CONTRIBUTORS MAKE NO
 * REPRESENTATION ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.
 * IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTIES OF ANY KIND.
 * CONEXANT AND OTHER CONTRIBUTORS DISCLAIMS ALL WARRANTIES WITH REGARD TO
 * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, GOOD TITLE AND AGAINST INFRINGEMENT.
 * 
 * This software has not been formally tested, and there is no guarantee that
 * it is free of errors including, but not limited to, bugs, defects,
 * interrupted operation, or unexpected results. Any use of this software is
 * at user's own risk.
 * 
 * 3.   No Liability.
 * 
 * (a) Conexant or contributors shall not be responsible for any loss or
 * damage to Company, its customers, or any third parties for any reason
 * whatsoever, and CONEXANT OR CONTRIBUTORS SHALL NOT BE LIABLE FOR ANY
 * ACTUAL, DIRECT, INDIRECT, SPECIAL, PUNITIVE, INCIDENTAL, OR CONSEQUENTIAL
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED, WHETHER IN CONTRACT, STRICT OR OTHER LEGAL THEORY OF
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY
 * WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 * 
 * (b) User agrees to hold Conexant and contributors harmless from any
 * liability, loss, cost, damage or expense, including attorney's fees,
 * as a result of any claims which may be made by any person, including
 * but not limited to User, its agents and employees, its customers, or
 * any third parties that arise out of or result from the manufacture,
 * delivery, actual or alleged ownership, performance, use, operation
 * or possession of the software furnished hereunder, whether such claims
 * are based on negligence, breach of contract, absolute liability or any
 * other legal theory.
 * 
 * 4.   Notices. User hereby agrees not to remove, alter or destroy any
 * copyright, trademark, credits, other proprietary notices or confidential
 * legends placed upon, contained within or associated with the Software,
 * and shall include all such unaltered copyright, trademark, credits,
 * other proprietary notices or confidential legends on or in every copy of
 * the Software.
 * 
 */

/*
 * Copyright (c) 2001 Conexant Systems, Inc.
 * 
 * 1.   Permitted use. Redistribution and use in source and binary forms,
 * with or without modification, are permitted under the terms set forth
 * herein.
 * 
 * 2.   Disclaimer of Warranties. CONEXANT AND OTHER CONTRIBUTORS MAKE NO
 * REPRESENTATION ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.
 * IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTIES OF ANY KIND.
 * CONEXANT AND OTHER CONTRIBUTORS DISCLAIMS ALL WARRANTIES WITH REGARD TO
 * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, GOOD TITLE AND AGAINST INFRINGEMENT.
 * 
 * This software has not been formally tested, and there is no guarantee that
 * it is free of errors including, but not limited to, bugs, defects,
 * interrupted operation, or unexpected results. Any use of this software is
 * at user's own risk.
 * 
 * 3.   No Liability.
 * 
 * (a) Conexant or contributors shall not be responsible for any loss or
 * damage to Company, its customers, or any third parties for any reason
 * whatsoever, and CONEXANT OR CONTRIBUTORS SHALL NOT BE LIABLE FOR ANY
 * ACTUAL, DIRECT, INDIRECT, SPECIAL, PUNITIVE, INCIDENTAL, OR CONSEQUENTIAL
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED, WHETHER IN CONTRACT, STRICT OR OTHER LEGAL THEORY OF
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY
 * WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 * 
 * (b) User agrees to hold Conexant and contributors harmless from any
 * liability, loss, cost, damage or expense, including attorney's fees,
 * as a result of any claims which may be made by any person, including
 * but not limited to User, its agents and employees, its customers, or
 * any third parties that arise out of or result from the manufacture,
 * delivery, actual or alleged ownership, performance, use, operation
 * or possession of the software furnished hereunder, whether such claims
 * are based on negligence, breach of contract, absolute liability or any
 * other legal theory.
 * 
 * 4.   Notices. User hereby agrees not to remove, alter or destroy any
 * copyright, trademark, credits, other proprietary notices or confidential
 * legends placed upon, contained within or associated with the Software,
 * and shall include all such unaltered copyright, trademark, credits,
 * other proprietary notices or confidential legends on or in every copy of
 * the Software.
 * 
 */
#ifndef _INTFCTRL_H_
#define _INTFCTRL_H_

#include "comtypes.h"

#if ( USE_PRAGMA_PACK == 1 )
#pragma pack(push,1)   // Packing compatible with WinAC
#endif
#define OCTOPUS_BASE			0
#define SOFT_MODEM_BLOCK_BASE	100
#define NILE_BLOCK_BASE         200
#define NON_BLOCK		255
 
typedef enum
{
    BLOCK_COM_CTRL = OCTOPUS_BASE,
	BLOCK_MEM_MGR, 
	BLOCK_RT_MGR, 
	BLOCK_DEBUG_MGR, 
	BLOCK_STATUS_MGR, 
	BLOCK_CONFIG_MGR,
	BLOCK_DEVICE_MGR,
	BLOCK_SESSION_MGR,
	BLOCK_NVM_MGR,
	BLOCK_SCR_SRV,
	BLOCK_DMP_SRV,
	// HSF blocks :
    
    BLOCK_AT_DTE = SOFT_MODEM_BLOCK_BASE,
	BLOCK_HW_NONE , /* HSF hardware manager*/
	BLOCK_HW_BASIC2,
	BLOCK_HW_ICH,
	BLOCK_HW_YUKON,
	BLOCK_TONE_DET,
	BLOCK_TONE_GEN,
	BLOCK_ANS_DET,
	BLOCK_ANS_GEN,
	BLOCK_DTMF_DET,
	BLOCK_DTMF_GEN,
	BLOCK_CR_DET,
	BLOCK_CR_GEN,
	BLOCK_V23,
	BLOCK_V8,
	BLOCK_V21,
	BLOCK_V34,
	BLOCK_V90,
	BLOCK_V32,
	BLOCK_V32BIS,
	BLOCK_V22,
	BLOCK_V22BIS,
	BLOCK_BELL103,
	BLOCK_BELL212,

    /* Nile blocks */
    BLOCK_NILE_HW = NILE_BLOCK_BASE,
    BLOCK_DSL_DATAPUMP,

    BLOCK_NONE = NON_BLOCK
 
} BLOCK_TYPE;
 
typedef enum 
{
    HSF_ONLINE_COM_CNTRL,
    SDSL_BASIC_OFFLINE_COM_CNTRL
} COM_CNTRL_BLOCK_ID;
typedef enum 
{
    ATUR_BLOCK_ID,
    ATUC_BLOCK_ID,
    HSTUR_BLOCK_ID,
    HSTUC_BLOCK_ID
} DATAPUMP_BLOCK_ID;

typedef enum 
{
    NILEHW_RT_BLOCK_ID,  /* Real Time hw mgr               */
    NILEHW_B2B_BLOCK_ID, /* Back to Back hw mgr            */
    NILEHW_SR_BLOCK_ID   /* Session Reconstaruction hw mgr */
} NILE_HW_BLOCK_ID;
typedef PVOID(*GET_ENTRY_POINT_FUNC)(BLOCK_TYPE, UINT32);

typedef  PVOID (__stdcall *FUNC_CREATE_INTERFACE)(	BLOCK_TYPE		,
													UINT32	);

typedef COM_STATUS (__stdcall *FUNC_DESTROY_INTERFACE)(PVOID			);

typedef struct I_INTF_CTRL_TAG
{
	FUNC_CREATE_INTERFACE	CreateInterface;
	FUNC_DESTROY_INTERFACE	DestroyInterface;
}I_INTF_CTRL_T, *PI_INTF_CTRL_T;
typedef struct SYSTEM_INSTANCES_TAG
{
    struct I_INTF_CTRL_TAG*     pftInfCntrl;
 
    struct I_MEM_MGR_TAG*       pftMemMgr;
    HANDLE        hMemMgr;
 
    struct I_RT_MGR_TAG*        pftRtMgr;
    HANDLE                      hRtMgr;
 
    struct I_CONFIG_MGR_TAG*    pftCfgMgr;
    HANDLE                      hCfgMgr;
 
    struct I_STAT_MGR_TAG*      pftStatMgr;
    HANDLE  hStatMgr;
 
    struct I_AT_DTE_TAG*        pftAtParser;
    HANDLE      hAtParser; 
 
    struct I_SESSION_MGR_TAG*   pftSessionMgr;
    struct SESMGR_handle_tag*   hSessionMgr;
    struct I_DEVICE_MGR_TAG*    pftDevMgr;
    HANDLE                      hDevMgr;
 
    struct I_COM_CTRL_TAG*      pftComCtrl;
    HANDLE                      hComCtrl;
 
    struct I_DBG_MGR_TAG*		pftDbgMgr;
    HANDLE                      hDbgMgr;
 
}SYSTEM_INSTANCES_T, *PSYSTEM_INSTANCES_T;
 

PVOID GetInterfaceControllerFuncTable(	void );

#define INTFCTRL_CreateInterface(   pSys, BlockType, BlockID)   pSys->pftInfCntrl->CreateInterface (BlockType, BlockID)
#define INTFCTRL_DestroyInterface(  pSys, Interface)            pSys->pftInfCntrl->DestroyInterface   (Interface)
 
#if ( USE_PRAGMA_PACK == 1 )
#pragma pack(pop)   // Packing compatible with our VXDs
#endif

#endif
