#
# Initializations that should only be performed when in interactive mode
#
# etc/fish_interactive.fish.  Generated from fish_interactive.fish.in by configure.

if not status --is-interactive
	exit
end

#
# Print a greeting 
#

printf (_ 'Welcome to fish, the friendly interactive shell\n')
printf (_ 'Type %shelp%s for instructions on how to use fish\n') (set_color green) (set_color normal)

#
# Set exit message
#

function fish_on_exit -d (_ "Commands to execute when fish exits") --on-process %self
	printf (_ "Good bye\n")
end

#
# Set INPUTRC to something nice
#
# We override INPUTRC if already set, since it may be set by a shell 
# other than fish, which may use a different file. The new value should
# be exported, since the fish inputrc file plays nice with other files 
# by including them when found.
# Give priority to the default file installed with fish in 
# /usr/etc/fish_inputrc.
#

for i in ~/.fish_inputrc /usr/etc/fish_inputrc ~/.inputrc /etc/inputrc
	if test -f $i
		set -xg INPUTRC $i
		break
	end
end


#
# Set various defaults using these throwaway functions
#

function set_default -d "Set an universal variable, unless it has already been set"
	if not set -q $argv[1]
		set -U -- $argv	
	end
	if not set -q $argv[1]
		set -g -- $argv	
	end
end

function set_exported_default -d "Set an exported universal variable, unless it has already been set"
	if not set -q $argv[1]
		set -Ux -- $argv	
	end
	if not set -q $argv[1]
		set -gx -- $argv	
	end
end


# Regular syntax highlighting colors
set_default fish_color_normal normal
set_default fish_color_command green
set_default fish_color_redirection normal
set_default fish_color_comment brown
set_default fish_color_error red

set_default fish_color_cwd green

# Background color for matching quotes and parenthesis
set_default fish_color_match cyan

# Background color for search matches
set_default fish_color_search_match purple

# Pager colors
set_default fish_pager_color_prefix cyan
set_default fish_pager_color_completion normal
set_default fish_pager_color_description normal
set_default fish_pager_color_progress cyan

#
# Directory history colors
#

set_default fish_color_history_current cyan


#
# Setup the CDPATH variable
#

set_default CDPATH . ~

#
# Remove temporary functions for setting default variable values
#

functions -e set_exported_default
functions -e set_default
