<?xml version="1.0" encoding="UTF-8"?>
<!--


   Sun Microsystems Inc., October, 2000

   GNU Lesser General Public License Version 2.1
   =============================================
   Copyright 2000 by Sun Microsystems, Inc.
   901 San Antonio Road, Palo Alto, CA 94303, USA

   $RCSfile: table_rows.xsl,v $

   GNU Lesser General Public License Version 2.1
   =============================================
   Copyright 2000 by Sun Microsystems, Inc.
   901 San Antonio Road, Palo Alto, CA 94303, USA

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License version 2.1, as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
   MA  02111-1307  USA
   $Revision: 1.5 $

   last change: $Autho
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNUr: sus $ $Date: 2005/03/29 12:42:57 $

   The Contents of this file are made available subject to the terms of
   either of the following licenses

		  - GNU Lesser General Public License Version 2.1
		  - Sun Industry Standards Source License Version 1.1

   Sun Microsystems Inc., October, 2000

   GNU Lesser General Public License Version 2.1
   =============================================
   Copyright 2000 by Sun Microsystems, Inc.
   901 San Antonio Road, Palo Alto, CA 94303, USA

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License version 2.1, as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
   MA  02111-1307  USA


   Sun Industry Standards Source License Version 1.1
   =================================================
   The contents of this file are subject to the Sun Industry Standards
   Source License Version 1.1 (the "License"); You may not use this file
   except in compliance with the License. You may obtain a copy of the
   License at http://www.openoffice.org/license.html.

   Software provided under this License is provided on an "AS IS" basis,
   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
   See the License for the specific provisions governing your rights and
   obligations concerning the Software.

   The Initial Developer of the Original Code is: Sun Microsystems, Inc.

   Copyright © 2002 by Sun Microsystems, Inc.

   All Rights Reserved.

   Contributor(s): _______________________________________

-->
<!--
	For further documentation and updates visit http://xml.openoffice.org/sx2ml
-->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:office="http://openoffice.org/2000/office"
	xmlns:style="http://openoffice.org/2000/style"
	xmlns:text="http://openoffice.org/2000/text"
	xmlns:table="http://openoffice.org/2000/table"
	xmlns:draw="http://openoffice.org/2000/drawing"
	xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:xlink="http://www.w3.org/1999/xlink"
	xmlns:number="http://openoffice.org/2000/datastyle"
	xmlns:svg="http://www.w3.org/2000/svg"
	xmlns:chart="http://openoffice.org/2000/chart"
	xmlns:dr3d="http://openoffice.org/2000/dr3d"
	xmlns:math="http://www.w3.org/1998/Math/MathML"
	xmlns:form="http://openoffice.org/2000/form"
	xmlns:script="http://openoffice.org/2000/script"
	xmlns:dc="http://purl.org/dc/elements/1.1/"
	xmlns:meta="http://openoffice.org/2000/meta"
	xmlns:config="http://openoffice.org/2001/config"
	xmlns:help="http://openoffice.org/2000/help"
	exclude-result-prefixes="office style text table draw fo xlink number svg chart dr3d math form script dc meta config help">


	<xsl:param name="rowElement" select="'tr'" />

	<!-- ********************************** -->
	<!-- *** write repeating table rows *** -->
	<!-- ********************************** -->

	<!-- current node is a table:table or table:sub-table -->
	<xsl:template name="create-table-rows">
		<xsl:param name="globalData" />
		<xsl:param name="allVisibleTableRows" />
		<xsl:param name="allTableColumns" />

		<!-- Some Office Calc documents simulate a background by repeating one of the later cells until end of used space
			 (The value of "table:number-columns-repeated" is enourmous). Writing out all these cells would be fatal in time
			 and output size. Therefore, this global variable shows us the longest row with content. -->
		<xsl:variable name="maxRowLength" select="count($allTableColumns/table:table-column)" />
		<xsl:if test="$debugEnabled">
			<xsl:message>maxRowLength: <xsl:value-of select="$maxRowLength" /></xsl:message>
			<xsl:call-template name="table-debug-allTableColumns">
				<xsl:with-param name="allTableColumns" select="$allTableColumns" />
			</xsl:call-template>
		</xsl:if>

		<!-- a table is a table header, when it has a "table:table-header-rows" ancestor -->
		<xsl:variable name="tableDataType">
			<xsl:choose>
				<xsl:when test="ancestor::table:table-header-rows">
					<xsl:text>th</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>td</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$outputType = 'WML'">
				<xsl:for-each select="$allVisibleTableRows">
					<xsl:call-template name="wml-repeat-write-row">
						<xsl:with-param name="globalData"           select="$globalData" />
						<xsl:with-param name="allTableColumns"      select="$allTableColumns" />
						<xsl:with-param name="numberRowsRepeated"   select="@table:number-rows-repeated" />
						<xsl:with-param name="maxRowLength"         select="$maxRowLength" />
					</xsl:call-template>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<!-- removes repetition of rows, most probably done for background emulating -->
				<xsl:for-each select="$allVisibleTableRows">
					<xsl:choose>
						<xsl:when test="(last() or (last() - 1)) and @table:number-rows-repeated &gt; 99">
							<xsl:call-template name="repeat-write-row">
								<xsl:with-param name="globalData"           select="$globalData" />
								<xsl:with-param name="allTableColumns"      select="$allTableColumns" />
								<xsl:with-param name="numberRowsRepeated"   select="1" />
								<xsl:with-param name="maxRowLength"         select="$maxRowLength" />
								<xsl:with-param name="tableDataType"        select="$tableDataType" />
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="repeat-write-row">
								<xsl:with-param name="globalData"           select="$globalData" />
								<xsl:with-param name="allTableColumns"      select="$allTableColumns" />
								<xsl:with-param name="numberRowsRepeated"   select="@table:number-rows-repeated" />
								<xsl:with-param name="maxRowLength"         select="$maxRowLength" />
								<xsl:with-param name="tableDataType"        select="$tableDataType" />
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<xsl:template name="repeat-write-row">
		<xsl:param name="globalData" />
		<xsl:param name="allTableColumns" />
		<xsl:param name="numberRowsRepeated" select="1" />
		<xsl:param name="maxRowLength" />
		<xsl:param name="tableDataType" />

		<xsl:choose>
			<!-- write an entry of a row and repeat calling this method until all elements are written out -->
			<xsl:when test="$numberRowsRepeated > 1 and table:table-cell">
				<xsl:call-template name="write-row">
					<xsl:with-param name="globalData"       select="$globalData" />
					<xsl:with-param name="allTableColumns"  select="$allTableColumns" />
					<xsl:with-param name="maxRowLength"     select="$maxRowLength" />
					<xsl:with-param name="tableDataType"    select="$tableDataType" />
				</xsl:call-template>

				<!-- NOTE: take variable from the output of repeated write-row and iterate giving out the variable -->
				<xsl:call-template name="repeat-write-row">
					<xsl:with-param name="globalData"           select="$globalData" />
					<xsl:with-param name="allTableColumns"      select="$allTableColumns" />
					<xsl:with-param name="maxRowLength"         select="$maxRowLength" />
					<xsl:with-param name="numberRowsRepeated"   select="$numberRowsRepeated - 1" />
					<xsl:with-param name="tableDataType"        select="$tableDataType" />
				</xsl:call-template>
			</xsl:when>
			<!-- write a single entry of a row -->
			<xsl:otherwise>
				<xsl:call-template name="write-row">
					<xsl:with-param name="globalData"           select="$globalData" />
					<xsl:with-param name="allTableColumns"      select="$allTableColumns" />
					<xsl:with-param name="maxRowLength"         select="$maxRowLength" />
					<xsl:with-param name="tableDataType"        select="$tableDataType" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<xsl:template name="add-table-row-attributes">
		<xsl:param name="globalData" />

		<!-- writing the style of the row -->
		<xsl:if test="@table:style-name">
			<xsl:call-template name='add-style-properties'>
				<xsl:with-param name="globalData" select="$globalData" />
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

	<xsl:template name="write-row">
		<xsl:param name="globalData" />
		<xsl:param name="allTableColumns" />
		<xsl:param name="maxRowLength" />
		<xsl:param name="tableDataType" />


		<xsl:element namespace="{$namespace}" name="{$rowElement}">
			<xsl:call-template name='add-table-row-attributes'>
				<xsl:with-param name="globalData" select="$globalData" />
			</xsl:call-template>

			<xsl:if test="$debugEnabled">
				<xsl:message>'tr' element has been added!</xsl:message>
			</xsl:if>

			<xsl:apply-templates select="table:table-cell">
				<xsl:with-param name="globalData"       select="$globalData" />
				<xsl:with-param name="allTableColumns"  select="$allTableColumns" />
				<xsl:with-param name="maxRowLength"     select="$maxRowLength" />
				<xsl:with-param name="tableDataType"    select="$tableDataType" />
			</xsl:apply-templates>

		</xsl:element>
	</xsl:template>


	<!-- **************************** -->
	<!-- *** HELPER: table styles *** -->
	<!-- **************************** -->

	<xsl:template name="add-style-properties">
		<xsl:param name="globalData" />
		<xsl:param name="allTableColumns" />
		<xsl:param name="node-position" />

		<xsl:choose>
			<!--+++++ CSS (CASCADING STYLE SHEET) HEADER STYLE WAY +++++-->
			<xsl:when test="$outputType = 'CSS_HEADER'">
				<xsl:attribute name="class">
					<xsl:value-of select="translate(@table:style-name, '. %()/\+', '')" />
				</xsl:attribute>
			</xsl:when>

			<!--+++++ HTML 4.0 INLINED WAY  +++++-->
			<xsl:when test="$outputType = 'CSS_INLINED'">
				<xsl:attribute name="style">
					<xsl:value-of select="$globalData/all-styles/style[@style:name = current()/@table:style-name]/final-properties" />
				</xsl:attribute>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

	<!-- default template to be overwritten -->
	<xsl:template name="wml-repeat-write-row" />

</xsl:stylesheet>
