<?xml version="1.0" encoding="UTF-8"?>
<!--

   $RCSfile: style_mapping_html32.xsl,v $

   $Revision: 1.4 $

   last change: $Author: rt $ $Date: 2005/03/29 12:42:01 $

   The Contents of this file are made available subject to the terms of
   either of the following licenses

		  - GNU Lesser General Public License Version 2.1
		  - Sun Industry Standards Source License Version 1.1

   Sun Microsystems Inc., October, 2000

   GNU Lesser General Public License Version 2.1
   =============================================
   Copyright 2000 by Sun Microsystems, Inc.
   901 San Antonio Road, Palo Alto, CA 94303, USA

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License version 2.1, as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
   MA  02111-1307  USA


   Sun Industry Standards Source License Version 1.1
   =================================================
   The contents of this file are subject to the Sun Industry Standards
   Source License Version 1.1 (the "License"); You may not use this file
   except in compliance with the License. You may obtain a copy of the
   License at http://www.openoffice.org/license.html.

   Software provided under this License is provided on an "AS IS" basis,
   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
   See the License for the specific provisions governing your rights and
   obligations concerning the Software.

   The Initial Developer of the Original Code is: Sun Microsystems, Inc.

   Copyright © 2002 by Sun Microsystems, Inc.

   All Rights Reserved.

   Contributor(s): _______________________________________

-->
<!--
	For further documentation and updates visit http://xml.openoffice.org/sx2ml
-->
<xsl:stylesheet version="1.0"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:office="http://openoffice.org/2000/office"
				xmlns:style="http://openoffice.org/2000/style"
				xmlns:text="http://openoffice.org/2000/text"
				xmlns:table="http://openoffice.org/2000/table"
				xmlns:draw="http://openoffice.org/2000/drawing"
				xmlns:fo="http://www.w3.org/1999/XSL/Format"
				xmlns:xlink="http://www.w3.org/1999/xlink"
				xmlns:number="http://openoffice.org/2000/datastyle"
				xmlns:svg="http://www.w3.org/2000/svg"
				xmlns:chart="http://openoffice.org/2000/chart"
				xmlns:dr3d="http://openoffice.org/2000/dr3d"
				xmlns:math="http://www.w3.org/1998/Math/MathML"
				xmlns:form="http://openoffice.org/2000/form"
				xmlns:script="http://openoffice.org/2000/script"
				xmlns:dc="http://purl.org/dc/elements/1.1/"
				xmlns:meta="http://openoffice.org/2000/meta"
				xmlns:config="http://openoffice.org/2001/config"
				xmlns:help="http://openoffice.org/2000/help"
				exclude-result-prefixes="office style text table draw fo xlink number svg chart dr3d math form script dc meta config help">


	<xsl:template name="write-style-properties">
		<xsl:param name="style:properties" />

		<!--+++++ PALM 3.2 SUBSET AND WAP PROPERTIES  +++++-->
		<xsl:for-each select="$style:properties/@*">
			<xsl:choose>
				<!--*** FORMAT ATTRIBUTES ***-->

				<!-- Italic -->
				<xsl:when test='name()="fo:font-style"'>
					<xsl:if test="contains(., 'italic') or contains(., 'oblique')">
						<xsl:text>italic, </xsl:text>
					</xsl:if>
				</xsl:when>

				<!-- Boldface -->
				<xsl:when test='name()="fo:font-weight"'>
					<xsl:if test="contains(., 'bold') or contains(., 'bolder')">
						<xsl:text>bold, </xsl:text>
					</xsl:if>
				</xsl:when>

				<!-- Underline -->
				<xsl:when test='name()="style:text-underline"'>
					<xsl:text>underline, </xsl:text>
				</xsl:when>

				<!-- Alignment -->
				<xsl:when test='name()="fo:text-align"'>
					 <xsl:choose>
						<xsl:when test="contains(., 'start')">
							<xsl:text>align:left, </xsl:text>
						</xsl:when>
						<xsl:when test="contains(., 'end')">
							<xsl:text>align:right, </xsl:text>
						</xsl:when>
						<xsl:when test="contains(., 'center')">
							<xsl:text>align:center, </xsl:text>
						</xsl:when>
					 </xsl:choose>
				</xsl:when>

				<!-- strikethrough -->
				<xsl:when test='name()="style:text-crossing-out"'>
					<xsl:text>strike, </xsl:text>
				</xsl:when>

				<!-- Font - size (Palm: emulator transformed sizes to available set (e.g. 30 to (probably) 9)-->
				<xsl:when test='name()="fo:font-size"'>
					<xsl:text>size:</xsl:text><xsl:value-of select="." /><xsl:text>:size, </xsl:text>
				</xsl:when>

				<!-- Font - Color (PALM: but mostly only 2 available)
					black (#000000)
					gray (#808080)(rendered as dark gray)
					silver (#C0C0C0)(rendered as light gray)
					white (#FFFFFF)-->
				<xsl:when test='name()="fo:color"'>
					<xsl:choose>
						<xsl:when test="contains(. , '#FFFFFF') or contains(. , '#ffffff') or contains(. , 'white') or contains(. , 'WHITE')">
							<xsl:text>color:#FFFFFF, </xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>color:#000000, </xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>

				<!--*** TABLE ATTRIBUTES ***-->
				<xsl:when test='name()="fo:font-size"'>
					<xsl:text>size:</xsl:text><xsl:value-of select="." /><xsl:text>:size, </xsl:text>
				</xsl:when>
				<xsl:when test='name()="style:column-width"'>
					<xsl:text>width:</xsl:text>
					<xsl:choose>
						<!-- changing the distance measure: inch to in -->
						<xsl:when test="contains(., 'inch')">
							<xsl:value-of select="substring-before(.,'ch')" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="." />
						</xsl:otherwise>
					</xsl:choose>
					<xsl:text>:width, </xsl:text>
				</xsl:when>
				<xsl:when test='name()="style:row-height"'>
					<xsl:text>height:</xsl:text>
					<xsl:choose>
						<!-- changing the distance measure: inch to in -->
						<xsl:when test="contains(., 'inch')">
							<xsl:value-of select="substring-before(.,'ch')" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="." />
						</xsl:otherwise>
					</xsl:choose>
					<xsl:text>:height; </xsl:text>
				</xsl:when>
				<xsl:when test='name()="style:width"'> <!--earlier fo:width-->
					<xsl:text>width:</xsl:text>
					<xsl:choose>
						<!-- changing the distance measure: inch to in -->
						<xsl:when test="contains(., 'inch')">
							<xsl:value-of select="substring-before(.,'ch')" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="." />
						</xsl:otherwise>
					</xsl:choose>
					<xsl:text>:width; </xsl:text>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>



	<!-- ********************************* -->
	<!-- *** creating table attributes *** -->
	<!-- ********************************* -->

	<!-- table data (td) and table header (th) attributes -->
	<xsl:template name="create-attribute-ALIGN">
		<xsl:param name="styleProperties" />

		<xsl:if test="contains($styleProperties, 'align')">
			<xsl:attribute name="align">
				 <xsl:choose>
					<xsl:when test="contains($styleProperties, 'align:left')">
						<xsl:text>left</xsl:text>
					</xsl:when>
					<xsl:when test="contains($styleProperties, 'align:right')">
						<xsl:text>right</xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>center</xsl:text>
					</xsl:otherwise>
				 </xsl:choose>
			</xsl:attribute>
		</xsl:if>
	</xsl:template>


	<!-- ********************************* -->
	<!-- *** creating List attributes  *** -->
	<!-- ********************************* -->
<!--
	<xsl:template name="create-list-attributes">
		<xsl:param name="styleProperties" />


!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
2 be implemented
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


	</xsl:template>
-->

	<!-- ************************************************ -->
	<!-- *** creating nested format tags (PALM & WML) *** -->
	<!-- ************************************************ -->

	<!-- Italic -->
	<xsl:template name="create-nested-format-tags">
		<xsl:param name="globalData" />
		<xsl:param name="styleProperties" />
		<xsl:choose>
			<xsl:when test="contains($styleProperties, 'italic')">
				<xsl:element namespace="{$namespace}" name="i">
					<xsl:call-template name="bold">
						<xsl:with-param name="styleProperties" select="$styleProperties" />
						<xsl:with-param name="globalData" select="$globalData" />
					</xsl:call-template>
				</xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="bold">
					<xsl:with-param name="styleProperties" select="$styleProperties" />
					<xsl:with-param name="globalData" select="$globalData" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<!-- Bold -->
	<xsl:template name="bold">
		<xsl:param name="globalData" />
		<xsl:param name="styleProperties" />

		<xsl:choose>
			<xsl:when test="contains($styleProperties, 'bold')">
				<xsl:element namespace="{$namespace}" name="b">
					<xsl:call-template name="underline">
						<xsl:with-param name="styleProperties" select="$styleProperties" />
						<xsl:with-param name="globalData" select="$globalData" />
					</xsl:call-template>
				</xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="underline">
					<xsl:with-param name="styleProperties" select="$styleProperties" />
					<xsl:with-param name="globalData" select="$globalData" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<!-- Underline : last format attribute, which is also used from WML - WML ends here! -->
	<xsl:template name="underline">
		<xsl:param name="globalData" />
		<xsl:param name="styleProperties" />

		<xsl:choose>
			<xsl:when test="$outputType = 'PALM'">
				<xsl:choose>
					<xsl:when test="contains($styleProperties, 'underline')">
						<xsl:element namespace="{$namespace}" name="u">
							<xsl:call-template name="strikethrough">
								<xsl:with-param name="styleProperties" select="$styleProperties" />
								<xsl:with-param name="globalData" select="$globalData" />
							</xsl:call-template>
						</xsl:element>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="strikethrough">
							<xsl:with-param name="styleProperties" select="$styleProperties" />
							<xsl:with-param name="globalData" select="$globalData" />
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="contains($styleProperties, 'underline')">
						<xsl:element namespace="{$namespace}" name="u">
							<xsl:apply-templates>
								<xsl:with-param name="globalData" select="$globalData" />
							</xsl:apply-templates>
						</xsl:element>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates>
							<xsl:with-param name="globalData" select="$globalData" />
						</xsl:apply-templates>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<!-- strikethrough -->
	<xsl:template name="strikethrough">
		<xsl:param name="globalData" />
		<xsl:param name="styleProperties" />

		<xsl:choose>
			<xsl:when test="contains($styleProperties, 'strike')">
				<xsl:element namespace="{$namespace}" name="strike">
					<xsl:call-template name="align">
						<xsl:with-param name="styleProperties" select="$styleProperties" />
						<xsl:with-param name="globalData" select="$globalData" />
					</xsl:call-template>
				</xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="align">
					<xsl:with-param name="styleProperties" select="$styleProperties" />
					<xsl:with-param name="globalData" select="$globalData" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<!-- Alignment -->
	<xsl:template name="align">
		<xsl:param name="globalData" />
		<xsl:param name="styleProperties" />

		<xsl:choose>
			<xsl:when test="contains($styleProperties, 'align')">
				<xsl:element namespace="{$namespace}" name="div">
					<xsl:attribute name="style">
						 <xsl:choose>
							<xsl:when test="contains($styleProperties, 'align:left')">
								<xsl:text>text-align:left;</xsl:text>
							</xsl:when>
							<xsl:when test="contains($styleProperties, 'align:right')">
								<xsl:text>text-align:right;</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>text-align:center;</xsl:text>
							</xsl:otherwise>
						 </xsl:choose>
					</xsl:attribute>
					<xsl:call-template name="font_combined">
						<xsl:with-param name="styleProperties" select="$styleProperties" />
						<xsl:with-param name="globalData" select="$globalData" />
					</xsl:call-template>
				</xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="font_combined">
					<xsl:with-param name="styleProperties" select="$styleProperties" />
					<xsl:with-param name="globalData" select="$globalData" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<!-- Both size and Color for font -->
	<xsl:template name="font_combined">
		<xsl:param name="globalData" />
		<xsl:param name="styleProperties" />

		<xsl:choose>
			<xsl:when test="contains($styleProperties, 'color') and contains($styleProperties, 'size')">
				<xsl:element namespace="{$namespace}" name="font">

					<xsl:attribute name="color">
						 <xsl:choose>
							<xsl:when test="contains($styleProperties, 'color:#000000')">
								<xsl:text>#000000</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>#FFFFFF</xsl:text>
							</xsl:otherwise>
						 </xsl:choose>
					</xsl:attribute>

					<xsl:attribute name="size">
						<xsl:value-of select="substring-after(substring-before($styleProperties ,':size'), 'size:')" />
					</xsl:attribute>

					<!-- get the embedded content -->
					<xsl:apply-templates>
						<xsl:with-param name="globalData" select="$globalData" />
					</xsl:apply-templates>
				</xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="font_simple">
					<xsl:with-param name="styleProperties" select="$styleProperties" />
					<xsl:with-param name="globalData" select="$globalData" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<!-- size or Color for font -->
	<xsl:template name="font_simple">
		<xsl:param name="globalData" />
		<xsl:param name="styleProperties" />

		<xsl:choose>
			<xsl:when test="contains($styleProperties, 'color')">
				<xsl:element namespace="{$namespace}" name="font">
					<xsl:attribute name="color">
						 <xsl:choose>
							<xsl:when test="contains($styleProperties, 'color:#000000')">
								<xsl:text>#000000</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>#FFFFFF</xsl:text>
							</xsl:otherwise>
						 </xsl:choose>
					</xsl:attribute>

					<!-- get the embedded content -->
					<xsl:apply-templates>
						<xsl:with-param name="globalData" select="$globalData" />
					</xsl:apply-templates>
				</xsl:element>
			</xsl:when>

			<xsl:when test="contains($styleProperties, 'size')">
				<xsl:element namespace="{$namespace}" name="font">
					<xsl:attribute name="size">
						<xsl:value-of select="substring-after(substring-before($styleProperties ,':size'), 'size:')" />
					</xsl:attribute>

					<!-- get the embedded content -->
					<xsl:apply-templates>
						<xsl:with-param name="globalData" select="$globalData" />
					</xsl:apply-templates>
				</xsl:element>
			</xsl:when>

			<xsl:otherwise>
				<!-- get the embedded content -->
				<xsl:apply-templates>
					<xsl:with-param name="globalData" select="$globalData" />
				</xsl:apply-templates>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>
