<?xml version="1.0" encoding="UTF-8"?>
<!--

   $RCSfile: table_cells.xsl,v $

   $Revision: 1.4 $

   last change: $Author: rt $ $Date: 2005/03/29 12:42:28 $

   The Contents of this file are made available subject to the terms of
   either of the following licenses

		  - GNU Lesser General Public License Version 2.1
		  - Sun Industry Standards Source License Version 1.1

   Sun Microsystems Inc., October, 2000

   GNU Lesser General Public License Version 2.1
   =============================================
   Copyright 2000 by Sun Microsystems, Inc.
   901 San Antonio Road, Palo Alto, CA 94303, USA

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License version 2.1, as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
   MA  02111-1307  USA


   Sun Industry Standards Source License Version 1.1
   =================================================
   The contents of this file are subject to the Sun Industry Standards
   Source License Version 1.1 (the "License"); You may not use this file
   except in compliance with the License. You may obtain a copy of the
   License at http://www.openoffice.org/license.html.

   Software provided under this License is provided on an "AS IS" basis,
   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
   See the License for the specific provisions governing your rights and
   obligations concerning the Software.

   The Initial Developer of the Original Code is: Sun Microsystems, Inc.

   Copyright © 2002 by Sun Microsystems, Inc.

   All Rights Reserved.

   Contributor(s): _______________________________________

-->
<!--
	For further documentation and updates visit http://xml.openoffice.org/sx2ml
-->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:office="http://openoffice.org/2000/office"
	xmlns:style="http://openoffice.org/2000/style"
	xmlns:text="http://openoffice.org/2000/text"
	xmlns:table="http://openoffice.org/2000/table"
	xmlns:draw="http://openoffice.org/2000/drawing"
	xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:xlink="http://www.w3.org/1999/xlink"
	xmlns:number="http://openoffice.org/2000/datastyle"
	xmlns:svg="http://www.w3.org/2000/svg"
	xmlns:chart="http://openoffice.org/2000/chart"
	xmlns:dr3d="http://openoffice.org/2000/dr3d"
	xmlns:math="http://www.w3.org/1998/Math/MathML"
	xmlns:form="http://openoffice.org/2000/form"
	xmlns:script="http://openoffice.org/2000/script"
	xmlns:dc="http://purl.org/dc/elements/1.1/"
	xmlns:meta="http://openoffice.org/2000/meta"
	xmlns:config="http://openoffice.org/2001/config"
	xmlns:help="http://openoffice.org/2000/help"
	xmlns:xt="http://www.jclark.com/xt"
	xmlns:common="http://exslt.org/common"
	xmlns:xalan="http://xml.apache.org/xalan"
	exclude-result-prefixes="office style text table draw fo xlink number svg chart dr3d math form script dc meta config help xt common xalan">


	<!-- *********************************** -->
	<!-- *** write repeating table cells *** -->
	<!-- *********************************** -->


	<!-- matching cells to give out -> covered table cells are not written out -->
	<xsl:template match="table:table-cell">
		<xsl:param name="globalData" />
		<!-- position of the current input cell to get the correct colum style (hidden are also counted)-->
		<xsl:param name="allTableColumns" />
		<xsl:param name="maxRowLength" />
		<xsl:param name="tableDataType" />


		<!-- The column position of the current cell has to be determined
		to get the adequate column styles during later cell creation,
		or hiding the cell when @table:visibility is not set to 'visible'.

		The position is archieved by adding up all table:number-columns-repeated of the preceding cells.
			Step1: creating '$precedingCells/quantity/@table:number-columns-repeated').
			Step2: sum(xxx:nodeset($precedingCells)/quantity) + 1        -->
		<xsl:variable name="precedingCells">
			<xsl:for-each select="preceding-sibling::*">
				<xsl:choose>
					<!-- maybe a parser is used, which reads the DTD files (e.g. Xerces),
						then '1' is the default for 'table:number-columns-repeated' -->
					<xsl:when test="not(@table:number-columns-repeated and @table:number-columns-repeated > 1)">
						<xsl:element name="quantity" namespace="">
							<xsl:text>1</xsl:text>
						</xsl:element>
					</xsl:when>
					<xsl:otherwise>
						<xsl:element name="quantity" namespace="">
							<xsl:value-of select="@table:number-columns-repeated" />
						</xsl:element>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="function-available('xt:node-set')">
				<xsl:call-template name="create-table-cell">
					<!-- position of the current input cell to get the correct colum style (hidden are also counted)-->
					<xsl:with-param name="allTableColumns"  select="$allTableColumns" />
					<xsl:with-param name="maxRowLength"     select="$maxRowLength" />
					<xsl:with-param name="columnPosition"   select="sum(xt:node-set($precedingCells)/*) + 1" />
					<xsl:with-param name="globalData"       select="$globalData" />
					<xsl:with-param name="tableDataType"    select="$tableDataType" />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="function-available('common:nodeset')">
				<xsl:call-template name="create-table-cell">
					<!-- position of the current input cell to get the correct colum style (hidden are also counted)-->
					<xsl:with-param name="allTableColumns"  select="$allTableColumns" />
					<xsl:with-param name="maxRowLength"     select="$maxRowLength" />
					<xsl:with-param name="columnPosition"   select="sum(common:nodeset($precedingCells)/*) + 1" />
					<xsl:with-param name="globalData"       select="$globalData" />
					<xsl:with-param name="tableDataType"    select="$tableDataType" />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="function-available('xalan:nodeset')">
				<xsl:call-template name="create-table-cell">
					<!-- position of the current input cell to get the correct colum style (hidden are also counted)-->
					<xsl:with-param name="allTableColumns"  select="$allTableColumns" />
					<xsl:with-param name="maxRowLength"     select="$maxRowLength" />
					<xsl:with-param name="columnPosition"   select="sum(xalan:nodeset($precedingCells)/*) + 1" />
					<xsl:with-param name="globalData"       select="$globalData" />
					<xsl:with-param name="tableDataType"    select="$tableDataType" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:message terminate="yes">ERROR: Function not found: nodeset</xsl:message>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<!-- current node is a table:table-cell -->
	<xsl:template name="create-table-cell">
		<!-- position of the current input cell to get the correct colum style (hidden are also counted)-->
		<xsl:param name="allTableColumns" />
		<xsl:param name="globalData" />
		<xsl:param name="maxRowLength" />
		<xsl:param name="columnPosition" />
		<xsl:param name="tableDataType" />

		<xsl:if test="$debugEnabled">
			<xsl:message>
				<xsl:text>
					table:table-cell #</xsl:text>
				<xsl:value-of select="$columnPosition" />
				<xsl:text> has been entered with node value: </xsl:text>
				<xsl:value-of select="." />
				<xsl:text>
					table:number-columns-repeated: </xsl:text>
				<xsl:value-of select="@table:number-columns-repeated" />
				<xsl:text>
					maxRowLength: </xsl:text>
				<xsl:value-of select="$maxRowLength" />
			</xsl:message>
		</xsl:if>

		<!-- only non hidden column will be given out -->
		<xsl:variable name="currentTableColumn" select="$allTableColumns/table:table-column[position() = $columnPosition]" />
		<xsl:if test="$currentTableColumn[not(@table:visibility = 'collapse' or @table:visibility = 'filter')]">
			<xsl:choose>
				<!-- if parser reads DTD the default is set to '1' -->
				<xsl:when test="@table:number-columns-repeated > 1">
					<!-- writes multiple entries of a cell -->
					<xsl:call-template name="repeat-write-cell">
						<xsl:with-param name="globalData"               select="$globalData" />
						<xsl:with-param name="allTableColumns"          select="$allTableColumns" />
						<xsl:with-param name="columnPosition"           select="$columnPosition" />
						<xsl:with-param name="currentTableColumn"       select="$currentTableColumn" />
						<xsl:with-param name="maxRowLength"             select="$maxRowLength" />
						<xsl:with-param name="numberColumnsRepeated"    select="@table:number-columns-repeated" />
						<xsl:with-param name="tableDataType"            select="$tableDataType" />
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<!-- writes an entry of a cell -->
					<xsl:call-template name="write-cell">
						<xsl:with-param name="globalData"           select="$globalData" />
						<xsl:with-param name="allTableColumns"      select="$allTableColumns" />
						<xsl:with-param name="columnPosition"       select="$columnPosition" />
						<xsl:with-param name="currentTableColumn"   select="$currentTableColumn" />
						<xsl:with-param name="maxRowLength"         select="$maxRowLength" />
						<xsl:with-param name="tableDataType"        select="$tableDataType" />
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>


	<xsl:template name="repeat-write-cell">
		<xsl:param name="globalData" />
		<xsl:param name="allTableColumns" />
		<xsl:param name="columnPosition" />
		<xsl:param name="currentTableColumn" />
		<xsl:param name="maxRowLength" />
		<xsl:param name="numberColumnsRepeated" />
		<xsl:param name="tableDataType" />

		<xsl:choose>
			<!-- This is the current workaround for the flood of cells, simulation background by repeating cell -->
			<xsl:when test="$numberColumnsRepeated > 1 and $maxRowLength > $columnPosition">

				<!-- writes an entry of a cell -->
				<xsl:call-template name="write-cell">
					<xsl:with-param name="globalData"           select="$globalData" />
					<xsl:with-param name="allTableColumns"      select="$allTableColumns" />
					<xsl:with-param name="columnPosition"       select="$columnPosition" />
					<xsl:with-param name="currentTableColumn"   select="$currentTableColumn" />
					<xsl:with-param name="tableDataType"        select="$tableDataType" />
				</xsl:call-template>
				<!-- repeat calling this method until all elements written out -->
				<xsl:if test="$debugEnabled">
					<xsl:message>+++++++++ cell repetition +++++++++</xsl:message>
				</xsl:if>
				<xsl:call-template name="repeat-write-cell">
					<xsl:with-param name="globalData"               select="$globalData" />
					<xsl:with-param name="allTableColumns"          select="$allTableColumns" />
					<xsl:with-param name="columnPosition"           select="$columnPosition + 1" />
					<xsl:with-param name="currentTableColumn"       select="$allTableColumns/table:table-column[position() = ($columnPosition + 1)]" />
					<xsl:with-param name="maxRowLength"             select="$maxRowLength" />
					<xsl:with-param name="numberColumnsRepeated"    select="$numberColumnsRepeated - 1" />
					<xsl:with-param name="tableDataType"            select="$tableDataType" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<!-- This is the current workaround for the flood of cells, simulation background by repeating cell -->
				<!--      When the maxRowLength is reached a last entry of a cell is written -->
				<xsl:call-template name="write-cell">
					<xsl:with-param name="globalData"           select="$globalData" />
					<xsl:with-param name="allTableColumns"      select="$allTableColumns" />
					<xsl:with-param name="columnPosition"       select="$columnPosition" />
					<xsl:with-param name="currentTableColumn"   select="$currentTableColumn" />
					<xsl:with-param name="tableDataType"        select="$tableDataType" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<xsl:template name="write-cell">
		<xsl:param name="globalData" />
		<xsl:param name="allTableColumns" />
		<xsl:param name="columnPosition" />
		<xsl:param name="currentTableColumn" />
		<xsl:param name="tableDataType" />

		<!-- a non hidden column will be give out -->
		<xsl:choose>
			<xsl:when test="$currentTableColumn[not(@table:visibility = 'collapse' or @table:visibility = 'filter')]">
				<xsl:call-template name="create-table-cell-content">
					<xsl:with-param name="globalData"           select="$globalData" />
					<xsl:with-param name="allTableColumns"      select="$allTableColumns" />
					<xsl:with-param name="columnPosition"       select="$columnPosition" />
					<xsl:with-param name="currentTableColumn"   select="$currentTableColumn" />
					<xsl:with-param name="tableDataType"        select="$tableDataType" />
				</xsl:call-template>
			</xsl:when>
			<!-- a hidden column -->
			<xsl:otherwise>
				<xsl:if test="$debugEnabled">
					<xsl:message>table column is hidden!</xsl:message>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
