<?xml version="1.0" encoding="UTF-8"?>
<!--

   $RCSfile: table.xsl,v $

   $Revision: 1.4 $

   last change: $Author: rt $ $Date: 2005/03/29 12:42:14 $

   The Contents of this file are made available subject to the terms of
   either of the following licenses

		  - GNU Lesser General Public License Version 2.1
		  - Sun Industry Standards Source License Version 1.1

   Sun Microsystems Inc., October, 2000

   GNU Lesser General Public License Version 2.1
   =============================================
   Copyright 2000 by Sun Microsystems, Inc.
   901 San Antonio Road, Palo Alto, CA 94303, USA

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License version 2.1, as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
   MA  02111-1307  USA


   Sun Industry Standards Source License Version 1.1
   =================================================
   The contents of this file are subject to the Sun Industry Standards
   Source License Version 1.1 (the "License"); You may not use this file
   except in compliance with the License. You may obtain a copy of the
   License at http://www.openoffice.org/license.html.

   Software provided under this License is provided on an "AS IS" basis,
   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
   See the License for the specific provisions governing your rights and
   obligations concerning the Software.

   The Initial Developer of the Original Code is: Sun Microsystems, Inc.

   Copyright © 2002 by Sun Microsystems, Inc.

   All Rights Reserved.

   Contributor(s): _______________________________________

-->
<!--
	For further documentation and updates visit http://xml.openoffice.org/sx2ml
-->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:office="http://openoffice.org/2000/office"
	xmlns:style="http://openoffice.org/2000/style"
	xmlns:text="http://openoffice.org/2000/text"
	xmlns:table="http://openoffice.org/2000/table"
	xmlns:draw="http://openoffice.org/2000/drawing"
	xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:xlink="http://www.w3.org/1999/xlink"
	xmlns:number="http://openoffice.org/2000/datastyle"
	xmlns:svg="http://www.w3.org/2000/svg"
	xmlns:chart="http://openoffice.org/2000/chart"
	xmlns:dr3d="http://openoffice.org/2000/dr3d"
	xmlns:math="http://www.w3.org/1998/Math/MathML"
	xmlns:form="http://openoffice.org/2000/form"
	xmlns:script="http://openoffice.org/2000/script"
	xmlns:dc="http://purl.org/dc/elements/1.1/"
	xmlns:meta="http://openoffice.org/2000/meta"
	xmlns:config="http://openoffice.org/2001/config"
	xmlns:help="http://openoffice.org/2000/help"
	exclude-result-prefixes="office style text table draw fo xlink number svg chart dr3d math form script dc meta config help">


	<!-- table row handling -->
	<xsl:include href="table_rows.xsl" />
	<!-- table column handling -->
	<xsl:include href="table_columns.xsl" />
	<!-- table cell handling -->
	<xsl:include href="table_cells.xsl" />

	<xsl:param name="tableElement" select="'table'" />

	<!-- ******************* -->
	<!-- *** main table  *** -->
	<!-- ******************* -->


	<xsl:template match="table:table | table:sub-table" name="table:table">
		<xsl:param name="globalData" />

		<!-- The table will only be created if the table:scenario is active -->
		<xsl:if test="not(table:scenario) or table:scenario/@table:is-active">
			<xsl:call-template name="create-table">
				<xsl:with-param name="globalData" select="$globalData" />
			</xsl:call-template>
		</xsl:if>
	</xsl:template>



	<xsl:template name="create-table">
		<xsl:param name="globalData" />

		<!-- by default '1', for each new sub/inner/nested table the number counts one up -->
		<xsl:variable name="tableLevel" select="count(ancestor-or-self::table:table | ancestor-or-self::table:sub-table)" />
		<!-- collecting all visible "table:table-row" elements of the table -->
		<xsl:variable name="allVisibleTableRows" select="table:table-row[not(@table:visibility = 'collapse' or @table:visibility = 'filter')][count(ancestor-or-self::table:table | ancestor-or-self::table:sub-table) = $tableLevel] |
														 table:table-header-rows/descendant::table:table-row[not(@table:visibility = 'collapse' or @table:visibility = 'filter')][count(ancestor-or-self::table:table | ancestor-or-self::table:sub-table) = $tableLevel] |
														 table:table-row-group/descendant::table:table-row[not(@table:visibility = 'collapse' or @table:visibility = 'filter')][count(ancestor-or-self::table:table | ancestor-or-self::table:sub-table) = $tableLevel]" />
		<xsl:choose>
			<xsl:when test="$outputType = 'WML'">
			<!-- for WML devices only ASCII table are written as tables are not implemented widley.
				 Beginning from 'repeat-write-row' the templates are handled by the table_wml.xsl stylesheet -->
				<xsl:call-template name="create-column-style-variable">
					<xsl:with-param name="globalData" select="$globalData" />
					<xsl:with-param name="allVisibleTableRows" select="$allVisibleTableRows" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<!-- As the alignment of a table is by 'align' attribut is deprecated and as the CSS 'float' attribute not well displayed,
					 we do a trick by encapsulating the table with a aligned 'div' element-->
				<xsl:variable name="table-alignment" select="$globalData/office:automatic-styles/style:style[@style:name = current()/@table:style-name]/style:properties/@table:align" />
				<xsl:choose>
					<xsl:when test="string-length($table-alignment) != 0">
						<xsl:element namespace="{$namespace}" name="div">
							<xsl:attribute name="style">
								<xsl:choose>
									<xsl:when test='$table-alignment="left" or $table-alignment="margins"'>
										<xsl:text>text-align:left</xsl:text>
									</xsl:when>
									<xsl:when test='$table-alignment="right"'>
										<xsl:text>text-align:right</xsl:text>
									</xsl:when>
									<xsl:when test='$table-alignment="center"'>
										<xsl:text>text-align:center</xsl:text>
									</xsl:when>
								</xsl:choose>
							</xsl:attribute>
							<xsl:call-template name="create-table-element">
								<xsl:with-param name="globalData" select="$globalData" />
								<xsl:with-param name="allVisibleTableRows" select="$allVisibleTableRows" />
							</xsl:call-template>
						</xsl:element>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="create-table-element">
							<xsl:with-param name="globalData" select="$globalData" />
							<xsl:with-param name="allVisibleTableRows" select="$allVisibleTableRows" />
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<xsl:template name="create-table-element">
		<xsl:param name="globalData" />
		<xsl:param name="allVisibleTableRows" />

		<xsl:element namespace="{$namespace}" name="{$tableElement}">
			<xsl:attribute name="border">0</xsl:attribute>
			<xsl:attribute name="cellspacing">0</xsl:attribute>
			<xsl:attribute name="cellpadding">0</xsl:attribute>
			<xsl:choose>
				<xsl:when test='name()="table:table"'>
					<xsl:variable name="value" select="$globalData/all-ooo-styles/style[@style:name = current()/@table:style-name]/style:properties/@style:rel-width" />
					<xsl:if test="$value">
						<xsl:attribute name="width">
							<xsl:value-of select="$value" />
						</xsl:attribute>
					</xsl:if>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="width">100%</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>

			<xsl:choose>
				<!--+++++ SPECIAL HANDLING HTML 4.0 INLINED WAY  +++++-->
				<!-- The office default value 'border-spacing:0;' have to be added to the style -->
				<xsl:when test="$outputType = 'CSS_INLINED'">
					<xsl:attribute name="style">
						<xsl:text>border-spacing:0;  empty-cells:show; </xsl:text>
						<xsl:value-of select="$globalData/all-styles/style[@style:name = current()/@table:style-name]/final-properties" />
					</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="@table:style-name">
						<xsl:with-param name="globalData" select="$globalData" />
					</xsl:apply-templates>
				</xsl:otherwise>
			</xsl:choose>

			<xsl:call-template name="create-column-style-variable">
				<xsl:with-param name="globalData" select="$globalData" />
				<xsl:with-param name="allVisibleTableRows" select="$allVisibleTableRows" />
			</xsl:call-template>
		</xsl:element>
	</xsl:template>

</xsl:stylesheet>
