<?xml version="1.0" encoding="UTF-8"?>
<!--

   $RCSfile: style_mapping_css.xsl,v $

   $Revision: 1.5 $

   last change: $Author: rt $ $Date: 2005/03/29 12:41:46 $

   The Contents of this file are made available subject to the terms of
   either of the following licenses

		  - GNU Lesser General Public License Version 2.1
		  - Sun Industry Standards Source License Version 1.1

   Sun Microsystems Inc., October, 2000

   GNU Lesser General Public License Version 2.1
   =============================================
   Copyright 2000 by Sun Microsystems, Inc.
   901 San Antonio Road, Palo Alto, CA 94303, USA

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License version 2.1, as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
   MA  02111-1307  USA


   Sun Industry Standards Source License Version 1.1
   =================================================
   The contents of this file are subject to the Sun Industry Standards
   Source License Version 1.1 (the "License"); You may not use this file
   except in compliance with the License. You may obtain a copy of the
   License at http://www.openoffice.org/license.html.

   Software provided under this License is provided on an "AS IS" basis,
   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
   See the License for the specific provisions governing your rights and
   obligations concerning the Software.

   The Initial Developer of the Original Code is: Sun Microsystems, Inc.

   Copyright © 2002 by Sun Microsystems, Inc.

   All Rights Reserved.

   Contributor(s): _______________________________________

-->
<!--
	For further documentation and updates visit http://xml.openoffice.org/sx2ml
-->
<xsl:stylesheet version="1.0"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:office="http://openoffice.org/2000/office"
				xmlns:style="http://openoffice.org/2000/style"
				xmlns:text="http://openoffice.org/2000/text"
				xmlns:table="http://openoffice.org/2000/table"
				xmlns:draw="http://openoffice.org/2000/drawing"
				xmlns:fo="http://www.w3.org/1999/XSL/Format"
				xmlns:xlink="http://www.w3.org/1999/xlink"
				xmlns:number="http://openoffice.org/2000/datastyle"
				xmlns:svg="http://www.w3.org/2000/svg"
				xmlns:chart="http://openoffice.org/2000/chart"
				xmlns:dr3d="http://openoffice.org/2000/dr3d"
				xmlns:math="http://www.w3.org/1998/Math/MathML"
				xmlns:form="http://openoffice.org/2000/form"
				xmlns:script="http://openoffice.org/2000/script"
				xmlns:dc="http://purl.org/dc/elements/1.1/"
				xmlns:meta="http://openoffice.org/2000/meta"
				xmlns:config="http://openoffice.org/2001/config"
				xmlns:help="http://openoffice.org/2000/help"
				exclude-result-prefixes="office style text table draw fo xlink number svg chart dr3d math form script dc meta config help">

	<!--+++++ CSS PROPERTIES  +++++-->
	<xsl:template name="write-style-properties">
		<xsl:param name="globalData" />
		<xsl:param name="style:properties" />

        <!-- NOTE: The OOo attribute 'style:number-wrapped-paragraphs' is not matched yet -->
		<xsl:for-each select="$style:properties/@*">
			<xsl:choose>
                <!-- *** Properties with a 'fo:' prefix *** -->
                <xsl:when test="starts-with(name(), 'fo:')">
                    <xsl:choose>
                        <xsl:when test='name()="fo:background-color"'>
                            <xsl:text>background-color:</xsl:text><xsl:value-of select="." /><xsl:text>; </xsl:text>
                        </xsl:when>
                        <xsl:when test='starts-with(name(),"fo:border")'>
                            <!-- generic type for five attributes: fo:border, fo:border-top, fo:border-bottom, fo:border-left, fo:border-right -->
                            <xsl:variable name="borderType" select="substring-after(name(), ':')" />
                            <xsl:choose>
                                <xsl:when test=". = 'none'">
                                    <xsl:value-of select="$borderType" /><xsl:text>-style:none; </xsl:text>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:variable name="borderWidth" select="substring-before(., ' ')" />
                                    <xsl:variable name="borderStyle" select="substring-before(substring-after(., ' '), ' ')" />
                                    <xsl:variable name="borderColor" select="substring-after(substring-after(., ' '), ' ')" />

                                    <!-- More information at template 'round-up-border-width' -->
                                    <xsl:variable name="borderWidthFixed">
                                        <xsl:call-template name="round-up-border-width">
                                            <xsl:with-param name="borderWidth" select="$borderWidth" />
                                            <xsl:with-param name="multiplier">
                                                <xsl:choose>
                                                    <xsl:when test="$borderStyle = 'double'">3</xsl:when>
                                                    <xsl:otherwise>1</xsl:otherwise>
                                                </xsl:choose>
                                            </xsl:with-param>
                                        </xsl:call-template>
                                    </xsl:variable>

                                    <xsl:value-of select="$borderType" /><xsl:text>-width:</xsl:text><xsl:value-of select="$borderWidthFixed"/><xsl:text>; </xsl:text>
                                    <xsl:value-of select="$borderType" /><xsl:text>-style:</xsl:text><xsl:value-of select="$borderStyle" /><xsl:text>; </xsl:text>
                                    <xsl:value-of select="$borderType" /><xsl:text>-color:</xsl:text><xsl:value-of select="$borderColor" /><xsl:text>; </xsl:text>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:when>
                        <!-- NOTE: Still there have to be placed a <br clear='all' /> to disable the flow!!!!-->
                        <xsl:when test='name()="fo:clear"'>
                            <xsl:text>clear:both; </xsl:text>
                        </xsl:when>
                        <!-- text-shadow is a CSS2 feature and yet not common used in user-agents -->
                        <xsl:when test='name() = "fo:color" or
                                        name() = "fo:font-family" or
                                        name() = "fo:font-size" or
                                        name() = "fo:font-style" or
                                        name() = "fo:font-weight" or
                                        name() = "fo:text-indent" or
                                        name() = "fo:text-shadow"'>
                            <xsl:value-of select="substring-after(name(), ':')" /><xsl:text>:</xsl:text><xsl:value-of select="." /><xsl:text>; </xsl:text>
                        </xsl:when>
                        <!-- Maps fo:margin as well fo:margin-top, fo:margin-bottom, fo:margin-left, fo:margin-right -->
                        <!-- Maps fo:padding as well fo:padding-top, fo:padding-bottom, fo:padding-left, fo:padding-right -->
                        <xsl:when test='name() = "fo:line-height" or
                                        name() = "fo:width" or
                                        starts-with(name(), "fo:margin") or
                                        starts-with(name(), "fo:padding")'>
                            <xsl:value-of select="substring-after(name(), ':')" /><xsl:text>:</xsl:text>
                            <!-- Map OOo inch shortage 'inch' to CSS shortage 'in' -->
                            <xsl:choose>
                                <xsl:when test="contains(., 'inch')">
                                    <xsl:value-of select="substring-before(.,'ch')" />
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="." />
                                </xsl:otherwise>
                            </xsl:choose>
                            <xsl:text>; </xsl:text>
                        </xsl:when>
                        <xsl:when test='name()="fo:text-align"'>
                            <!-- 'important' is necessary as table cell value alignment is decided by runtime over the valuetype
                                 Otherwise a table cell style-class would always be outnumbered by the run-time alignment value -->
                             <xsl:choose>
                                <xsl:when test="contains(., 'start')">
                                    <xsl:text>text-align:left ! important; </xsl:text>
                                </xsl:when>
                                <xsl:when test="contains(., 'end')">
                                    <xsl:text>text-align:right ! important; </xsl:text>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:text>text-align:</xsl:text><xsl:value-of select='.' /><xsl:text> ! important; </xsl:text>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:when>
                        <xsl:when test='name()="fo:vertical-align"'>
                            <xsl:choose>
                                <xsl:when test='contains(., "bottom")'>
                                    <xsl:text>vertical-align:bottom; </xsl:text>
                                </xsl:when>
                                <xsl:when test='contains(., "middle")'>
                                    <xsl:text>vertical-align:middle; </xsl:text>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:text>vertical-align:top; </xsl:text>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:when>
                    </xsl:choose>
                </xsl:when>

                <!-- *** Properties with a 'style:' prefix *** -->
                <xsl:when test="starts-with(name(), 'style:')">
                    <xsl:choose>
                        <xsl:when test='name()="style:background-image"'>
                            <xsl:text>background-image:url(</xsl:text><xsl:value-of select="@xlink:href" /><xsl:text>); </xsl:text>
                            <xsl:choose>
                                <xsl:when test="@style:repeat = 'repeat'">
                                    <xsl:text>background-repeat:repeat; </xsl:text>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:text>background-repeat:no-repeat; </xsl:text>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:when>
                        <!-- NOTE: Can 'inside' | 'from-inside' better be handled:
                            <!ATTLIST style:properties style:horizontal-pos (from-left|left|center|right|from-inside|inside|outside)#IMPLIED>-->
                        <xsl:when test='name() = "style:horizontal-pos"'>
                            <xsl:choose>
                                <xsl:when test='.="left"'>
                                    <xsl:text>text-align:left; </xsl:text>
                                </xsl:when>
                                <xsl:when test='. = "right"'>
                                    <xsl:text>text-align:right; </xsl:text>
                                </xsl:when>
                                <xsl:when test='.="center"'>
                                    <xsl:text>text-align:center; </xsl:text>
                                </xsl:when>
                                <!-- NOTE: currently other values are not used.
                                    If the property value is from-left or from-inside,
                                    the svg:x attribute associated with the frame element specifies
                                    the horizontal position of the frame.
                                    Otherwise the svg:x attribute is ignored for text documents.
                                -->
                            </xsl:choose>
                        </xsl:when>
                        <xsl:when test='name()="style:column-width"'>
                            <xsl:text>width:</xsl:text>
                            <xsl:choose>
                                <!-- changing the distance measure: inch to in -->
                                <xsl:when test="contains(., 'inch')">
                                    <xsl:value-of select="substring-before(.,'ch')" />
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="." />
                                </xsl:otherwise>
                            </xsl:choose>
                            <xsl:text>; </xsl:text>
                        </xsl:when>
                        <xsl:when test='name()="style:font-name"'>
                            <xsl:text>font-family:</xsl:text>
                            <xsl:variable name="content" select="." />
                            <xsl:value-of select="$globalData/office:font-decls/style:font-decl[@style:name=$content]/@fo:font-family" />
                            <xsl:text>; </xsl:text>
                            <xsl:if test="contains($globalData/office:font-decls/style:font-decl[@style:name=$content]/@style:font-style-name, 'Italic')">
                                <xsl:text>font-style:italic; </xsl:text>
                            </xsl:if>
                            <xsl:if test="contains($globalData/office:font-decls/style:font-decl[@style:name=$content]/@style:font-style-name, 'Bold')">
                                <xsl:text>font-weight:bold; </xsl:text>
                            </xsl:if>
                        </xsl:when>
                        <xsl:when test='name()="style:row-height"'>
                            <xsl:text>height:</xsl:text>
                            <xsl:choose>
                                <!-- changing the distance measure: inch to in -->
                                <xsl:when test="contains(., 'inch')">
                                    <xsl:value-of select="substring-before(.,'ch')" />
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="." />
                                </xsl:otherwise>
                            </xsl:choose>
                            <xsl:text>; </xsl:text>
                        </xsl:when>
                        <xsl:when test='name()="style:text-background-color"'>
                            <xsl:text>background-color:</xsl:text><xsl:value-of select="." /><xsl:text>; </xsl:text>
                        </xsl:when>
                        <xsl:when test='name()="style:text-crossing-out"'>
                            <xsl:if test='not(.="none")'>
                                <xsl:text>text-decoration:line-through; </xsl:text>
                            </xsl:if>
                        </xsl:when>
                        <xsl:when test='name()="style:text-position"'>
                            <xsl:if test='contains(., "sub")'>
                                <xsl:text>vertical-align:sub; </xsl:text>
                            </xsl:if>
                            <xsl:if test='contains(., "sup")'>
                                <xsl:text>vertical-align:sup; </xsl:text>
                            </xsl:if>
                        </xsl:when>
                        <xsl:when test='name()="style:text-underline"'>
                            <xsl:if test='not(.="none")'>
                                <xsl:text>text-decoration:underline; </xsl:text>
                            </xsl:if>
                        </xsl:when>
                        <xsl:when test='name() = "style:vertical-pos"'>
                            <xsl:choose>
                                <xsl:when test='.="from-top"'>
                                    <xsl:text>vertical-align:top; </xsl:text>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:text>vertical-align:</xsl:text><xsl:value-of select="." /><xsl:text>; </xsl:text>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:when>
                        <xsl:when test='name()="style:width"'>
                            <xsl:text>width:</xsl:text>
                            <xsl:choose>
                                <!-- changing the distance measure: inch to in -->
                                <xsl:when test="contains(., 'inch')">
                                    <xsl:value-of select="substring-before(.,'ch')" />
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="." />
                                </xsl:otherwise>
                            </xsl:choose>
                            <xsl:text>; </xsl:text>
                        </xsl:when>
                        <xsl:when test='name()="style:wrap"'>
                            <xsl:choose>
                                <xsl:when test='.="left"'>
                                    <xsl:text>float:right; </xsl:text>
                                </xsl:when>
                                <xsl:when test='.="right"'>
                                    <xsl:text>float:left; </xsl:text>
                                </xsl:when>
                            </xsl:choose>
                        </xsl:when>
                    </xsl:choose>
                </xsl:when>
                <!-- *** Properties with a no 'fo:' or 'style:' prefix *** -->
                <xsl:otherwise>
                    <xsl:choose>
                        <xsl:when test='name() = "table:align"'>
                            <xsl:choose>
                                <xsl:when test='.="left"'>
                                <!-- Note: problems with meeting minutes example
                                    <xsl:text>float:right; </xsl:text> -->
                                </xsl:when>
                                <xsl:when test='.="right"'>
                                <!-- Note: problems with meeting minutes example
                                    <xsl:text>float:left; </xsl:text> -->
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:text>float:none; </xsl:text>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:when>
                    </xsl:choose>
                </xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>

	<!-- Changing border width measure to cm and enlarging border-width to the Mozilla browser(1.7)
         visible minimum width
            - 0.0133cm for solid style
            - 0.0399cm for double style
         as there are three border lines painted -->
	<xsl:template name="round-up-border-width">
		<xsl:param name="borderWidth" />
        <xsl:param name="multiplier" />

		<xsl:variable name="borderWidthByCentimeter">
			<xsl:call-template name="convert2cm">
				<xsl:with-param name="value" select="$borderWidth" />
			</xsl:call-template>
		</xsl:variable>
        <xsl:variable name="minimalBorderWidth" select="0.0133 * $multiplier" />
		<xsl:choose>
			<xsl:when test="number($borderWidthByCentimeter) &lt; $minimalBorderWidth">
				<xsl:value-of select="$minimalBorderWidth" /><xsl:text>cm</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$borderWidthByCentimeter" /><xsl:text>cm</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>

