#!/bin/sh

if [ "$UID" = 0 ]; then
   /sbin/echoc "You are working as root" red
   echo Type vasm to run administration menu.
   export CFLAGS="-O2 -march=i586 -mcpu=i686"
   export CXXFLAGS="-O2 -march=i586 -mcpu=i686"
   export PATH="$PATH:/usr/local/sbin:/usr/sbin:/sbin"
   if [ -z "$USER" ] || [ "$USER" != "root" ]; then
      UHOME=`egrep "^$USER:" /etc/passwd | cut -f6 -d:`
      if [ -f $UHOME/.Xauthority ]; then
	 # echo "Enabling X-Window $UHOME/.Xauthority"
	 cp $UHOME/.Xauthority /root
      fi
   fi
   echo "Type vasm to configure the system"
else
   /sbin/echoc "You are working as $USER" green
   echo "Type vasm to configure personal settings"
fi

case `/sbin/runlevel | cut -f2 -d ' '` in
    2|3) 
    if [ -z "$DISPLAY" ] && which startx >/dev/null 2>&1; then
	echo Type startx to launch GUI system. 
    fi
    ;;
esac
