/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.peer.ScrollbarPeer;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MToolkit;

class MScrollbarPeer
extends MComponentPeer
implements ScrollbarPeer {
    private boolean inUpCall = false;
    private boolean dragInProgress = false;

    static {
        MScrollbarPeer.initIDs();
    }

    private static native void initIDs();

    protected boolean shouldFocusOnClick() {
        return true;
    }

    void drag(int n2) {
        if (!this.dragInProgress) {
            this.dragInProgress = true;
        }
        this.postAdjustmentEvent(5, n2, true);
    }

    void dragEnd(int n2) {
        Scrollbar scrollbar = (Scrollbar)this.target;
        if (!this.dragInProgress) {
            return;
        }
        this.dragInProgress = false;
        MToolkit.executeOnEventHandlerThread(scrollbar, new Runnable(this, scrollbar, n2){
            private final Scrollbar val$sb;
            private final int val$value;
            private final MScrollbarPeer this$0;

            public void run() {
                MScrollbarPeer.access$002(this.this$0, true);
                this.val$sb.setValueIsAdjusting(false);
                this.this$0.postEvent(new AdjustmentEvent(this.val$sb, 601, 5, this.val$value, false));
                MScrollbarPeer.access$002(this.this$0, false);
            }
            {
                this.this$0 = mScrollbarPeer;
                this.val$sb = scrollbar;
                this.val$value = n2;
            }
        });
    }

    void lineDown(int n2) {
        this.postAdjustmentEvent(1, n2, false);
    }

    void lineUp(int n2) {
        this.postAdjustmentEvent(2, n2, false);
    }

    void pageDown(int n2) {
        this.postAdjustmentEvent(4, n2, false);
    }

    void pageUp(int n2) {
        this.postAdjustmentEvent(3, n2, false);
    }

    public native void setLineIncrement(int var1);

    public native void setPageIncrement(int var1);

    void warp(int n2) {
        this.postAdjustmentEvent(5, n2, false);
    }

    public native void pSetValues(int var1, int var2, int var3, int var4);

    public void setValues(int n2, int n3, int n4, int n5) {
        if (!this.inUpCall) {
            this.pSetValues(n2, n3, n4, n5);
        }
    }

    private void postAdjustmentEvent(int n2, int n3, boolean bl2) {
        Scrollbar scrollbar = (Scrollbar)this.target;
        MToolkit.executeOnEventHandlerThread(scrollbar, new Runnable(this, scrollbar, bl2, n3, n2){
            private final Scrollbar val$sb;
            private final boolean val$isAdjusting;
            private final int val$value;
            private final int val$type;
            private final MScrollbarPeer this$0;

            public void run() {
                MScrollbarPeer.access$002(this.this$0, true);
                this.val$sb.setValueIsAdjusting(this.val$isAdjusting);
                this.val$sb.setValue(this.val$value);
                this.this$0.postEvent(new AdjustmentEvent(this.val$sb, 601, this.val$type, this.val$value, this.val$isAdjusting));
                MScrollbarPeer.access$002(this.this$0, false);
            }
            {
                this.this$0 = mScrollbarPeer;
                this.val$sb = scrollbar;
                this.val$isAdjusting = bl2;
                this.val$value = n2;
                this.val$type = n3;
            }
        });
    }

    public Dimension getMinimumSize() {
        if (((Scrollbar)this.target).getOrientation() == 1) {
            return new Dimension(18, 50);
        }
        return new Dimension(50, 18);
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public void print(Graphics graphics) {
        Scrollbar scrollbar = (Scrollbar)this.target;
        Dimension dimension = scrollbar.size();
        Color color = scrollbar.getBackground();
        boolean bl2 = scrollbar.getOrientation() == 0;
        this.drawScrollbar(graphics, color, bl2 ? dimension.height : dimension.width, bl2 ? dimension.width : dimension.height, scrollbar.getMinimum(), scrollbar.getMaximum(), scrollbar.getValue(), scrollbar.getVisible(), bl2);
        this.target.print(graphics);
    }

    MScrollbarPeer(Scrollbar scrollbar) {
        super(scrollbar);
    }

    native void create(MComponentPeer var1);

    static boolean access$002(MScrollbarPeer mScrollbarPeer, boolean bl2) {
        mScrollbarPeer.inUpCall = bl2;
        return mScrollbarPeer.inUpCall;
    }
}

