/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import org.apache.crimson.tree.DomEx;
import org.apache.crimson.tree.NodeBase;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class DataNode
extends NodeBase
implements CharacterData {
    char[] data;
    static NodeListImpl childNodes = new NodeListImpl();

    public int getLength() {
        return this.data == null ? 0 : this.data.length;
    }

    DataNode() {
    }

    public char[] getText() {
        return this.data;
    }

    public void deleteData(int n2, int n3) throws DOMException {
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        if (n2 < 0 || n2 >= this.data.length || n3 < 0) {
            throw new DomEx(1);
        }
        n3 = Math.min(n3, this.data.length - n2);
        char[] cArray = new char[this.data.length - n3];
        System.arraycopy(this.data, 0, cArray, 0, n2);
        System.arraycopy(this.data, n2 + n3, cArray, n2, cArray.length - n2);
        this.data = cArray;
    }

    public void setText(char[] cArray) {
        this.data = cArray;
    }

    DataNode(char[] cArray, int n2, int n3) {
        this.data = new char[n3];
        System.arraycopy(cArray, n2, this.data, 0, n3);
    }

    public String getData() {
        return this.toString();
    }

    public String getNodeValue() {
        return this.getData();
    }

    public String toString() {
        if (this.data != null) {
            return new String(this.data);
        }
        return null;
    }

    public String substringData(int n2, int n3) throws DOMException {
        if (n2 < 0 || n2 > this.data.length || n3 < 0) {
            throw new DomEx(1);
        }
        n3 = Math.min(n3, this.data.length - n2);
        return new String(this.data, n2, n3);
    }

    public void replaceData(int n2, int n3, String string) throws DOMException {
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        if (n2 < 0 || n2 >= this.data.length || n3 < 0) {
            throw new DomEx(1);
        }
        if (n2 + n3 >= this.data.length) {
            this.deleteData(n2, n3);
            this.appendData(string);
        } else if (string.length() == n3) {
            string.getChars(0, string.length(), this.data, n2);
        } else {
            char[] cArray = new char[this.data.length + (string.length() - n3)];
            System.arraycopy(this.data, 0, cArray, 0, n2);
            string.getChars(0, string.length(), cArray, n2);
            System.arraycopy(this.data, n2 + n3, cArray, n2 + string.length(), this.data.length - (n2 + n3));
            this.data = cArray;
        }
    }

    public void insertData(int n2, String string) throws DOMException {
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        if (n2 < 0 || n2 > this.data.length) {
            throw new DomEx(1);
        }
        int n3 = string.length();
        char[] cArray = new char[n3 + this.data.length];
        System.arraycopy(this.data, 0, cArray, 0, n2);
        string.getChars(0, n3, cArray, n2);
        System.arraycopy(this.data, n2, cArray, n2 + n3, this.data.length - n2);
        this.data = cArray;
    }

    DataNode(String string) {
        if (string != null) {
            this.data = new char[string.length()];
            string.getChars(0, this.data.length, this.data, 0);
        } else {
            this.data = new char[0];
        }
    }

    public void appendData(String string) {
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        int n2 = string.length();
        char[] cArray = new char[n2 + this.data.length];
        System.arraycopy(this.data, 0, cArray, 0, this.data.length);
        string.getChars(0, n2, cArray, this.data.length);
        this.data = cArray;
    }

    public void setData(String string) {
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        if (string == null) {
            this.setText(new char[0]);
        } else {
            this.setText(string.toCharArray());
        }
    }

    public void setNodeValue(String string) {
        this.setData(string);
    }

    public NodeList getChildNodes() {
        return childNodes;
    }

    static final class NodeListImpl
    implements NodeList {
        public int getLength() {
            return 0;
        }

        NodeListImpl() {
        }

        public Node item(int n2) {
            return null;
        }
    }
}

