/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class VariableHeightLayoutCache
extends AbstractLayoutCache {
    private Vector visibleNodes;
    private boolean updateNodeSizes;
    private TreeStateNode root;
    private Rectangle boundsBuffer;
    private Hashtable treePathMapping;
    private Stack tempStacks = new Stack();

    private int getMaxNodeWidth() {
        int n2 = 0;
        for (int i2 = this.getRowCount() - 1; i2 >= 0; --i2) {
            TreeStateNode treeStateNode = this.getNode(i2);
            int n3 = treeStateNode.getPreferredWidth() + treeStateNode.getXOrigin();
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    public int getPreferredHeight() {
        int n2 = this.getRowCount();
        if (n2 > 0) {
            TreeStateNode treeStateNode = this.getNode(n2 - 1);
            return treeStateNode.getYOrigin() + treeStateNode.getPreferredHeight();
        }
        return 0;
    }

    public int getRowCount() {
        return this.visibleNodes.size();
    }

    public VariableHeightLayoutCache() {
        this.visibleNodes = new Vector();
        this.boundsBuffer = new Rectangle();
        this.treePathMapping = new Hashtable();
    }

    public void invalidateSizes() {
        if (this.root != null) {
            this.root.deepMarkSizeInvalid();
        }
        if (!this.isFixedRowHeight() && this.visibleNodes.size() > 0) {
            this.updateNodeSizes(true);
        }
    }

    private void visibleNodesChanged() {
    }

    private int getRowContainingYLocation(int n2) {
        if (this.isFixedRowHeight()) {
            if (this.getRowCount() == 0) {
                return -1;
            }
            return Math.max(0, Math.min(this.getRowCount() - 1, n2 / this.getRowHeight()));
        }
        int n3 = this.getRowCount();
        if (n3 <= 0) {
            return -1;
        }
        int n4 = 0;
        int n5 = 0;
        while (n4 < n3) {
            n5 = (n3 - n4) / 2 + n4;
            TreeStateNode treeStateNode = (TreeStateNode)this.visibleNodes.elementAt(n5);
            int n6 = treeStateNode.getYOrigin();
            int n7 = n6 + treeStateNode.getPreferredHeight();
            if (n2 < n6) {
                n3 = n5 - 1;
                continue;
            }
            if (n2 < n7) break;
            n4 = n5 + 1;
        }
        if (n4 == n3 && (n5 = n4) >= this.getRowCount()) {
            n5 = this.getRowCount() - 1;
        }
        return n5;
    }

    public void setRowHeight(int n2) {
        if (n2 != this.getRowHeight()) {
            super.setRowHeight(n2);
            this.invalidateSizes();
            this.visibleNodesChanged();
        }
    }

    private void updateYLocationsFrom(int n2) {
        if (n2 >= 0 && n2 < this.getRowCount()) {
            TreeStateNode treeStateNode = this.getNode(n2);
            int n3 = treeStateNode.getYOrigin() + treeStateNode.getPreferredHeight();
            int n4 = this.visibleNodes.size();
            for (int i2 = n2 + 1; i2 < n4; ++i2) {
                treeStateNode = (TreeStateNode)this.visibleNodes.elementAt(i2);
                treeStateNode.setYOrigin(n3);
                n3 += treeStateNode.getPreferredHeight();
            }
        }
    }

    private void rebuild(boolean bl2) {
        Object object;
        this.treePathMapping.clear();
        if (this.treeModel != null && (object = this.treeModel.getRoot()) != null) {
            this.root = this.createNodeForValue(object);
            this.root.path = new TreePath(object);
            this.addMapping(this.root);
            this.root.updatePreferredSize(0);
            this.visibleNodes.removeAllElements();
            if (this.isRootVisible()) {
                this.visibleNodes.addElement(this.root);
            }
            if (!this.root.isExpanded()) {
                this.root.expand();
            } else {
                Enumeration enumeration = this.root.children();
                while (enumeration.hasMoreElements()) {
                    this.visibleNodes.addElement(enumeration.nextElement());
                }
                if (!this.isFixedRowHeight()) {
                    this.updateYLocationsFrom(0);
                }
            }
        } else {
            this.visibleNodes.removeAllElements();
            this.root = null;
        }
        if (bl2 && this.treeSelectionModel != null) {
            this.treeSelectionModel.clearSelection();
        }
        this.visibleNodesChanged();
    }

    public void setRootVisible(boolean bl2) {
        if (this.isRootVisible() != bl2 && this.root != null) {
            if (bl2) {
                this.root.updatePreferredSize(0);
                this.visibleNodes.insertElementAt(this.root, 0);
            } else if (this.visibleNodes.size() > 0) {
                this.visibleNodes.removeElementAt(0);
                if (this.treeSelectionModel != null) {
                    this.treeSelectionModel.removeSelectionPath(this.root.getTreePath());
                }
            }
            if (this.treeSelectionModel != null) {
                this.treeSelectionModel.resetRowSelection();
            }
            if (this.getRowCount() > 0) {
                this.getNode(0).setYOrigin(0);
            }
            this.updateYLocationsFrom(0);
            this.visibleNodesChanged();
        }
        super.setRootVisible(bl2);
    }

    private void updateNodeSizes(boolean bl2) {
        this.updateNodeSizes = false;
        int n2 = 0;
        int n3 = this.visibleNodes.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            TreeStateNode treeStateNode = (TreeStateNode)this.visibleNodes.elementAt(i2);
            treeStateNode.setYOrigin(n2);
            if (bl2 || !treeStateNode.hasValidSize()) {
                treeStateNode.updatePreferredSize(i2);
            }
            n2 += treeStateNode.getPreferredHeight();
        }
    }

    public int getPreferredWidth(Rectangle rectangle) {
        if (this.updateNodeSizes) {
            this.updateNodeSizes(false);
        }
        return this.getMaxNodeWidth();
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        if (treeModelEvent != null) {
            int[] nArray = treeModelEvent.getChildIndices();
            TreeStateNode treeStateNode = this.getNodeForPath(treeModelEvent.getTreePath(), false, false);
            if (treeStateNode != null) {
                int n2;
                Object object = treeStateNode.getValue();
                treeStateNode.updatePreferredSize();
                if (treeStateNode.hasBeenExpanded() && nArray != null) {
                    for (n2 = 0; n2 < nArray.length; ++n2) {
                        TreeStateNode treeStateNode2 = (TreeStateNode)treeStateNode.getChildAt(nArray[n2]);
                        treeStateNode2.setUserObject(this.treeModel.getChild(object, nArray[n2]));
                        treeStateNode2.updatePreferredSize();
                    }
                } else if (treeStateNode == this.root) {
                    treeStateNode.updatePreferredSize();
                }
                if (!this.isFixedRowHeight() && (n2 = treeStateNode.getRow()) != -1) {
                    this.updateYLocationsFrom(n2);
                }
                this.visibleNodesChanged();
            }
        }
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        if (treeModelEvent != null) {
            int[] nArray = treeModelEvent.getChildIndices();
            TreeStateNode treeStateNode = this.getNodeForPath(treeModelEvent.getTreePath(), false, false);
            if (treeStateNode != null && nArray != null && nArray.length > 0) {
                if (treeStateNode.hasBeenExpanded()) {
                    int n2 = treeStateNode.getChildCount();
                    Object object = treeStateNode.getValue();
                    boolean bl2 = treeStateNode == this.root && !this.rootVisible || treeStateNode.getRow() != -1 && treeStateNode.isExpanded();
                    for (int i2 = 0; i2 < nArray.length; ++i2) {
                        TreeStateNode treeStateNode2 = this.createNodeAt(treeStateNode, nArray[i2]);
                    }
                    if (n2 == 0) {
                        treeStateNode.updatePreferredSize();
                    }
                    if (this.treeSelectionModel != null) {
                        this.treeSelectionModel.resetRowSelection();
                    }
                    if (!this.isFixedRowHeight() && (bl2 || n2 == 0 && treeStateNode.isVisible())) {
                        if (treeStateNode == this.root) {
                            this.updateYLocationsFrom(0);
                        } else {
                            this.updateYLocationsFrom(treeStateNode.getRow());
                        }
                        this.visibleNodesChanged();
                    } else if (bl2) {
                        this.visibleNodesChanged();
                    }
                } else if (this.treeModel.getChildCount(treeStateNode.getValue()) - nArray.length == 0) {
                    treeStateNode.updatePreferredSize();
                    if (!this.isFixedRowHeight() && treeStateNode.isVisible()) {
                        this.updateYLocationsFrom(treeStateNode.getRow());
                    }
                }
            }
        }
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        if (treeModelEvent != null) {
            int[] nArray = treeModelEvent.getChildIndices();
            TreeStateNode treeStateNode = this.getNodeForPath(treeModelEvent.getTreePath(), false, false);
            if (treeStateNode != null && nArray != null && nArray.length > 0) {
                if (treeStateNode.hasBeenExpanded()) {
                    boolean bl2 = treeStateNode == this.root && !this.rootVisible || treeStateNode.getRow() != -1 && treeStateNode.isExpanded();
                    for (int i2 = nArray.length - 1; i2 >= 0; --i2) {
                        int n2;
                        TreeStateNode treeStateNode2 = (TreeStateNode)treeStateNode.getChildAt(nArray[i2]);
                        if (treeStateNode2.isExpanded()) {
                            treeStateNode2.collapse(false);
                        }
                        if (bl2 && (n2 = treeStateNode2.getRow()) != -1) {
                            this.visibleNodes.removeElementAt(n2);
                        }
                        treeStateNode.remove(nArray[i2]);
                    }
                    if (treeStateNode.getChildCount() == 0) {
                        treeStateNode.updatePreferredSize();
                        if (treeStateNode.isExpanded() && treeStateNode.isLeaf()) {
                            treeStateNode.collapse(false);
                        }
                    }
                    if (this.treeSelectionModel != null) {
                        this.treeSelectionModel.resetRowSelection();
                    }
                    if (!this.isFixedRowHeight() && (bl2 || treeStateNode.getChildCount() == 0 && treeStateNode.isVisible())) {
                        if (treeStateNode == this.root) {
                            if (this.getRowCount() > 0) {
                                this.getNode(0).setYOrigin(0);
                            }
                            this.updateYLocationsFrom(0);
                        } else {
                            this.updateYLocationsFrom(treeStateNode.getRow());
                        }
                        this.visibleNodesChanged();
                    } else if (bl2) {
                        this.visibleNodesChanged();
                    }
                } else if (this.treeModel.getChildCount(treeStateNode.getValue()) == 0) {
                    treeStateNode.updatePreferredSize();
                    if (!this.isFixedRowHeight() && treeStateNode.isVisible()) {
                        this.updateYLocationsFrom(treeStateNode.getRow());
                    }
                }
            }
        }
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        if (treeModelEvent != null) {
            TreePath treePath = treeModelEvent.getTreePath();
            TreeStateNode treeStateNode = this.getNodeForPath(treePath, false, false);
            if (treeStateNode == this.root || treeStateNode == null && (treePath == null && this.treeModel != null && this.treeModel.getRoot() == null || treePath != null && treePath.getPathCount() == 1)) {
                this.rebuild(true);
            } else if (treeStateNode != null) {
                boolean bl2 = treeStateNode.isExpanded();
                boolean bl3 = treeStateNode.getRow() != -1;
                TreeStateNode treeStateNode2 = (TreeStateNode)treeStateNode.getParent();
                int n2 = treeStateNode2.getIndex(treeStateNode);
                if (bl3 && bl2) {
                    treeStateNode.collapse(false);
                }
                if (bl3) {
                    this.visibleNodes.removeElement(treeStateNode);
                }
                treeStateNode.removeFromParent();
                this.createNodeAt(treeStateNode2, n2);
                TreeStateNode treeStateNode3 = (TreeStateNode)treeStateNode2.getChildAt(n2);
                if (bl3 && bl2) {
                    treeStateNode3.expand(false);
                }
                int n3 = treeStateNode3.getRow();
                if (!this.isFixedRowHeight() && bl3) {
                    if (n3 == 0) {
                        this.updateYLocationsFrom(n3);
                    } else {
                        this.updateYLocationsFrom(n3 - 1);
                    }
                    this.visibleNodesChanged();
                } else if (bl3) {
                    this.visibleNodesChanged();
                }
            }
        }
    }

    public void setNodeDimensions(AbstractLayoutCache.NodeDimensions nodeDimensions) {
        super.setNodeDimensions(nodeDimensions);
        this.invalidateSizes();
        this.visibleNodesChanged();
    }

    public void setModel(TreeModel treeModel) {
        super.setModel(treeModel);
        this.rebuild(false);
    }

    public TreePath getPathForRow(int n2) {
        if (n2 >= 0 && n2 < this.getRowCount()) {
            return this.getNode(n2).getTreePath();
        }
        return null;
    }

    public TreePath getPathClosestTo(int n2, int n3) {
        if (this.getRowCount() == 0) {
            return null;
        }
        if (this.updateNodeSizes) {
            this.updateNodeSizes(false);
        }
        int n4 = this.getRowContainingYLocation(n3);
        return this.getNode(n4).getTreePath();
    }

    public int getRowForPath(TreePath treePath) {
        if (treePath == null) {
            return -1;
        }
        TreeStateNode treeStateNode = this.getNodeForPath(treePath, true, false);
        if (treeStateNode != null) {
            return treeStateNode.getRow();
        }
        return -1;
    }

    public int getVisibleChildCount(TreePath treePath) {
        TreeStateNode treeStateNode = this.getNodeForPath(treePath, true, false);
        return treeStateNode != null ? treeStateNode.getVisibleChildCount() : 0;
    }

    public void invalidatePathBounds(TreePath treePath) {
        TreeStateNode treeStateNode = this.getNodeForPath(treePath, true, false);
        if (treeStateNode != null) {
            treeStateNode.markSizeInvalid();
            if (treeStateNode.isVisible()) {
                this.updateYLocationsFrom(treeStateNode.getRow());
            }
        }
    }

    public boolean getExpandedState(TreePath treePath) {
        TreeStateNode treeStateNode = this.getNodeForPath(treePath, true, false);
        return treeStateNode != null ? treeStateNode.isVisible() && treeStateNode.isExpanded() : false;
    }

    public boolean isExpanded(TreePath treePath) {
        if (treePath != null) {
            TreeStateNode treeStateNode = this.getNodeForPath(treePath, true, false);
            return treeStateNode != null && treeStateNode.isExpanded();
        }
        return false;
    }

    private void ensurePathIsExpanded(TreePath treePath, boolean bl2) {
        if (treePath != null) {
            TreeStateNode treeStateNode;
            if (this.treeModel.isLeaf(treePath.getLastPathComponent())) {
                treePath = treePath.getParentPath();
                bl2 = true;
            }
            if (treePath != null && (treeStateNode = this.getNodeForPath(treePath, false, true)) != null) {
                treeStateNode.makeVisible();
                if (bl2) {
                    treeStateNode.expand();
                }
            }
        }
    }

    public void setExpandedState(TreePath treePath, boolean bl2) {
        if (treePath != null) {
            if (bl2) {
                this.ensurePathIsExpanded(treePath, true);
            } else {
                TreeStateNode treeStateNode = this.getNodeForPath(treePath, false, true);
                if (treeStateNode != null) {
                    treeStateNode.makeVisible();
                    treeStateNode.collapse();
                }
            }
        }
    }

    static void access$700(VariableHeightLayoutCache variableHeightLayoutCache) {
        variableHeightLayoutCache.visibleNodesChanged();
    }

    static boolean access$500(VariableHeightLayoutCache variableHeightLayoutCache) {
        return variableHeightLayoutCache.updateNodeSizes;
    }

    static boolean access$502(VariableHeightLayoutCache variableHeightLayoutCache, boolean bl2) {
        variableHeightLayoutCache.updateNodeSizes = bl2;
        return variableHeightLayoutCache.updateNodeSizes;
    }

    private TreeStateNode getNode(int n2) {
        return (TreeStateNode)this.visibleNodes.elementAt(n2);
    }

    private void addMapping(TreeStateNode treeStateNode) {
        this.treePathMapping.put(treeStateNode.getTreePath(), treeStateNode);
    }

    private void removeMapping(TreeStateNode treeStateNode) {
        this.treePathMapping.remove(treeStateNode.getTreePath());
    }

    private Rectangle getBounds(int n2, Rectangle rectangle) {
        if (this.updateNodeSizes) {
            this.updateNodeSizes(false);
        }
        if (n2 >= 0 && n2 < this.getRowCount()) {
            return this.getNode(n2).getNodeBounds(rectangle);
        }
        return null;
    }

    static Rectangle access$400(VariableHeightLayoutCache variableHeightLayoutCache) {
        return variableHeightLayoutCache.boundsBuffer;
    }

    public Enumeration getVisiblePathsFrom(TreePath treePath) {
        TreeStateNode treeStateNode = this.getNodeForPath(treePath, true, false);
        if (treeStateNode != null) {
            return new VisibleTreeStateNodeEnumeration(this, treeStateNode);
        }
        return null;
    }

    static Vector access$100(VariableHeightLayoutCache variableHeightLayoutCache) {
        return variableHeightLayoutCache.visibleNodes;
    }

    private TreeStateNode createNodeForValue(Object object) {
        return new TreeStateNode(this, object);
    }

    private TreeStateNode getMapping(TreePath treePath) {
        return (TreeStateNode)this.treePathMapping.get(treePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeStateNode getNodeForPath(TreePath treePath, boolean bl2, boolean bl3) {
        if (treePath != null) {
            TreeStateNode treeStateNode = this.getMapping(treePath);
            if (treeStateNode != null) {
                if (bl2 && !treeStateNode.isVisible()) {
                    return null;
                }
                return treeStateNode;
            }
            Stack stack = this.tempStacks.size() == 0 ? new Stack() : (Stack)this.tempStacks.pop();
            try {
                stack.push(treePath);
                treeStateNode = null;
                for (treePath = treePath.getParentPath(); treePath != null; treePath = treePath.getParentPath()) {
                    treeStateNode = this.getMapping(treePath);
                    if (treeStateNode != null) {
                        while (treeStateNode != null && stack.size() > 0) {
                            treePath = (TreePath)stack.pop();
                            treeStateNode.getLoadedChildren(bl3);
                            int n2 = this.treeModel.getIndexOfChild(treeStateNode.getUserObject(), treePath.getLastPathComponent());
                            if (n2 == -1 || n2 >= treeStateNode.getChildCount() || bl2 && !treeStateNode.isVisible()) {
                                treeStateNode = null;
                                continue;
                            }
                            treeStateNode = (TreeStateNode)treeStateNode.getChildAt(n2);
                        }
                        TreeStateNode treeStateNode2 = treeStateNode;
                        return treeStateNode2;
                    }
                    stack.push(treePath);
                }
            }
            finally {
                stack.removeAllElements();
                this.tempStacks.push(stack);
            }
        }
        return null;
    }

    static TreeStateNode access$200(VariableHeightLayoutCache variableHeightLayoutCache) {
        return variableHeightLayoutCache.root;
    }

    static void access$000(VariableHeightLayoutCache variableHeightLayoutCache, TreeStateNode treeStateNode) {
        variableHeightLayoutCache.addMapping(treeStateNode);
    }

    static void access$300(VariableHeightLayoutCache variableHeightLayoutCache, TreeStateNode treeStateNode) {
        variableHeightLayoutCache.removeMapping(treeStateNode);
    }

    private TreeStateNode createNodeAt(TreeStateNode treeStateNode, int n2) {
        boolean bl2;
        Object object = this.treeModel.getChild(treeStateNode.getValue(), n2);
        TreeStateNode treeStateNode2 = this.createNodeForValue(object);
        treeStateNode.insert(treeStateNode2, n2);
        treeStateNode2.updatePreferredSize(-1);
        boolean bl3 = bl2 = treeStateNode == this.root;
        if (treeStateNode2 != null && treeStateNode.isExpanded() && (treeStateNode.getRow() != -1 || bl2)) {
            int n3;
            if (n2 == 0) {
                n3 = bl2 && !this.isRootVisible() ? 0 : treeStateNode.getRow() + 1;
            } else if (n2 == treeStateNode.getChildCount()) {
                n3 = treeStateNode.getLastVisibleNode().getRow() + 1;
            } else {
                TreeStateNode treeStateNode3 = (TreeStateNode)treeStateNode.getChildAt(n2 - 1);
                n3 = treeStateNode3.getLastVisibleNode().getRow() + 1;
            }
            this.visibleNodes.insertElementAt(treeStateNode2, n3);
        }
        return treeStateNode2;
    }

    public Rectangle getBounds(TreePath treePath, Rectangle rectangle) {
        TreeStateNode treeStateNode = this.getNodeForPath(treePath, true, false);
        if (treeStateNode != null) {
            if (this.updateNodeSizes) {
                this.updateNodeSizes(false);
            }
            return treeStateNode.getNodeBounds(rectangle);
        }
        return null;
    }

    static TreeStateNode access$600(VariableHeightLayoutCache variableHeightLayoutCache, Object object) {
        return variableHeightLayoutCache.createNodeForValue(object);
    }

    private class TreeStateNode
    extends DefaultMutableTreeNode {
        protected int preferredWidth;
        protected int preferredHeight;
        protected int xOrigin;
        protected int yOrigin;
        protected boolean expanded;
        protected boolean hasBeenExpanded;
        protected TreePath path;
        private final VariableHeightLayoutCache this$0;

        public int getModelChildCount() {
            if (this.hasBeenExpanded) {
                return super.getChildCount();
            }
            return this.this$0.getModel().getChildCount(this.getValue());
        }

        public int getPreferredHeight() {
            if (this.this$0.isFixedRowHeight()) {
                return this.this$0.getRowHeight();
            }
            if (!this.hasValidSize()) {
                this.updatePreferredSize(this.getRow());
            }
            return this.preferredHeight;
        }

        public int getPreferredWidth() {
            if (!this.hasValidSize()) {
                this.updatePreferredSize(this.getRow());
            }
            return this.preferredWidth;
        }

        public int getRow() {
            return VariableHeightLayoutCache.access$100(this.this$0).indexOf(this);
        }

        public int getVisibleChildCount() {
            int n2 = 0;
            if (this.isExpanded()) {
                int n3 = this.getChildCount();
                n2 += n3;
                for (int i2 = 0; i2 < n3; ++i2) {
                    n2 += ((TreeStateNode)this.getChildAt(i2)).getVisibleChildCount();
                }
            }
            return n2;
        }

        public int getXOrigin() {
            if (!this.hasValidSize()) {
                this.updatePreferredSize(this.getRow());
            }
            return this.xOrigin;
        }

        public int getYOrigin() {
            if (this.this$0.isFixedRowHeight()) {
                int n2 = this.getRow();
                if (n2 == -1) {
                    return -1;
                }
                return this.this$0.getRowHeight() * n2;
            }
            return this.yOrigin;
        }

        public void collapse() {
            this.collapse(true);
        }

        protected void deepMarkSizeInvalid() {
            this.markSizeInvalid();
            for (int i2 = this.getChildCount() - 1; i2 >= 0; --i2) {
                ((TreeStateNode)this.getChildAt(i2)).deepMarkSizeInvalid();
            }
        }

        protected void didAdjustTree() {
        }

        public void expand() {
            this.expand(true);
        }

        protected void expandParentAndReceiver() {
            TreeStateNode treeStateNode = (TreeStateNode)this.getParent();
            if (treeStateNode != null) {
                treeStateNode.expandParentAndReceiver();
            }
            this.expand();
        }

        public void makeVisible() {
            TreeStateNode treeStateNode = (TreeStateNode)this.getParent();
            if (treeStateNode != null) {
                treeStateNode.expandParentAndReceiver();
            }
        }

        protected void markSizeInvalid() {
            this.preferredHeight = 0;
        }

        protected void removeFromMapping() {
            if (this.path != null) {
                VariableHeightLayoutCache.access$300(this.this$0, this);
                for (int i2 = this.getChildCount() - 1; i2 >= 0; --i2) {
                    ((TreeStateNode)this.getChildAt(i2)).removeFromMapping();
                }
            }
        }

        public void toggleExpanded() {
            if (this.isExpanded()) {
                this.collapse();
            } else {
                this.expand();
            }
        }

        protected void updatePreferredSize() {
            this.updatePreferredSize(this.getRow());
        }

        public boolean hasBeenExpanded() {
            return this.hasBeenExpanded;
        }

        public boolean hasValidSize() {
            return this.preferredHeight != 0;
        }

        public boolean isExpanded() {
            return this.expanded;
        }

        public boolean isLeaf() {
            return this.this$0.getModel().isLeaf(this.getValue());
        }

        public boolean isVisible() {
            if (this == VariableHeightLayoutCache.access$200(this.this$0)) {
                return true;
            }
            TreeStateNode treeStateNode = (TreeStateNode)this.getParent();
            return treeStateNode != null && treeStateNode.isExpanded() && treeStateNode.isVisible();
        }

        public void remove(int n2) {
            TreeStateNode treeStateNode = (TreeStateNode)this.getChildAt(n2);
            treeStateNode.removeFromMapping();
            super.remove(n2);
        }

        protected void setYOrigin(int n2) {
            this.yOrigin = n2;
        }

        protected void shiftYOriginBy(int n2) {
            this.yOrigin += n2;
        }

        protected void updatePreferredSize(int n2) {
            Rectangle rectangle = this.this$0.getNodeDimensions(this.getUserObject(), n2, this.getLevel(), this.isExpanded(), VariableHeightLayoutCache.access$400(this.this$0));
            if (rectangle == null) {
                this.xOrigin = 0;
                this.preferredHeight = 0;
                this.preferredWidth = 0;
                VariableHeightLayoutCache.access$502(this.this$0, true);
            } else if (rectangle.height == 0) {
                this.xOrigin = 0;
                this.preferredHeight = 0;
                this.preferredWidth = 0;
                VariableHeightLayoutCache.access$502(this.this$0, true);
            } else {
                this.xOrigin = rectangle.x;
                this.preferredWidth = rectangle.width;
                this.preferredHeight = this.this$0.isFixedRowHeight() ? this.this$0.getRowHeight() : rectangle.height;
            }
        }

        protected void collapse(boolean bl2) {
            if (this.isExpanded()) {
                int n2;
                TreeStateNode treeStateNode;
                Enumeration enumeration = this.preorderEnumeration();
                enumeration.nextElement();
                int n3 = 0;
                boolean bl3 = this.this$0.isFixedRowHeight();
                int n4 = bl3 ? 0 : this.getPreferredHeight() + this.getYOrigin();
                int n5 = this.getPreferredHeight();
                int n6 = n4;
                int n7 = this.getRow();
                if (!bl3) {
                    while (enumeration.hasMoreElements()) {
                        treeStateNode = (TreeStateNode)enumeration.nextElement();
                        if (!treeStateNode.isVisible()) continue;
                        ++n3;
                        n4 = treeStateNode.getYOrigin() + treeStateNode.getPreferredHeight();
                    }
                } else {
                    while (enumeration.hasMoreElements()) {
                        treeStateNode = (TreeStateNode)enumeration.nextElement();
                        if (!treeStateNode.isVisible()) continue;
                        ++n3;
                    }
                }
                for (n2 = n3 + n7; n2 > n7; --n2) {
                    VariableHeightLayoutCache.access$100(this.this$0).removeElementAt(n2);
                }
                this.expanded = false;
                if (n7 == -1) {
                    this.markSizeInvalid();
                } else if (bl2) {
                    this.updatePreferredSize(n7);
                }
                if (n7 != -1 && bl2 && (n3 > 0 || n5 != this.getPreferredHeight())) {
                    if (!bl3 && n7 + 1 < this.this$0.getRowCount() && (n6 += this.getPreferredHeight() - n5) != n4) {
                        int n8 = n6 - n4;
                        int n9 = VariableHeightLayoutCache.access$100(this.this$0).size();
                        for (n2 = n7 + 1; n2 < n9; ++n2) {
                            ((TreeStateNode)VariableHeightLayoutCache.access$100(this.this$0).elementAt(n2)).shiftYOriginBy(n8);
                        }
                    }
                    this.didAdjustTree();
                    VariableHeightLayoutCache.access$700(this.this$0);
                }
                if (this.this$0.treeSelectionModel != null && n3 > 0 && n7 != -1) {
                    this.this$0.treeSelectionModel.resetRowSelection();
                }
            }
        }

        protected void expand(boolean bl2) {
            if (!this.isExpanded() && !this.isLeaf()) {
                int n2;
                int n3;
                Object object;
                boolean bl3 = this.this$0.isFixedRowHeight();
                int n4 = this.getPreferredHeight();
                int n5 = this.getRow();
                this.expanded = true;
                this.updatePreferredSize(n5);
                if (!this.hasBeenExpanded) {
                    TreeStateNode treeStateNode;
                    object = this.getValue();
                    TreeModel treeModel = this.this$0.getModel();
                    int n6 = treeModel.getChildCount(object);
                    this.hasBeenExpanded = true;
                    if (n5 == -1) {
                        for (n3 = 0; n3 < n6; ++n3) {
                            treeStateNode = VariableHeightLayoutCache.access$600(this.this$0, treeModel.getChild(object, n3));
                            this.add(treeStateNode);
                            treeStateNode.updatePreferredSize(-1);
                        }
                    } else {
                        n3 = n5 + 1;
                        for (n2 = 0; n2 < n6; ++n2) {
                            treeStateNode = VariableHeightLayoutCache.access$600(this.this$0, treeModel.getChild(object, n2));
                            this.add(treeStateNode);
                            treeStateNode.updatePreferredSize(n3);
                        }
                    }
                }
                int n7 = n5;
                object = this.preorderEnumeration();
                object.nextElement();
                int n8 = bl3 ? 0 : (this == VariableHeightLayoutCache.access$200(this.this$0) && !this.this$0.isRootVisible() ? 0 : this.getYOrigin() + this.getPreferredHeight());
                if (!bl3) {
                    while (object.hasMoreElements()) {
                        TreeStateNode treeStateNode = (TreeStateNode)object.nextElement();
                        if (!VariableHeightLayoutCache.access$500(this.this$0) && !treeStateNode.hasValidSize()) {
                            treeStateNode.updatePreferredSize(n7 + 1);
                        }
                        treeStateNode.setYOrigin(n8);
                        n8 += treeStateNode.getPreferredHeight();
                        VariableHeightLayoutCache.access$100(this.this$0).insertElementAt(treeStateNode, ++n7);
                    }
                } else {
                    while (object.hasMoreElements()) {
                        TreeStateNode treeStateNode = (TreeStateNode)object.nextElement();
                        VariableHeightLayoutCache.access$100(this.this$0).insertElementAt(treeStateNode, ++n7);
                    }
                }
                if (bl2 && (n5 != n7 || this.getPreferredHeight() != n4)) {
                    if (!bl3 && ++n7 < this.this$0.getRowCount()) {
                        n2 = n8 - (this.getYOrigin() + this.getPreferredHeight()) + (this.getPreferredHeight() - n4);
                        for (n3 = VariableHeightLayoutCache.access$100(this.this$0).size() - 1; n3 >= n7; --n3) {
                            ((TreeStateNode)VariableHeightLayoutCache.access$100(this.this$0).elementAt(n3)).shiftYOriginBy(n2);
                        }
                    }
                    this.didAdjustTree();
                    VariableHeightLayoutCache.access$700(this.this$0);
                }
                if (this.this$0.treeSelectionModel != null) {
                    this.this$0.treeSelectionModel.resetRowSelection();
                }
            }
        }

        public Object getValue() {
            return this.getUserObject();
        }

        public void setUserObject(Object object) {
            super.setUserObject(object);
            if (this.path != null) {
                TreeStateNode treeStateNode = (TreeStateNode)this.getParent();
                if (treeStateNode != null) {
                    this.resetChildrenPaths(treeStateNode.getTreePath());
                } else {
                    this.resetChildrenPaths(null);
                }
            }
        }

        public Enumeration children() {
            if (!this.isExpanded()) {
                return DefaultMutableTreeNode.EMPTY_ENUMERATION;
            }
            return super.children();
        }

        protected Enumeration getLoadedChildren(boolean bl2) {
            if (!bl2 || this.hasBeenExpanded) {
                return super.children();
            }
            Object object = this.getValue();
            TreeModel treeModel = this.this$0.getModel();
            int n2 = treeModel.getChildCount(object);
            this.hasBeenExpanded = true;
            int n3 = this.getRow();
            if (n3 == -1) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    TreeStateNode treeStateNode = VariableHeightLayoutCache.access$600(this.this$0, treeModel.getChild(object, i2));
                    this.add(treeStateNode);
                    treeStateNode.updatePreferredSize(-1);
                }
            } else {
                ++n3;
                for (int i3 = 0; i3 < n2; ++i3) {
                    TreeStateNode treeStateNode = VariableHeightLayoutCache.access$600(this.this$0, treeModel.getChild(object, i3));
                    this.add(treeStateNode);
                    treeStateNode.updatePreferredSize(n3++);
                }
            }
            return super.children();
        }

        public void setParent(MutableTreeNode mutableTreeNode) {
            super.setParent(mutableTreeNode);
            if (mutableTreeNode != null) {
                this.path = ((TreeStateNode)mutableTreeNode).getTreePath().pathByAddingChild(this.getUserObject());
                VariableHeightLayoutCache.access$000(this.this$0, this);
            }
        }

        public TreePath getTreePath() {
            return this.path;
        }

        protected void resetChildrenPaths(TreePath treePath) {
            VariableHeightLayoutCache.access$300(this.this$0, this);
            this.path = treePath == null ? new TreePath(this.getUserObject()) : treePath.pathByAddingChild(this.getUserObject());
            VariableHeightLayoutCache.access$000(this.this$0, this);
            for (int i2 = this.getChildCount() - 1; i2 >= 0; --i2) {
                ((TreeStateNode)this.getChildAt(i2)).resetChildrenPaths(this.path);
            }
        }

        public TreeStateNode getLastVisibleNode() {
            TreeStateNode treeStateNode = this;
            while (treeStateNode.isExpanded() && treeStateNode.getChildCount() > 0) {
                treeStateNode = (TreeStateNode)treeStateNode.getLastChild();
            }
            return treeStateNode;
        }

        public Rectangle getNodeBounds(Rectangle rectangle) {
            if (rectangle == null) {
                rectangle = new Rectangle(this.getXOrigin(), this.getYOrigin(), this.getPreferredWidth(), this.getPreferredHeight());
            } else {
                rectangle.x = this.getXOrigin();
                rectangle.y = this.getYOrigin();
                rectangle.width = this.getPreferredWidth();
                rectangle.height = this.getPreferredHeight();
            }
            return rectangle;
        }

        public TreeStateNode(VariableHeightLayoutCache variableHeightLayoutCache, Object object) {
            this.this$0 = variableHeightLayoutCache;
            super(object);
        }
    }

    private class VisibleTreeStateNodeEnumeration
    implements Enumeration {
        protected TreeStateNode parent;
        protected int nextIndex;
        protected int childCount;
        private final VariableHeightLayoutCache this$0;

        protected void updateNextObject() {
            if (!this.updateNextIndex()) {
                this.findNextValidParent();
            }
        }

        protected boolean findNextValidParent() {
            if (this.parent == VariableHeightLayoutCache.access$200(this.this$0)) {
                this.parent = null;
                return false;
            }
            while (this.parent != null) {
                TreeStateNode treeStateNode = (TreeStateNode)this.parent.getParent();
                if (treeStateNode != null) {
                    this.nextIndex = treeStateNode.getIndex(this.parent);
                    this.parent = treeStateNode;
                    this.childCount = this.parent.getChildCount();
                    if (!this.updateNextIndex()) continue;
                    return true;
                }
                this.parent = null;
            }
            return false;
        }

        public boolean hasMoreElements() {
            return this.parent != null;
        }

        protected boolean updateNextIndex() {
            if (this.nextIndex == -1 && !this.parent.isExpanded()) {
                return false;
            }
            if (this.childCount == 0) {
                return false;
            }
            if (++this.nextIndex >= this.childCount) {
                return false;
            }
            TreeStateNode treeStateNode = (TreeStateNode)this.parent.getChildAt(this.nextIndex);
            if (treeStateNode != null && treeStateNode.isExpanded()) {
                this.parent = treeStateNode;
                this.nextIndex = -1;
                this.childCount = treeStateNode.getChildCount();
            }
            return true;
        }

        public Object nextElement() {
            TreePath treePath;
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException("No more visible paths");
            }
            if (this.nextIndex == -1) {
                treePath = this.parent.getTreePath();
            } else {
                TreeStateNode treeStateNode = (TreeStateNode)this.parent.getChildAt(this.nextIndex);
                treePath = treeStateNode.getTreePath();
            }
            this.updateNextObject();
            return treePath;
        }

        protected VisibleTreeStateNodeEnumeration(VariableHeightLayoutCache variableHeightLayoutCache, TreeStateNode treeStateNode) {
            this(variableHeightLayoutCache, treeStateNode, -1);
        }

        protected VisibleTreeStateNodeEnumeration(VariableHeightLayoutCache variableHeightLayoutCache, TreeStateNode treeStateNode, int n2) {
            this.this$0 = variableHeightLayoutCache;
            this.parent = treeStateNode;
            this.nextIndex = n2;
            this.childCount = this.parent.getChildCount();
        }
    }
}

