/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import javax.swing.plaf.metal.MetalBumps;
import javax.swing.plaf.metal.MetalScrollButton;
import javax.swing.plaf.metal.MetalUtils;

public class MetalScrollBarUI
extends BasicScrollBarUI {
    private static Color shadowColor;
    private static Color highlightColor;
    private static Color darkShadowColor;
    private static Color thumbColor;
    private static Color thumbShadow;
    private static Color thumbHighlightColor;
    protected MetalBumps bumps;
    protected MetalScrollButton increaseButton;
    protected MetalScrollButton decreaseButton;
    protected int scrollBarWidth;
    public static final String FREE_STANDING_PROP = "JScrollBar.isFreeStanding";
    protected boolean isFreeStanding = true;

    protected void configureScrollBarColors() {
        super.configureScrollBarColors();
        shadowColor = UIManager.getColor("ScrollBar.shadow");
        highlightColor = UIManager.getColor("ScrollBar.highlight");
        darkShadowColor = UIManager.getColor("ScrollBar.darkShadow");
        thumbColor = UIManager.getColor("ScrollBar.thumb");
        thumbShadow = UIManager.getColor("ScrollBar.thumbShadow");
        thumbHighlightColor = UIManager.getColor("ScrollBar.thumbHighlight");
    }

    protected void installDefaults() {
        this.scrollBarWidth = (Integer)UIManager.get("ScrollBar.width");
        super.installDefaults();
        this.bumps = new MetalBumps(10, 10, thumbHighlightColor, thumbShadow, thumbColor);
    }

    protected void installListeners() {
        super.installListeners();
        ((ScrollBarListener)this.propertyChangeListener).handlePropertyChange(this.scrollbar.getClientProperty(FREE_STANDING_PROP));
    }

    protected void setThumbBounds(int n2, int n3, int n4, int n5) {
        if (this.thumbRect.x == n2 && this.thumbRect.y == n3 && this.thumbRect.width == n4 && this.thumbRect.height == n5) {
            return;
        }
        int n6 = Math.min(n2, this.thumbRect.x);
        int n7 = Math.min(n3, this.thumbRect.y);
        int n8 = Math.max(n2 + n4, this.thumbRect.x + this.thumbRect.width);
        int n9 = Math.max(n3 + n5, this.thumbRect.y + this.thumbRect.height);
        this.thumbRect.setBounds(n2, n3, n4, n5);
        this.scrollbar.repaint(n6, n7, n8 - n6 + 1, n9 - n7 + 1);
    }

    protected Dimension getMinimumThumbSize() {
        return new Dimension(this.scrollBarWidth, this.scrollBarWidth);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new ScrollBarListener(this);
    }

    protected JButton createDecreaseButton(int n2) {
        this.decreaseButton = new MetalScrollButton(n2, this.scrollBarWidth, this.isFreeStanding);
        return this.decreaseButton;
    }

    protected JButton createIncreaseButton(int n2) {
        this.increaseButton = new MetalScrollButton(n2, this.scrollBarWidth, this.isFreeStanding);
        return this.increaseButton;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if (this.scrollbar.getOrientation() == 1) {
            return new Dimension(this.scrollBarWidth, this.scrollBarWidth * 3 + 10);
        }
        return new Dimension(this.scrollBarWidth * 3 + 10, this.scrollBarWidth);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalScrollBarUI();
    }

    protected void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        if (!jComponent.isEnabled()) {
            return;
        }
        boolean bl2 = MetalUtils.isLeftToRight(jComponent);
        graphics.translate(rectangle.x, rectangle.y);
        if (this.scrollbar.getOrientation() == 1) {
            if (!this.isFreeStanding) {
                if (!bl2) {
                    ++rectangle.width;
                    graphics.translate(-1, 0);
                } else {
                    rectangle.width += 2;
                }
            }
            graphics.setColor(thumbColor);
            graphics.fillRect(0, 0, rectangle.width - 2, rectangle.height - 1);
            graphics.setColor(thumbShadow);
            graphics.drawRect(0, 0, rectangle.width - 2, rectangle.height - 1);
            graphics.setColor(thumbHighlightColor);
            graphics.drawLine(1, 1, rectangle.width - 3, 1);
            graphics.drawLine(1, 1, 1, rectangle.height - 2);
            this.bumps.setBumpArea(rectangle.width - 6, rectangle.height - 7);
            this.bumps.paintIcon(jComponent, graphics, 3, 4);
            if (!this.isFreeStanding) {
                if (!bl2) {
                    --rectangle.width;
                    graphics.translate(1, 0);
                } else {
                    rectangle.width -= 2;
                }
            }
        } else {
            if (!this.isFreeStanding) {
                rectangle.height += 2;
            }
            graphics.setColor(thumbColor);
            graphics.fillRect(0, 0, rectangle.width - 1, rectangle.height - 2);
            graphics.setColor(thumbShadow);
            graphics.drawRect(0, 0, rectangle.width - 1, rectangle.height - 2);
            graphics.setColor(thumbHighlightColor);
            graphics.drawLine(1, 1, rectangle.width - 3, 1);
            graphics.drawLine(1, 1, 1, rectangle.height - 3);
            this.bumps.setBumpArea(rectangle.width - 7, rectangle.height - 6);
            this.bumps.paintIcon(jComponent, graphics, 4, 3);
            if (!this.isFreeStanding) {
                rectangle.height -= 2;
            }
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    protected void paintTrack(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        graphics.translate(rectangle.x, rectangle.y);
        boolean bl2 = MetalUtils.isLeftToRight(jComponent);
        if (this.scrollbar.getOrientation() == 1) {
            if (!this.isFreeStanding) {
                if (!bl2) {
                    ++rectangle.width;
                    graphics.translate(-1, 0);
                } else {
                    rectangle.width += 2;
                }
            }
            if (jComponent.isEnabled()) {
                graphics.setColor(darkShadowColor);
                graphics.drawLine(0, 0, 0, rectangle.height - 1);
                graphics.drawLine(rectangle.width - 2, 0, rectangle.width - 2, rectangle.height - 1);
                graphics.drawLine(2, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
                graphics.drawLine(2, 0, rectangle.width - 2, 0);
                graphics.setColor(shadowColor);
                graphics.drawLine(1, 1, 1, rectangle.height - 2);
                graphics.drawLine(1, 1, rectangle.width - 3, 1);
                if (this.scrollbar.getValue() != this.scrollbar.getMaximum()) {
                    int n2 = this.thumbRect.y + this.thumbRect.height - rectangle.y;
                    graphics.drawLine(1, n2, rectangle.width - 1, n2);
                }
                graphics.setColor(highlightColor);
                graphics.drawLine(rectangle.width - 1, 0, rectangle.width - 1, rectangle.height - 1);
            } else {
                MetalUtils.drawDisabledBorder(graphics, 0, 0, rectangle.width, rectangle.height);
            }
            if (!this.isFreeStanding) {
                if (!bl2) {
                    --rectangle.width;
                    graphics.translate(1, 0);
                } else {
                    rectangle.width -= 2;
                }
            }
        } else {
            if (!this.isFreeStanding) {
                rectangle.height += 2;
            }
            if (jComponent.isEnabled()) {
                graphics.setColor(darkShadowColor);
                graphics.drawLine(0, 0, rectangle.width - 1, 0);
                graphics.drawLine(0, 2, 0, rectangle.height - 2);
                graphics.drawLine(0, rectangle.height - 2, rectangle.width - 1, rectangle.height - 2);
                graphics.drawLine(rectangle.width - 1, 2, rectangle.width - 1, rectangle.height - 1);
                graphics.setColor(shadowColor);
                graphics.drawLine(1, 1, rectangle.width - 2, 1);
                graphics.drawLine(1, 1, 1, rectangle.height - 3);
                graphics.drawLine(0, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
                if (this.scrollbar.getValue() != this.scrollbar.getMaximum()) {
                    int n3 = this.thumbRect.x + this.thumbRect.width - rectangle.x;
                    graphics.drawLine(n3, 1, n3, rectangle.height - 1);
                }
            } else {
                MetalUtils.drawDisabledBorder(graphics, 0, 0, rectangle.width, rectangle.height);
            }
            if (!this.isFreeStanding) {
                rectangle.height -= 2;
            }
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    class ScrollBarListener
    extends BasicScrollBarUI.PropertyChangeHandler {
        private final MetalScrollBarUI this$0;

        protected void toFlush() {
            this.this$0.scrollBarWidth -= 2;
        }

        protected void toFreeStanding() {
            this.this$0.scrollBarWidth += 2;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals(MetalScrollBarUI.FREE_STANDING_PROP)) {
                this.handlePropertyChange(propertyChangeEvent.getNewValue());
            } else {
                super.propertyChange(propertyChangeEvent);
            }
        }

        public void handlePropertyChange(Object object) {
            if (object != null) {
                boolean bl2 = (Boolean)object;
                boolean bl3 = !bl2 && this.this$0.isFreeStanding;
                boolean bl4 = bl2 && !this.this$0.isFreeStanding;
                this.this$0.isFreeStanding = bl2;
                if (bl3) {
                    this.toFlush();
                } else if (bl4) {
                    this.toFreeStanding();
                }
            } else if (!this.this$0.isFreeStanding) {
                this.this$0.isFreeStanding = true;
                this.toFreeStanding();
            }
            if (this.this$0.increaseButton != null) {
                this.this$0.increaseButton.setFreeStanding(this.this$0.isFreeStanding);
            }
            if (this.this$0.decreaseButton != null) {
                this.this$0.decreaseButton.setFreeStanding(this.this$0.isFreeStanding);
            }
        }

        ScrollBarListener(MetalScrollBarUI metalScrollBarUI) {
            this.this$0 = metalScrollBarUI;
            super(metalScrollBarUI);
        }
    }
}

