/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractSpinnerModel;

public class SpinnerListModel
extends AbstractSpinnerModel
implements Serializable {
    private List list;
    private int index;

    public SpinnerListModel() {
        this(new Object[]{"empty"});
    }

    public Object getNextValue() {
        return this.index >= this.list.size() - 1 ? null : this.list.get(this.index + 1);
    }

    public Object getPreviousValue() {
        return this.index <= 0 ? null : this.list.get(this.index - 1);
    }

    public Object getValue() {
        return this.list.get(this.index);
    }

    public void setValue(Object object) {
        int n2 = this.list.indexOf(object);
        if (n2 == -1) {
            throw new IllegalArgumentException("invalid sequence element");
        }
        if (n2 != this.index) {
            this.index = n2;
            this.fireStateChanged();
        }
    }

    public SpinnerListModel(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            throw new IllegalArgumentException("SpinnerListModel(Object[]) expects non-null non-empty Object[]");
        }
        this.list = Arrays.asList(objectArray);
        this.index = 0;
    }

    public List getList() {
        return this.list;
    }

    public SpinnerListModel(List list) {
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("SpinnerListModel(List) expects non-null non-empty List");
        }
        this.list = list;
        this.index = 0;
    }

    public void setList(List list) {
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("invalid list");
        }
        if (!((Object)list).equals(this.list)) {
            this.list = list;
            this.index = 0;
            this.fireStateChanged();
        }
    }

    Object findNextMatch(String string) {
        int n2 = this.list.size();
        if (n2 == 0) {
            return null;
        }
        int n3 = this.index;
        do {
            Object object;
            String string2;
            if ((string2 = (object = this.list.get(n3)).toString()) == null || !string2.startsWith(string)) continue;
            return object;
        } while ((n3 = (n3 + 1) % n2) != this.index);
        return null;
    }
}

