/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Graphics;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.Format;
import java.text.NumberFormat;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ProgressBarUI;

public class JProgressBar
extends JComponent
implements SwingConstants,
Accessible {
    private static final String uiClassID = "ProgressBarUI";
    protected int orientation;
    protected boolean paintBorder;
    protected BoundedRangeModel model;
    protected String progressString;
    protected boolean paintString;
    private static final int defaultMinimum = 0;
    private static final int defaultMaximum = 100;
    private static final int defaultOrientation = 0;
    protected transient ChangeEvent changeEvent = null;
    protected ChangeListener changeListener = null;
    private transient Format format;
    private boolean indeterminate;
    static Class class$javax$swing$event$ChangeListener;

    public double getPercentComplete() {
        long l2 = this.model.getMaximum() - this.model.getMinimum();
        double d2 = this.model.getValue();
        double d3 = (d2 - (double)this.model.getMinimum()) / (double)l2;
        return d3;
    }

    public int getMaximum() {
        return this.getModel().getMaximum();
    }

    public int getMinimum() {
        return this.getModel().getMinimum();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int getValue() {
        return this.getModel().getValue();
    }

    public JProgressBar() {
        this(0);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != (class$javax$swing$event$ChangeListener == null ? JProgressBar.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i2 + 1]).stateChanged(this.changeEvent);
        }
    }

    public void updateUI() {
        this.setUI((ProgressBarUI)UIManager.getUI(this));
    }

    public boolean isBorderPainted() {
        return this.paintBorder;
    }

    public boolean isIndeterminate() {
        return this.indeterminate;
    }

    public boolean isStringPainted() {
        return this.paintString;
    }

    public JProgressBar(int n2) {
        this(n2, 0, 100);
    }

    public void setMaximum(int n2) {
        this.getModel().setMaximum(n2);
    }

    public void setMinimum(int n2) {
        this.getModel().setMinimum(n2);
    }

    public void setOrientation(int n2) {
        if (this.orientation != n2) {
            switch (n2) {
                case 0: 
                case 1: {
                    int n3 = this.orientation;
                    this.orientation = n2;
                    this.firePropertyChange("orientation", n3, n2);
                    if (this.accessibleContext == null) break;
                    this.accessibleContext.firePropertyChange("AccessibleState", n3 == 1 ? AccessibleState.VERTICAL : AccessibleState.HORIZONTAL, this.orientation == 1 ? AccessibleState.VERTICAL : AccessibleState.HORIZONTAL);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(n2 + " is not a legal orientation");
                }
            }
            this.revalidate();
        }
    }

    public void setValue(int n2) {
        BoundedRangeModel boundedRangeModel = this.getModel();
        int n3 = boundedRangeModel.getValue();
        boundedRangeModel.setValue(n2);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleValue", new Integer(n3), new Integer(boundedRangeModel.getValue()));
        }
    }

    public JProgressBar(int n2, int n3) {
        this(0, n2, n3);
    }

    public JProgressBar(int n2, int n3, int n4) {
        this.setModel(new DefaultBoundedRangeModel(n3, 0, n3, n4));
        this.updateUI();
        this.setOrientation(n2);
        this.setBorderPainted(true);
        this.setStringPainted(false);
        this.setString(null);
        this.setIndeterminate(false);
    }

    public void setBorderPainted(boolean bl2) {
        boolean bl3 = this.paintBorder;
        this.paintBorder = bl2;
        this.firePropertyChange("borderPainted", bl3, this.paintBorder);
        if (this.paintBorder != bl3) {
            this.repaint();
        }
    }

    public void setIndeterminate(boolean bl2) {
        boolean bl3 = this.indeterminate;
        this.indeterminate = bl2;
        this.firePropertyChange("indeterminate", bl3, this.indeterminate);
    }

    public void setStringPainted(boolean bl2) {
        boolean bl3 = this.paintString;
        this.paintString = bl2;
        this.firePropertyChange("stringPainted", bl3, this.paintString);
        if (this.paintString != bl3) {
            this.revalidate();
            this.repaint();
        }
    }

    protected void paintBorder(Graphics graphics) {
        if (this.isBorderPainted()) {
            super.paintBorder(graphics);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    public String getString() {
        if (this.progressString != null) {
            return this.progressString;
        }
        if (this.format == null) {
            this.format = NumberFormat.getPercentInstance();
        }
        return this.format.format(new Double(this.getPercentComplete()));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected String paramString() {
        String string = this.orientation == 0 ? "HORIZONTAL" : "VERTICAL";
        String string2 = this.paintBorder ? "true" : "false";
        String string3 = this.progressString != null ? this.progressString : "";
        String string4 = this.paintString ? "true" : "false";
        String string5 = this.indeterminate ? "true" : "false";
        return super.paramString() + ",orientation=" + string + ",paintBorder=" + string2 + ",paintString=" + string4 + ",progressString=" + string3 + ",indeterminateString=" + string5;
    }

    public void setString(String string) {
        String string2 = this.progressString;
        this.progressString = string;
        this.firePropertyChange("string", string2, this.progressString);
        if (this.progressString == null || string2 == null || !this.progressString.equals(string2)) {
            this.repaint();
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJProgressBar(this);
        }
        return this.accessibleContext;
    }

    public BoundedRangeModel getModel() {
        return this.model;
    }

    public JProgressBar(BoundedRangeModel boundedRangeModel) {
        this.setModel(boundedRangeModel);
        this.updateUI();
        this.setOrientation(0);
        this.setBorderPainted(true);
        this.setStringPainted(false);
        this.setString(null);
        this.setIndeterminate(false);
    }

    public void setModel(BoundedRangeModel boundedRangeModel) {
        BoundedRangeModel boundedRangeModel2 = this.getModel();
        if (boundedRangeModel != boundedRangeModel2) {
            if (boundedRangeModel2 != null) {
                boundedRangeModel2.removeChangeListener(this.changeListener);
                this.changeListener = null;
            }
            this.model = boundedRangeModel;
            if (boundedRangeModel != null) {
                this.changeListener = this.createChangeListener();
                boundedRangeModel.addChangeListener(this.changeListener);
            }
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleValue", boundedRangeModel2 == null ? null : new Integer(boundedRangeModel2.getValue()), boundedRangeModel == null ? null : new Integer(boundedRangeModel.getValue()));
            }
            if (this.model != null) {
                this.model.setExtent(0);
            }
            this.repaint();
        }
    }

    protected ChangeListener createChangeListener() {
        return new ModelListener(this, null);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = JProgressBar.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = JProgressBar.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = JProgressBar.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public ProgressBarUI getUI() {
        return (ProgressBarUI)this.ui;
    }

    public void setUI(ProgressBarUI progressBarUI) {
        super.setUI(progressBarUI);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static class 1 {
    }

    protected class AccessibleJProgressBar
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        private final JProgressBar this$0;

        public Number getCurrentAccessibleValue() {
            return new Integer(this.this$0.getValue());
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(this.this$0.getMaximum());
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(this.this$0.getMinimum());
        }

        public boolean setCurrentAccessibleValue(Number number) {
            if (number instanceof Integer) {
                this.this$0.setValue(number.intValue());
                return true;
            }
            return false;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PROGRESS_BAR;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (this.this$0.getModel().getValueIsAdjusting()) {
                accessibleStateSet.add(AccessibleState.BUSY);
            }
            if (this.this$0.getOrientation() == 1) {
                accessibleStateSet.add(AccessibleState.VERTICAL);
            } else {
                accessibleStateSet.add(AccessibleState.HORIZONTAL);
            }
            return accessibleStateSet;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        protected AccessibleJProgressBar(JProgressBar jProgressBar) {
            this.this$0 = jProgressBar;
            super(jProgressBar);
        }
    }

    private class ModelListener
    implements ChangeListener,
    Serializable {
        private final JProgressBar this$0;

        private ModelListener(JProgressBar jProgressBar) {
            this.this$0 = jProgressBar;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.this$0.fireStateChanged();
        }

        ModelListener(JProgressBar jProgressBar, 1 var2_2) {
            this(jProgressBar);
        }
    }
}

