/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.WindowEvent;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.WindowConstants;

public class JDialog
extends Dialog
implements WindowConstants,
Accessible,
RootPaneContainer {
    private static final Object defaultLookAndFeelDecoratedKey = new StringBuffer("JDialog.defaultLookAndFeelDecorated");
    private int defaultCloseOperation = 1;
    protected JRootPane rootPane;
    protected boolean rootPaneCheckingEnabled = false;
    protected AccessibleContext accessibleContext = null;

    public int getDefaultCloseOperation() {
        return this.defaultCloseOperation;
    }

    public JDialog() throws HeadlessException {
        this((Frame)null, false);
    }

    protected void dialogInit() {
        boolean bl2;
        this.enableEvents(72L);
        this.setLocale(JComponent.getDefaultLocale());
        this.setRootPane(this.createRootPane());
        this.setRootPaneCheckingEnabled(true);
        if (JDialog.isDefaultLookAndFeelDecorated() && (bl2 = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            this.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(2);
        }
        this.setFocusTraversalPolicy(KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalPolicy());
    }

    public static boolean isDefaultLookAndFeelDecorated() {
        Boolean bl2 = (Boolean)SwingUtilities.appContextGet(defaultLookAndFeelDecoratedKey);
        if (bl2 == null) {
            bl2 = Boolean.FALSE;
        }
        return bl2;
    }

    protected boolean isRootPaneCheckingEnabled() {
        return this.rootPaneCheckingEnabled;
    }

    public void setDefaultCloseOperation(int n2) {
        this.defaultCloseOperation = n2;
    }

    public static void setDefaultLookAndFeelDecorated(boolean bl2) {
        if (bl2) {
            SwingUtilities.appContextPut(defaultLookAndFeelDecoratedKey, Boolean.TRUE);
        } else {
            SwingUtilities.appContextPut(defaultLookAndFeelDecoratedKey, Boolean.FALSE);
        }
    }

    protected void setRootPaneCheckingEnabled(boolean bl2) {
        this.rootPaneCheckingEnabled = bl2;
    }

    public Component getGlassPane() {
        return this.getRootPane().getGlassPane();
    }

    public void remove(Component component) {
        if (component == this.rootPane) {
            super.remove(component);
        } else {
            this.getContentPane().remove(component);
        }
    }

    public void setGlassPane(Component component) {
        this.getRootPane().setGlassPane(component);
    }

    public Container getContentPane() {
        return this.getRootPane().getContentPane();
    }

    public void setContentPane(Container container) {
        this.getRootPane().setContentPane(container);
    }

    public JDialog(Dialog dialog) throws HeadlessException {
        this(dialog, false);
    }

    public JDialog(Dialog dialog, boolean bl2) throws HeadlessException {
        this(dialog, null, bl2);
    }

    public JDialog(Frame frame) throws HeadlessException {
        this(frame, false);
    }

    public JDialog(Frame frame, boolean bl2) throws HeadlessException {
        this(frame, null, bl2);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void setLayout(LayoutManager layoutManager) {
        if (this.isRootPaneCheckingEnabled()) {
            throw this.createRootPaneException("setLayout");
        }
        super.setLayout(layoutManager);
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            switch (this.defaultCloseOperation) {
                case 1: {
                    this.setVisible(false);
                    break;
                }
                case 2: {
                    this.setVisible(false);
                    this.dispose();
                    break;
                }
            }
        }
    }

    protected String paramString() {
        String string = this.defaultCloseOperation == 1 ? "HIDE_ON_CLOSE" : (this.defaultCloseOperation == 2 ? "DISPOSE_ON_CLOSE" : (this.defaultCloseOperation == 0 ? "DO_NOTHING_ON_CLOSE" : ""));
        String string2 = this.rootPane != null ? this.rootPane.toString() : "";
        String string3 = this.rootPaneCheckingEnabled ? "true" : "false";
        return super.paramString() + ",defaultCloseOperation=" + string + ",rootPane=" + string2 + ",rootPaneCheckingEnabled=" + string3;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJDialog(this);
        }
        return this.accessibleContext;
    }

    public JLayeredPane getLayeredPane() {
        return this.getRootPane().getLayeredPane();
    }

    public void setLayeredPane(JLayeredPane jLayeredPane) {
        this.getRootPane().setLayeredPane(jLayeredPane);
    }

    public JMenuBar getJMenuBar() {
        return this.getRootPane().getMenuBar();
    }

    public void setJMenuBar(JMenuBar jMenuBar) {
        this.getRootPane().setMenuBar(jMenuBar);
    }

    protected JRootPane createRootPane() {
        return new JRootPane();
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRootPane(JRootPane jRootPane) {
        if (this.rootPane != null) {
            this.remove(this.rootPane);
        }
        this.rootPane = jRootPane;
        if (this.rootPane != null) {
            boolean bl2 = this.isRootPaneCheckingEnabled();
            try {
                this.setRootPaneCheckingEnabled(false);
                this.add((Component)this.rootPane, "Center");
            }
            finally {
                this.setRootPaneCheckingEnabled(bl2);
            }
        }
    }

    private Error createRootPaneException(String string) {
        String string2 = this.getClass().getName();
        return new Error("Do not use " + string2 + "." + string + "() use " + string2 + ".getContentPane()." + string + "() instead");
    }

    protected void addImpl(Component component, Object object, int n2) {
        if (this.isRootPaneCheckingEnabled()) {
            throw this.createRootPaneException("add");
        }
        super.addImpl(component, object, n2);
    }

    public JDialog(Dialog dialog, String string) throws HeadlessException {
        this(dialog, string, false);
    }

    public JDialog(Dialog dialog, String string, boolean bl2) throws HeadlessException {
        super(dialog, string, bl2);
        this.dialogInit();
    }

    public JDialog(Frame frame, String string) throws HeadlessException {
        this(frame, string, false);
    }

    public JDialog(Frame frame, String string, boolean bl2) throws HeadlessException {
        super(frame == null ? SwingUtilities.getSharedOwnerFrame() : frame, string, bl2);
        this.dialogInit();
    }

    public JDialog(Dialog dialog, String string, boolean bl2, GraphicsConfiguration graphicsConfiguration) throws HeadlessException {
        super(dialog, string, bl2, graphicsConfiguration);
        this.dialogInit();
    }

    public JDialog(Frame frame, String string, boolean bl2, GraphicsConfiguration graphicsConfiguration) {
        super(frame == null ? SwingUtilities.getSharedOwnerFrame() : frame, string, bl2, graphicsConfiguration);
        this.dialogInit();
    }

    protected class AccessibleJDialog
    extends Dialog.AccessibleAWTDialog {
        private final JDialog this$0;

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (this.this$0.getTitle() == null) {
                return super.getAccessibleName();
            }
            return this.this$0.getTitle();
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (this.this$0.isResizable()) {
                accessibleStateSet.add(AccessibleState.RESIZABLE);
            }
            if (this.this$0.getFocusOwner() != null) {
                accessibleStateSet.add(AccessibleState.ACTIVE);
            }
            if (this.this$0.isModal()) {
                accessibleStateSet.add(AccessibleState.MODAL);
            }
            return accessibleStateSet;
        }

        protected AccessibleJDialog(JDialog jDialog) {
            this.this$0 = jDialog;
            super(jDialog);
        }
    }
}

