/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.security.auth.kerberos.DelegationPermission;

final class KrbDelegationPermissionCollection
extends PermissionCollection
implements Serializable {
    private transient List perms = new ArrayList();
    private static final long serialVersionUID = -3383936936589966948L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("permissions", class$java$util$Vector == null ? (class$java$util$Vector = KrbDelegationPermissionCollection.class$("java.util.Vector")) : class$java$util$Vector)};
    static Class class$java$util$Vector;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Vector vector = (Vector)getField.get("permissions", null);
        this.perms = new ArrayList(vector.size());
        this.perms.addAll(vector);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Vector vector = new Vector(this.perms.size());
        vector.addAll(this.perms);
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("permissions", vector);
        objectOutputStream.writeFields();
    }

    public void add(Permission permission) {
        if (!(permission instanceof DelegationPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        this.perms.add(0, permission);
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof DelegationPermission)) {
            return false;
        }
        DelegationPermission delegationPermission = (DelegationPermission)permission;
        int n2 = this.perms.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            DelegationPermission delegationPermission2 = (DelegationPermission)this.perms.get(i2);
            if (!delegationPermission2.implies(delegationPermission)) continue;
            return true;
        }
        return false;
    }

    public Enumeration elements() {
        return Collections.enumeration(this.perms);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

