/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth;

import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;
import sun.security.util.ResourcesMgr;

public abstract class Policy {
    private static Policy policy;
    private static ClassLoader contextClassLoader;
    static Class class$javax$security$auth$Policy;

    static {
        contextClassLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    protected Policy() {
    }

    public abstract void refresh();

    static ClassLoader access$000() {
        return contextClassLoader;
    }

    public static Policy getPolicy() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("getPolicy"));
        }
        return Policy.getPolicyNoCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Policy getPolicyNoCheck() {
        if (policy == null) {
            Class clazz = class$javax$security$auth$Policy == null ? (class$javax$security$auth$Policy = Policy.class$("javax.security.auth.Policy")) : class$javax$security$auth$Policy;
            synchronized (clazz) {
                if (policy == null) {
                    String string = null;
                    string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return Security.getProperty("auth.policy.provider");
                        }
                    });
                    if (string == null) {
                        string = "com.sun.security.auth.PolicyFile";
                    }
                    try {
                        String string2 = string;
                        policy = (Policy)AccessController.doPrivileged(new PrivilegedExceptionAction(string2){
                            private final String val$finalClass;

                            public Object run() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
                                return Class.forName(this.val$finalClass, true, Policy.access$000()).newInstance();
                            }
                            {
                                this.val$finalClass = string;
                            }
                        });
                    }
                    catch (Exception exception) {
                        throw new SecurityException(ResourcesMgr.getString("unable to instantiate Subject-based policy"));
                    }
                }
            }
        }
        return policy;
    }

    public static void setPolicy(Policy policy) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("setPolicy"));
        }
        Policy.policy = policy;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public abstract PermissionCollection getPermissions(Subject var1, CodeSource var2);
}

