/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.EntryPair;
import java.text.MergeCollation;
import java.text.ParseException;
import java.text.PatternEntry;
import java.text.RBCollationTables;
import java.util.Vector;
import sun.text.CompactIntArray;
import sun.text.ComposedCharIter;
import sun.text.IntHashtable;
import sun.text.Normalizer;
import sun.text.NormalizerUtilities;

final class RBTableBuilder {
    static final int CHARINDEX = 0x70000000;
    private static final int IGNORABLEMASK = 65535;
    private static final int PRIMARYORDERINCREMENT = 65536;
    private static final int SECONDARYORDERINCREMENT = 256;
    private static final int TERTIARYORDERINCREMENT = 1;
    private static final int INITIALTABLESIZE = 20;
    private static final int MAXKEYSIZE = 5;
    private RBCollationTables.BuildAPI tables = null;
    private MergeCollation mPattern = null;
    private boolean isOverIgnore = false;
    private StringBuffer key = new StringBuffer(5);
    private IntHashtable contractFlags = new IntHashtable(100);
    private boolean frenchSec = false;
    private boolean seAsianSwapping = false;
    private CompactIntArray mapping = null;
    private Vector contractTable = null;
    private Vector expandTable = null;
    private short maxSecOrder = 0;
    private short maxTerOrder = 0;

    private void addComposedChars() throws ParseException {
        StringBuffer stringBuffer = new StringBuffer(1);
        ComposedCharIter composedCharIter = new ComposedCharIter(false, 1);
        while (composedCharIter.hasNext()) {
            char c2 = composedCharIter.next();
            if (this.getCharOrder(c2) != -1) continue;
            String string = composedCharIter.decomposition();
            int n2 = this.getContractOrder(string);
            if (n2 != -1) {
                this.addOrder(c2, n2);
                continue;
            }
            boolean bl2 = true;
            for (int i2 = 0; i2 < string.length(); ++i2) {
                if (this.getCharOrder(string.charAt(i2)) != -1) continue;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            stringBuffer.setLength(0);
            stringBuffer.append(c2);
            this.addExpandOrder(stringBuffer.toString(), string, -1);
        }
    }

    private final void commit() {
        if (this.expandTable != null) {
            for (int i2 = 0; i2 < this.expandTable.size(); ++i2) {
                int[] nArray = (int[])this.expandTable.elementAt(i2);
                for (int i3 = 0; i3 < nArray.length; ++i3) {
                    int n2 = nArray[i3];
                    if (n2 >= 0x7E000000 || n2 <= 0x70000000) continue;
                    char c2 = (char)(n2 - 0x70000000);
                    int n3 = this.getCharOrder(c2);
                    nArray[i3] = n3 == -1 ? 0xFFFF & c2 : n3;
                }
            }
        }
    }

    private final int getCharOrder(char c2) {
        int n2 = this.mapping.elementAt(c2);
        if (n2 >= 0x7F000000) {
            Vector vector = this.getContractValues(n2 - 0x7F000000);
            EntryPair entryPair = (EntryPair)vector.firstElement();
            n2 = entryPair.value;
        }
        return n2;
    }

    private final void addOrder(char c2, int n2) {
        int n3 = this.mapping.elementAt(c2);
        if (n3 >= 0x7F000000) {
            this.key.setLength(0);
            this.key.append(c2);
            this.addContractOrder(this.key.toString(), n2);
        } else {
            this.mapping.setElementAt(c2, n2);
        }
    }

    private final int increment(int n2, int n3) {
        switch (n2) {
            case 0: {
                n3 += 65536;
                n3 &= 0xFFFF0000;
                this.isOverIgnore = true;
                break;
            }
            case 1: {
                n3 += 256;
                n3 &= 0xFFFFFF00;
                if (this.isOverIgnore) break;
                this.maxSecOrder = (short)(this.maxSecOrder + 1);
                break;
            }
            case 2: {
                ++n3;
                if (this.isOverIgnore) break;
                this.maxTerOrder = (short)(this.maxTerOrder + 1);
            }
        }
        return n3;
    }

    private int addExpansion(int n2, String string) {
        int n3;
        if (this.expandTable == null) {
            this.expandTable = new Vector(20);
        }
        int n4 = n2 == -1 ? 0 : 1;
        int[] nArray = new int[string.length() + n4];
        if (n4 == 1) {
            nArray[0] = n2;
        }
        for (n3 = 0; n3 < string.length(); ++n3) {
            char c2 = string.charAt(n3);
            int n5 = this.getCharOrder(c2);
            nArray[n3 + n4] = n5 != -1 ? n5 : 0x70000000 + c2;
        }
        n3 = 0x7E000000 + this.expandTable.size();
        this.expandTable.addElement(nArray);
        return n3;
    }

    private int getContractOrder(String string) {
        int n2;
        Vector vector;
        int n3 = -1;
        if (this.contractTable != null && (vector = this.getContractValues(string.charAt(0))) != null && (n2 = RBCollationTables.getEntry(vector, string, true)) != -1) {
            EntryPair entryPair = (EntryPair)vector.elementAt(n2);
            n3 = entryPair.value;
        }
        return n3;
    }

    private void addContractFlags(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            this.contractFlags.put(c2, 1);
        }
    }

    private final void addContractOrder(String string, int n2) {
        this.addContractOrder(string, n2, true);
    }

    public void build(String string, int n2) throws ParseException {
        boolean bl2 = true;
        int n3 = 0;
        if (string.length() == 0) {
            throw new ParseException("Build rules empty.", 0);
        }
        this.mapping = new CompactIntArray(-1);
        Normalizer.Mode mode = NormalizerUtilities.toNormalizerMode(n2);
        string = Normalizer.normalize(string, mode, 0, true);
        this.mPattern = new MergeCollation(string);
        int n4 = 0;
        for (n3 = 0; n3 < this.mPattern.getCount(); ++n3) {
            PatternEntry patternEntry = this.mPattern.getItemAt(n3);
            if (patternEntry == null) continue;
            String string2 = patternEntry.getChars();
            if (string2.length() > 1) {
                switch (string2.charAt(string2.length() - 1)) {
                    case '@': {
                        this.frenchSec = true;
                        string2 = string2.substring(0, string2.length() - 1);
                        break;
                    }
                    case '!': {
                        this.seAsianSwapping = true;
                        string2 = string2.substring(0, string2.length() - 1);
                    }
                }
            }
            n4 = this.increment(patternEntry.getStrength(), n4);
            String string3 = patternEntry.getExtension();
            if (string3.length() != 0) {
                this.addExpandOrder(string2, string3, n4);
                continue;
            }
            if (string2.length() > 1) {
                this.addContractOrder(string2, n4);
                continue;
            }
            char c2 = string2.charAt(0);
            this.addOrder(c2, n4);
        }
        this.addComposedChars();
        this.commit();
        this.mapping.compact();
        this.tables.fillInTables(this.frenchSec, this.seAsianSwapping, this.mapping, this.contractTable, this.expandTable, this.contractFlags, this.maxSecOrder, this.maxTerOrder);
    }

    private final void addContractOrder(String string, int n2, boolean bl2) {
        int n3;
        int n4;
        Vector vector;
        if (this.contractTable == null) {
            this.contractTable = new Vector(20);
        }
        if ((vector = this.getContractValues((n4 = this.mapping.elementAt(string.charAt(0))) - 0x7F000000)) == null) {
            n3 = 0x7F000000 + this.contractTable.size();
            vector = new Vector(20);
            this.contractTable.addElement(vector);
            vector.addElement(new EntryPair(string.substring(0, 1), n4));
            this.mapping.setElementAt(string.charAt(0), n3);
        }
        if ((n3 = RBCollationTables.getEntry(vector, string, bl2)) != -1) {
            EntryPair entryPair = (EntryPair)vector.elementAt(n3);
            entryPair.value = n2;
        } else {
            EntryPair entryPair = (EntryPair)vector.lastElement();
            if (string.length() > entryPair.entryName.length()) {
                vector.addElement(new EntryPair(string, n2, bl2));
            } else {
                vector.insertElementAt(new EntryPair(string, n2, bl2), vector.size() - 1);
            }
        }
        if (bl2 && string.length() > 1) {
            this.addContractFlags(string);
            this.addContractOrder(new StringBuffer(string).reverse().toString(), n2, false);
        }
    }

    public RBTableBuilder(RBCollationTables.BuildAPI buildAPI) {
        this.tables = buildAPI;
    }

    Vector getContractValues(char c2) {
        int n2 = this.mapping.elementAt(c2);
        return this.getContractValues(n2 - 0x7F000000);
    }

    Vector getContractValues(int n2) {
        if (n2 >= 0) {
            return (Vector)this.contractTable.elementAt(n2);
        }
        return null;
    }

    private final void addExpandOrder(String string, String string2, int n2) throws ParseException {
        int n3 = this.addExpansion(n2, string2);
        if (string.length() > 1) {
            this.addContractOrder(string, n3);
        } else {
            this.addOrder(string.charAt(0), n3);
        }
    }
}

