/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.CharacterIterator;
import java.text.DictionaryBasedBreakIterator;
import java.text.RuleBasedBreakIterator;
import java.text.StringCharacterIterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import sun.text.resources.LocaleData;

public abstract class BreakIterator
implements Cloneable {
    public static final int DONE = -1;
    private static final int CHARACTER_INDEX = 0;
    private static final int WORD_INDEX = 1;
    private static final int LINE_INDEX = 2;
    private static final int SENTENCE_INDEX = 3;
    private static final SoftReference[] iterCache = new SoftReference[4];

    public abstract int current();

    public abstract int first();

    public abstract int last();

    public abstract int next();

    public abstract int previous();

    protected BreakIterator() {
    }

    public abstract int following(int var1);

    public abstract int next(int var1);

    public int preceding(int n2) {
        int n3 = this.following(n2);
        while (n3 >= n2 && n3 != -1) {
            n3 = this.previous();
        }
        return n3;
    }

    public boolean isBoundary(int n2) {
        if (n2 == 0) {
            return true;
        }
        return this.following(n2 - 1) == n2;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void setText(String string) {
        this.setText(new StringCharacterIterator(string));
    }

    public static BreakIterator getCharacterInstance() {
        return BreakIterator.getCharacterInstance(Locale.getDefault());
    }

    public static BreakIterator getLineInstance() {
        return BreakIterator.getLineInstance(Locale.getDefault());
    }

    public static BreakIterator getSentenceInstance() {
        return BreakIterator.getSentenceInstance(Locale.getDefault());
    }

    public static BreakIterator getWordInstance() {
        return BreakIterator.getWordInstance(Locale.getDefault());
    }

    public abstract CharacterIterator getText();

    public abstract void setText(CharacterIterator var1);

    public static synchronized Locale[] getAvailableLocales() {
        return LocaleData.getAvailableLocales("NumberPatterns");
    }

    public static BreakIterator getCharacterInstance(Locale locale) {
        return BreakIterator.getBreakInstance(locale, 0, "CharacterBreakRules", "CharacterBreakDictionary");
    }

    public static BreakIterator getLineInstance(Locale locale) {
        return BreakIterator.getBreakInstance(locale, 2, "LineBreakRules", "LineBreakDictionary");
    }

    public static BreakIterator getSentenceInstance(Locale locale) {
        return BreakIterator.getBreakInstance(locale, 3, "SentenceBreakRules", "SentenceBreakDictionary");
    }

    public static BreakIterator getWordInstance(Locale locale) {
        return BreakIterator.getBreakInstance(locale, 1, "WordBreakRules", "WordBreakDictionary");
    }

    private static ResourceBundle getBundle(String string, Locale locale) {
        return (ResourceBundle)AccessController.doPrivileged(new PrivilegedAction(string, locale){
            private final String val$baseName;
            private final Locale val$locale;

            public Object run() {
                return ResourceBundle.getBundle(this.val$baseName, this.val$locale);
            }
            {
                this.val$baseName = string;
                this.val$locale = locale;
            }
        });
    }

    private static BreakIterator createBreakInstance(Locale locale, int n2, String string, String string2) {
        ResourceBundle resourceBundle = BreakIterator.getBundle("sun.text.resources.BreakIteratorRules", locale);
        String[] stringArray = resourceBundle.getStringArray("BreakIteratorClasses");
        String string3 = resourceBundle.getString(string);
        if (stringArray[n2].equals("RuleBasedBreakIterator")) {
            return new RuleBasedBreakIterator(string3);
        }
        if (stringArray[n2].equals("DictionaryBasedBreakIterator")) {
            try {
                URL uRL = (URL)resourceBundle.getObject(string2);
                InputStream inputStream = uRL.openStream();
                return new DictionaryBasedBreakIterator(string3, inputStream);
            }
            catch (IOException iOException) {
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            return new RuleBasedBreakIterator(string3);
        }
        throw new IllegalArgumentException("Invalid break iterator class \"" + stringArray[n2] + "\"");
    }

    private static BreakIterator getBreakInstance(Locale locale, int n2, String string, String string2) {
        Object object;
        if (iterCache[n2] != null && (object = (BreakIteratorCache)iterCache[n2].get()) != null && ((BreakIteratorCache)object).getLocale().equals(locale)) {
            return ((BreakIteratorCache)object).createBreakInstance();
        }
        object = BreakIterator.createBreakInstance(locale, n2, string, string2);
        BreakIteratorCache breakIteratorCache = new BreakIteratorCache(locale, (BreakIterator)object);
        BreakIterator.iterCache[n2] = new SoftReference(breakIteratorCache);
        return object;
    }

    private static final class BreakIteratorCache {
        private BreakIterator iter;
        private Locale where;

        BreakIterator createBreakInstance() {
            return (BreakIterator)this.iter.clone();
        }

        Locale getLocale() {
            return this.where;
        }

        BreakIteratorCache(Locale locale, BreakIterator breakIterator) {
            this.where = locale;
            this.iter = (BreakIterator)breakIterator.clone();
        }
    }
}

