/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.ExpiringCache;
import java.io.File;
import java.io.FileSystem;
import java.io.IOException;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

class UnixFileSystem
extends FileSystem {
    private final char slash;
    private final char colon;
    private final String javaHome;
    private ExpiringCache cache = new ExpiringCache();
    private ExpiringCache javaHomePrefixCache = new ExpiringCache();
    static final boolean $assertionsDisabled = !(class$java$io$UnixFileSystem == null ? (class$java$io$UnixFileSystem = UnixFileSystem.class$("java.io.UnixFileSystem")) : class$java$io$UnixFileSystem).desiredAssertionStatus();
    static Class class$java$io$UnixFileSystem;

    public char getPathSeparator() {
        return this.colon;
    }

    public char getSeparator() {
        return this.slash;
    }

    static {
        UnixFileSystem.initIDs();
    }

    public UnixFileSystem() {
        this.slash = ((String)AccessController.doPrivileged(new GetPropertyAction("file.separator"))).charAt(0);
        this.colon = ((String)AccessController.doPrivileged(new GetPropertyAction("path.separator"))).charAt(0);
        this.javaHome = (String)AccessController.doPrivileged(new GetPropertyAction("java.home"));
    }

    private static native void initIDs();

    public File[] listRoots() {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkRead("/");
            }
            return new File[]{new File("/")};
        }
        catch (SecurityException securityException) {
            return new File[0];
        }
    }

    public int getBooleanAttributes(File file) {
        int n2 = this.getBooleanAttributes0(file);
        String string = file.getName();
        boolean bl2 = string.length() > 0 && string.charAt(0) == '.';
        return n2 | (bl2 ? 8 : 0);
    }

    public native int getBooleanAttributes0(File var1);

    public int hashCode(File file) {
        return file.getPath().hashCode() ^ 0x12D591;
    }

    public native long getLastModifiedTime(File var1);

    public native long getLength(File var1);

    public native boolean createDirectory(File var1);

    public boolean delete(File file) {
        this.cache.clear();
        this.javaHomePrefixCache.clear();
        return this.delete0(file);
    }

    private native boolean delete0(File var1);

    public synchronized native boolean deleteOnExit(File var1);

    public boolean isAbsolute(File file) {
        return file.getPrefixLength() != 0;
    }

    public native boolean setReadOnly(File var1);

    public native boolean setLastModifiedTime(File var1, long var2);

    public native boolean checkAccess(File var1, boolean var2);

    public String getDefaultParent() {
        return "/";
    }

    public int prefixLength(String string) {
        if (string.length() == 0) {
            return 0;
        }
        return string.charAt(0) == '/' ? 1 : 0;
    }

    public native boolean createFileExclusively(String var1) throws IOException;

    public int compare(File file, File file2) {
        return file.getPath().compareTo(file2.getPath());
    }

    public boolean rename(File file, File file2) {
        this.cache.clear();
        this.javaHomePrefixCache.clear();
        return this.rename0(file, file2);
    }

    private native boolean rename0(File var1, File var2);

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public String resolve(File file) {
        if (this.isAbsolute(file)) {
            return file.getPath();
        }
        return this.resolve(System.getProperty("user.dir"), file.getPath());
    }

    public native String[] list(File var1);

    public String canonicalize(String string) throws IOException {
        if (!useCanonCaches) {
            return this.canonicalize0(string);
        }
        String string2 = this.cache.get(string);
        if (string2 == null) {
            Object object;
            String string3 = null;
            String string4 = null;
            if (useCanonPrefixCache && (string3 = UnixFileSystem.parentOrNull(string)) != null && (string4 = this.javaHomePrefixCache.get(string3)) != null) {
                object = string.substring(1 + string3.length());
                string2 = string4 + this.slash + (String)object;
                this.cache.put(string3 + this.slash + (String)object, string2);
            }
            if (string2 == null) {
                string2 = this.canonicalize0(string);
                this.cache.put(string, string2);
                if (useCanonPrefixCache && string3 != null && string3.startsWith(this.javaHome) && (string4 = UnixFileSystem.parentOrNull(string2)) != null && string4.startsWith(this.javaHome) && ((File)(object = new File(string2))).exists() && !((File)object).isDirectory()) {
                    this.javaHomePrefixCache.put(string3, string4);
                }
            }
        }
        if (!$assertionsDisabled && !this.canonicalize0(string).equals(string2)) {
            throw new AssertionError();
        }
        return string2;
    }

    private native String canonicalize0(String var1) throws IOException;

    public String fromURIPath(String string) {
        String string2 = string;
        if (string2.endsWith("/") && string2.length() > 1) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public String normalize(String string) {
        int n2 = string.length();
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (n3 == 47 && c2 == '/') {
                return this.normalize(string, n2, i2 - 1);
            }
            n3 = c2;
        }
        if (n3 == 47) {
            return this.normalize(string, n2, n2 - 1);
        }
        return string;
    }

    static String parentOrNull(String string) {
        int n2;
        if (string == null) {
            return null;
        }
        char c2 = File.separatorChar;
        int n3 = 0;
        int n4 = 0;
        for (int i2 = n2 = string.length() - 1; i2 > 0; --i2) {
            char c3 = string.charAt(i2);
            if (c3 == '.') {
                if (++n3 < 2) continue;
                return null;
            }
            if (c3 == c2) {
                if (n3 == 1 && n4 == 0) {
                    return null;
                }
                if (i2 == 0 || i2 >= n2 - 1 || string.charAt(i2 - 1) == c2) {
                    return null;
                }
                return string.substring(0, i2);
            }
            ++n4;
            n3 = 0;
        }
        return null;
    }

    private String normalize(String string, int n2, int n3) {
        int n4;
        if (n2 == 0) {
            return string;
        }
        for (n4 = n2; n4 > 0 && string.charAt(n4 - 1) == '/'; --n4) {
        }
        if (n4 == 0) {
            return "/";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        if (n3 > 0) {
            stringBuffer.append(string.substring(0, n3));
        }
        int n5 = 0;
        for (int i2 = n3; i2 < n4; ++i2) {
            char c2 = string.charAt(i2);
            if (n5 == 47 && c2 == '/') continue;
            stringBuffer.append(c2);
            n5 = c2;
        }
        return stringBuffer.toString();
    }

    public String resolve(String string, String string2) {
        if (string2.equals("")) {
            return string;
        }
        if (string2.charAt(0) == '/') {
            if (string.equals("/")) {
                return string2;
            }
            return string + string2;
        }
        if (string.equals("/")) {
            return string + string2;
        }
        return string + '/' + string2;
    }
}

