/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

public class PrintWriter
extends Writer {
    protected Writer out;
    private boolean autoFlush = false;
    private boolean trouble = false;
    private String lineSeparator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.out == null) {
                    return;
                }
                this.out.close();
                this.out = null;
            }
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                this.out.flush();
            }
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newLine() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                this.out.write(this.lineSeparator);
                if (this.autoFlush) {
                    this.out.flush();
                }
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    public void println() {
        this.newLine();
    }

    protected void setError() {
        this.trouble = true;
    }

    public boolean checkError() {
        if (this.out != null) {
            this.flush();
        }
        return this.trouble;
    }

    public void print(char c2) {
        this.write(c2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char c2) {
        Object object = this.lock;
        synchronized (object) {
            this.print(c2);
            this.println();
        }
    }

    public void print(double d2) {
        this.write(String.valueOf(d2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(double d2) {
        Object object = this.lock;
        synchronized (object) {
            this.print(d2);
            this.println();
        }
    }

    public void print(float f2) {
        this.write(String.valueOf(f2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(float f2) {
        Object object = this.lock;
        synchronized (object) {
            this.print(f2);
            this.println();
        }
    }

    public void print(int n2) {
        this.write(String.valueOf(n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(int n2) {
        Object object = this.lock;
        synchronized (object) {
            this.print(n2);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int n2) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                this.out.write(n2);
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    public void print(long l2) {
        this.write(String.valueOf(l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(long l2) {
        Object object = this.lock;
        synchronized (object) {
            this.print(l2);
            this.println();
        }
    }

    public void print(boolean bl2) {
        this.write(bl2 ? "true" : "false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(boolean bl2) {
        Object object = this.lock;
        synchronized (object) {
            this.print(bl2);
            this.println();
        }
    }

    public void print(char[] cArray) {
        this.write(cArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char[] cArray) {
        Object object = this.lock;
        synchronized (object) {
            this.print(cArray);
            this.println();
        }
    }

    public void write(char[] cArray) {
        this.write(cArray, 0, cArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cArray, int n2, int n3) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                this.out.write(cArray, n2, n3);
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    public PrintWriter(OutputStream outputStream) {
        this(outputStream, false);
    }

    public PrintWriter(OutputStream outputStream, boolean bl2) {
        this(new BufferedWriter(new OutputStreamWriter(outputStream)), bl2);
    }

    public PrintWriter(Writer writer) {
        this(writer, false);
    }

    public PrintWriter(Writer writer, boolean bl2) {
        super(writer);
        this.out = writer;
        this.autoFlush = bl2;
        this.lineSeparator = (String)AccessController.doPrivileged(new GetPropertyAction("line.separator"));
    }

    public void print(Object object) {
        this.write(String.valueOf(object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            this.print(object);
            this.println();
        }
    }

    public void print(String string) {
        if (string == null) {
            string = "null";
        }
        this.write(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String string) {
        Object object = this.lock;
        synchronized (object) {
            this.print(string);
            this.println();
        }
    }

    public void write(String string) {
        this.write(string, 0, string.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String string, int n2, int n3) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                this.out.write(string, n2, n3);
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }
}

