/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GraphicAttribute;
import java.awt.font.LineMetrics;
import java.awt.font.NumericShaper;
import java.awt.font.StyledParagraph;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLine;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import sun.awt.font.AdvanceCache;
import sun.awt.font.Decoration;
import sun.awt.font.FontResolver;

public final class TextLayout
implements Cloneable {
    private int characterCount;
    private boolean isVerticalLine = false;
    private byte baseline;
    private float[] baselineOffsets;
    private TextLine textLine;
    private TextLine.TextLineMetrics lineMetrics = null;
    private float visibleAdvance;
    private int hashCodeCache;
    private OptInfo optInfo;
    private boolean cacheIsValid = false;
    private float justifyRatio;
    private static final float ALREADY_JUSTIFIED = -53.9f;
    private static float dx;
    private static float dy;
    private Rectangle2D naturalBounds = null;
    private Rectangle2D boundsRect = null;
    private boolean caretsInLigaturesAreAllowed = false;
    public static final CaretPolicy DEFAULT_CARET_POLICY;

    public byte getBaseline() {
        return this.baseline;
    }

    public float getAdvance() {
        if (this.optInfo != null) {
            try {
                return this.optInfo.getAdvance();
            }
            catch (Error error) {
                // empty catch block
            }
        }
        this.ensureCache();
        return this.lineMetrics.advance;
    }

    public float getAscent() {
        if (this.optInfo != null) {
            return this.optInfo.getLineMetrics().getAscent();
        }
        this.ensureCache();
        return this.lineMetrics.ascent;
    }

    public float getDescent() {
        if (this.optInfo != null) {
            return this.optInfo.getLineMetrics().getDescent();
        }
        this.ensureCache();
        return this.lineMetrics.descent;
    }

    public float getLeading() {
        if (this.optInfo != null) {
            return this.optInfo.getLineMetrics().getLeading();
        }
        this.ensureCache();
        return this.lineMetrics.leading;
    }

    public float getVisibleAdvance() {
        this.ensureCache();
        return this.visibleAdvance;
    }

    public int getCharacterCount() {
        return this.characterCount;
    }

    public int hashCode() {
        if (this.hashCodeCache == 0) {
            this.ensureCache();
            this.hashCodeCache = this.textLine.hashCode();
        }
        return this.hashCodeCache;
    }

    static {
        DEFAULT_CARET_POLICY = new CaretPolicy();
    }

    private void buildCache() {
        if (this.textLine == null) {
            this.initTextLine();
        }
        this.lineMetrics = this.textLine.getMetrics();
        if (this.textLine.isDirectionLTR()) {
            int n2;
            int n3;
            for (n3 = this.characterCount - 1; n3 != -1 && this.textLine.isCharSpace(n2 = this.textLine.visualToLogical(n3)); --n3) {
            }
            if (n3 == this.characterCount - 1) {
                this.visibleAdvance = this.lineMetrics.advance;
            } else if (n3 == -1) {
                this.visibleAdvance = 0.0f;
            } else {
                n2 = this.textLine.visualToLogical(n3);
                this.visibleAdvance = this.textLine.getCharLinePosition(n2) + this.textLine.getCharAdvance(n2);
            }
        } else {
            int n4;
            int n5;
            for (n5 = 0; n5 != this.characterCount && this.textLine.isCharSpace(n4 = this.textLine.visualToLogical(n5)); ++n5) {
            }
            if (n5 == this.characterCount) {
                this.visibleAdvance = 0.0f;
            } else if (n5 == 0) {
                this.visibleAdvance = this.lineMetrics.advance;
            } else {
                n4 = this.textLine.visualToLogical(n5);
                float f2 = this.textLine.getCharLinePosition(n4);
                this.visibleAdvance = this.lineMetrics.advance - f2;
            }
        }
        this.naturalBounds = null;
        this.boundsRect = null;
        this.hashCodeCache = 0;
        this.cacheIsValid = true;
    }

    private void ensureCache() {
        if (!this.cacheIsValid) {
            this.buildCache();
        }
    }

    private void initTextLine() {
        this.textLine = this.optInfo.createTextLine();
        this.optInfo = null;
    }

    public boolean isLeftToRight() {
        return this.optInfo != null || this.textLine.isDirectionLTR();
    }

    public boolean isVertical() {
        return this.isVerticalLine;
    }

    public float[] getBaselineOffsets() {
        float[] fArray = new float[this.baselineOffsets.length];
        System.arraycopy(this.baselineOffsets, 0, fArray, 0, fArray.length);
        return fArray;
    }

    protected void handleJustify(float f2) {
    }

    public byte getCharacterLevel(int n2) {
        if (n2 < -1 || n2 > this.characterCount) {
            throw new IllegalArgumentException("Index is out of range in getCharacterLevel.");
        }
        if (this.optInfo != null) {
            return 0;
        }
        this.ensureCache();
        if (n2 == -1 || n2 == this.characterCount) {
            return (byte)(!this.textLine.isDirectionLTR() ? 1 : 0);
        }
        return this.textLine.getCharLevel(n2);
    }

    private boolean caretIsValid(int n2) {
        if (n2 == this.characterCount || n2 == 0) {
            return true;
        }
        int n3 = this.textLine.visualToLogical(n2);
        if (!this.textLine.isCharLTR(n3) && this.textLine.isCharLTR(n3 = this.textLine.visualToLogical(n2 - 1))) {
            return true;
        }
        return this.textLine.caretAtOffsetIsValid(n3);
    }

    private float caretToPointDistance(float[] fArray, float f2, float f3) {
        float f4 = this.isVerticalLine ? f3 : f2;
        float f5 = this.isVerticalLine ? -f2 : f3;
        return f4 - fArray[0] + f5 * fArray[1];
    }

    private static int sameBaselineUpTo(Font font, char[] cArray, int n2, int n3) {
        return n3;
    }

    public void draw(Graphics2D graphics2D, float f2, float f3) {
        if (graphics2D == null) {
            throw new IllegalArgumentException("Null Graphics2D passed to TextLayout.draw()");
        }
        if (this.optInfo != null) {
            if (this.optInfo.draw(graphics2D, f2, f3)) {
                return;
            }
            this.initTextLine();
        }
        this.textLine.draw(graphics2D, f2 - dx, f3 - dy);
    }

    public Shape[] getCaretShapes(int n2) {
        return this.getCaretShapes(n2, this.getNaturalBounds(), DEFAULT_CARET_POLICY);
    }

    public Shape getBlackBoxBounds(int n2, int n3) {
        this.ensureCache();
        if (n2 > n3) {
            int n4 = n2;
            n2 = n3;
            n3 = n4;
        }
        if (n2 < 0 || n3 > this.characterCount) {
            throw new IllegalArgumentException("Invalid range passed to TextLayout.getBlackBoxBounds()");
        }
        GeneralPath generalPath = new GeneralPath(1);
        if (n2 < this.characterCount) {
            for (int i2 = n2; i2 < n3; ++i2) {
                if (this.textLine.isCharWhitespace(i2)) continue;
                Rectangle2D rectangle2D = this.textLine.getCharBounds(i2);
                generalPath.append(rectangle2D, false);
            }
        }
        if (dx != 0.0f || dy != 0.0f) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.setToTranslation(dx, dy);
            generalPath = (GeneralPath)generalPath.createTransformedShape(affineTransform);
        }
        return generalPath;
    }

    public Shape getLogicalHighlightShape(int n2, int n3) {
        return this.getLogicalHighlightShape(n2, n3, this.getNaturalBounds());
    }

    static byte getBaselineFromGraphic(GraphicAttribute graphicAttribute) {
        byte by = (byte)graphicAttribute.getAlignment();
        if (by == -2 || by == -1) {
            return 0;
        }
        return by;
    }

    public TextHitInfo hitTestChar(float f2, float f3) {
        return this.hitTestChar(f2, f3, this.getNaturalBounds());
    }

    private TextHitInfo caretToHit(int n2) {
        if (n2 == 0 || n2 == this.characterCount) {
            if (n2 == this.characterCount == this.textLine.isDirectionLTR()) {
                return TextHitInfo.leading(this.characterCount);
            }
            return TextHitInfo.trailing(-1);
        }
        int n3 = this.textLine.visualToLogical(n2);
        boolean bl2 = this.textLine.isCharLTR(n3);
        return bl2 ? TextHitInfo.leading(n3) : TextHitInfo.trailing(n3);
    }

    public TextHitInfo getNextLeftHit(int n2) {
        return this.getNextLeftHit(n2, DEFAULT_CARET_POLICY);
    }

    public TextHitInfo getNextRightHit(int n2) {
        return this.getNextRightHit(n2, DEFAULT_CARET_POLICY);
    }

    private int hitToCaret(TextHitInfo textHitInfo) {
        int n2 = textHitInfo.getCharIndex();
        if (n2 < 0) {
            return this.textLine.isDirectionLTR() ? 0 : this.characterCount;
        }
        if (n2 >= this.characterCount) {
            return this.textLine.isDirectionLTR() ? this.characterCount : 0;
        }
        int n3 = this.textLine.logicalToVisual(n2);
        if (textHitInfo.isLeadingEdge() != this.textLine.isCharLTR(n2)) {
            ++n3;
        }
        return n3;
    }

    private void checkTextHit(TextHitInfo textHitInfo) {
        if (textHitInfo == null) {
            throw new IllegalArgumentException("TextHitInfo is null.");
        }
        if (textHitInfo.getInsertionIndex() < 0 || textHitInfo.getInsertionIndex() > this.characterCount) {
            throw new IllegalArgumentException("TextHitInfo is out of range");
        }
    }

    public float[] getCaretInfo(TextHitInfo textHitInfo) {
        return this.getCaretInfo(textHitInfo, this.getNaturalBounds());
    }

    public TextLayout getJustifiedLayout(float f2) {
        int n2;
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException("justificationWidth <= 0 passed to TextLayout.getJustifiedLayout()");
        }
        if (this.justifyRatio == -53.9f) {
            throw new Error("Can't justify again.");
        }
        this.ensureCache();
        for (n2 = this.characterCount; n2 > 0 && this.textLine.isCharWhitespace(n2 - 1); --n2) {
        }
        TextLine textLine = this.textLine.getJustifiedLine(f2, this.justifyRatio, 0, n2);
        if (textLine != null) {
            return new TextLayout(textLine, this.baseline, this.baselineOffsets, -53.9f);
        }
        return this;
    }

    public boolean equals(TextLayout textLayout) {
        if (textLayout == null) {
            return false;
        }
        if (textLayout == this) {
            return true;
        }
        this.ensureCache();
        return this.textLine.equals(textLayout.textLine);
    }

    TextLine getTextLineForTesting() {
        return this.textLine;
    }

    TextLayout(TextLine textLine, byte by, float[] fArray, float f2) {
        this.characterCount = textLine.characterCount();
        this.baseline = by;
        this.baselineOffsets = fArray;
        this.textLine = textLine;
        this.justifyRatio = f2;
    }

    private static GeneralPath pathToShape(double[] dArray, boolean bl2) {
        GeneralPath generalPath = new GeneralPath(0, dArray.length);
        generalPath.moveTo((float)dArray[0], (float)dArray[1]);
        for (int i2 = 2; i2 < dArray.length; i2 += 2) {
            generalPath.lineTo((float)dArray[i2], (float)dArray[i2 + 1]);
        }
        if (bl2) {
            generalPath.closePath();
        }
        return generalPath;
    }

    private GeneralPath boundingShape(double[] dArray, double[] dArray2) {
        int n2;
        int n3;
        int n4;
        boolean bl2;
        GeneralPath generalPath = TextLayout.pathToShape(dArray, false);
        if (this.isVerticalLine) {
            bl2 = dArray[1] > dArray[dArray.length - 1] == dArray2[1] > dArray2[dArray2.length - 1];
        } else {
            boolean bl3 = bl2 = dArray[0] > dArray[dArray.length - 2] == dArray2[0] > dArray2[dArray2.length - 2];
        }
        if (bl2) {
            n4 = dArray2.length - 2;
            n3 = -2;
            n2 = -2;
        } else {
            n4 = 0;
            n3 = dArray2.length;
            n2 = 2;
        }
        for (int i2 = n4; i2 != n3; i2 += n2) {
            generalPath.lineTo((float)dArray2[i2], (float)dArray2[i2 + 1]);
        }
        generalPath.closePath();
        return generalPath;
    }

    public Rectangle2D getBounds() {
        Rectangle2D rectangle2D;
        if (this.optInfo != null) {
            return this.optInfo.getVisualBounds();
        }
        this.ensureCache();
        if (this.boundsRect == null) {
            rectangle2D = this.textLine.getBounds();
            if (dx != 0.0f || dy != 0.0f) {
                rectangle2D.setRect(rectangle2D.getX() - (double)dx, rectangle2D.getY() - (double)dy, rectangle2D.getWidth(), rectangle2D.getHeight());
            }
            this.boundsRect = rectangle2D;
        }
        rectangle2D = new Rectangle2D.Float();
        rectangle2D.setRect(this.boundsRect);
        return rectangle2D;
    }

    private Rectangle2D getNaturalBounds() {
        this.ensureCache();
        if (this.naturalBounds == null) {
            float f2;
            int n2 = this.textLine.visualToLogical(0);
            float f3 = this.textLine.getCharAngle(n2);
            float f4 = f2 = this.isVerticalLine ? -dy : -dx;
            if (f3 < 0.0f) {
                f2 += f3 * this.textLine.getCharAscent(n2);
            } else if (f3 > 0.0f) {
                f2 -= f3 * this.textLine.getCharDescent(n2);
            }
            int n3 = this.textLine.visualToLogical(this.characterCount - 1);
            f3 = this.textLine.getCharAngle(n3);
            float f5 = this.lineMetrics.advance;
            if (f3 < 0.0f) {
                f5 -= f3 * this.textLine.getCharDescent(n3);
            } else if (f3 > 0.0f) {
                f5 += f3 * this.textLine.getCharAscent(n3);
            }
            float f6 = f5 - f2;
            this.naturalBounds = this.isVerticalLine ? new Rectangle2D.Float(-this.lineMetrics.descent, f2, this.lineMetrics.ascent + this.lineMetrics.descent, f6) : new Rectangle2D.Float(f2, -this.lineMetrics.ascent, f6, this.lineMetrics.ascent + this.lineMetrics.descent);
        }
        return this.naturalBounds;
    }

    private double[] getCaretPath(int n2, Rectangle2D rectangle2D, boolean bl2) {
        double[] dArray;
        double d2;
        double d3;
        double d4;
        double d5;
        float[] fArray = this.getCaretInfo(n2, rectangle2D, null);
        double d6 = fArray[0];
        double d7 = fArray[1];
        double d8 = -3141.59;
        double d9 = -2.7;
        double d10 = rectangle2D.getX();
        double d11 = d10 + rectangle2D.getWidth();
        double d12 = rectangle2D.getY();
        double d13 = d12 + rectangle2D.getHeight();
        boolean bl3 = false;
        if (this.isVerticalLine) {
            if (d7 >= 0.0) {
                d5 = d10;
                d4 = d11;
            } else {
                d4 = d10;
                d5 = d11;
            }
            d3 = d6 + d5 * d7;
            d2 = d6 + d4 * d7;
            if (bl2) {
                if (d3 < d12) {
                    if (d7 <= 0.0 || d2 <= d12) {
                        d3 = d2 = d12;
                    } else {
                        bl3 = true;
                        d3 = d12;
                        d9 = d12;
                        d8 = d4 + (d12 - d2) / d7;
                        if (d2 > d13) {
                            d2 = d13;
                        }
                    }
                } else if (d2 > d13) {
                    if (d7 >= 0.0 || d3 >= d13) {
                        d3 = d2 = d13;
                    } else {
                        bl3 = true;
                        d2 = d13;
                        d9 = d13;
                        d8 = d5 + (d13 - d4) / d7;
                    }
                }
            }
        } else {
            if (d7 >= 0.0) {
                d3 = d13;
                d2 = d12;
            } else {
                d2 = d13;
                d3 = d12;
            }
            d5 = d6 - d3 * d7;
            d4 = d6 - d2 * d7;
            if (bl2) {
                if (d5 < d10) {
                    if (d7 <= 0.0 || d4 <= d10) {
                        d5 = d4 = d10;
                    } else {
                        bl3 = true;
                        d5 = d10;
                        d8 = d10;
                        d9 = d2 - (d10 - d4) / d7;
                        if (d4 > d11) {
                            d4 = d11;
                        }
                    }
                } else if (d4 > d11) {
                    if (d7 >= 0.0 || d5 >= d11) {
                        d5 = d4 = d11;
                    } else {
                        bl3 = true;
                        d4 = d11;
                        d8 = d11;
                        d9 = d3 - (d11 - d5) / d7;
                    }
                }
            }
        }
        if (bl3) {
            double[] dArray2 = new double[6];
            dArray2[0] = d5;
            dArray2[1] = d3;
            dArray2[2] = d8;
            dArray2[3] = d9;
            dArray2[4] = d4;
            dArray = dArray2;
            dArray2[5] = d2;
        } else {
            double[] dArray3 = new double[4];
            dArray3[0] = d5;
            dArray3[1] = d3;
            dArray3[2] = d4;
            dArray = dArray3;
            dArray3[3] = d2;
        }
        return dArray;
    }

    private float[] getCaretInfo(int n2, Rectangle2D rectangle2D, float[] fArray) {
        float f2;
        float f3;
        float f4;
        float f5;
        if (n2 == 0 || n2 == this.characterCount) {
            float f6;
            int n3;
            if (n2 == this.characterCount) {
                n3 = this.textLine.visualToLogical(this.characterCount - 1);
                f6 = this.textLine.getCharLinePosition(n3) + this.textLine.getCharAdvance(n3);
            } else {
                n3 = this.textLine.visualToLogical(n2);
                f6 = this.textLine.getCharLinePosition(n3);
            }
            float f7 = this.textLine.getCharAngle(n3);
            f4 = f5 = f6 + f7 * this.textLine.getCharAscent(n3);
            f2 = f3 = f6 - f7 * this.textLine.getCharDescent(n3);
        } else {
            int n4 = this.textLine.visualToLogical(n2 - 1);
            float f8 = this.textLine.getCharAngle(n4);
            float f9 = this.textLine.getCharLinePosition(n4) + this.textLine.getCharAdvance(n4);
            if (f8 != 0.0f) {
                f4 = f9 + f8 * this.textLine.getCharAscent(n4);
                f2 = f9 - f8 * this.textLine.getCharDescent(n4);
            } else {
                f4 = f2 = f9;
            }
            n4 = this.textLine.visualToLogical(n2);
            f8 = this.textLine.getCharAngle(n4);
            f9 = this.textLine.getCharLinePosition(n4);
            if (f8 != 0.0f) {
                f5 = f9 + f8 * this.textLine.getCharAscent(n4);
                f3 = f9 - f8 * this.textLine.getCharDescent(n4);
            } else {
                f5 = f3 = f9;
            }
        }
        float f10 = (f4 + f5) / 2.0f;
        float f11 = (f2 + f3) / 2.0f;
        if (fArray == null) {
            fArray = new float[2];
        }
        if (this.isVerticalLine) {
            fArray[1] = (float)((double)(f10 - f11) / rectangle2D.getWidth());
            fArray[0] = (float)((double)f10 + (double)fArray[1] * rectangle2D.getX());
        } else {
            fArray[1] = (float)((double)(f10 - f11) / rectangle2D.getHeight());
            fArray[0] = (float)((double)f11 + (double)fArray[1] * rectangle2D.getMaxY());
        }
        return fArray;
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        return object instanceof TextLayout && this.equals((TextLayout)object);
    }

    public String toString() {
        this.ensureCache();
        return this.textLine.toString();
    }

    private static Font singleFont(char[] cArray, int n2, int n3, Map map) {
        if (map.get(TextAttribute.CHAR_REPLACEMENT) != null) {
            return null;
        }
        Font font = (Font)map.get(TextAttribute.FONT);
        if (font == null) {
            if (map.get(TextAttribute.FAMILY) != null) {
                font = Font.getFont(map);
                if (font.canDisplayUpTo(cArray, n2, n3) != -1) {
                    return null;
                }
            } else {
                FontResolver fontResolver = FontResolver.getInstance();
                int n4 = fontResolver.getFontIndex(cArray[n2]);
                for (int i2 = n2 + 1; i2 < n3; ++i2) {
                    if (fontResolver.getFontIndex(cArray[i2]) == n4) continue;
                    return null;
                }
                font = fontResolver.getFont(n4, map);
            }
        }
        if (TextLayout.sameBaselineUpTo(font, cArray, n2, n3) != n3) {
            return null;
        }
        return font;
    }

    public Shape getCaretShape(TextHitInfo textHitInfo) {
        return this.getCaretShape(textHitInfo, this.getNaturalBounds());
    }

    public Shape getOutline(AffineTransform affineTransform) {
        this.ensureCache();
        return this.textLine.getOutline(affineTransform);
    }

    public Shape getLogicalHighlightShape(int n2, int n3, Rectangle2D rectangle2D) {
        int n4;
        if (rectangle2D == null) {
            throw new IllegalArgumentException("Null Rectangle2D passed to TextLayout.getLogicalHighlightShape()");
        }
        this.ensureCache();
        if (n2 > n3) {
            int n5 = n2;
            n2 = n3;
            n3 = n5;
        }
        if (n2 < 0 || n3 > this.characterCount) {
            throw new IllegalArgumentException("Range is invalid in TextLayout.getLogicalHighlightShape()");
        }
        int[] nArray = new int[10];
        int n6 = 0;
        if (n2 < n3) {
            int n7 = n2;
            do {
                nArray[n6++] = this.hitToCaret(TextHitInfo.leading(n7));
                n4 = this.textLine.isCharLTR(n7);
                while (++n7 < n3 && this.textLine.isCharLTR(n7) == n4) {
                }
                int n8 = n7;
                nArray[n6++] = this.hitToCaret(TextHitInfo.trailing(n8 - 1));
                if (n6 != nArray.length) continue;
                int[] nArray2 = new int[nArray.length + 10];
                System.arraycopy(nArray, 0, nArray2, 0, n6);
                nArray = nArray2;
            } while (n7 < n3);
        } else {
            n6 = 2;
            nArray[0] = nArray[1] = this.hitToCaret(TextHitInfo.leading(n2));
        }
        GeneralPath generalPath = new GeneralPath(0);
        for (n4 = 0; n4 < n6; n4 += 2) {
            generalPath.append(this.caretBoundingShape(nArray[n4], nArray[n4 + 1], rectangle2D), false);
        }
        if (this.textLine.isDirectionLTR() && n2 == 0 || !this.textLine.isDirectionLTR() && n3 == this.characterCount) {
            generalPath.append(this.leftShape(rectangle2D), false);
        }
        if (this.textLine.isDirectionLTR() && n3 == this.characterCount || !this.textLine.isDirectionLTR() && n2 == 0) {
            generalPath.append(this.rightShape(rectangle2D), false);
        }
        return generalPath;
    }

    public Shape[] getCaretShapes(int n2, Rectangle2D rectangle2D) {
        return this.getCaretShapes(n2, rectangle2D, DEFAULT_CARET_POLICY);
    }

    public TextLayout(AttributedCharacterIterator attributedCharacterIterator, FontRenderContext fontRenderContext) {
        Map map;
        Font font;
        int n2;
        if (attributedCharacterIterator == null) {
            throw new IllegalArgumentException("Null iterator passed to TextLayout constructor.");
        }
        int n3 = attributedCharacterIterator.getBeginIndex();
        if (n3 == (n2 = attributedCharacterIterator.getEndIndex())) {
            throw new IllegalArgumentException("Zero length iterator passed to TextLayout constructor.");
        }
        int n4 = n2 - n3;
        attributedCharacterIterator.first();
        char[] cArray = new char[n4];
        int n5 = 0;
        char c2 = attributedCharacterIterator.first();
        while (true) {
            if (c2 == '\uffff') break;
            cArray[n5++] = c2;
            c2 = attributedCharacterIterator.next();
        }
        attributedCharacterIterator.first();
        if (attributedCharacterIterator.getRunLimit() == n2 && (font = TextLayout.singleFont(cArray, 0, n4, map = attributedCharacterIterator.getAttributes())) != null) {
            this.fastInit(cArray, font, map, fontRenderContext);
            return;
        }
        this.standardInit(attributedCharacterIterator, cArray, fontRenderContext);
    }

    private void standardInit(AttributedCharacterIterator attributedCharacterIterator, char[] cArray, FontRenderContext fontRenderContext) {
        this.characterCount = cArray.length;
        Map map = attributedCharacterIterator.getAttributes();
        boolean bl2 = TextLine.advanceToFirstFont(attributedCharacterIterator);
        if (bl2) {
            Font font = TextLine.getFontAtCurrentPos(attributedCharacterIterator);
            int n2 = attributedCharacterIterator.getIndex() - attributedCharacterIterator.getBeginIndex();
            LineMetrics lineMetrics = font.getLineMetrics(cArray, n2, n2 + 1, fontRenderContext);
            this.paragraphInit((byte)lineMetrics.getBaselineIndex(), lineMetrics, map, cArray);
        } else {
            GraphicAttribute graphicAttribute = (GraphicAttribute)map.get(TextAttribute.CHAR_REPLACEMENT);
            byte by = TextLayout.getBaselineFromGraphic(graphicAttribute);
            Font font = new Font(new Hashtable(5, 0.9f));
            LineMetrics lineMetrics = font.getLineMetrics(" ", 0, 1, fontRenderContext);
            this.paragraphInit(by, lineMetrics, map, cArray);
        }
        this.textLine = TextLine.standardCreateTextLine(fontRenderContext, attributedCharacterIterator, cArray, this.baselineOffsets);
    }

    public TextHitInfo getNextLeftHit(TextHitInfo textHitInfo) {
        this.ensureCache();
        this.checkTextHit(textHitInfo);
        int n2 = this.hitToCaret(textHitInfo);
        if (n2 == 0) {
            return null;
        }
        while (!this.caretIsValid(--n2)) {
        }
        return this.caretToHit(n2);
    }

    public TextHitInfo getNextRightHit(TextHitInfo textHitInfo) {
        this.ensureCache();
        this.checkTextHit(textHitInfo);
        int n2 = this.hitToCaret(textHitInfo);
        if (n2 == this.characterCount) {
            return null;
        }
        while (!this.caretIsValid(++n2)) {
        }
        return this.caretToHit(n2);
    }

    public TextHitInfo getVisualOtherHit(TextHitInfo textHitInfo) {
        boolean bl2;
        int n2;
        this.ensureCache();
        this.checkTextHit(textHitInfo);
        int n3 = textHitInfo.getCharIndex();
        if (n3 == -1 || n3 == this.characterCount) {
            int n4 = this.textLine.isDirectionLTR() == (n3 == -1) ? 0 : this.characterCount - 1;
            n2 = this.textLine.visualToLogical(n4);
            bl2 = this.textLine.isDirectionLTR() == (n3 == -1) ? this.textLine.isCharLTR(n2) : !this.textLine.isCharLTR(n2);
        } else {
            boolean bl3;
            int n5 = this.textLine.logicalToVisual(n3);
            if (this.textLine.isCharLTR(n3) == textHitInfo.isLeadingEdge()) {
                --n5;
                bl3 = false;
            } else {
                ++n5;
                bl3 = true;
            }
            if (n5 > -1 && n5 < this.characterCount) {
                n2 = this.textLine.visualToLogical(n5);
                bl2 = bl3 == this.textLine.isCharLTR(n2);
            } else {
                n2 = bl3 == this.textLine.isDirectionLTR() ? this.characterCount : -1;
                bl2 = n2 == this.characterCount;
            }
        }
        return bl2 ? TextHitInfo.leading(n2) : TextHitInfo.trailing(n2);
    }

    public int[] getLogicalRangesForVisualSelection(TextHitInfo textHitInfo, TextHitInfo textHitInfo2) {
        int n2;
        this.ensureCache();
        this.checkTextHit(textHitInfo);
        this.checkTextHit(textHitInfo2);
        boolean[] blArray = new boolean[this.characterCount];
        int n3 = this.hitToCaret(textHitInfo);
        int n4 = this.hitToCaret(textHitInfo2);
        if (n3 > n4) {
            n2 = n3;
            n3 = n4;
            n4 = n2;
        }
        if (n3 < n4) {
            for (n2 = n3; n2 < n4; ++n2) {
                blArray[this.textLine.visualToLogical((int)n2)] = true;
            }
        }
        n2 = 0;
        boolean bl2 = false;
        for (int i2 = 0; i2 < this.characterCount; ++i2) {
            if (blArray[i2] == bl2) continue;
            boolean bl3 = bl2 = !bl2;
            if (!bl2) continue;
            ++n2;
        }
        int[] nArray = new int[n2 * 2];
        n2 = 0;
        bl2 = false;
        for (int i3 = 0; i3 < this.characterCount; ++i3) {
            if (blArray[i3] == bl2) continue;
            nArray[n2++] = i3;
            bl2 = !bl2;
        }
        if (bl2) {
            nArray[n2++] = this.characterCount;
        }
        return nArray;
    }

    public TextHitInfo getNextLeftHit(int n2, CaretPolicy caretPolicy) {
        TextHitInfo textHitInfo;
        if (caretPolicy == null) {
            throw new IllegalArgumentException("Null CaretPolicy passed to TextLayout.getNextLeftHit()");
        }
        if (n2 < 0 || n2 > this.characterCount) {
            throw new IllegalArgumentException("Offset out of bounds in TextLayout.getNextLeftHit()");
        }
        TextHitInfo textHitInfo2 = TextHitInfo.afterOffset(n2);
        TextHitInfo textHitInfo3 = this.getNextLeftHit(caretPolicy.getStrongCaret(textHitInfo2, textHitInfo = textHitInfo2.getOtherHit(), this));
        if (textHitInfo3 != null) {
            TextHitInfo textHitInfo4 = this.getVisualOtherHit(textHitInfo3);
            return caretPolicy.getStrongCaret(textHitInfo4, textHitInfo3, this);
        }
        return null;
    }

    public TextHitInfo getNextRightHit(int n2, CaretPolicy caretPolicy) {
        TextHitInfo textHitInfo;
        if (n2 < 0 || n2 > this.characterCount) {
            throw new IllegalArgumentException("Offset out of bounds in TextLayout.getNextRightHit()");
        }
        if (caretPolicy == null) {
            throw new IllegalArgumentException("Null CaretPolicy passed to TextLayout.getNextRightHit()");
        }
        TextHitInfo textHitInfo2 = TextHitInfo.afterOffset(n2);
        TextHitInfo textHitInfo3 = this.getNextRightHit(caretPolicy.getStrongCaret(textHitInfo2, textHitInfo = textHitInfo2.getOtherHit(), this));
        if (textHitInfo3 != null) {
            TextHitInfo textHitInfo4 = this.getVisualOtherHit(textHitInfo3);
            return caretPolicy.getStrongCaret(textHitInfo4, textHitInfo3, this);
        }
        return null;
    }

    public TextHitInfo hitTestChar(float f2, float f3, Rectangle2D rectangle2D) {
        TextHitInfo textHitInfo;
        float f4;
        float f5;
        int n2;
        this.ensureCache();
        float[] fArray = new float[2];
        int n3 = 0;
        fArray = this.getCaretInfo(n3, rectangle2D, fArray);
        if (this.caretToPointDistance(fArray, f2, f3) < 0.0f) {
            return this.textLine.isDirectionLTR() ? TextHitInfo.trailing(-1) : TextHitInfo.leading(this.characterCount);
        }
        int n4 = this.characterCount;
        if (this.caretToPointDistance(fArray = this.getCaretInfo(n4, rectangle2D, fArray), f2, f3) >= 0.0f) {
            return this.textLine.isDirectionLTR() ? TextHitInfo.leading(this.characterCount) : TextHitInfo.trailing(-1);
        }
        while (n3 + 1 != n4) {
            n2 = (n3 + n4) / 2;
            while (!this.caretIsValid(n2)) {
                ++n2;
            }
            if (n2 == n4) {
                n2 = (n3 + n4) / 2;
                while (!this.caretIsValid(--n2)) {
                }
                if (n2 == n3) break;
            }
            if ((f5 = this.caretToPointDistance(fArray = this.getCaretInfo(n2, rectangle2D, fArray), f2, f3)) == 0.0f) {
                int n5 = this.textLine.visualToLogical(n2);
                boolean bl2 = this.textLine.isCharLTR(n5);
                return bl2 ? TextHitInfo.leading(n5) : TextHitInfo.trailing(n5);
            }
            if (f5 < 0.0f) {
                n4 = n2;
                continue;
            }
            n3 = n2;
        }
        n2 = this.textLine.visualToLogical(n3);
        f5 = this.textLine.getCharLinePosition(n2) + (this.isVerticalLine ? -dy : -dx);
        int n6 = this.textLine.visualToLogical(n4 - 1);
        if (n4 - n3 > 1) {
            float f6 = this.textLine.getCharLinePosition(n6);
            f5 += (f6 - f5) / 2.0f;
        }
        fArray[0] = f5 += this.textLine.getCharAdvance(n6) / 2.0f;
        fArray[1] = this.textLine.getCharAngle(n2);
        if (fArray[1] != 0.0f) {
            fArray[0] = fArray[0] + fArray[1] * (this.isVerticalLine ? this.textLine.getCharXPosition(n2) : this.textLine.getCharYPosition(n2));
        }
        if ((f4 = this.caretToPointDistance(fArray, f2, f3)) < 0.0f) {
            textHitInfo = this.textLine.isCharLTR(n2) ? TextHitInfo.leading(n2) : TextHitInfo.trailing(n2);
        } else {
            n2 = this.textLine.visualToLogical(n4 - 1);
            boolean bl3 = !this.textLine.isCharLTR(n2);
            textHitInfo = bl3 ? TextHitInfo.leading(n2) : TextHitInfo.trailing(n2);
        }
        return textHitInfo;
    }

    private GeneralPath caretBoundingShape(int n2, int n3, Rectangle2D rectangle2D) {
        if (n2 > n3) {
            int n4 = n2;
            n2 = n3;
            n3 = n4;
        }
        return this.boundingShape(this.getCaretPath(n2, rectangle2D, true), this.getCaretPath(n3, rectangle2D, true));
    }

    private GeneralPath leftShape(Rectangle2D rectangle2D) {
        double[] dArray = this.isVerticalLine ? new double[]{rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY()} : new double[]{rectangle2D.getX(), rectangle2D.getY() + rectangle2D.getHeight(), rectangle2D.getX(), rectangle2D.getY()};
        double[] dArray2 = this.getCaretPath(0, rectangle2D, true);
        return this.boundingShape(dArray, dArray2);
    }

    private GeneralPath rightShape(Rectangle2D rectangle2D) {
        double[] dArray = this.isVerticalLine ? new double[]{rectangle2D.getX(), rectangle2D.getY() + rectangle2D.getHeight(), rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY() + rectangle2D.getHeight()} : new double[]{rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY() + rectangle2D.getHeight(), rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY()};
        double[] dArray2 = this.getCaretPath(this.characterCount, rectangle2D, true);
        return this.boundingShape(dArray2, dArray);
    }

    public float[] getCaretInfo(TextHitInfo textHitInfo, Rectangle2D rectangle2D) {
        this.ensureCache();
        this.checkTextHit(textHitInfo);
        return this.getCaretInfo(this.hitToCaret(textHitInfo), rectangle2D, null);
    }

    private void paragraphInit(byte by, LineMetrics lineMetrics, Map map, char[] cArray) {
        Object object;
        this.baseline = by;
        this.baselineOffsets = TextLine.getNormalizedOffsets(lineMetrics.getBaselineOffsets(), this.baseline);
        this.justifyRatio = TextLine.getJustifyRatio(map);
        if (map != null && (object = map.get(TextAttribute.NUMERIC_SHAPING)) != null) {
            try {
                NumericShaper numericShaper = (NumericShaper)object;
                numericShaper.shape(cArray, 0, cArray.length);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public Shape getVisualHighlightShape(TextHitInfo textHitInfo, TextHitInfo textHitInfo2) {
        return this.getVisualHighlightShape(textHitInfo, textHitInfo2, this.getNaturalBounds());
    }

    public Shape[] getCaretShapes(int n2, Rectangle2D rectangle2D, CaretPolicy caretPolicy) {
        this.ensureCache();
        if (n2 < 0 || n2 > this.characterCount) {
            throw new IllegalArgumentException("Offset out of bounds in TextLayout.getCaretShapes()");
        }
        if (rectangle2D == null) {
            throw new IllegalArgumentException("Null Rectangle2D passed to TextLayout.getCaretShapes()");
        }
        if (caretPolicy == null) {
            throw new IllegalArgumentException("Null CaretPolicy passed to TextLayout.getCaretShapes()");
        }
        Shape[] shapeArray = new Shape[2];
        TextHitInfo textHitInfo = TextHitInfo.afterOffset(n2);
        int n3 = this.hitToCaret(textHitInfo);
        GeneralPath generalPath = TextLayout.pathToShape(this.getCaretPath(n3, rectangle2D, false), false);
        TextHitInfo textHitInfo2 = textHitInfo.getOtherHit();
        int n4 = this.hitToCaret(textHitInfo2);
        if (n3 == n4) {
            shapeArray[0] = generalPath;
        } else {
            GeneralPath generalPath2 = TextLayout.pathToShape(this.getCaretPath(n4, rectangle2D, false), false);
            TextHitInfo textHitInfo3 = caretPolicy.getStrongCaret(textHitInfo, textHitInfo2, this);
            boolean bl2 = textHitInfo3.equals(textHitInfo);
            if (bl2) {
                shapeArray[0] = generalPath;
                shapeArray[1] = generalPath2;
            } else {
                shapeArray[0] = generalPath2;
                shapeArray[1] = generalPath;
            }
        }
        return shapeArray;
    }

    public Shape getCaretShape(TextHitInfo textHitInfo, Rectangle2D rectangle2D) {
        this.ensureCache();
        this.checkTextHit(textHitInfo);
        if (rectangle2D == null) {
            throw new IllegalArgumentException("Null Rectangle2D passed to TextLayout.getCaret()");
        }
        int n2 = this.hitToCaret(textHitInfo);
        GeneralPath generalPath = TextLayout.pathToShape(this.getCaretPath(n2, rectangle2D, false), false);
        return generalPath;
    }

    public TextLayout(String string, Font font, FontRenderContext fontRenderContext) {
        if (font == null) {
            throw new IllegalArgumentException("Null font passed to TextLayout constructor.");
        }
        if (string == null) {
            throw new IllegalArgumentException("Null string passed to TextLayout constructor.");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("Zero length string passed to TextLayout constructor.");
        }
        char[] cArray = string.toCharArray();
        if (TextLayout.sameBaselineUpTo(font, cArray, 0, cArray.length) == cArray.length) {
            this.fastInit(cArray, font, null, fontRenderContext);
        } else {
            AttributedString attributedString = new AttributedString(string);
            attributedString.addAttribute(TextAttribute.FONT, font);
            this.standardInit(attributedString.getIterator(), cArray, fontRenderContext);
        }
    }

    private void fastInit(char[] cArray, Font font, Map map, FontRenderContext fontRenderContext) {
        this.isVerticalLine = false;
        LineMetrics lineMetrics = font.getLineMetrics(cArray, 0, cArray.length, fontRenderContext);
        byte by = (byte)lineMetrics.getBaselineIndex();
        if (map == null) {
            this.baseline = by;
            this.baselineOffsets = lineMetrics.getBaselineOffsets();
            this.justifyRatio = 1.0f;
        } else {
            this.paragraphInit(by, lineMetrics, map, cArray);
        }
        this.characterCount = cArray.length;
        this.optInfo = OptInfo.create(fontRenderContext, cArray, font, lineMetrics, map);
        if (this.optInfo == null) {
            this.textLine = TextLine.fastCreateTextLine(fontRenderContext, cArray, font, lineMetrics, map);
        }
    }

    public TextLayout(String string, Map map, FontRenderContext fontRenderContext) {
        if (string == null) {
            throw new IllegalArgumentException("Null string passed to TextLayout constructor.");
        }
        if (map == null) {
            throw new IllegalArgumentException("Null map passed to TextLayout constructor.");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("Zero length string passed to TextLayout constructor.");
        }
        char[] cArray = string.toCharArray();
        Font font = TextLayout.singleFont(cArray, 0, cArray.length, map);
        if (font != null) {
            this.fastInit(cArray, font, map, fontRenderContext);
        } else {
            AttributedString attributedString = new AttributedString(string, map);
            this.standardInit(attributedString.getIterator(), cArray, fontRenderContext);
        }
    }

    private final TextHitInfo getStrongHit(TextHitInfo textHitInfo, TextHitInfo textHitInfo2) {
        byte by;
        byte by2 = this.getCharacterLevel(textHitInfo.getCharIndex());
        if (by2 == (by = this.getCharacterLevel(textHitInfo2.getCharIndex()))) {
            if (textHitInfo2.isLeadingEdge() && !textHitInfo.isLeadingEdge()) {
                return textHitInfo2;
            }
            return textHitInfo;
        }
        return by2 < by ? textHitInfo : textHitInfo2;
    }

    public Shape getVisualHighlightShape(TextHitInfo textHitInfo, TextHitInfo textHitInfo2, Rectangle2D rectangle2D) {
        this.ensureCache();
        this.checkTextHit(textHitInfo);
        this.checkTextHit(textHitInfo2);
        if (rectangle2D == null) {
            throw new IllegalArgumentException("Null Rectangle2D passed to TextLayout.getVisualHighlightShape()");
        }
        GeneralPath generalPath = new GeneralPath(0);
        int n2 = this.hitToCaret(textHitInfo);
        int n3 = this.hitToCaret(textHitInfo2);
        generalPath.append(this.caretBoundingShape(n2, n3, rectangle2D), false);
        if (n2 == 0 || n3 == 0) {
            generalPath.append(this.leftShape(rectangle2D), false);
        }
        if (n2 == this.characterCount || n3 == this.characterCount) {
            generalPath.append(this.rightShape(rectangle2D), false);
        }
        return generalPath;
    }

    static TextHitInfo access$000(TextLayout textLayout, TextHitInfo textHitInfo, TextHitInfo textHitInfo2) {
        return textLayout.getStrongHit(textHitInfo, textHitInfo2);
    }

    public static class CaretPolicy {
        public TextHitInfo getStrongCaret(TextHitInfo textHitInfo, TextHitInfo textHitInfo2, TextLayout textLayout) {
            return TextLayout.access$000(textLayout, textHitInfo, textHitInfo2);
        }
    }

    static class OptInfo
    implements Decoration.Label {
        private static final float MAGIC_ADVANCE = -12345.67f;
        private FontRenderContext frc;
        private char[] chars;
        private Font font;
        private LineMetrics metrics;
        private Map attrs;
        private float advance;
        private Rectangle2D vb;
        private Decoration decoration;
        private String str;

        float getAdvance() {
            if (this.advance == -12345.67f) {
                AdvanceCache advanceCache = AdvanceCache.get(this.font, this.frc);
                this.advance = advanceCache.getAdvance(this.chars, 0, this.chars.length);
            }
            return this.advance;
        }

        public void handleDraw(Graphics2D graphics2D, float f2, float f3) {
            if (this.str == null) {
                this.str = new String(this.chars, 0, this.chars.length);
            }
            graphics2D.drawString(this.str, f2, f3);
        }

        boolean draw(Graphics2D graphics2D, float f2, float f3) {
            if (graphics2D.getFontRenderContext().equals(this.frc)) {
                Font font = graphics2D.getFont();
                graphics2D.setFont(this.font);
                this.getDecoration().drawTextAndDecorations(this, graphics2D, f2, f3);
                graphics2D.setFont(font);
                return true;
            }
            return false;
        }

        public Shape handleGetOutline(float f2, float f3) {
            throw new InternalError();
        }

        public LineMetrics getLineMetrics() {
            return this.metrics;
        }

        TextLine createTextLine() {
            return TextLine.fastCreateTextLine(this.frc, this.chars, this.font, this.metrics, this.attrs);
        }

        public Rectangle2D getLogicalBounds() {
            return new Rectangle2D.Float(0.0f, -this.metrics.getAscent(), this.getAdvance(), this.metrics.getHeight());
        }

        Rectangle2D getVisualBounds() {
            if (this.vb == null) {
                this.vb = this.getDecoration().getVisualBounds(this);
            }
            return (Rectangle2D)this.vb.clone();
        }

        public Rectangle2D handleGetVisualBounds() {
            AdvanceCache advanceCache = AdvanceCache.get(this.font, this.frc);
            return advanceCache.getVisualBounds(this.chars, 0, this.chars.length);
        }

        public Rectangle2D handleGetCharVisualBounds(int n2) {
            throw new InternalError();
        }

        Decoration getDecoration() {
            if (this.decoration == null) {
                this.decoration = this.attrs == null ? Decoration.getDecoration(null) : Decoration.getDecoration(StyledParagraph.addInputMethodAttrs(this.attrs));
            }
            return this.decoration;
        }

        private OptInfo(FontRenderContext fontRenderContext, char[] cArray, Font font, LineMetrics lineMetrics, Map map) {
            this.frc = fontRenderContext;
            this.chars = cArray;
            this.font = font;
            this.metrics = lineMetrics;
            this.attrs = map;
            if (map != null) {
                this.attrs = new HashMap(map);
            }
            this.advance = -12345.67f;
        }

        static OptInfo create(FontRenderContext fontRenderContext, char[] cArray, Font font, LineMetrics lineMetrics, Map map) {
            if (!font.isTransformed() && AdvanceCache.supportsText(cArray) && (map == null || map.get(TextAttribute.CHAR_REPLACEMENT) == null)) {
                return new OptInfo(fontRenderContext, cArray, font, lineMetrics, map);
            }
            return null;
        }
    }
}

