/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.GraphicAttribute;
import java.awt.geom.Rectangle2D;

public final class ImageGraphicAttribute
extends GraphicAttribute {
    private Image fImage;
    private float fImageWidth;
    private float fImageHeight;
    private float fOriginX;
    private float fOriginY;

    public float getAdvance() {
        return Math.max(0.0f, this.fImageWidth - this.fOriginX);
    }

    public float getAscent() {
        return Math.max(0.0f, this.fOriginY);
    }

    public float getDescent() {
        return Math.max(0.0f, this.fImageHeight - this.fOriginY);
    }

    public int hashCode() {
        return this.fImage.hashCode();
    }

    public void draw(Graphics2D graphics2D, float f2, float f3) {
        graphics2D.drawImage(this.fImage, (int)(f2 - this.fOriginX), (int)(f3 - this.fOriginY), null);
    }

    public ImageGraphicAttribute(Image image, int n2) {
        this(image, n2, 0.0f, 0.0f);
    }

    public ImageGraphicAttribute(Image image, int n2, float f2, float f3) {
        super(n2);
        this.fImage = image;
        this.fImageWidth = image.getWidth(null);
        this.fImageHeight = image.getHeight(null);
        this.fOriginX = f2;
        this.fOriginY = f3;
    }

    public boolean equals(ImageGraphicAttribute imageGraphicAttribute) {
        if (imageGraphicAttribute == null) {
            return false;
        }
        if (this == imageGraphicAttribute) {
            return true;
        }
        if (this.fOriginX != imageGraphicAttribute.fOriginX || this.fOriginY != imageGraphicAttribute.fOriginY) {
            return false;
        }
        if (this.getAlignment() != imageGraphicAttribute.getAlignment()) {
            return false;
        }
        return this.fImage.equals(imageGraphicAttribute.fImage);
    }

    public Rectangle2D getBounds() {
        return new Rectangle2D.Float(-this.fOriginX, -this.fOriginY, this.fImageWidth, this.fImageHeight);
    }

    public boolean equals(Object object) {
        try {
            return this.equals((ImageGraphicAttribute)object);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }
}

