/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractMidiDevice;
import com.sun.media.sound.HeadspaceInstrument;
import com.sun.media.sound.HeadspaceMixer;
import com.sun.media.sound.HeadspaceSoundbank;
import com.sun.media.sound.MidiOutDeviceProvider;
import com.sun.media.sound.MixerMidiChannel;
import com.sun.media.sound.Platform;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Patch;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import javax.sound.midi.VoiceStatus;
import javax.sound.sampled.LineUnavailableException;

abstract class AbstractPlayer
extends AbstractMidiDevice
implements Synthesizer {
    private static final String[] defaultSoundbankNames = new String[]{"soundbank-deluxe.gm", "soundbank-mid.gm", "soundbank.gm", "soundbank-min.gm"};
    private static final String soundJarName = "sound.jar";
    private static final String jmfJarName = "jmf.jar";
    private static final Class[] supportedMidiOutClasses = new Class[]{class$com$sun$media$sound$SimpleOutputDevice == null ? (class$com$sun$media$sound$SimpleOutputDevice = AbstractPlayer.class$("com.sun.media.sound.SimpleOutputDevice")) : class$com$sun$media$sound$SimpleOutputDevice, class$com$sun$media$sound$MidiOutDevice == null ? (class$com$sun$media$sound$MidiOutDevice = AbstractPlayer.class$("com.sun.media.sound.MidiOutDevice")) : class$com$sun$media$sound$MidiOutDevice};
    static HeadspaceMixer mixer = HeadspaceMixer.getMixerInstance();
    private static Soundbank defaultSoundbank = null;
    private Class[] orderedMidiOutClasses = new Class[]{class$com$sun$media$sound$SimpleOutputDevice == null ? (class$com$sun$media$sound$SimpleOutputDevice = AbstractPlayer.class$("com.sun.media.sound.SimpleOutputDevice")) : class$com$sun$media$sound$SimpleOutputDevice, class$com$sun$media$sound$MidiOutDevice == null ? (class$com$sun$media$sound$MidiOutDevice = AbstractPlayer.class$("com.sun.media.sound.MidiOutDevice")) : class$com$sun$media$sound$MidiOutDevice};
    AbstractMidiDevice internalSynth = null;
    protected MixerMidiChannel[] channels;
    private Vector instruments = new Vector();
    private Vector transmitters = new Vector();
    private Vector receivers = new Vector();
    static Class class$com$sun$media$sound$SimpleOutputDevice;
    static Class class$com$sun$media$sound$MidiOutDevice;

    public int getMaxPolyphony() {
        return HeadspaceMixer.getMixerInstance().getMidiVoices();
    }

    public int getMaxReceivers() {
        return -1;
    }

    public int getMaxTransmitters() {
        return -1;
    }

    public long getLatency() {
        return 0L;
    }

    abstract long getTimeStamp();

    public synchronized void close() {
        if (this.isOpen()) {
            int n2;
            for (n2 = 0; n2 < this.transmitters.size(); ++n2) {
                ((Transmitter)this.transmitters.elementAt(n2)).close();
            }
            this.transmitters.removeAllElements();
            for (n2 = 0; n2 < this.receivers.size(); ++n2) {
                ((Receiver)this.receivers.elementAt(n2)).close();
            }
            this.receivers.removeAllElements();
            this.open = false;
            this.implClose();
            mixer.close(this);
        }
    }

    protected void closeInternalSynth() {
        if (this.internalSynth != this) {
            this.nRemoveReceiver(this.id, this.internalSynth.getId());
            this.internalSynth.close(this);
        } else {
            this.nRemoveReceiver(this.id, 0L);
        }
        this.internalSynth = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectToInternalSynth() {
        if (this.internalSynth == null) {
            return;
        }
        if (this.internalSynth == this) {
            AbstractPlayer abstractPlayer = this;
            synchronized (abstractPlayer) {
                this.nAddReceiver(this.id, 0L);
            }
        }
        AbstractPlayer abstractPlayer = this;
        synchronized (abstractPlayer) {
            this.nAddReceiver(this.id, this.internalSynth.getId());
        }
    }

    synchronized void implClose() {
        this.closeInternalSynth();
        long l2 = this.id;
        this.id = 0L;
        for (int i2 = 0; i2 < this.channels.length; ++i2) {
            this.channels[i2].setId(this.id);
        }
        this.nClose(l2);
    }

    public synchronized void open() throws MidiUnavailableException {
        if (this.isOpen()) {
            return;
        }
        try {
            mixer.open(this);
        }
        catch (LineUnavailableException lineUnavailableException) {
            throw new MidiUnavailableException(lineUnavailableException.getMessage());
        }
        this.implOpen();
        this.open = true;
    }

    protected void openInternalSynth() throws MidiUnavailableException {
        if (this.internalSynth != null) {
            return;
        }
        for (int i2 = 0; i2 < this.orderedMidiOutClasses.length; ++i2) {
            if ((class$com$sun$media$sound$MidiOutDevice == null ? AbstractPlayer.class$("com.sun.media.sound.MidiOutDevice") : class$com$sun$media$sound$MidiOutDevice).isAssignableFrom(this.orderedMidiOutClasses[i2])) {
                this.internalSynth = this.openMidiOut();
                if (this.internalSynth == null) continue;
                return;
            }
            if (!(class$com$sun$media$sound$SimpleOutputDevice == null ? AbstractPlayer.class$("com.sun.media.sound.SimpleOutputDevice") : class$com$sun$media$sound$SimpleOutputDevice).isAssignableFrom(this.orderedMidiOutClasses[i2])) continue;
            if (defaultSoundbank == null) {
                defaultSoundbank = this.loadDefaultSoundbank();
            }
            if (defaultSoundbank == null) continue;
            this.internalSynth = this.openSoftwareSynth();
            return;
        }
        this.internalSynth = this.openSoftwareSynth();
        if (defaultSoundbank != null || (defaultSoundbank = this.loadDefaultSoundbank()) == null) {
            // empty if block
        }
    }

    boolean isUsingSoftwareSynth() {
        return this.internalSynth == this;
    }

    protected boolean parse(int n2, int n3, int n4, int n5, long l2) {
        if ((n2 & 0xF) != 0 || n2 < 128 || n2 > 224) {
            return false;
        }
        this.setTimeStamp(l2);
        switch (n2) {
            case 128: {
                this.channels[n3].noteOff(n4, n5);
                break;
            }
            case 144: {
                this.channels[n3].noteOn(n4, n5);
                break;
            }
            case 160: {
                this.channels[n3].setPolyPressure(n4, n5);
                break;
            }
            case 176: {
                this.channels[n3].controlChange(n4, n5);
                break;
            }
            case 192: {
                this.channels[n3].programChange(n4);
                break;
            }
            case 208: {
                this.channels[n3].setChannelPressure(n4);
                break;
            }
            case 224: {
                this.channels[n3].setPitchBend((n5 & 0x7F) << 7 | n4 & 0x7F);
            }
        }
        return true;
    }

    protected native void nClose(long var1);

    abstract void setTimeStamp(long var1);

    private native boolean nLoadInstrument(long var1, int var3);

    private native boolean nUnloadInstrument(long var1, int var3);

    private native boolean nRemapInstrument(long var1, int var3, int var4);

    protected native void nAddReceiver(long var1, long var3);

    protected native void nRemoveReceiver(long var1, long var3);

    protected AbstractMidiDevice openMidiOut() {
        MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
        for (int i2 = 0; i2 < infoArray.length; ++i2) {
            if (!(infoArray[i2] instanceof MidiOutDeviceProvider.MidiOutDeviceInfo)) continue;
            try {
                AbstractMidiDevice abstractMidiDevice = (AbstractMidiDevice)MidiSystem.getMidiDevice(infoArray[i2]);
                abstractMidiDevice.open();
                return abstractMidiDevice;
            }
            catch (MidiUnavailableException midiUnavailableException) {
                // empty catch block
            }
        }
        return null;
    }

    protected AbstractMidiDevice openSoftwareSynth() {
        return this;
    }

    public Class[] getMidiOutClasses() {
        return this.orderedMidiOutClasses;
    }

    public void setMidiOutClasses(Class[] classArray) {
        boolean bl2 = false;
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            bl2 = false;
            for (int i3 = 0; i3 < supportedMidiOutClasses.length; ++i3) {
                if (!supportedMidiOutClasses[i3].isAssignableFrom(classArray[i2])) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            throw new IllegalArgumentException("Unsupported class for midi out services: " + classArray[i2]);
        }
        this.orderedMidiOutClasses = classArray;
    }

    public Instrument[] getAvailableInstruments() {
        if (defaultSoundbank != null) {
            return defaultSoundbank.getInstruments();
        }
        return new Instrument[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instrument[] getLoadedInstruments() {
        Instrument[] instrumentArray;
        Vector vector = this.instruments;
        synchronized (vector) {
            instrumentArray = new Instrument[this.instruments.size()];
            for (int i2 = 0; i2 < instrumentArray.length; ++i2) {
                instrumentArray[i2] = (Instrument)this.instruments.elementAt(i2);
            }
        }
        return instrumentArray;
    }

    public void unloadInstrument(Instrument instrument) {
        try {
            if (this.nUnloadInstrument(this.id, ((HeadspaceInstrument)instrument).getId())) {
                this.instruments.removeElement(instrument);
            }
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Unsupported soundbank: " + instrument.getSoundbank());
        }
    }

    public boolean loadInstrument(Instrument instrument) {
        if (this.instruments.contains(instrument)) {
            return true;
        }
        try {
            if (this.nLoadInstrument(this.id, ((HeadspaceInstrument)instrument).getId())) {
                this.instruments.addElement(instrument);
                return true;
            }
            return false;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Unsupported soundbank: " + instrument.getSoundbank());
        }
    }

    public MidiChannel[] getChannels() {
        MidiChannel[] midiChannelArray = new MidiChannel[this.channels.length];
        System.arraycopy(this.channels, 0, midiChannelArray, 0, this.channels.length);
        return midiChannelArray;
    }

    protected AbstractPlayer(MidiDevice.Info info) {
        super(info);
        this.channels = new MixerMidiChannel[16];
        for (int i2 = 0; i2 < this.channels.length; ++i2) {
            this.channels[i2] = new MixerMidiChannel(this, i2);
        }
    }

    public synchronized Receiver getReceiver() throws MidiUnavailableException {
        PlayerReceiver playerReceiver = new PlayerReceiver(this);
        this.receivers.addElement(playerReceiver);
        return playerReceiver;
    }

    public Soundbank getDefaultSoundbank() {
        return defaultSoundbank;
    }

    private Soundbank loadDefaultSoundbank() {
        HeadspaceSoundbank headspaceSoundbank = null;
        for (int i2 = 0; i2 < defaultSoundbankNames.length; ++i2) {
            String string;
            String string2 = defaultSoundbankNames[i2];
            try {
                string = "file:" + string2;
                URL uRL = new URL(string);
                headspaceSoundbank = new HeadspaceSoundbank(uRL);
                if (headspaceSoundbank != null) {
                    break;
                }
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            String string3 = Platform.getClasspath();
            StringTokenizer stringTokenizer = new StringTokenizer(string3, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens() && headspaceSoundbank == null) {
                String string4 = stringTokenizer.nextToken();
                String string5 = string4.substring(string4.lastIndexOf(File.separatorChar) + 1, string4.length());
                if (!string5.equals(soundJarName) && !string5.equals(jmfJarName)) continue;
                string = string4.substring(0, string4.lastIndexOf(File.separatorChar));
                string = string + File.separatorChar + string2;
                try {
                    headspaceSoundbank = new HeadspaceSoundbank(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            if (headspaceSoundbank != null) break;
            string = Platform.getJavahome();
            string = string + File.separatorChar + "lib" + File.separatorChar + "audio" + File.separatorChar + string2;
            try {
                headspaceSoundbank = new HeadspaceSoundbank(string);
                if (headspaceSoundbank == null) continue;
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return headspaceSoundbank;
    }

    public void unloadAllInstruments(Soundbank soundbank) {
        Instrument[] instrumentArray = soundbank.getInstruments();
        for (int i2 = 0; i2 < instrumentArray.length; ++i2) {
            this.unloadInstrument(instrumentArray[i2]);
        }
    }

    public boolean isSoundbankSupported(Soundbank soundbank) {
        return soundbank instanceof HeadspaceSoundbank;
    }

    public boolean loadAllInstruments(Soundbank soundbank) {
        boolean bl2 = true;
        Instrument[] instrumentArray = soundbank.getInstruments();
        for (int i2 = 0; i2 < instrumentArray.length; ++i2) {
            if (this.loadInstrument(instrumentArray[i2])) continue;
            bl2 = false;
        }
        return bl2;
    }

    public synchronized Transmitter getTransmitter() throws MidiUnavailableException {
        PlayerOutTransmitter playerOutTransmitter = new PlayerOutTransmitter(this);
        this.transmitters.addElement(playerOutTransmitter);
        return playerOutTransmitter;
    }

    public VoiceStatus[] getVoiceStatus() {
        return new VoiceStatus[0];
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static Vector access$000(AbstractPlayer abstractPlayer) {
        return abstractPlayer.transmitters;
    }

    static Vector access$100(AbstractPlayer abstractPlayer) {
        return abstractPlayer.receivers;
    }

    public boolean remapInstrument(Instrument instrument, Instrument instrument2) {
        try {
            return this.nRemapInstrument(this.id, ((HeadspaceInstrument)instrument).getId(), ((HeadspaceInstrument)instrument2).getId());
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Unsupported soundbank: " + instrument.getSoundbank() + " or " + instrument2.getSoundbank());
        }
    }

    public void unloadInstruments(Soundbank soundbank, Patch[] patchArray) {
        for (int i2 = 0; i2 < patchArray.length; ++i2) {
            Instrument instrument = soundbank.getInstrument(patchArray[i2]);
            if (instrument == null) continue;
            this.unloadInstrument(instrument);
        }
    }

    public boolean loadInstruments(Soundbank soundbank, Patch[] patchArray) {
        boolean bl2 = true;
        for (int i2 = 0; i2 < patchArray.length; ++i2) {
            Instrument instrument = soundbank.getInstrument(patchArray[i2]);
            if (instrument != null) {
                if (this.loadInstrument(instrument)) continue;
                bl2 = false;
                continue;
            }
            bl2 = false;
        }
        return bl2;
    }

    class PlayerOutTransmitter
    implements Transmitter {
        private boolean open;
        private Receiver receiver;
        private final AbstractPlayer this$0;

        public void close() {
            AbstractPlayer.access$000(this.this$0).removeElement(this);
            this.open = false;
        }

        PlayerOutTransmitter(AbstractPlayer abstractPlayer) {
            this.this$0 = abstractPlayer;
            this.open = true;
            this.receiver = null;
        }

        public Receiver getReceiver() {
            return this.receiver;
        }

        public void setReceiver(Receiver receiver) {
            this.receiver = receiver;
        }
    }

    class PlayerReceiver
    implements Receiver {
        private boolean open;
        private final AbstractPlayer this$0;

        public void close() {
            AbstractPlayer.access$100(this.this$0).removeElement(this);
            this.open = false;
        }

        PlayerReceiver(AbstractPlayer abstractPlayer) {
            this.this$0 = abstractPlayer;
            this.open = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(MidiMessage midiMessage, long l2) {
            if (!this.open) {
                return;
            }
            if (this.this$0.id == 0L) {
                throw new IllegalStateException("Synthesizer is not open.");
            }
            Cloneable cloneable = AbstractPlayer.access$000(this.this$0);
            synchronized (cloneable) {
                for (int i2 = 0; i2 < AbstractPlayer.access$000(this.this$0).size(); ++i2) {
                    Receiver receiver = ((Transmitter)AbstractPlayer.access$000(this.this$0).elementAt(i2)).getReceiver();
                    if (receiver == null) continue;
                    receiver.send(midiMessage, l2);
                }
            }
            if (!(midiMessage instanceof ShortMessage)) {
                return;
            }
            cloneable = (ShortMessage)midiMessage;
            this.this$0.parse(((ShortMessage)cloneable).getCommand(), ((ShortMessage)cloneable).getChannel(), ((ShortMessage)cloneable).getData1(), ((ShortMessage)cloneable).getData2(), l2);
        }
    }
}

