/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsTextUI;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;

public class WindowsTextFieldUI
extends BasicTextFieldUI {
    protected void paintBackground(Graphics graphics) {
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            JTextComponent jTextComponent = this.getComponent();
            String string = !jTextComponent.isEnabled() ? "edit.edittext(disabled).fillcolor" : (!jTextComponent.isEditable() ? "edit.edittext(readonly).fillcolor" : "edit.fillcolor");
            graphics.setColor(xPStyle.getColor(string, jTextComponent.getBackground()));
            graphics.fillRect(0, 0, jTextComponent.getWidth(), jTextComponent.getHeight());
        } else {
            super.paintBackground(graphics);
        }
    }

    protected Caret createCaret() {
        return new WindowsFieldCaret();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsTextFieldUI();
    }

    static class WindowsFieldCaret
    extends DefaultCaret
    implements UIResource {
        protected void adjustVisibility(Rectangle rectangle) {
            SwingUtilities.invokeLater(new SafeScroller(this, rectangle));
        }

        protected Highlighter.HighlightPainter getSelectionPainter() {
            return WindowsTextUI.WindowsPainter;
        }

        static void access$100(WindowsFieldCaret windowsFieldCaret, Rectangle rectangle) {
            windowsFieldCaret.damage(rectangle);
        }

        static JTextComponent access$000(WindowsFieldCaret windowsFieldCaret) {
            return windowsFieldCaret.getComponent();
        }

        private class SafeScroller
        implements Runnable {
            private Rectangle r;
            private final WindowsFieldCaret this$0;

            public void run() {
                JTextField jTextField = (JTextField)WindowsFieldCaret.access$000(this.this$0);
                if (jTextField != null) {
                    TextUI textUI = jTextField.getUI();
                    int n2 = this.this$0.getDot();
                    Position.Bias bias = Position.Bias.Forward;
                    Rectangle rectangle = null;
                    try {
                        rectangle = textUI.modelToView(jTextField, n2, bias);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    BoundedRangeModel boundedRangeModel = jTextField.getHorizontalVisibility();
                    int n3 = this.r.x + boundedRangeModel.getValue();
                    int n4 = boundedRangeModel.getExtent() / 4;
                    if (n3 < boundedRangeModel.getValue()) {
                        boundedRangeModel.setValue(n3 - n4);
                    } else if (n3 > boundedRangeModel.getValue() + boundedRangeModel.getExtent()) {
                        boundedRangeModel.setValue(n3 - 3 * n4);
                    }
                    if (rectangle != null) {
                        try {
                            Rectangle rectangle2 = textUI.modelToView(jTextField, n2, bias);
                            if (rectangle2 != null && !rectangle2.equals(rectangle)) {
                                WindowsFieldCaret.access$100(this.this$0, rectangle2);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                }
            }

            SafeScroller(WindowsFieldCaret windowsFieldCaret, Rectangle rectangle) {
                this.this$0 = windowsFieldCaret;
                this.r = rectangle;
            }
        }
    }
}

