/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.LazyActionMap;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthArrowButton;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthPainter;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.UIResource;

class SynthSplitPaneUI
extends SplitPaneUI
implements SynthUI {
    private static final String NON_CONTINUOUS_DIVIDER = "nonContinuousDivider";
    protected static int KEYBOARD_DIVIDER_MOVE_OFFSET = 3;
    protected JSplitPane splitPane;
    protected Divider divider;
    protected PropertyChangeListener propertyChangeListener;
    protected FocusListener focusListener;
    private static Set managingFocusForwardTraversalKeys;
    private static Set managingFocusBackwardTraversalKeys;
    protected int dividerSize;
    protected Component nonContinuousLayoutDivider;
    protected boolean draggingHW;
    protected int beginDragDividerLocation;
    private int orientation;
    private int lastDragLocation;
    private boolean continuousLayout;
    private boolean dividerKeyboardResize;
    private boolean dividerLocationIsSet;
    private boolean rememberPaneSizes;
    boolean painted;
    boolean ignoreDividerLocationChange;
    private SynthStyle style;
    private SynthStyle dividerStyle;
    private int oneTouchSize;
    private int oneTouchOffset;
    private static final Cursor horizontalCursor;
    private static final Cursor verticalCursor;
    private static final Cursor defaultCursor;
    static Class class$com$sun$java$swing$plaf$gtk$SynthSplitPaneUI;
    static Class class$com$sun$java$swing$plaf$gtk$SynthContext;
    static Class class$javax$swing$JSplitPane;

    int getKeyboardMoveIncrement() {
        return KEYBOARD_DIVIDER_MOVE_OFFSET;
    }

    public int getLastDragLocation() {
        return this.lastDragLocation;
    }

    public int getOrientation() {
        return this.orientation;
    }

    static {
        horizontalCursor = Cursor.getPredefinedCursor(11);
        verticalCursor = Cursor.getPredefinedCursor(9);
        defaultCursor = Cursor.getPredefinedCursor(0);
    }

    SynthSplitPaneUI() {
    }

    private void addHeavyweightDivider() {
        if (this.nonContinuousLayoutDivider != null && this.splitPane != null) {
            Component component = this.splitPane.getLeftComponent();
            Component component2 = this.splitPane.getRightComponent();
            int n2 = this.splitPane.getDividerLocation();
            if (component != null) {
                this.splitPane.setLeftComponent(null);
            }
            if (component2 != null) {
                this.splitPane.setRightComponent(null);
            }
            this.splitPane.remove(this.divider);
            this.splitPane.add(this.nonContinuousLayoutDivider, NON_CONTINUOUS_DIVIDER, this.splitPane.getComponentCount());
            this.splitPane.setLeftComponent(component);
            this.splitPane.setRightComponent(component2);
            this.splitPane.add((Component)this.divider, "divider");
            if (this.rememberPaneSizes) {
                this.splitPane.setDividerLocation(n2);
            }
        }
    }

    protected void installComponents() {
        this.divider = new Divider(this, this.splitPane);
        this.splitPane.add((Component)this.divider, "divider");
    }

    protected void installDefaults() {
        this.setOrientation(this.splitPane.getOrientation());
        this.setContinuousLayout(this.splitPane.isContinuousLayout());
        this.fetchStyle(this.splitPane);
        this.resetLayoutManager();
        if (this.nonContinuousLayoutDivider == null) {
            this.setNonContinuousLayoutDivider(this.createDefaultNonContinuousLayoutDivider(), true);
        } else {
            this.setNonContinuousLayoutDivider(this.nonContinuousLayoutDivider, true);
        }
        if (managingFocusForwardTraversalKeys == null) {
            managingFocusForwardTraversalKeys = new TreeSet();
            managingFocusForwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 0));
        }
        this.splitPane.setFocusTraversalKeys(0, managingFocusForwardTraversalKeys);
        if (managingFocusBackwardTraversalKeys == null) {
            managingFocusBackwardTraversalKeys = new TreeSet();
            managingFocusBackwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 1));
        }
        this.splitPane.setFocusTraversalKeys(1, managingFocusBackwardTraversalKeys);
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.splitPane, 1, inputMap);
        LazyActionMap.installLazyActionMap(this.splitPane, class$com$sun$java$swing$plaf$gtk$SynthSplitPaneUI == null ? (class$com$sun$java$swing$plaf$gtk$SynthSplitPaneUI = SynthSplitPaneUI.class$("com.sun.java.swing.plaf.gtk.SynthSplitPaneUI")) : class$com$sun$java$swing$plaf$gtk$SynthSplitPaneUI, "SplitPane.actionMap");
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.splitPane.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.splitPane.addFocusListener(this.focusListener);
        }
    }

    protected void resetLayoutManager() {
        SplitPaneLayoutManager splitPaneLayoutManager = this.orientation == 1 ? new SplitPaneLayoutManager(this, 0) : new SplitPaneLayoutManager(this, 1);
        this.splitPane.setLayout(splitPaneLayoutManager);
        splitPaneLayoutManager.updateComponents();
        this.splitPane.revalidate();
        this.splitPane.repaint();
    }

    protected void startDragging() {
        ComponentPeer componentPeer;
        Component component = this.splitPane.getLeftComponent();
        Component component2 = this.splitPane.getRightComponent();
        this.beginDragDividerLocation = this.getDividerLocation(this.splitPane);
        this.draggingHW = false;
        if (component != null && (componentPeer = component.getPeer()) != null && !(componentPeer instanceof LightweightPeer)) {
            this.draggingHW = true;
        } else if (component2 != null && (componentPeer = component2.getPeer()) != null && !(componentPeer instanceof LightweightPeer)) {
            this.draggingHW = true;
        }
        if (this.orientation == 1) {
            this.setLastDragLocation(this.divider.getBounds().x);
            this.dividerSize = this.divider.getSize().width;
            if (!this.isContinuousLayout() && this.draggingHW) {
                this.nonContinuousLayoutDivider.setBounds(this.getLastDragLocation(), 0, this.dividerSize, this.splitPane.getHeight());
                this.addHeavyweightDivider();
            }
        } else {
            this.setLastDragLocation(this.divider.getBounds().y);
            this.dividerSize = this.divider.getSize().height;
            if (!this.isContinuousLayout() && this.draggingHW) {
                this.nonContinuousLayoutDivider.setBounds(0, this.getLastDragLocation(), this.splitPane.getWidth(), this.dividerSize);
                this.addHeavyweightDivider();
            }
        }
    }

    private void uninstallComponents() {
        if (this.nonContinuousLayoutDivider != null) {
            this.splitPane.remove(this.nonContinuousLayoutDivider);
        }
        this.splitPane.remove(this.divider);
        this.divider = null;
    }

    protected void uninstallDefaults() {
        if (this.splitPane.getLayout() instanceof UIResource) {
            this.splitPane.setLayout(null);
        }
        SynthContext synthContext = this.getContext((JComponent)this.splitPane, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
        synthContext = this.getContext(this.splitPane, Region.SPLIT_PANE_DIVIDER, 1);
        this.dividerStyle.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.dividerStyle = null;
        this.nonContinuousLayoutDivider = null;
        this.setNonContinuousLayoutDivider(null);
        this.splitPane.setFocusTraversalKeys(0, null);
        this.splitPane.setFocusTraversalKeys(1, null);
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.splitPane, null);
        SwingUtilities.replaceUIInputMap(this.splitPane, 1, null);
    }

    protected void uninstallListeners() {
        if (this.propertyChangeListener != null) {
            this.splitPane.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        if (this.focusListener != null) {
            this.splitPane.removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
    }

    public boolean isContinuousLayout() {
        return this.continuousLayout;
    }

    protected void dragDividerTo(int n2) {
        if (this.getLastDragLocation() != n2) {
            if (this.isContinuousLayout()) {
                this.splitPane.setDividerLocation(n2);
                this.setLastDragLocation(n2);
            } else {
                int n3 = this.getLastDragLocation();
                this.setLastDragLocation(n2);
                if (this.orientation == 1) {
                    if (this.draggingHW) {
                        this.nonContinuousLayoutDivider.setLocation(this.getLastDragLocation(), 0);
                    } else {
                        int n4 = this.splitPane.getHeight();
                        this.splitPane.repaint(n3, 0, this.dividerSize, n4);
                        this.splitPane.repaint(n2, 0, this.dividerSize, n4);
                    }
                } else if (this.draggingHW) {
                    this.nonContinuousLayoutDivider.setLocation(0, this.getLastDragLocation());
                } else {
                    int n5 = this.splitPane.getWidth();
                    this.splitPane.repaint(0, n3, n5, this.dividerSize);
                    this.splitPane.repaint(0, n2, n5, this.dividerSize);
                }
            }
        }
    }

    protected void finishDraggingTo(int n2) {
        this.dragDividerTo(n2);
        this.setLastDragLocation(-1);
        if (!this.isContinuousLayout()) {
            Component component = this.splitPane.getLeftComponent();
            Rectangle rectangle = component.getBounds();
            if (this.draggingHW) {
                if (this.orientation == 1) {
                    this.nonContinuousLayoutDivider.setLocation(-this.dividerSize, 0);
                } else {
                    this.nonContinuousLayoutDivider.setLocation(0, -this.dividerSize);
                }
                this.splitPane.remove(this.nonContinuousLayoutDivider);
            }
            this.splitPane.setDividerLocation(n2);
        }
    }

    public void setLastDragLocation(int n2) {
        this.lastDragLocation = n2;
    }

    public void setOrientation(int n2) {
        this.orientation = n2;
    }

    public void setContinuousLayout(boolean bl2) {
        this.continuousLayout = bl2;
    }

    static int access$100(SynthSplitPaneUI synthSplitPaneUI) {
        return synthSplitPaneUI.orientation;
    }

    static int access$1200(SynthSplitPaneUI synthSplitPaneUI) {
        return synthSplitPaneUI.oneTouchOffset;
    }

    static int access$800(SynthSplitPaneUI synthSplitPaneUI) {
        return synthSplitPaneUI.oneTouchSize;
    }

    static boolean access$200(SynthSplitPaneUI synthSplitPaneUI) {
        return synthSplitPaneUI.dividerKeyboardResize;
    }

    static boolean access$400(SynthSplitPaneUI synthSplitPaneUI) {
        return synthSplitPaneUI.dividerLocationIsSet;
    }

    static int access$102(SynthSplitPaneUI synthSplitPaneUI, int n2) {
        synthSplitPaneUI.orientation = n2;
        return synthSplitPaneUI.orientation;
    }

    static boolean access$202(SynthSplitPaneUI synthSplitPaneUI, boolean bl2) {
        synthSplitPaneUI.dividerKeyboardResize = bl2;
        return synthSplitPaneUI.dividerKeyboardResize;
    }

    static boolean access$402(SynthSplitPaneUI synthSplitPaneUI, boolean bl2) {
        synthSplitPaneUI.dividerLocationIsSet = bl2;
        return synthSplitPaneUI.dividerLocationIsSet;
    }

    protected Component createDefaultNonContinuousLayoutDivider() {
        return new Canvas(this){
            private final SynthSplitPaneUI this$0;
            {
                this.this$0 = synthSplitPaneUI;
            }

            public void paint(Graphics graphics) {
                SynthSplitPaneUI.access$300(this.this$0, graphics, 0, 0, this.getWidth(), this.getHeight());
            }
        };
    }

    public Component getNonContinuousLayoutDivider() {
        return this.nonContinuousLayoutDivider;
    }

    protected void setNonContinuousLayoutDivider(Component component) {
        this.setNonContinuousLayoutDivider(component, true);
    }

    protected void setNonContinuousLayoutDivider(Component component, boolean bl2) {
        this.rememberPaneSizes = bl2;
        if (this.nonContinuousLayoutDivider != null && this.splitPane != null) {
            this.splitPane.remove(this.nonContinuousLayoutDivider);
        }
        this.nonContinuousLayoutDivider = component;
    }

    static Cursor access$500() {
        return horizontalCursor;
    }

    static Cursor access$600() {
        return verticalCursor;
    }

    static Cursor access$900() {
        return defaultCursor;
    }

    private void paintDragDivider(Graphics graphics, int n2, int n3, int n4, int n5) {
        SynthContext synthContext = this.getContext((JComponent)this.splitPane, Region.SPLIT_PANE_DIVIDER);
        synthContext.setComponentState((synthContext.getComponentState() | 2) ^ 2 | 4);
        SynthPainter synthPainter = (SynthPainter)synthContext.getStyle().get(synthContext, "SplitPane.dragPainter");
        if (synthPainter != null) {
            synthPainter.paint(synthContext, "foreground", graphics, n2, n3, n4, n5);
        }
        synthContext.dispose();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler(this);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyHandler(this);
    }

    public static void loadActionMap(ActionMap actionMap) {
        actionMap.put("negativeIncrement", new KeyboardUpLeftAction());
        actionMap.put("positiveIncrement", new KeyboardDownRightAction());
        actionMap.put("selectMin", new KeyboardHomeAction());
        actionMap.put("selectMax", new KeyboardEndAction());
        actionMap.put("startResize", new KeyboardResizeToggleAction());
        actionMap.put("toggleFocus", new ToggleSideFocusAction());
        actionMap.put("focusOutForward", new MoveFocusOutAction(1));
        actionMap.put("focusOutBackward", new MoveFocusOutAction(-1));
    }

    InputMap getInputMap(int n2) {
        if (n2 == 1) {
            SynthContext synthContext = this.getContext((JComponent)this.splitPane, 1);
            InputMap inputMap = (InputMap)synthContext.getStyle().get(synthContext, "SplitPane.ancestorInputMap");
            synthContext.dispose();
            return inputMap;
        }
        return null;
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.splitPane = (JSplitPane)jComponent;
        this.dividerLocationIsSet = false;
        this.dividerKeyboardResize = false;
        this.installComponents();
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
        this.setLastDragLocation(-1);
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
        this.dividerLocationIsSet = false;
        this.dividerKeyboardResize = false;
        this.splitPane = null;
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public int getDividerLocation(JSplitPane jSplitPane) {
        if (this.orientation == 1) {
            return this.divider.getX();
        }
        return this.divider.getY();
    }

    public int getMaximumDividerLocation(JSplitPane jSplitPane) {
        Dimension dimension = this.splitPane.getSize();
        int n2 = 0;
        Component component = this.splitPane.getRightComponent();
        if (component != null) {
            Insets insets = this.splitPane.getInsets();
            Dimension dimension2 = new Dimension(0, 0);
            if (component.isVisible()) {
                dimension2 = component.getMinimumSize();
            }
            n2 = this.orientation == 1 ? dimension.width - dimension2.width : dimension.height - dimension2.height;
            n2 -= this.dividerSize;
            if (insets != null) {
                n2 = this.orientation == 1 ? (n2 -= insets.right) : (n2 -= insets.top);
            }
        }
        return Math.max(this.getMinimumDividerLocation(this.splitPane), n2);
    }

    public int getMinimumDividerLocation(JSplitPane jSplitPane) {
        int n2 = 0;
        Component component = this.splitPane.getLeftComponent();
        if (component != null && component.isVisible()) {
            Insets insets = this.splitPane.getInsets();
            Dimension dimension = component.getMinimumSize();
            n2 = this.orientation == 1 ? dimension.width : dimension.height;
            if (insets != null) {
                n2 = this.orientation == 1 ? (n2 += insets.left) : (n2 += insets.top);
            }
        }
        return n2;
    }

    private void fetchStyle(JSplitPane jSplitPane) {
        SynthContext synthContext = this.getContext((JComponent)jSplitPane, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            jSplitPane.setDividerSize((Integer)this.style.get(synthContext, "SplitPaneDivider.size"));
            this.divider.setDividerSize(jSplitPane.getDividerSize());
        }
        synthContext.dispose();
        synthContext = this.getContext(jSplitPane, Region.SPLIT_PANE_DIVIDER, 1);
        this.dividerStyle = SynthLookAndFeel.updateStyle(synthContext, this);
        this.divider.setOpaque(this.dividerStyle.isOpaque(synthContext));
        this.oneTouchSize = this.dividerStyle.getInt(synthContext, "SplitPaneDivider.oneTouchButtonSize", 6);
        this.oneTouchOffset = this.dividerStyle.getInt(synthContext, "SplitPaneDivider.oneTouchOffset", 6);
        synthContext.dispose();
    }

    public void resetToPreferredSizes(JSplitPane jSplitPane) {
        if (this.splitPane != null) {
            LayoutManager layoutManager = jSplitPane.getLayout();
            if (layoutManager instanceof SplitPaneLayoutManager) {
                ((SplitPaneLayoutManager)layoutManager).resetToPreferredSizes();
            }
            this.splitPane.revalidate();
            this.splitPane.repaint();
        }
    }

    public void setDividerLocation(JSplitPane jSplitPane, int n2) {
        if (!this.ignoreDividerLocationChange) {
            this.dividerLocationIsSet = true;
            this.splitPane.revalidate();
            this.splitPane.repaint();
        } else {
            this.ignoreDividerLocationChange = false;
        }
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent, Region region) {
        int n2 = SynthLookAndFeel.getComponentState(jComponent);
        if (this.divider.isMouseOver()) {
            n2 |= 2;
        }
        return n2;
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(class$com$sun$java$swing$plaf$gtk$SynthContext == null ? (class$com$sun$java$swing$plaf$gtk$SynthContext = SynthSplitPaneUI.class$("com.sun.java.swing.plaf.gtk.SynthContext")) : class$com$sun$java$swing$plaf$gtk$SynthContext, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n2);
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        if (!this.painted && this.splitPane.getDividerLocation() < 0) {
            this.ignoreDividerLocationChange = true;
            this.splitPane.setDividerLocation(this.getDividerLocation(this.splitPane));
        }
        this.painted = true;
    }

    static void access$300(SynthSplitPaneUI synthSplitPaneUI, Graphics graphics, int n2, int n3, int n4, int n5) {
        synthSplitPaneUI.paintDragDivider(graphics, n2, n3, n4, n5);
    }

    public void finishedPaintingChildren(JSplitPane jSplitPane, Graphics graphics) {
        if (jSplitPane == this.splitPane && this.getLastDragLocation() != -1 && !this.isContinuousLayout() && !this.draggingHW) {
            if (this.orientation == 1) {
                this.paintDragDivider(graphics, this.getLastDragLocation(), 0, this.dividerSize - 1, this.splitPane.getHeight() - 1);
            } else {
                this.paintDragDivider(graphics, 0, this.lastDragLocation, this.splitPane.getWidth() - 1, this.dividerSize - 1);
            }
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    static void access$000(SynthSplitPaneUI synthSplitPaneUI, JSplitPane jSplitPane) {
        synthSplitPaneUI.fetchStyle(jSplitPane);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthSplitPaneUI();
    }

    private SynthContext getContext(JComponent jComponent, Region region) {
        return this.getContext(jComponent, region, this.getComponentState(jComponent, region));
    }

    private SynthContext getContext(JComponent jComponent, Region region, int n2) {
        return SynthContext.getContext(class$com$sun$java$swing$plaf$gtk$SynthContext == null ? (class$com$sun$java$swing$plaf$gtk$SynthContext = SynthSplitPaneUI.class$("com.sun.java.swing.plaf.gtk.SynthContext")) : class$com$sun$java$swing$plaf$gtk$SynthContext, jComponent, region, this.style, n2);
    }

    static SynthContext access$700(SynthSplitPaneUI synthSplitPaneUI, JComponent jComponent, Region region) {
        return synthSplitPaneUI.getContext(jComponent, region);
    }

    private class Divider
    extends JComponent
    implements PropertyChangeListener {
        protected DragController dragger;
        protected int dividerSize;
        protected Component hiddenDivider;
        protected MouseHandler mouseHandler;
        protected SynthArrowButton leftButton;
        protected SynthArrowButton rightButton;
        private boolean mouseOver;
        private final SynthSplitPaneUI this$0;

        public int getDividerSize() {
            return this.dividerSize;
        }

        protected void oneTouchExpandableChanged() {
            if (this.this$0.splitPane.isOneTouchExpandable() && this.leftButton == null && this.rightButton == null) {
                this.leftButton = this.createLeftOneTouchButton();
                this.leftButton.setDirection(this.mapDirection(true));
                if (this.leftButton != null) {
                    this.leftButton.addActionListener(new OneTouchActionHandler(this, true));
                }
                this.rightButton = this.createRightOneTouchButton();
                if (this.rightButton != null) {
                    this.rightButton.setDirection(this.mapDirection(false));
                    this.rightButton.addActionListener(new OneTouchActionHandler(this, false));
                }
                if (this.leftButton != null && this.rightButton != null) {
                    this.add(this.leftButton);
                    this.add(this.rightButton);
                }
            }
            this.revalidate();
        }

        public boolean isMouseOver() {
            return this.mouseOver;
        }

        public void setDividerSize(int n2) {
            this.dividerSize = n2;
        }

        private int mapDirection(boolean bl2) {
            if (bl2) {
                if (this.this$0.splitPane.getOrientation() == 1) {
                    return 7;
                }
                return 1;
            }
            if (this.this$0.splitPane.getOrientation() == 1) {
                return 3;
            }
            return 5;
        }

        protected SynthArrowButton createLeftOneTouchButton() {
            SynthArrowButton synthArrowButton = new SynthArrowButton(1);
            synthArrowButton.setName("SplitPaneDivider.leftOneTouchButton");
            synthArrowButton.setMinimumSize(new Dimension(SynthSplitPaneUI.access$800(this.this$0), SynthSplitPaneUI.access$800(this.this$0)));
            synthArrowButton.setCursor(SynthSplitPaneUI.access$900());
            synthArrowButton.setFocusPainted(false);
            synthArrowButton.setBorderPainted(false);
            synthArrowButton.setRequestFocusEnabled(false);
            return synthArrowButton;
        }

        protected SynthArrowButton createRightOneTouchButton() {
            SynthArrowButton synthArrowButton = new SynthArrowButton(1);
            synthArrowButton.setMinimumSize(new Dimension(SynthSplitPaneUI.access$800(this.this$0), SynthSplitPaneUI.access$800(this.this$0)));
            synthArrowButton.setCursor(SynthSplitPaneUI.access$900());
            synthArrowButton.setFocusPainted(false);
            synthArrowButton.setBorderPainted(false);
            synthArrowButton.setRequestFocusEnabled(false);
            return synthArrowButton;
        }

        static boolean access$1102(Divider divider, boolean bl2) {
            divider.mouseOver = bl2;
            return divider.mouseOver;
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            if (SynthSplitPaneUI.access$100(this.this$0) == 1) {
                return new Dimension(this.getDividerSize(), 1);
            }
            return new Dimension(1, this.getDividerSize());
        }

        public void paintComponent(Graphics graphics) {
            SynthContext synthContext = SynthSplitPaneUI.access$700(this.this$0, this.this$0.splitPane, Region.SPLIT_PANE_DIVIDER);
            Rectangle rectangle = this.getBounds();
            rectangle.y = 0;
            rectangle.x = 0;
            SynthLookAndFeel.updateSubregion(synthContext, graphics, rectangle);
            SynthPainter synthPainter = (SynthPainter)synthContext.getStyle().get(synthContext, "foreground");
            if (synthPainter != null) {
                synthPainter.paint(synthContext, "foreground", graphics, 0, 0, this.getWidth(), this.getHeight());
            }
            synthContext.dispose();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == this.this$0.splitPane) {
                if (propertyChangeEvent.getPropertyName().equals("orientation")) {
                    SynthSplitPaneUI.access$102(this.this$0, this.this$0.splitPane.getOrientation());
                    this.setCursor(SynthSplitPaneUI.access$100(this.this$0) == 1 ? SynthSplitPaneUI.access$500() : SynthSplitPaneUI.access$600());
                    if (this.leftButton != null) {
                        this.leftButton.setDirection(this.mapDirection(true));
                    }
                    if (this.rightButton != null) {
                        this.rightButton.setDirection(this.mapDirection(false));
                    }
                    this.revalidate();
                } else if (propertyChangeEvent.getPropertyName().equals("oneTouchExpandable")) {
                    this.oneTouchExpandableChanged();
                }
            }
        }

        public String getUIClassID() {
            return "SplitPaneDividerUI";
        }

        static SynthSplitPaneUI access$1000(Divider divider) {
            return divider.this$0;
        }

        public Divider(SynthSplitPaneUI synthSplitPaneUI, JSplitPane jSplitPane) {
            this.this$0 = synthSplitPaneUI;
            this.dividerSize = 0;
            this.setLayout(new DividerLayout(this));
            int n2 = jSplitPane.getOrientation();
            this.setCursor(n2 == 1 ? SynthSplitPaneUI.access$500() : SynthSplitPaneUI.access$600());
            this.mouseHandler = new MouseHandler(this);
            jSplitPane.addMouseListener(this.mouseHandler);
            jSplitPane.addMouseMotionListener(this.mouseHandler);
            this.addMouseListener(this.mouseHandler);
            this.addMouseMotionListener(this.mouseHandler);
            jSplitPane.addPropertyChangeListener(this);
            if (jSplitPane.isOneTouchExpandable()) {
                this.oneTouchExpandableChanged();
            }
        }

        protected class DividerLayout
        implements LayoutManager {
            private final Divider this$1;

            protected DividerLayout(Divider divider) {
                this.this$1 = divider;
            }

            public void removeLayoutComponent(Component component) {
            }

            public void layoutContainer(Container container) {
                if (this.this$1.leftButton != null && this.this$1.rightButton != null && container == this.this$1) {
                    if (Divider.access$1000((Divider)this.this$1).splitPane.isOneTouchExpandable()) {
                        Insets insets = container.getInsets();
                        if (SynthSplitPaneUI.access$100(Divider.access$1000(this.this$1)) == 0) {
                            int n2 = insets != null ? insets.left : 0;
                            int n3 = this.this$1.getHeight();
                            if (insets != null) {
                                n3 -= insets.top + insets.bottom;
                                n3 = Math.max(n3, 0);
                            }
                            n3 = Math.min(n3, SynthSplitPaneUI.access$800(Divider.access$1000(this.this$1)));
                            int n4 = (container.getSize().height - n3) / 2;
                            this.this$1.leftButton.setBounds(n2 + SynthSplitPaneUI.access$1200(Divider.access$1000(this.this$1)), n4, n3 * 2, n3);
                            this.this$1.rightButton.setBounds(n2 + SynthSplitPaneUI.access$1200(Divider.access$1000(this.this$1)) + SynthSplitPaneUI.access$800(Divider.access$1000(this.this$1)) * 2, n4, n3 * 2, n3);
                        } else {
                            int n5 = insets != null ? insets.top : 0;
                            int n6 = this.this$1.getWidth();
                            if (insets != null) {
                                n6 -= insets.left + insets.right;
                                n6 = Math.max(n6, 0);
                            }
                            n6 = Math.min(n6, SynthSplitPaneUI.access$800(Divider.access$1000(this.this$1)));
                            int n7 = (container.getSize().width - n6) / 2;
                            this.this$1.leftButton.setBounds(n7, n5 + SynthSplitPaneUI.access$1200(Divider.access$1000(this.this$1)), n6, n6 * 2);
                            this.this$1.rightButton.setBounds(n7, n5 + SynthSplitPaneUI.access$1200(Divider.access$1000(this.this$1)) + SynthSplitPaneUI.access$800(Divider.access$1000(this.this$1)) * 2, n6, n6 * 2);
                        }
                    } else {
                        this.this$1.leftButton.setBounds(-5, -5, 1, 1);
                        this.this$1.rightButton.setBounds(-5, -5, 1, 1);
                    }
                }
            }

            public void addLayoutComponent(String string, Component component) {
            }

            public Dimension minimumLayoutSize(Container container) {
                int n2;
                if (container != this.this$1 || Divider.access$1000((Divider)this.this$1).splitPane == null) {
                    return new Dimension(0, 0);
                }
                Dimension dimension = null;
                if (Divider.access$1000((Divider)this.this$1).splitPane.isOneTouchExpandable() && this.this$1.leftButton != null) {
                    dimension = this.this$1.leftButton.getMinimumSize();
                }
                Insets insets = this.this$1.getInsets();
                int n3 = n2 = this.this$1.getDividerSize();
                if (SynthSplitPaneUI.access$100(Divider.access$1000(this.this$1)) == 0) {
                    if (dimension != null) {
                        int n4 = dimension.height;
                        if (insets != null) {
                            n4 += insets.top + insets.bottom;
                        }
                        n3 = Math.max(n3, n4);
                    }
                    n2 = 1;
                } else {
                    if (dimension != null) {
                        int n5 = dimension.width;
                        if (insets != null) {
                            n5 += insets.left + insets.right;
                        }
                        n2 = Math.max(n2, n5);
                    }
                    n3 = 1;
                }
                return new Dimension(n2, n3);
            }

            public Dimension preferredLayoutSize(Container container) {
                return this.minimumLayoutSize(container);
            }
        }

        protected class DragController {
            int initialX;
            int maxX;
            int minX;
            int offset;
            private final Divider this$1;

            protected boolean isValid() {
                return this.maxX > 0;
            }

            protected int getNeededLocation(int n2, int n3) {
                int n4 = Math.min(this.maxX, Math.max(this.minX, n2 - this.offset));
                return n4;
            }

            protected void completeDrag(int n2, int n3) {
                Divider.access$1000(this.this$1).finishDraggingTo(this.getNeededLocation(n2, n3));
            }

            protected void continueDrag(int n2, int n3) {
                Divider.access$1000(this.this$1).dragDividerTo(this.getNeededLocation(n2, n3));
            }

            protected int positionForMouseEvent(MouseEvent mouseEvent) {
                int n2 = mouseEvent.getSource() == this.this$1 ? mouseEvent.getX() + this.this$1.getLocation().x : mouseEvent.getX();
                n2 = Math.min(this.maxX, Math.max(this.minX, n2 - this.offset));
                return n2;
            }

            protected void completeDrag(MouseEvent mouseEvent) {
                Divider.access$1000(this.this$1).finishDraggingTo(this.positionForMouseEvent(mouseEvent));
            }

            protected void continueDrag(MouseEvent mouseEvent) {
                Divider.access$1000(this.this$1).dragDividerTo(this.positionForMouseEvent(mouseEvent));
            }

            protected DragController(Divider divider, MouseEvent mouseEvent) {
                this.this$1 = divider;
                JSplitPane jSplitPane = Divider.access$1000(divider).getSplitPane();
                Component component = jSplitPane.getLeftComponent();
                Component component2 = jSplitPane.getRightComponent();
                this.initialX = divider.getLocation().x;
                this.offset = mouseEvent.getSource() == divider ? mouseEvent.getX() : mouseEvent.getX() - this.initialX;
                if (component == null || component2 == null || this.offset < -1 || this.offset >= divider.getSize().width) {
                    this.maxX = -1;
                } else {
                    Insets insets = jSplitPane.getInsets();
                    if (component.isVisible()) {
                        this.minX = component.getMinimumSize().width;
                        if (insets != null) {
                            this.minX += insets.left;
                        }
                    } else {
                        this.minX = 0;
                    }
                    if (component2.isVisible()) {
                        int n2 = insets != null ? insets.right : 0;
                        this.maxX = Math.max(0, jSplitPane.getSize().width - (divider.getSize().width + n2) - component2.getMinimumSize().width);
                    } else {
                        int n3 = insets != null ? insets.right : 0;
                        this.maxX = Math.max(0, jSplitPane.getSize().width - (divider.getSize().width + n3));
                    }
                    if (this.maxX < this.minX) {
                        this.maxX = 0;
                        this.minX = 0;
                    }
                }
            }
        }

        protected class MouseHandler
        extends MouseAdapter
        implements MouseMotionListener {
            private final Divider this$1;

            protected MouseHandler(Divider divider) {
                this.this$1 = divider;
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                if (this.this$1.dragger != null) {
                    if (mouseEvent.getSource() == Divider.access$1000((Divider)this.this$1).splitPane) {
                        this.this$1.dragger.continueDrag(mouseEvent.getX(), mouseEvent.getY());
                    } else if (mouseEvent.getSource() == this.this$1) {
                        Point point = this.this$1.getLocation();
                        this.this$1.dragger.continueDrag(mouseEvent.getX() + point.x, mouseEvent.getY() + point.y);
                    } else if (mouseEvent.getSource() == this.this$1.hiddenDivider) {
                        Point point = this.this$1.hiddenDivider.getLocation();
                        int n2 = mouseEvent.getX() + point.x;
                        int n3 = mouseEvent.getY() + point.y;
                        this.this$1.dragger.continueDrag(n2, n3);
                    }
                    mouseEvent.consume();
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                if (mouseEvent.getSource() == this.this$1) {
                    Divider.access$1102(this.this$1, true);
                    this.this$1.repaint();
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                if (mouseEvent.getSource() == this.this$1) {
                    Divider.access$1102(this.this$1, false);
                    this.this$1.repaint();
                }
            }

            public void mouseMoved(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if ((mouseEvent.getSource() == this.this$1 || mouseEvent.getSource() == Divider.access$1000((Divider)this.this$1).splitPane) && this.this$1.dragger == null && Divider.access$1000((Divider)this.this$1).splitPane.isEnabled()) {
                    Component component = Divider.access$1000(this.this$1).getNonContinuousLayoutDivider();
                    if (this.this$1.hiddenDivider != component) {
                        if (this.this$1.hiddenDivider != null) {
                            this.this$1.hiddenDivider.removeMouseListener(this);
                            this.this$1.hiddenDivider.removeMouseMotionListener(this);
                        }
                        this.this$1.hiddenDivider = component;
                        if (this.this$1.hiddenDivider != null) {
                            this.this$1.hiddenDivider.addMouseMotionListener(this);
                            this.this$1.hiddenDivider.addMouseListener(this);
                        }
                    }
                    if (Divider.access$1000((Divider)this.this$1).splitPane.getLeftComponent() != null && Divider.access$1000((Divider)this.this$1).splitPane.getRightComponent() != null) {
                        this.this$1.dragger = SynthSplitPaneUI.access$100(Divider.access$1000(this.this$1)) == 1 ? new DragController(this.this$1, mouseEvent) : new VerticalDragController(this.this$1, mouseEvent);
                        if (!this.this$1.dragger.isValid()) {
                            this.this$1.dragger = null;
                        } else {
                            Divider.access$1000(this.this$1).startDragging();
                            this.this$1.dragger.continueDrag(mouseEvent);
                        }
                    }
                    mouseEvent.consume();
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (this.this$1.dragger != null) {
                    if (mouseEvent.getSource() == Divider.access$1000((Divider)this.this$1).splitPane) {
                        this.this$1.dragger.completeDrag(mouseEvent.getX(), mouseEvent.getY());
                    } else if (mouseEvent.getSource() == this.this$1) {
                        Point point = this.this$1.getLocation();
                        this.this$1.dragger.completeDrag(mouseEvent.getX() + point.x, mouseEvent.getY() + point.y);
                    } else if (mouseEvent.getSource() == this.this$1.hiddenDivider) {
                        Point point = this.this$1.hiddenDivider.getLocation();
                        int n2 = mouseEvent.getX() + point.x;
                        int n3 = mouseEvent.getY() + point.y;
                        this.this$1.dragger.completeDrag(n2, n3);
                    }
                    this.this$1.dragger = null;
                    mouseEvent.consume();
                }
            }
        }

        private class OneTouchActionHandler
        implements ActionListener {
            private boolean toMinimum;
            private final Divider this$1;

            OneTouchActionHandler(Divider divider, boolean bl2) {
                this.this$1 = divider;
                this.toMinimum = bl2;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Insets insets = Divider.access$1000((Divider)this.this$1).splitPane.getInsets();
                int n2 = Divider.access$1000((Divider)this.this$1).splitPane.getLastDividerLocation();
                int n3 = Divider.access$1000(this.this$1).getDividerLocation(Divider.access$1000((Divider)this.this$1).splitPane);
                int n4 = this.toMinimum ? (SynthSplitPaneUI.access$100(Divider.access$1000(this.this$1)) == 0 ? (n3 >= Divider.access$1000((Divider)this.this$1).splitPane.getHeight() - insets.bottom - this.this$1.getHeight() ? n2 : insets.top) : (n3 >= Divider.access$1000((Divider)this.this$1).splitPane.getWidth() - insets.right - this.this$1.getWidth() ? n2 : insets.left)) : (SynthSplitPaneUI.access$100(Divider.access$1000(this.this$1)) == 0 ? (n3 == insets.top ? n2 : Divider.access$1000((Divider)this.this$1).splitPane.getHeight() - this.this$1.getHeight() - insets.top) : (n3 == insets.left ? n2 : Divider.access$1000((Divider)this.this$1).splitPane.getWidth() - this.this$1.getWidth() - insets.left));
                if (n3 != n4) {
                    Divider.access$1000((Divider)this.this$1).splitPane.setDividerLocation(n4);
                    Divider.access$1000((Divider)this.this$1).splitPane.setLastDividerLocation(n3);
                }
            }
        }

        protected class VerticalDragController
        extends DragController {
            private final Divider this$1;

            protected int getNeededLocation(int n2, int n3) {
                int n4 = Math.min(this.maxX, Math.max(this.minX, n3 - this.offset));
                return n4;
            }

            protected int positionForMouseEvent(MouseEvent mouseEvent) {
                int n2 = mouseEvent.getSource() == this.this$1 ? mouseEvent.getY() + this.this$1.getLocation().y : mouseEvent.getY();
                n2 = Math.min(this.maxX, Math.max(this.minX, n2 - this.offset));
                return n2;
            }

            protected VerticalDragController(Divider divider, MouseEvent mouseEvent) {
                this.this$1 = divider;
                super(divider, mouseEvent);
                JSplitPane jSplitPane = Divider.access$1000(divider).getSplitPane();
                Component component = jSplitPane.getLeftComponent();
                Component component2 = jSplitPane.getRightComponent();
                this.initialX = divider.getLocation().y;
                this.offset = mouseEvent.getSource() == divider ? mouseEvent.getY() : mouseEvent.getY() - this.initialX;
                if (component == null || component2 == null || this.offset < -1 || this.offset > divider.getSize().height) {
                    this.maxX = -1;
                } else {
                    Insets insets = jSplitPane.getInsets();
                    if (component.isVisible()) {
                        this.minX = component.getMinimumSize().height;
                        if (insets != null) {
                            this.minX += insets.top;
                        }
                    } else {
                        this.minX = 0;
                    }
                    if (component2.isVisible()) {
                        int n2 = insets != null ? insets.bottom : 0;
                        this.maxX = Math.max(0, jSplitPane.getSize().height - (divider.getSize().height + n2) - component2.getMinimumSize().height);
                    } else {
                        int n3 = insets != null ? insets.bottom : 0;
                        this.maxX = Math.max(0, jSplitPane.getSize().height - (divider.getSize().height + n3));
                    }
                    if (this.maxX < this.minX) {
                        this.maxX = 0;
                        this.minX = 0;
                    }
                }
            }
        }
    }

    class FocusHandler
    extends FocusAdapter {
        private final SynthSplitPaneUI this$0;

        FocusHandler(SynthSplitPaneUI synthSplitPaneUI) {
            this.this$0 = synthSplitPaneUI;
        }

        public void focusGained(FocusEvent focusEvent) {
            SynthSplitPaneUI.access$202(this.this$0, true);
            this.this$0.splitPane.repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            SynthSplitPaneUI.access$202(this.this$0, false);
            this.this$0.splitPane.repaint();
        }
    }

    static class KeyboardDownRightAction
    extends AbstractAction {
        KeyboardDownRightAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JSplitPane jSplitPane = (JSplitPane)actionEvent.getSource();
            SynthSplitPaneUI synthSplitPaneUI = (SynthSplitPaneUI)jSplitPane.getUI();
            if (SynthSplitPaneUI.access$200(synthSplitPaneUI)) {
                jSplitPane.setDividerLocation(synthSplitPaneUI.getDividerLocation(jSplitPane) + synthSplitPaneUI.getKeyboardMoveIncrement());
            }
        }
    }

    static class KeyboardEndAction
    extends AbstractAction {
        KeyboardEndAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JSplitPane jSplitPane = (JSplitPane)actionEvent.getSource();
            SynthSplitPaneUI synthSplitPaneUI = (SynthSplitPaneUI)jSplitPane.getUI();
            if (SynthSplitPaneUI.access$200(synthSplitPaneUI)) {
                int n2;
                Insets insets = jSplitPane.getInsets();
                int n3 = insets != null ? insets.bottom : 0;
                int n4 = n2 = insets != null ? insets.right : 0;
                if (SynthSplitPaneUI.access$100(synthSplitPaneUI) == 0) {
                    jSplitPane.setDividerLocation(jSplitPane.getHeight() - n3);
                } else {
                    jSplitPane.setDividerLocation(jSplitPane.getWidth() - n2);
                }
            }
        }
    }

    static class KeyboardHomeAction
    extends AbstractAction {
        KeyboardHomeAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JSplitPane jSplitPane = (JSplitPane)actionEvent.getSource();
            SynthSplitPaneUI synthSplitPaneUI = (SynthSplitPaneUI)jSplitPane.getUI();
            if (SynthSplitPaneUI.access$200(synthSplitPaneUI)) {
                jSplitPane.setDividerLocation(0);
            }
        }
    }

    static class KeyboardResizeToggleAction
    extends AbstractAction {
        KeyboardResizeToggleAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JSplitPane jSplitPane = (JSplitPane)actionEvent.getSource();
            SynthSplitPaneUI synthSplitPaneUI = (SynthSplitPaneUI)jSplitPane.getUI();
            if (!SynthSplitPaneUI.access$200(synthSplitPaneUI)) {
                jSplitPane.requestFocus();
            } else {
                JSplitPane jSplitPane2 = (JSplitPane)SwingUtilities.getAncestorOfClass(class$javax$swing$JSplitPane == null ? (class$javax$swing$JSplitPane = SynthSplitPaneUI.class$("javax.swing.JSplitPane")) : class$javax$swing$JSplitPane, jSplitPane);
                if (jSplitPane2 != null) {
                    jSplitPane2.requestFocus();
                }
            }
        }
    }

    static class KeyboardUpLeftAction
    extends AbstractAction {
        KeyboardUpLeftAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JSplitPane jSplitPane = (JSplitPane)actionEvent.getSource();
            SynthSplitPaneUI synthSplitPaneUI = (SynthSplitPaneUI)jSplitPane.getUI();
            if (SynthSplitPaneUI.access$200(synthSplitPaneUI)) {
                jSplitPane.setDividerLocation(Math.max(0, synthSplitPaneUI.getDividerLocation(jSplitPane) - synthSplitPaneUI.getKeyboardMoveIncrement()));
            }
        }
    }

    static class MoveFocusOutAction
    extends AbstractAction {
        private int direction;

        public MoveFocusOutAction(int n2) {
            this.direction = n2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JSplitPane jSplitPane = (JSplitPane)actionEvent.getSource();
            Container container = jSplitPane.getFocusCycleRootAncestor();
            FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
            Component component = this.direction > 0 ? focusTraversalPolicy.getComponentAfter(container, jSplitPane) : focusTraversalPolicy.getComponentBefore(container, jSplitPane);
            HashSet hashSet = new HashSet();
            if (jSplitPane.isAncestorOf(component)) {
                do {
                    hashSet.add(component);
                    container = component.getFocusCycleRootAncestor();
                    focusTraversalPolicy = container.getFocusTraversalPolicy();
                    Component component2 = component = this.direction > 0 ? focusTraversalPolicy.getComponentAfter(container, component) : focusTraversalPolicy.getComponentBefore(container, component);
                } while (jSplitPane.isAncestorOf(component) && !hashSet.contains(component));
            }
            if (component != null && !jSplitPane.isAncestorOf(component)) {
                component.requestFocus();
            }
        }
    }

    class PropertyHandler
    implements PropertyChangeListener {
        private final SynthSplitPaneUI this$0;

        PropertyHandler(SynthSplitPaneUI synthSplitPaneUI) {
            this.this$0 = synthSplitPaneUI;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == this.this$0.splitPane) {
                String string = propertyChangeEvent.getPropertyName();
                if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
                    SynthSplitPaneUI.access$000(this.this$0, (JSplitPane)propertyChangeEvent.getSource());
                }
                if (string.equals("orientation")) {
                    SynthSplitPaneUI.access$102(this.this$0, this.this$0.splitPane.getOrientation());
                    this.this$0.resetLayoutManager();
                } else if (string.equals("continuousLayout")) {
                    this.this$0.setContinuousLayout(this.this$0.splitPane.isContinuousLayout());
                    if (!this.this$0.isContinuousLayout()) {
                        if (this.this$0.nonContinuousLayoutDivider == null) {
                            this.this$0.setNonContinuousLayoutDivider(this.this$0.createDefaultNonContinuousLayoutDivider(), true);
                        } else if (this.this$0.nonContinuousLayoutDivider.getParent() == null) {
                            this.this$0.setNonContinuousLayoutDivider(this.this$0.nonContinuousLayoutDivider, true);
                        }
                    }
                } else if (string.equals("dividerSize")) {
                    this.this$0.divider.setDividerSize(this.this$0.splitPane.getDividerSize());
                    this.this$0.dividerSize = this.this$0.divider.getDividerSize();
                    this.this$0.splitPane.revalidate();
                    this.this$0.splitPane.repaint();
                }
            }
        }
    }

    private class SplitPaneLayoutManager
    implements LayoutManager2,
    UIResource {
        protected int[] sizes;
        protected Component[] components;
        private int lastSplitPaneSize;
        private boolean doReset;
        private int axis;
        private final SynthSplitPaneUI this$0;

        public void resetToPreferredSizes() {
            this.doReset = true;
        }

        protected void updateComponents() {
            Component component = this.this$0.splitPane.getLeftComponent();
            if (this.components[0] != component) {
                this.components[0] = component;
                this.sizes[0] = component == null ? 0 : -1;
            }
            if (this.components[1] != (component = this.this$0.splitPane.getRightComponent())) {
                this.components[1] = component;
                this.sizes[1] = component == null ? 0 : -1;
            }
            Component[] componentArray = this.this$0.splitPane.getComponents();
            Component component2 = this.components[2];
            this.components[2] = null;
            for (int i2 = componentArray.length - 1; i2 >= 0; --i2) {
                if (componentArray[i2] == this.components[0] || componentArray[i2] == this.components[1] || componentArray[i2] == this.this$0.nonContinuousLayoutDivider) continue;
                if (component2 != componentArray[i2]) {
                    this.components[2] = componentArray[i2];
                    break;
                }
                this.components[2] = component2;
                break;
            }
            this.sizes[2] = this.components[2] == null ? 0 : this.getSizeForPrimaryAxis(this.components[2].getPreferredSize());
        }

        int[] getMinimumSizes() {
            int[] nArray = new int[3];
            for (int i2 = 0; i2 < 2; ++i2) {
                nArray[i2] = this.components[i2] != null && this.components[i2].isVisible() ? this.getMinimumSizeOfComponent(this.components[i2]) : -1;
            }
            nArray[2] = this.components[2] != null ? this.getMinimumSizeOfComponent(this.components[2]) : -1;
            return nArray;
        }

        int[] getPreferredSizes() {
            int[] nArray = new int[3];
            for (int i2 = 0; i2 < 3; ++i2) {
                nArray[i2] = this.components[i2] != null && this.components[i2].isVisible() ? this.getPreferredSizeOfComponent(this.components[i2]) : -1;
            }
            return nArray;
        }

        protected int[] getSizes() {
            int[] nArray = new int[3];
            System.arraycopy(this.sizes, 0, nArray, 0, 3);
            return nArray;
        }

        protected void resetSizeAt(int n2) {
            this.sizes[n2] = 0;
            this.doReset = true;
        }

        void resetToPreferredSizes(int n2) {
            int n3;
            int[] nArray = this.getPreferredSizes();
            int n4 = 0;
            for (n3 = 0; n3 < 3; ++n3) {
                if (nArray[n3] == -1) continue;
                n4 += nArray[n3];
            }
            if (n4 > n2) {
                nArray = this.getMinimumSizes();
                n4 = 0;
                for (n3 = 0; n3 < 3; ++n3) {
                    if (nArray[n3] == -1) continue;
                    n4 += nArray[n3];
                }
            }
            this.setSizes(nArray);
            this.distributeSpace(n2 - n4, false);
        }

        void setDividerLocation(int n2, int n3) {
            boolean bl2 = this.components[0] != null && this.components[0].isVisible();
            boolean bl3 = this.components[1] != null && this.components[1].isVisible();
            boolean bl4 = this.components[2] != null && this.components[2].isVisible();
            int n4 = n3;
            if (bl4) {
                n4 -= this.sizes[2];
            }
            n2 = Math.max(0, Math.min(n2, n4));
            if (bl2) {
                if (bl3) {
                    this.sizes[0] = n2;
                    this.sizes[1] = n4 - n2;
                } else {
                    this.sizes[0] = n4;
                    this.sizes[1] = 0;
                }
            } else if (bl3) {
                this.sizes[1] = n4;
                this.sizes[0] = 0;
            }
        }

        void distributeSpace(int n2, boolean bl2) {
            boolean bl3;
            boolean bl4 = this.components[0] != null && this.components[0].isVisible();
            boolean bl5 = bl3 = this.components[1] != null && this.components[1].isVisible();
            if (bl2) {
                if (bl4 && this.getSizeForPrimaryAxis(this.components[0].getSize()) == 0) {
                    bl4 = false;
                    if (bl3 && this.getSizeForPrimaryAxis(this.components[1].getSize()) == 0) {
                        bl4 = true;
                    }
                } else if (bl3 && this.getSizeForPrimaryAxis(this.components[1].getSize()) == 0) {
                    bl3 = false;
                }
            }
            if (bl4 && bl3) {
                boolean bl6;
                double d2 = this.this$0.splitPane.getResizeWeight();
                int n3 = (int)(d2 * (double)n2);
                int n4 = n2 - n3;
                this.sizes[0] = this.sizes[0] + n3;
                this.sizes[1] = this.sizes[1] + n4;
                int n5 = this.getMinimumSizeOfComponent(this.components[0]);
                int n6 = this.getMinimumSizeOfComponent(this.components[1]);
                boolean bl7 = this.sizes[0] >= n5;
                boolean bl8 = bl6 = this.sizes[1] >= n6;
                if (!bl7 && !bl6) {
                    if (this.sizes[0] < 0) {
                        this.sizes[1] = this.sizes[1] + this.sizes[0];
                        this.sizes[0] = 0;
                    } else if (this.sizes[1] < 0) {
                        this.sizes[0] = this.sizes[0] + this.sizes[1];
                        this.sizes[1] = 0;
                    }
                } else if (!bl7) {
                    if (this.sizes[1] - (n5 - this.sizes[0]) < n6) {
                        if (this.sizes[0] < 0) {
                            this.sizes[1] = this.sizes[1] + this.sizes[0];
                            this.sizes[0] = 0;
                        }
                    } else {
                        this.sizes[1] = this.sizes[1] - (n5 - this.sizes[0]);
                        this.sizes[0] = n5;
                    }
                } else if (!bl6) {
                    if (this.sizes[0] - (n6 - this.sizes[1]) < n5) {
                        if (this.sizes[1] < 0) {
                            this.sizes[0] = this.sizes[0] + this.sizes[1];
                            this.sizes[1] = 0;
                        }
                    } else {
                        this.sizes[0] = this.sizes[0] - (n6 - this.sizes[1]);
                        this.sizes[1] = n6;
                    }
                }
                if (this.sizes[0] < 0) {
                    this.sizes[0] = 0;
                }
                if (this.sizes[1] < 0) {
                    this.sizes[1] = 0;
                }
            } else if (bl4) {
                this.sizes[0] = Math.max(0, this.sizes[0] + n2);
            } else if (bl3) {
                this.sizes[1] = Math.max(0, this.sizes[1] + n2);
            }
        }

        protected void setSizes(int[] nArray) {
            System.arraycopy(nArray, 0, this.sizes, 0, 3);
        }

        SplitPaneLayoutManager(SynthSplitPaneUI synthSplitPaneUI, int n2) {
            this.this$0 = synthSplitPaneUI;
            this.axis = n2;
            this.components = new Component[3];
            this.components[2] = null;
            this.components[1] = null;
            this.components[0] = null;
            this.sizes = new int[3];
        }

        int getMinimumSizeOfComponent(Component component) {
            return this.getSizeForPrimaryAxis(component.getMinimumSize());
        }

        protected int getPreferredSizeOfComponent(Component component) {
            return this.getSizeForPrimaryAxis(component.getPreferredSize());
        }

        protected int getSizeOfComponent(Component component) {
            return this.getSizeForPrimaryAxis(component.getSize());
        }

        public void removeLayoutComponent(Component component) {
            for (int i2 = 0; i2 < 3; ++i2) {
                if (this.components[i2] != component) continue;
                this.components[i2] = null;
                this.sizes[i2] = 0;
                this.doReset = true;
            }
        }

        public float getLayoutAlignmentX(Container container) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container container) {
            return 0.0f;
        }

        public void invalidateLayout(Container container) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container container) {
            int n2;
            Dimension dimension;
            Dimension dimension2 = container.getSize();
            if (dimension2.height <= 0 || dimension2.width <= 0) {
                this.lastSplitPaneSize = 0;
                return;
            }
            int n3 = this.this$0.splitPane.getDividerLocation();
            Insets insets = this.this$0.splitPane.getInsets();
            int n4 = this.getAvailableSize(dimension2, insets);
            int n5 = this.getSizeForPrimaryAxis(dimension2);
            int n6 = this.this$0.getDividerLocation(this.this$0.splitPane);
            int n7 = this.getSizeForPrimaryAxis(insets, true);
            Dimension dimension3 = dimension = this.components[2] == null ? null : this.components[2].getPreferredSize();
            if (this.doReset && !SynthSplitPaneUI.access$400(this.this$0) || n3 < 0) {
                this.resetToPreferredSizes(n4);
            } else if (this.lastSplitPaneSize <= 0 || n4 == this.lastSplitPaneSize || !this.this$0.painted || dimension != null && this.getSizeForPrimaryAxis(dimension) != this.sizes[2]) {
                this.sizes[2] = dimension != null ? this.getSizeForPrimaryAxis(dimension) : 0;
                this.setDividerLocation(n3 - n7, n4);
                SynthSplitPaneUI.access$402(this.this$0, false);
            } else if (n4 != this.lastSplitPaneSize) {
                this.distributeSpace(n4 - this.lastSplitPaneSize, true);
            }
            this.doReset = false;
            SynthSplitPaneUI.access$402(this.this$0, false);
            this.lastSplitPaneSize = n4;
            int n8 = this.getInitialLocation(insets);
            int n9 = 0;
            while (n9 < 3) {
                if (this.components[n9] != null && this.components[n9].isVisible()) {
                    this.setComponentToSize(this.components[n9], this.sizes[n9], n8, insets, dimension2);
                    n8 += this.sizes[n9];
                }
                switch (n9) {
                    case 0: {
                        n9 = 2;
                        break;
                    }
                    case 2: {
                        n9 = 1;
                        break;
                    }
                    case 1: {
                        n9 = 3;
                    }
                }
            }
            if (this.this$0.painted && (n2 = this.this$0.getDividerLocation(this.this$0.splitPane)) != n3 - n7) {
                int n10 = this.this$0.splitPane.getLastDividerLocation();
                this.this$0.ignoreDividerLocationChange = true;
                try {
                    this.this$0.splitPane.setDividerLocation(n2);
                    this.this$0.splitPane.setLastDividerLocation(n10);
                }
                finally {
                    this.this$0.ignoreDividerLocationChange = false;
                }
            }
        }

        int getSizeForPrimaryAxis(Dimension dimension) {
            if (this.axis == 0) {
                return dimension.width;
            }
            return dimension.height;
        }

        int getSizeForSecondaryAxis(Dimension dimension) {
            if (this.axis == 0) {
                return dimension.height;
            }
            return dimension.width;
        }

        protected int getInitialLocation(Insets insets) {
            if (insets != null) {
                return this.getSizeForPrimaryAxis(insets, true);
            }
            return 0;
        }

        int getSizeForPrimaryAxis(Insets insets, boolean bl2) {
            if (this.axis == 0) {
                if (bl2) {
                    return insets.left;
                }
                return insets.right;
            }
            if (bl2) {
                return insets.top;
            }
            return insets.bottom;
        }

        int getSizeForSecondaryAxis(Insets insets, boolean bl2) {
            if (this.axis == 0) {
                if (bl2) {
                    return insets.top;
                }
                return insets.bottom;
            }
            if (bl2) {
                return insets.left;
            }
            return insets.right;
        }

        public void addLayoutComponent(String string, Component component) {
            boolean bl2 = true;
            if (string != null) {
                if (string.equals("divider")) {
                    this.components[2] = component;
                    this.sizes[2] = this.getSizeForPrimaryAxis(component.getPreferredSize());
                } else if (string.equals("left") || string.equals("top")) {
                    this.components[0] = component;
                    this.sizes[0] = 0;
                } else if (string.equals("right") || string.equals("bottom")) {
                    this.components[1] = component;
                    this.sizes[1] = 0;
                } else if (!string.equals(SynthSplitPaneUI.NON_CONTINUOUS_DIVIDER)) {
                    bl2 = false;
                }
            } else {
                bl2 = false;
            }
            if (!bl2) {
                throw new IllegalArgumentException("cannot add to layout: unknown constraint: " + string);
            }
            this.doReset = true;
        }

        public Dimension maximumLayoutSize(Container container) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        public Dimension minimumLayoutSize(Container container) {
            int n2 = 0;
            int n3 = 0;
            Insets insets = this.this$0.splitPane.getInsets();
            for (int i2 = 0; i2 < 3; ++i2) {
                if (this.components[i2] == null) continue;
                Dimension dimension = this.components[i2].getMinimumSize();
                int n4 = this.getSizeForSecondaryAxis(dimension);
                n2 += this.getSizeForPrimaryAxis(dimension);
                if (n4 <= n3) continue;
                n3 = n4;
            }
            if (insets != null) {
                n2 += this.getSizeForPrimaryAxis(insets, true) + this.getSizeForPrimaryAxis(insets, false);
                n3 += this.getSizeForSecondaryAxis(insets, true) + this.getSizeForSecondaryAxis(insets, false);
            }
            if (this.axis == 0) {
                return new Dimension(n2, n3);
            }
            return new Dimension(n3, n2);
        }

        public Dimension preferredLayoutSize(Container container) {
            int n2 = 0;
            int n3 = 0;
            Insets insets = this.this$0.splitPane.getInsets();
            for (int i2 = 0; i2 < 3; ++i2) {
                if (this.components[i2] == null) continue;
                Dimension dimension = this.components[i2].getPreferredSize();
                int n4 = this.getSizeForSecondaryAxis(dimension);
                n2 += this.getSizeForPrimaryAxis(dimension);
                if (n4 <= n3) continue;
                n3 = n4;
            }
            if (insets != null) {
                n2 += this.getSizeForPrimaryAxis(insets, true) + this.getSizeForPrimaryAxis(insets, false);
                n3 += this.getSizeForSecondaryAxis(insets, true) + this.getSizeForSecondaryAxis(insets, false);
            }
            if (this.axis == 0) {
                return new Dimension(n2, n3);
            }
            return new Dimension(n3, n2);
        }

        protected int getAvailableSize(Dimension dimension, Insets insets) {
            if (insets == null) {
                return this.getSizeForPrimaryAxis(dimension);
            }
            return this.getSizeForPrimaryAxis(dimension) - (this.getSizeForPrimaryAxis(insets, true) + this.getSizeForPrimaryAxis(insets, false));
        }

        public void addLayoutComponent(Component component, Object object) {
            if (object != null && !(object instanceof String)) {
                throw new IllegalArgumentException("cannot add to layout: constraint must be a string (or null)");
            }
            this.addLayoutComponent((String)object, component);
        }

        protected void setComponentToSize(Component component, int n2, int n3, Insets insets, Dimension dimension) {
            if (insets != null) {
                if (this.axis == 0) {
                    component.setBounds(n3, insets.top, n2, dimension.height - (insets.top + insets.bottom));
                } else {
                    component.setBounds(insets.left, n3, dimension.width - (insets.left + insets.right), n2);
                }
            } else if (this.axis == 0) {
                component.setBounds(n3, 0, n2, dimension.height);
            } else {
                component.setBounds(0, n3, dimension.width, n2);
            }
        }
    }

    static class ToggleSideFocusAction
    extends AbstractAction {
        ToggleSideFocusAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JSplitPane jSplitPane = (JSplitPane)actionEvent.getSource();
            Component component = jSplitPane.getLeftComponent();
            Component component2 = jSplitPane.getRightComponent();
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Component component3 = keyboardFocusManager.getFocusOwner();
            Component component4 = this.getNextSide(jSplitPane, component3);
            if (component4 != null) {
                if (component3 != null && (SwingUtilities.isDescendingFrom(component3, component) && SwingUtilities.isDescendingFrom(component4, component) || SwingUtilities.isDescendingFrom(component3, component2) && SwingUtilities.isDescendingFrom(component4, component2))) {
                    return;
                }
                SynthLookAndFeel.compositeRequestFocus(component4);
            }
        }

        private Component getFirstAvailableComponent(Component component) {
            if (component != null && component instanceof JSplitPane) {
                JSplitPane jSplitPane = (JSplitPane)component;
                Component component2 = this.getFirstAvailableComponent(jSplitPane.getLeftComponent());
                component = component2 != null ? component2 : this.getFirstAvailableComponent(jSplitPane.getRightComponent());
            }
            return component;
        }

        private Component getNextSide(JSplitPane jSplitPane, Component component) {
            Component component2 = jSplitPane.getLeftComponent();
            Component component3 = jSplitPane.getRightComponent();
            Component component4 = null;
            if (component != null && SwingUtilities.isDescendingFrom(component, component2) && component3 != null && (component4 = this.getFirstAvailableComponent(component3)) != null) {
                return component4;
            }
            JSplitPane jSplitPane2 = (JSplitPane)SwingUtilities.getAncestorOfClass(class$javax$swing$JSplitPane == null ? (class$javax$swing$JSplitPane = SynthSplitPaneUI.class$("javax.swing.JSplitPane")) : class$javax$swing$JSplitPane, jSplitPane);
            if (jSplitPane2 != null) {
                component4 = this.getNextSide(jSplitPane2, component);
            } else {
                component4 = this.getFirstAvailableComponent(component2);
                if (component4 == null) {
                    component4 = this.getFirstAvailableComponent(component3);
                }
            }
            return component4;
        }
    }
}

