/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.LazyActionMap;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthArrowButton;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SpinnerUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.InternationalFormatter;

class SynthSpinnerUI
extends SpinnerUI
implements SynthUI {
    private SynthStyle style;
    protected JSpinner spinner;
    private static final PropertyChangeListener propertyChangeListener = new PropertyChangeHandler(null);
    private static final ArrowButtonHandler nextButtonHandler = new ArrowButtonHandler("increment", true);
    private static final ArrowButtonHandler previousButtonHandler = new ArrowButtonHandler("decrement", false);
    static Class class$com$sun$java$swing$plaf$gtk$SynthSpinnerUI;
    static Class class$com$sun$java$swing$plaf$gtk$SynthContext;

    SynthSpinnerUI() {
    }

    protected void installDefaults() {
        JComponent jComponent;
        LayoutManager layoutManager = this.spinner.getLayout();
        if (layoutManager == null || layoutManager instanceof UIResource) {
            this.spinner.setLayout(this.createLayout());
        }
        if ((jComponent = this.spinner.getEditor()) instanceof JSpinner.DefaultEditor) {
            JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)jComponent).getTextField();
            jFormattedTextField.setName("Spinner.formattedTextField");
        }
        this.fetchStyle(this.spinner);
    }

    private void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.spinner, 1, inputMap);
        LazyActionMap.installLazyActionMap(this.spinner, class$com$sun$java$swing$plaf$gtk$SynthSpinnerUI == null ? (class$com$sun$java$swing$plaf$gtk$SynthSpinnerUI = SynthSpinnerUI.class$("com.sun.java.swing.plaf.gtk.SynthSpinnerUI")) : class$com$sun$java$swing$plaf$gtk$SynthSpinnerUI, "Spinner.actionMap");
    }

    protected void installListeners() {
        this.spinner.addPropertyChangeListener(propertyChangeListener);
    }

    protected void uninstallDefaults() {
        if (this.spinner.getLayout() instanceof UIResource) {
            this.spinner.setLayout(null);
        }
        SynthContext synthContext = this.getContext(this.spinner, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    protected void uninstallListeners() {
        this.spinner.removePropertyChangeListener(propertyChangeListener);
    }

    private void updateEnabledState() {
        this.updateEnabledState(this.spinner, this.spinner.isEnabled());
    }

    static void access$300(SynthSpinnerUI synthSpinnerUI) {
        synthSpinnerUI.updateEnabledState();
    }

    protected Component createNextButton() {
        SynthArrowButton synthArrowButton = new SynthArrowButton(1);
        synthArrowButton.addActionListener(nextButtonHandler);
        synthArrowButton.addMouseListener(nextButtonHandler);
        return synthArrowButton;
    }

    protected Component createPreviousButton() {
        SynthArrowButton synthArrowButton = new SynthArrowButton(5);
        synthArrowButton.addActionListener(previousButtonHandler);
        synthArrowButton.addMouseListener(previousButtonHandler);
        return synthArrowButton;
    }

    private void updateEnabledState(Container container, boolean bl2) {
        for (int i2 = container.getComponentCount() - 1; i2 >= 0; --i2) {
            Component component = container.getComponent(i2);
            component.setEnabled(bl2);
            if (!(component instanceof Container)) continue;
            this.updateEnabledState((Container)component, bl2);
        }
    }

    protected LayoutManager createLayout() {
        return new SpinnerLayout(null);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return propertyChangeListener;
    }

    public static void loadActionMap(ActionMap actionMap) {
        actionMap.put("increment", nextButtonHandler);
        actionMap.put("decrement", previousButtonHandler);
    }

    private InputMap getInputMap(int n2) {
        if (n2 == 1) {
            SynthContext synthContext = this.getContext(this.spinner, 1);
            InputMap inputMap = (InputMap)synthContext.getStyle().get(synthContext, "Spinner.ancestorInputMap");
            synthContext.dispose();
            return inputMap;
        }
        return null;
    }

    protected JComponent createEditor() {
        return this.spinner.getEditor();
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void installUI(JComponent jComponent) {
        JComponent jComponent2;
        Component component;
        this.spinner = (JSpinner)jComponent;
        this.installDefaults();
        this.installListeners();
        Component component2 = this.createNextButton();
        if (component2 != null) {
            component2.setName("Spinner.nextButton");
            if (component2 instanceof JComponent) {
                ((JComponent)component2).updateUI();
            }
            this.spinner.add(component2, "Next");
        }
        if ((component = this.createPreviousButton()) != null) {
            component.setName("Spinner.previousButton");
            if (component instanceof JComponent) {
                ((JComponent)component).updateUI();
            }
            this.spinner.add(component, "Previous");
        }
        if ((jComponent2 = this.createEditor()) != null) {
            jComponent2.setName("Spinner.editor");
            if (jComponent2 instanceof JComponent) {
                jComponent2.updateUI();
            }
            this.spinner.add((Component)jComponent2, "Editor");
        }
        this.updateEnabledState();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.spinner = null;
        jComponent.removeAll();
    }

    private void fetchStyle(JSpinner jSpinner) {
        SynthContext synthContext = this.getContext(jSpinner, 1);
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(class$com$sun$java$swing$plaf$gtk$SynthContext == null ? (class$com$sun$java$swing$plaf$gtk$SynthContext = SynthSpinnerUI.class$("com.sun.java.swing.plaf.gtk.SynthContext")) : class$com$sun$java$swing$plaf$gtk$SynthContext, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n2);
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void replaceEditor(JComponent jComponent, JComponent jComponent2) {
        this.spinner.remove(jComponent);
        this.spinner.add((Component)jComponent2, "Editor");
        JComponent jComponent3 = this.spinner.getEditor();
        if (jComponent3 instanceof JSpinner.DefaultEditor) {
            JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)jComponent3).getTextField();
            jFormattedTextField.setName("Spinner.formattedTextField");
        }
    }

    static void access$200(SynthSpinnerUI synthSpinnerUI, JSpinner jSpinner) {
        synthSpinnerUI.fetchStyle(jSpinner);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthSpinnerUI();
    }

    static class 1 {
    }

    private static class ArrowButtonHandler
    extends AbstractAction
    implements MouseListener {
        final Timer autoRepeatTimer;
        final boolean isNext;
        JSpinner spinner = null;

        private void focusSpinnerIfNecessary() {
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (this.spinner.isRequestFocusEnabled() && (component == null || !SwingUtilities.isDescendingFrom(component, this.spinner))) {
                FocusTraversalPolicy focusTraversalPolicy;
                Component component2;
                Container container = this.spinner;
                if (!container.isFocusCycleRoot()) {
                    container = container.getFocusCycleRootAncestor();
                }
                if (container != null && (component2 = (focusTraversalPolicy = container.getFocusTraversalPolicy()).getComponentAfter(container, this.spinner)) != null && SwingUtilities.isDescendingFrom(component2, this.spinner)) {
                    component2.requestFocus();
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JSpinner jSpinner = this.spinner;
            if (!(actionEvent.getSource() instanceof Timer)) {
                jSpinner = this.eventToSpinner(actionEvent);
            }
            if (jSpinner != null) {
                try {
                    Object object;
                    int n2 = this.getCalendarField(jSpinner);
                    jSpinner.commitEdit();
                    if (n2 != -1) {
                        ((SpinnerDateModel)jSpinner.getModel()).setCalendarField(n2);
                    }
                    Object object2 = object = this.isNext ? jSpinner.getNextValue() : jSpinner.getPreviousValue();
                    if (object != null) {
                        jSpinner.setValue(object);
                        this.select(jSpinner);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(jSpinner);
                }
                catch (ParseException parseException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(jSpinner);
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getComponent().isEnabled()) {
                this.spinner = this.eventToSpinner(mouseEvent);
                this.autoRepeatTimer.start();
                this.focusSpinnerIfNecessary();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.autoRepeatTimer.stop();
            this.spinner = null;
        }

        ArrowButtonHandler(String string, boolean bl2) {
            super(string);
            this.isNext = bl2;
            this.autoRepeatTimer = new Timer(60, this);
            this.autoRepeatTimer.setInitialDelay(300);
        }

        private int getCalendarField(JSpinner jSpinner) {
            JComponent jComponent = jSpinner.getEditor();
            if (jComponent instanceof JSpinner.DateEditor) {
                JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)jComponent;
                JFormattedTextField jFormattedTextField = dateEditor.getTextField();
                int n2 = jFormattedTextField.getSelectionStart();
                JFormattedTextField.AbstractFormatter abstractFormatter = jFormattedTextField.getFormatter();
                if (abstractFormatter instanceof InternationalFormatter) {
                    Format.Field[] fieldArray = ((InternationalFormatter)abstractFormatter).getFields(n2);
                    for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                        int n3;
                        if (!(fieldArray[i2] instanceof DateFormat.Field) || (n3 = fieldArray[i2] == DateFormat.Field.HOUR1 ? 10 : ((DateFormat.Field)fieldArray[i2]).getCalendarField()) == -1) continue;
                        return n3;
                    }
                }
            }
            return -1;
        }

        private void select(JSpinner jSpinner) {
            JComponent jComponent = jSpinner.getEditor();
            if (jComponent instanceof JSpinner.DateEditor) {
                SpinnerDateModel spinnerDateModel;
                DateFormat.Field field;
                Object object;
                JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)jComponent;
                JFormattedTextField jFormattedTextField = dateEditor.getTextField();
                SimpleDateFormat simpleDateFormat = dateEditor.getFormat();
                if (simpleDateFormat != null && (object = jSpinner.getValue()) != null && (field = DateFormat.Field.ofCalendarField((spinnerDateModel = dateEditor.getModel()).getCalendarField())) != null) {
                    try {
                        AttributedCharacterIterator attributedCharacterIterator = ((Format)simpleDateFormat).formatToCharacterIterator(object);
                        if (!this.select(jFormattedTextField, attributedCharacterIterator, field) && field == DateFormat.Field.HOUR0) {
                            this.select(jFormattedTextField, attributedCharacterIterator, DateFormat.Field.HOUR1);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }

        private JSpinner eventToSpinner(AWTEvent aWTEvent) {
            Object object = aWTEvent.getSource();
            while (object instanceof Component && !(object instanceof JSpinner)) {
                object = ((Component)object).getParent();
            }
            return object instanceof JSpinner ? (JSpinner)object : null;
        }

        private boolean select(JFormattedTextField jFormattedTextField, AttributedCharacterIterator attributedCharacterIterator, DateFormat.Field field) {
            int n2 = jFormattedTextField.getDocument().getLength();
            attributedCharacterIterator.first();
            do {
                Map map;
                if ((map = attributedCharacterIterator.getAttributes()) == null || !map.containsKey(field)) continue;
                int n3 = attributedCharacterIterator.getRunStart(field);
                int n4 = attributedCharacterIterator.getRunLimit(field);
                if (n3 != -1 && n4 != -1 && n3 <= n2 && n4 <= n2) {
                    jFormattedTextField.select(n3, n4);
                }
                return true;
            } while (attributedCharacterIterator.next() != '\uffff');
            return false;
        }
    }

    private static class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        PropertyChangeHandler(1 var1_1) {
            this();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            JSpinner jSpinner = (JSpinner)propertyChangeEvent.getSource();
            SpinnerUI spinnerUI = jSpinner.getUI();
            if (spinnerUI instanceof SynthSpinnerUI) {
                SynthSpinnerUI synthSpinnerUI = (SynthSpinnerUI)spinnerUI;
                if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
                    SynthSpinnerUI.access$200(synthSpinnerUI, jSpinner);
                }
                if ("editor".equals(string)) {
                    JComponent jComponent = (JComponent)propertyChangeEvent.getOldValue();
                    JComponent jComponent2 = (JComponent)propertyChangeEvent.getNewValue();
                    synthSpinnerUI.replaceEditor(jComponent, jComponent2);
                    SynthSpinnerUI.access$300(synthSpinnerUI);
                } else if ("enabled".equals(string)) {
                    SynthSpinnerUI.access$300(synthSpinnerUI);
                }
            }
        }
    }

    private static class SpinnerLayout
    implements LayoutManager,
    UIResource {
        private Component nextButton = null;
        private Component previousButton = null;
        private Component editor = null;

        private SpinnerLayout() {
        }

        SpinnerLayout(1 var1_1) {
            this();
        }

        public void removeLayoutComponent(Component component) {
            if (component == this.nextButton) {
                component = null;
            } else if (component == this.previousButton) {
                this.previousButton = null;
            } else if (component == this.editor) {
                this.editor = null;
            }
        }

        private void setBounds(Component component, int n2, int n3, int n4, int n5) {
            if (component != null) {
                component.setBounds(n2, n3, n4, n5);
            }
        }

        public void layoutContainer(Container container) {
            int n2;
            int n3;
            Insets insets = container.getInsets();
            int n4 = container.getWidth() - (insets.left + insets.right);
            int n5 = container.getHeight() - (insets.top + insets.bottom);
            Dimension dimension = this.preferredSize(this.nextButton);
            Dimension dimension2 = this.preferredSize(this.previousButton);
            int n6 = n5 / 2;
            int n7 = n5 - n6;
            int n8 = Math.max(dimension.width, dimension2.width);
            int n9 = n4 - n8;
            if (container.getComponentOrientation().isLeftToRight()) {
                n3 = insets.left;
                n2 = n3 + n9;
            } else {
                n2 = insets.left;
                n3 = n2 + n8;
            }
            int n10 = insets.top + n6;
            this.setBounds(this.editor, n3, insets.top, n9, n5);
            this.setBounds(this.nextButton, n2, insets.top, n8, n6);
            this.setBounds(this.previousButton, n2, n10, n8, n7);
        }

        public void addLayoutComponent(String string, Component component) {
            if ("Next".equals(string)) {
                this.nextButton = component;
            } else if ("Previous".equals(string)) {
                this.previousButton = component;
            } else if ("Editor".equals(string)) {
                this.editor = component;
            }
        }

        private Dimension preferredSize(Component component) {
            return component == null ? new Dimension(0, 0) : component.getPreferredSize();
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = this.preferredSize(this.nextButton);
            Dimension dimension2 = this.preferredSize(this.previousButton);
            Dimension dimension3 = this.preferredSize(this.editor);
            dimension3.height = (dimension3.height + 1) / 2 * 2;
            Dimension dimension4 = new Dimension(dimension3.width, dimension3.height);
            dimension4.width += Math.max(dimension.width, dimension2.width);
            Insets insets = container.getInsets();
            dimension4.width += insets.left + insets.right;
            dimension4.height += insets.top + insets.bottom;
            return dimension4;
        }
    }
}

