/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.LazyActionMap;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthInternalFrameTitlePane;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JWindow;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InternalFrameUI;
import javax.swing.plaf.UIResource;

class SynthInternalFrameUI
extends InternalFrameUI
implements SynthUI,
LazyActionMap.Loader {
    private SynthStyle style;
    protected MouseInputAdapter borderListener;
    protected PropertyChangeListener propertyChangeListener;
    protected LayoutManager internalFrameLayout;
    protected ComponentListener componentListener;
    protected MouseInputListener glassPaneDispatcher;
    protected JComponent northPane;
    protected JComponent southPane;
    protected JComponent westPane;
    protected JComponent eastPane;
    protected SynthInternalFrameTitlePane titlePane;
    protected JInternalFrame frame;
    private static DesktopManager sharedDesktopManager;
    private boolean componentListenerAdded = false;
    private Rectangle parentBounds;
    private boolean dragging = false;
    private boolean keyBindingRegistered = false;
    private boolean keyBindingActive = false;
    private InternalFrameListener internalFrameListener = null;
    private static boolean isDragging;
    static Class class$com$sun$java$swing$plaf$gtk$SynthContext;

    static {
        isDragging = false;
    }

    SynthInternalFrameUI() {
    }

    protected void createInternalFrameListener() {
        this.internalFrameListener = new BasicInternalFrameListener(this);
    }

    protected void installComponents() {
        this.setNorthPane(this.createNorthPane(this.frame));
        this.setSouthPane(this.createSouthPane(this.frame));
        this.setEastPane(this.createEastPane(this.frame));
        this.setWestPane(this.createWestPane(this.frame));
    }

    protected void installDefaults() {
        Color color;
        JComponent jComponent = (JComponent)this.frame.getContentPane();
        if (jComponent != null && (color = jComponent.getBackground()) instanceof UIResource) {
            jComponent.setBackground(null);
        }
    }

    protected void installKeyboardActions() {
        if (this.internalFrameListener == null) {
            this.createInternalFrameListener();
        }
        this.frame.addInternalFrameListener(this.internalFrameListener);
        LazyActionMap.installLazyActionMap(this.frame, this);
    }

    protected void installListeners() {
        this.borderListener = this.createBorderListener(this.frame);
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.frame.addPropertyChangeListener(this.propertyChangeListener);
        this.installMouseHandlers(this.frame);
        this.glassPaneDispatcher = this.createGlassPaneDispatcher();
        this.frame.getGlassPane().addMouseListener(this.glassPaneDispatcher);
        this.frame.getGlassPane().addMouseMotionListener(this.glassPaneDispatcher);
        this.componentListener = this.createComponentListener();
        if (this.frame.getParent() != null) {
            this.parentBounds = this.frame.getParent().getBounds();
        }
        if (this.frame.getParent() != null && !this.componentListenerAdded) {
            this.frame.getParent().addComponentListener(this.componentListener);
            this.componentListenerAdded = true;
        }
    }

    protected void setupMenuCloseKey() {
    }

    protected void setupMenuOpenKey() {
        InputMap inputMap = this.getInputMap(2);
        SwingUtilities.replaceUIInputMap(this.frame, 2, inputMap);
    }

    protected void uninstallComponents() {
        this.setNorthPane(null);
        this.setSouthPane(null);
        this.setEastPane(null);
        this.setWestPane(null);
        this.titlePane = null;
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext(this.frame, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        Icon icon = this.frame.getFrameIcon();
        if (icon instanceof UIResource) {
            this.frame.setFrameIcon(null);
        }
        this.style = null;
    }

    protected void uninstallKeyboardActions() {
        if (this.internalFrameListener != null) {
            this.frame.removeInternalFrameListener(this.internalFrameListener);
        }
        SwingUtilities.replaceUIInputMap(this.frame, 2, null);
        SwingUtilities.replaceUIActionMap(this.frame, null);
    }

    protected void uninstallListeners() {
        if (this.frame.getParent() != null && this.componentListenerAdded) {
            this.frame.getParent().removeComponentListener(this.componentListener);
            this.componentListenerAdded = false;
        }
        this.componentListener = null;
        this.frame.getGlassPane().removeMouseListener(this.glassPaneDispatcher);
        this.frame.getGlassPane().removeMouseMotionListener(this.glassPaneDispatcher);
        this.glassPaneDispatcher = null;
        this.deinstallMouseHandlers(this.frame);
        this.frame.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        this.borderListener = null;
    }

    static boolean access$400() {
        return isDragging;
    }

    public final boolean isKeyBindingActive() {
        return this.keyBindingActive;
    }

    protected final boolean isKeyBindingRegistered() {
        return this.keyBindingRegistered;
    }

    protected final void setKeyBindingActive(boolean bl2) {
        this.keyBindingActive = bl2;
    }

    protected final void setKeyBindingRegistered(boolean bl2) {
        this.keyBindingRegistered = bl2;
    }

    static boolean access$402(boolean bl2) {
        isDragging = bl2;
        return isDragging;
    }

    static boolean access$100(SynthInternalFrameUI synthInternalFrameUI) {
        return synthInternalFrameUI.componentListenerAdded;
    }

    static boolean access$300(SynthInternalFrameUI synthInternalFrameUI) {
        return synthInternalFrameUI.dragging;
    }

    static boolean access$102(SynthInternalFrameUI synthInternalFrameUI, boolean bl2) {
        synthInternalFrameUI.componentListenerAdded = bl2;
        return synthInternalFrameUI.componentListenerAdded;
    }

    static boolean access$302(SynthInternalFrameUI synthInternalFrameUI, boolean bl2) {
        synthInternalFrameUI.dragging = bl2;
        return synthInternalFrameUI.dragging;
    }

    protected LayoutManager createLayoutManager() {
        return new InternalFrameLayout(this);
    }

    protected ComponentListener createComponentListener() {
        return new ComponentHandler(this);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new InternalFramePropertyChangeListener(this);
    }

    protected DesktopManager createDesktopManager() {
        return new DefaultDesktopManager();
    }

    protected DesktopManager getDesktopManager() {
        if (this.frame.getDesktopPane() != null && this.frame.getDesktopPane().getDesktopManager() != null) {
            return this.frame.getDesktopPane().getDesktopManager();
        }
        if (sharedDesktopManager == null) {
            sharedDesktopManager = this.createDesktopManager();
        }
        return sharedDesktopManager;
    }

    InputMap createInputMap(int n2) {
        SynthContext synthContext;
        Object[] objectArray;
        if (n2 == 2 && (objectArray = (Object[])(synthContext = this.getContext(this.frame, 1)).getStyle().get(synthContext, "InternalFrame.windowBindings")) != null) {
            return LookAndFeel.makeComponentInputMap(this.frame, objectArray);
        }
        return null;
    }

    InputMap getInputMap(int n2) {
        if (n2 == 2) {
            return this.createInputMap(n2);
        }
        return null;
    }

    public JComponent getEastPane() {
        return this.eastPane;
    }

    public JComponent getNorthPane() {
        return this.northPane;
    }

    public JComponent getSouthPane() {
        return this.southPane;
    }

    public JComponent getWestPane() {
        return this.westPane;
    }

    public int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    protected void deinstallMouseHandlers(JComponent jComponent) {
        jComponent.removeMouseListener(this.borderListener);
        jComponent.removeMouseMotionListener(this.borderListener);
    }

    private void fetchStyle(JComponent jComponent) {
        Icon icon;
        SynthContext synthContext = this.getContext(jComponent, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle && ((icon = this.frame.getFrameIcon()) == null || icon instanceof UIResource)) {
            this.frame.setFrameIcon(synthContext.getStyle().getIcon(synthContext, "InternalFrame.icon"));
        }
        synthContext.dispose();
    }

    protected void installMouseHandlers(JComponent jComponent) {
        jComponent.addMouseListener(this.borderListener);
        jComponent.addMouseMotionListener(this.borderListener);
    }

    public void installUI(JComponent jComponent) {
        this.frame = (JInternalFrame)jComponent;
        this.fetchStyle(jComponent);
        this.internalFrameLayout = this.createLayoutManager();
        this.frame.setLayout(this.internalFrameLayout);
        this.installListeners();
        this.installComponents();
        this.installDefaults();
        this.installKeyboardActions();
    }

    public void setEastPane(JComponent jComponent) {
        this.eastPane = jComponent;
    }

    public void setNorthPane(JComponent jComponent) {
        if (this.northPane != null && this.northPane instanceof SynthInternalFrameTitlePane) {
            ((SynthInternalFrameTitlePane)this.northPane).uninstallListeners();
        }
        this.replacePane(this.northPane, jComponent);
        this.northPane = jComponent;
    }

    public void setSouthPane(JComponent jComponent) {
        this.southPane = jComponent;
    }

    public void setWestPane(JComponent jComponent) {
        this.westPane = jComponent;
    }

    public void uninstallUI(JComponent jComponent) {
        if (jComponent != this.frame) {
            throw new IllegalComponentStateException(this + " was asked to deinstall() " + jComponent + " when it only knows about " + this.frame + ".");
        }
        this.uninstallKeyboardActions();
        this.uninstallDefaults();
        this.uninstallComponents();
        this.uninstallListeners();
        this.frame.setCursor(Cursor.getPredefinedCursor(0));
        this.internalFrameLayout = null;
        this.frame.setLayout(null);
        this.frame = null;
    }

    protected void activateFrame(JInternalFrame jInternalFrame) {
        this.getDesktopManager().activateFrame(jInternalFrame);
    }

    protected void closeFrame(JInternalFrame jInternalFrame) {
        SynthLookAndFeel.playSound(jInternalFrame, "InternalFrame.closeSound");
        this.getDesktopManager().closeFrame(jInternalFrame);
    }

    protected void deactivateFrame(JInternalFrame jInternalFrame) {
        this.getDesktopManager().deactivateFrame(jInternalFrame);
    }

    protected void deiconifyFrame(JInternalFrame jInternalFrame) {
        if (!jInternalFrame.isMaximum()) {
            SynthLookAndFeel.playSound(jInternalFrame, "InternalFrame.restoreUpSound");
        }
        this.getDesktopManager().deiconifyFrame(jInternalFrame);
    }

    protected void iconifyFrame(JInternalFrame jInternalFrame) {
        SynthLookAndFeel.playSound(jInternalFrame, "InternalFrame.minimizeSound");
        this.getDesktopManager().iconifyFrame(jInternalFrame);
    }

    protected void maximizeFrame(JInternalFrame jInternalFrame) {
        SynthLookAndFeel.playSound(jInternalFrame, "InternalFrame.maximizeSound");
        this.getDesktopManager().maximizeFrame(jInternalFrame);
    }

    protected void minimizeFrame(JInternalFrame jInternalFrame) {
        if (!jInternalFrame.isIcon()) {
            SynthLookAndFeel.playSound(jInternalFrame, "InternalFrame.restoreDownSound");
        }
        this.getDesktopManager().minimizeFrame(jInternalFrame);
    }

    private InternalFrameListener getInternalFrameListener() {
        return this.internalFrameListener;
    }

    protected MouseInputListener createGlassPaneDispatcher() {
        return new GlassPaneDispatcher(this);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(class$com$sun$java$swing$plaf$gtk$SynthContext == null ? (class$com$sun$java$swing$plaf$gtk$SynthContext = SynthInternalFrameUI.class$("com.sun.java.swing.plaf.gtk.SynthContext")) : class$com$sun$java$swing$plaf$gtk$SynthContext, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n2);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (this.frame == jComponent) {
            return this.frame.getLayout().minimumLayoutSize(jComponent);
        }
        return new Dimension(0, 0);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if (this.frame == jComponent) {
            return this.frame.getLayout().preferredLayoutSize(jComponent);
        }
        return new Dimension(100, 100);
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
    }

    static Rectangle access$200(SynthInternalFrameUI synthInternalFrameUI) {
        return synthInternalFrameUI.parentBounds;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public void loadActionMap(JComponent jComponent, ActionMap actionMap) {
        actionMap.put("showSystemMenu", new AbstractAction(this){
            private final SynthInternalFrameUI this$0;

            public boolean isEnabled() {
                return this.this$0.isKeyBindingActive();
            }
            {
                this.this$0 = synthInternalFrameUI;
            }

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
    }

    static void access$000(SynthInternalFrameUI synthInternalFrameUI, JComponent jComponent) {
        synthInternalFrameUI.fetchStyle(jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void replacePane(JComponent jComponent, JComponent jComponent2) {
        if (jComponent != null) {
            this.deinstallMouseHandlers(jComponent);
            this.frame.remove(jComponent);
        }
        if (jComponent2 != null) {
            this.frame.add(jComponent2);
            this.installMouseHandlers(jComponent2);
        }
    }

    protected JComponent createEastPane(JInternalFrame jInternalFrame) {
        return null;
    }

    protected JComponent createNorthPane(JInternalFrame jInternalFrame) {
        this.titlePane = new SynthInternalFrameTitlePane(jInternalFrame);
        this.titlePane.setName("InternalFrame.northPane");
        return this.titlePane;
    }

    protected JComponent createSouthPane(JInternalFrame jInternalFrame) {
        return null;
    }

    protected JComponent createWestPane(JInternalFrame jInternalFrame) {
        return null;
    }

    static InternalFrameListener access$500(SynthInternalFrameUI synthInternalFrameUI) {
        return synthInternalFrameUI.internalFrameListener;
    }

    protected MouseInputAdapter createBorderListener(JInternalFrame jInternalFrame) {
        return new BorderListener(this);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthInternalFrameUI();
    }

    static Rectangle access$202(SynthInternalFrameUI synthInternalFrameUI, Rectangle rectangle) {
        synthInternalFrameUI.parentBounds = rectangle;
        return synthInternalFrameUI.parentBounds;
    }

    protected class BasicInternalFrameListener
    implements InternalFrameListener {
        private final SynthInternalFrameUI this$0;

        protected BasicInternalFrameListener(SynthInternalFrameUI synthInternalFrameUI) {
            this.this$0 = synthInternalFrameUI;
        }

        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
            if (!this.this$0.isKeyBindingRegistered()) {
                this.this$0.setKeyBindingRegistered(true);
                this.this$0.setupMenuOpenKey();
                this.this$0.setupMenuCloseKey();
            }
            if (this.this$0.isKeyBindingRegistered()) {
                this.this$0.setKeyBindingActive(true);
            }
        }

        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
            this.this$0.frame.removeInternalFrameListener(SynthInternalFrameUI.access$500(this.this$0));
        }

        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
            this.this$0.setKeyBindingActive(false);
        }

        public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
        }
    }

    protected class BorderListener
    extends MouseInputAdapter
    implements SwingConstants {
        int _x;
        int _y;
        int __x;
        int __y;
        Rectangle startingBounds;
        int resizeDir;
        protected final int RESIZE_NONE = 0;
        private boolean discardRelease;
        int resizeCornerSize;
        private final SynthInternalFrameUI this$0;

        protected BorderListener(SynthInternalFrameUI synthInternalFrameUI) {
            this.this$0 = synthInternalFrameUI;
            this.RESIZE_NONE = 0;
            this.discardRelease = false;
            this.resizeCornerSize = 16;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() > 1 && mouseEvent.getSource() == this.this$0.getNorthPane()) {
                if (this.this$0.frame.isIconifiable() && this.this$0.frame.isIcon()) {
                    try {
                        this.this$0.frame.setIcon(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else if (this.this$0.frame.isMaximizable()) {
                    if (!this.this$0.frame.isMaximum()) {
                        try {
                            this.this$0.frame.setMaximum(true);
                        }
                        catch (PropertyVetoException propertyVetoException) {}
                    } else {
                        try {
                            this.this$0.frame.setMaximum(false);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                    }
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.startingBounds == null) {
                return;
            }
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), null);
            int n2 = this._x - point.x;
            int n3 = this._y - point.y;
            Dimension dimension = this.this$0.frame.getMinimumSize();
            Dimension dimension2 = this.this$0.frame.getMaximumSize();
            if (SynthInternalFrameUI.access$300(this.this$0)) {
                if (this.this$0.frame.isMaximum() || (mouseEvent.getModifiers() & 0x10) != 16) {
                    return;
                }
                Insets insets = this.this$0.frame.getInsets();
                Dimension dimension3 = this.this$0.frame.getParent().getSize();
                int n4 = dimension3.width;
                int n5 = dimension3.height;
                int n6 = this.startingBounds.x - n2;
                int n7 = this.startingBounds.y - n3;
                if (n6 + insets.left <= -this.__x) {
                    n6 = -this.__x - insets.left;
                }
                if (n7 + insets.top <= -this.__y) {
                    n7 = -this.__y - insets.top;
                }
                if (n6 + this.__x + insets.right > n4) {
                    n6 = n4 - this.__x - insets.right;
                }
                if (n7 + this.__y + insets.bottom > n5) {
                    n7 = n5 - this.__y - insets.bottom;
                }
                this.this$0.getDesktopManager().dragFrame(this.this$0.frame, n6, n7);
                return;
            }
            if (!this.this$0.frame.isResizable()) {
                return;
            }
            int n8 = this.this$0.frame.getX();
            int n9 = this.this$0.frame.getY();
            int n10 = this.this$0.frame.getWidth();
            int n11 = this.this$0.frame.getHeight();
            SynthInternalFrameUI.access$202(this.this$0, this.this$0.frame.getParent().getBounds());
            switch (this.resizeDir) {
                case 0: {
                    return;
                }
                case 1: {
                    if (this.startingBounds.height + n3 < dimension.height) {
                        n3 = -(this.startingBounds.height - dimension.height);
                    } else if (this.startingBounds.height + n3 > dimension2.height) {
                        n3 = dimension2.height - this.startingBounds.height;
                    }
                    if (this.startingBounds.y - n3 < 0) {
                        n3 = this.startingBounds.y;
                    }
                    n8 = this.startingBounds.x;
                    n9 = this.startingBounds.y - n3;
                    n10 = this.startingBounds.width;
                    n11 = this.startingBounds.height + n3;
                    break;
                }
                case 2: {
                    if (this.startingBounds.height + n3 < dimension.height) {
                        n3 = -(this.startingBounds.height - dimension.height);
                    } else if (this.startingBounds.height + n3 > dimension2.height) {
                        n3 = dimension2.height - this.startingBounds.height;
                    }
                    if (this.startingBounds.y - n3 < 0) {
                        n3 = this.startingBounds.y;
                    }
                    if (this.startingBounds.width - n2 < dimension.width) {
                        n2 = this.startingBounds.width - dimension.width;
                    } else if (this.startingBounds.width - n2 > dimension2.width) {
                        n2 = -(dimension2.width - this.startingBounds.width);
                    }
                    if (this.startingBounds.x + this.startingBounds.width - n2 > SynthInternalFrameUI.access$200((SynthInternalFrameUI)this.this$0).width) {
                        n2 = this.startingBounds.x + this.startingBounds.width - SynthInternalFrameUI.access$200((SynthInternalFrameUI)this.this$0).width;
                    }
                    n8 = this.startingBounds.x;
                    n9 = this.startingBounds.y - n3;
                    n10 = this.startingBounds.width - n2;
                    n11 = this.startingBounds.height + n3;
                    break;
                }
                case 3: {
                    if (this.startingBounds.width - n2 < dimension.width) {
                        n2 = this.startingBounds.width - dimension.width;
                    } else if (this.startingBounds.width - n2 > dimension2.width) {
                        n2 = -(dimension2.width - this.startingBounds.width);
                    }
                    if (this.startingBounds.x + this.startingBounds.width - n2 > SynthInternalFrameUI.access$200((SynthInternalFrameUI)this.this$0).width) {
                        n2 = this.startingBounds.x + this.startingBounds.width - SynthInternalFrameUI.access$200((SynthInternalFrameUI)this.this$0).width;
                    }
                    n10 = this.startingBounds.width - n2;
                    n11 = this.startingBounds.height;
                    break;
                }
                case 4: {
                    if (this.startingBounds.width - n2 < dimension.width) {
                        n2 = this.startingBounds.width - dimension.width;
                    } else if (this.startingBounds.width - n2 > dimension2.width) {
                        n2 = -(dimension2.width - this.startingBounds.width);
                    }
                    if (this.startingBounds.x + this.startingBounds.width - n2 > SynthInternalFrameUI.access$200((SynthInternalFrameUI)this.this$0).width) {
                        n2 = this.startingBounds.x + this.startingBounds.width - SynthInternalFrameUI.access$200((SynthInternalFrameUI)this.this$0).width;
                    }
                    if (this.startingBounds.height - n3 < dimension.height) {
                        n3 = this.startingBounds.height - dimension.height;
                    } else if (this.startingBounds.height - n3 > dimension2.height) {
                        n3 = -(dimension2.height - this.startingBounds.height);
                    }
                    if (this.startingBounds.y + this.startingBounds.height - n3 > SynthInternalFrameUI.access$200((SynthInternalFrameUI)this.this$0).height) {
                        n3 = this.startingBounds.y + this.startingBounds.height - SynthInternalFrameUI.access$200((SynthInternalFrameUI)this.this$0).height;
                    }
                    n10 = this.startingBounds.width - n2;
                    n11 = this.startingBounds.height - n3;
                    break;
                }
                case 5: {
                    if (this.startingBounds.height - n3 < dimension.height) {
                        n3 = this.startingBounds.height - dimension.height;
                    } else if (this.startingBounds.height - n3 > dimension2.height) {
                        n3 = -(dimension2.height - this.startingBounds.height);
                    }
                    if (this.startingBounds.y + this.startingBounds.height - n3 > SynthInternalFrameUI.access$200((SynthInternalFrameUI)this.this$0).height) {
                        n3 = this.startingBounds.y + this.startingBounds.height - SynthInternalFrameUI.access$200((SynthInternalFrameUI)this.this$0).height;
                    }
                    n10 = this.startingBounds.width;
                    n11 = this.startingBounds.height - n3;
                    break;
                }
                case 6: {
                    if (this.startingBounds.height - n3 < dimension.height) {
                        n3 = this.startingBounds.height - dimension.height;
                    } else if (this.startingBounds.height - n3 > dimension2.height) {
                        n3 = -(dimension2.height - this.startingBounds.height);
                    }
                    if (this.startingBounds.y + this.startingBounds.height - n3 > SynthInternalFrameUI.access$200((SynthInternalFrameUI)this.this$0).height) {
                        n3 = this.startingBounds.y + this.startingBounds.height - SynthInternalFrameUI.access$200((SynthInternalFrameUI)this.this$0).height;
                    }
                    if (this.startingBounds.width + n2 < dimension.width) {
                        n2 = -(this.startingBounds.width - dimension.width);
                    } else if (this.startingBounds.width + n2 > dimension2.width) {
                        n2 = dimension2.width - this.startingBounds.width;
                    }
                    if (this.startingBounds.x - n2 < 0) {
                        n2 = this.startingBounds.x;
                    }
                    n8 = this.startingBounds.x - n2;
                    n9 = this.startingBounds.y;
                    n10 = this.startingBounds.width + n2;
                    n11 = this.startingBounds.height - n3;
                    break;
                }
                case 7: {
                    if (this.startingBounds.width + n2 < dimension.width) {
                        n2 = -(this.startingBounds.width - dimension.width);
                    } else if (this.startingBounds.width + n2 > dimension2.width) {
                        n2 = dimension2.width - this.startingBounds.width;
                    }
                    if (this.startingBounds.x - n2 < 0) {
                        n2 = this.startingBounds.x;
                    }
                    n8 = this.startingBounds.x - n2;
                    n9 = this.startingBounds.y;
                    n10 = this.startingBounds.width + n2;
                    n11 = this.startingBounds.height;
                    break;
                }
                case 8: {
                    if (this.startingBounds.width + n2 < dimension.width) {
                        n2 = -(this.startingBounds.width - dimension.width);
                    } else if (this.startingBounds.width + n2 > dimension2.width) {
                        n2 = dimension2.width - this.startingBounds.width;
                    }
                    if (this.startingBounds.x - n2 < 0) {
                        n2 = this.startingBounds.x;
                    }
                    if (this.startingBounds.height + n3 < dimension.height) {
                        n3 = -(this.startingBounds.height - dimension.height);
                    } else if (this.startingBounds.height + n3 > dimension2.height) {
                        n3 = dimension2.height - this.startingBounds.height;
                    }
                    if (this.startingBounds.y - n3 < 0) {
                        n3 = this.startingBounds.y;
                    }
                    n8 = this.startingBounds.x - n2;
                    n9 = this.startingBounds.y - n3;
                    n10 = this.startingBounds.width + n2;
                    n11 = this.startingBounds.height + n3;
                    break;
                }
                default: {
                    return;
                }
            }
            this.this$0.getDesktopManager().resizeFrame(this.this$0.frame, n8, n9, n10, n11);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.this$0.frame.setCursor(Cursor.getPredefinedCursor(0));
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (!this.this$0.frame.isResizable()) {
                return;
            }
            if (mouseEvent.getSource() == this.this$0.frame || mouseEvent.getSource() == this.this$0.getNorthPane()) {
                Insets insets = this.this$0.frame.getInsets();
                if (mouseEvent.getX() <= insets.left) {
                    if (mouseEvent.getY() < this.resizeCornerSize + insets.top) {
                        this.this$0.frame.setCursor(Cursor.getPredefinedCursor(6));
                    } else if (mouseEvent.getY() > this.this$0.frame.getHeight() - this.resizeCornerSize - insets.bottom) {
                        this.this$0.frame.setCursor(Cursor.getPredefinedCursor(4));
                    } else {
                        this.this$0.frame.setCursor(Cursor.getPredefinedCursor(10));
                    }
                } else if (mouseEvent.getX() >= this.this$0.frame.getWidth() - insets.right) {
                    if (mouseEvent.getY() < this.resizeCornerSize + insets.top) {
                        this.this$0.frame.setCursor(Cursor.getPredefinedCursor(7));
                    } else if (mouseEvent.getY() > this.this$0.frame.getHeight() - this.resizeCornerSize - insets.bottom) {
                        this.this$0.frame.setCursor(Cursor.getPredefinedCursor(5));
                    } else {
                        this.this$0.frame.setCursor(Cursor.getPredefinedCursor(11));
                    }
                } else if (mouseEvent.getY() <= insets.top) {
                    if (mouseEvent.getX() < this.resizeCornerSize + insets.left) {
                        this.this$0.frame.setCursor(Cursor.getPredefinedCursor(6));
                    } else if (mouseEvent.getX() > this.this$0.frame.getWidth() - this.resizeCornerSize - insets.right) {
                        this.this$0.frame.setCursor(Cursor.getPredefinedCursor(7));
                    } else {
                        this.this$0.frame.setCursor(Cursor.getPredefinedCursor(8));
                    }
                } else if (mouseEvent.getY() >= this.this$0.frame.getHeight() - insets.bottom) {
                    if (mouseEvent.getX() < this.resizeCornerSize + insets.left) {
                        this.this$0.frame.setCursor(Cursor.getPredefinedCursor(4));
                    } else if (mouseEvent.getX() > this.this$0.frame.getWidth() - this.resizeCornerSize - insets.right) {
                        this.this$0.frame.setCursor(Cursor.getPredefinedCursor(5));
                    } else {
                        this.this$0.frame.setCursor(Cursor.getPredefinedCursor(9));
                    }
                } else {
                    this.this$0.frame.setCursor(Cursor.getPredefinedCursor(0));
                }
                return;
            }
            this.this$0.frame.setCursor(Cursor.getPredefinedCursor(0));
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Serializable serializable;
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), null);
            this.__x = mouseEvent.getX();
            this.__y = mouseEvent.getY();
            this._x = point.x;
            this._y = point.y;
            this.startingBounds = this.this$0.frame.getBounds();
            this.resizeDir = 0;
            if (!this.this$0.frame.isSelected()) {
                try {
                    this.this$0.frame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            Insets insets = this.this$0.frame.getInsets();
            Point point2 = new Point(this.__x, this.__y);
            if (mouseEvent.getSource() == this.this$0.getNorthPane()) {
                serializable = this.this$0.getNorthPane().getLocation();
                point2.x += serializable.x;
                point2.y += serializable.y;
                if (point2.x > insets.left && point2.y > insets.top && point2.x < this.this$0.frame.getWidth() - insets.right) {
                    this.this$0.getDesktopManager().beginDraggingFrame(this.this$0.frame);
                    SynthInternalFrameUI.access$302(this.this$0, true);
                    return;
                }
            }
            if (!this.this$0.frame.isResizable()) {
                return;
            }
            if (mouseEvent.getSource() == this.this$0.frame || mouseEvent.getSource() == this.this$0.getNorthPane()) {
                if (point2.x <= insets.left) {
                    this.resizeDir = point2.y < this.resizeCornerSize + insets.top ? 8 : (point2.y > this.this$0.frame.getHeight() - this.resizeCornerSize - insets.bottom ? 6 : 7);
                } else if (point2.x >= this.this$0.frame.getWidth() - insets.right) {
                    this.resizeDir = point2.y < this.resizeCornerSize + insets.top ? 2 : (point2.y > this.this$0.frame.getHeight() - this.resizeCornerSize - insets.bottom ? 4 : 3);
                } else if (point2.y <= insets.top) {
                    this.resizeDir = point2.x < this.resizeCornerSize + insets.left ? 8 : (point2.x > this.this$0.frame.getWidth() - this.resizeCornerSize - insets.right ? 2 : 1);
                } else if (point2.y >= this.this$0.frame.getHeight() - insets.bottom) {
                    this.resizeDir = point2.x < this.resizeCornerSize + insets.left ? 6 : (point2.x > this.this$0.frame.getWidth() - this.resizeCornerSize - insets.right ? 4 : 5);
                } else {
                    this.discardRelease = true;
                    return;
                }
                serializable = Cursor.getPredefinedCursor(0);
                switch (this.resizeDir) {
                    case 5: {
                        serializable = Cursor.getPredefinedCursor(9);
                        break;
                    }
                    case 1: {
                        serializable = Cursor.getPredefinedCursor(8);
                        break;
                    }
                    case 7: {
                        serializable = Cursor.getPredefinedCursor(10);
                        break;
                    }
                    case 3: {
                        serializable = Cursor.getPredefinedCursor(11);
                        break;
                    }
                    case 4: {
                        serializable = Cursor.getPredefinedCursor(5);
                        break;
                    }
                    case 6: {
                        serializable = Cursor.getPredefinedCursor(4);
                        break;
                    }
                    case 8: {
                        serializable = Cursor.getPredefinedCursor(6);
                        break;
                    }
                    case 2: {
                        serializable = Cursor.getPredefinedCursor(7);
                    }
                }
                Container container = this.this$0.frame.getTopLevelAncestor();
                if (container instanceof JFrame) {
                    ((JFrame)container).getGlassPane().setVisible(true);
                    ((JFrame)container).getGlassPane().setCursor((Cursor)serializable);
                } else if (container instanceof JApplet) {
                    ((JApplet)container).getGlassPane().setVisible(true);
                    ((JApplet)container).getGlassPane().setCursor((Cursor)serializable);
                } else if (container instanceof JWindow) {
                    ((JWindow)container).getGlassPane().setVisible(true);
                    ((JWindow)container).getGlassPane().setCursor((Cursor)serializable);
                } else if (container instanceof JDialog) {
                    ((JDialog)container).getGlassPane().setVisible(true);
                    ((JDialog)container).getGlassPane().setCursor((Cursor)serializable);
                }
                this.this$0.getDesktopManager().beginResizingFrame(this.this$0.frame, this.resizeDir);
                return;
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.discardRelease) {
                this.discardRelease = false;
                return;
            }
            if (this.resizeDir == 0) {
                this.this$0.getDesktopManager().endDraggingFrame(this.this$0.frame);
                SynthInternalFrameUI.access$302(this.this$0, false);
            } else {
                Container container = this.this$0.frame.getTopLevelAncestor();
                if (container instanceof JFrame) {
                    ((JFrame)this.this$0.frame.getTopLevelAncestor()).getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
                    ((JFrame)this.this$0.frame.getTopLevelAncestor()).getGlassPane().setVisible(false);
                } else if (container instanceof JApplet) {
                    ((JApplet)container).getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
                    ((JApplet)container).getGlassPane().setVisible(false);
                } else if (container instanceof JWindow) {
                    ((JWindow)container).getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
                    ((JWindow)container).getGlassPane().setVisible(false);
                } else if (container instanceof JDialog) {
                    ((JDialog)container).getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
                    ((JDialog)container).getGlassPane().setVisible(false);
                }
                this.this$0.getDesktopManager().endResizingFrame(this.this$0.frame);
            }
            this._x = 0;
            this._y = 0;
            this.__x = 0;
            this.__y = 0;
            this.startingBounds = null;
            this.resizeDir = 0;
        }
    }

    protected class ComponentHandler
    implements ComponentListener {
        private final SynthInternalFrameUI this$0;

        protected ComponentHandler(SynthInternalFrameUI synthInternalFrameUI) {
            this.this$0 = synthInternalFrameUI;
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentResized(ComponentEvent componentEvent) {
            Rectangle rectangle = ((Component)componentEvent.getSource()).getBounds();
            Component component = null;
            if (this.this$0.frame != null) {
                component = this.this$0.frame.getDesktopIcon();
                if (this.this$0.frame.isMaximum()) {
                    this.this$0.frame.setBounds(0, 0, rectangle.width, rectangle.height);
                }
            }
            if (component != null) {
                Rectangle rectangle2 = component.getBounds();
                int n2 = rectangle2.y + (rectangle.height - SynthInternalFrameUI.access$200((SynthInternalFrameUI)this.this$0).height);
                component.setBounds(rectangle2.x, n2, rectangle2.width, rectangle2.height);
            }
            if (!SynthInternalFrameUI.access$200(this.this$0).equals(rectangle)) {
                SynthInternalFrameUI.access$202(this.this$0, rectangle);
            }
            if (this.this$0.frame != null) {
                this.this$0.frame.validate();
            }
        }

        public void componentShown(ComponentEvent componentEvent) {
        }
    }

    protected class GlassPaneDispatcher
    implements MouseInputListener {
        private Component mouseEventTarget;
        private Component dragSource;
        private final SynthInternalFrameUI this$0;

        protected GlassPaneDispatcher(SynthInternalFrameUI synthInternalFrameUI) {
            this.this$0 = synthInternalFrameUI;
            this.mouseEventTarget = null;
            this.dragSource = null;
        }

        private void forwardMouseEvent(MouseEvent mouseEvent) {
            Component component = this.findComponentAt(this.this$0.frame.getRootPane().getLayeredPane(), mouseEvent.getX(), mouseEvent.getY());
            int n2 = mouseEvent.getID();
            switch (n2) {
                case 504: {
                    if (SynthInternalFrameUI.access$400() && !this.this$0.frame.isSelected()) {
                        return;
                    }
                    if (component != this.mouseEventTarget) {
                        this.mouseEventTarget = component;
                    }
                    this.retargetMouseEvent(n2, mouseEvent, this.mouseEventTarget);
                    break;
                }
                case 501: {
                    if (component != this.mouseEventTarget) {
                        this.mouseEventTarget = component;
                    }
                    this.retargetMouseEvent(n2, mouseEvent, this.mouseEventTarget);
                    this.dragSource = component;
                    break;
                }
                case 505: {
                    if (SynthInternalFrameUI.access$400() && !this.this$0.frame.isSelected()) {
                        return;
                    }
                    this.retargetMouseEvent(n2, mouseEvent, this.mouseEventTarget);
                    break;
                }
                case 500: {
                    this.retargetMouseEvent(n2, mouseEvent, this.mouseEventTarget);
                    break;
                }
                case 503: {
                    if (component != this.mouseEventTarget) {
                        this.retargetMouseEvent(505, mouseEvent, this.mouseEventTarget);
                        this.mouseEventTarget = component;
                        this.retargetMouseEvent(504, mouseEvent, this.mouseEventTarget);
                    }
                    this.retargetMouseEvent(n2, mouseEvent, this.mouseEventTarget);
                    break;
                }
                case 506: {
                    if (!SynthInternalFrameUI.access$400()) {
                        SynthInternalFrameUI.access$402(true);
                    }
                    this.retargetMouseEvent(n2, mouseEvent, this.dragSource);
                    break;
                }
                case 502: {
                    if (SynthInternalFrameUI.access$400()) {
                        this.retargetMouseEvent(n2, mouseEvent, this.dragSource);
                        SynthInternalFrameUI.access$402(false);
                        break;
                    }
                    this.retargetMouseEvent(n2, mouseEvent, this.mouseEventTarget);
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.forwardMouseEvent(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.forwardMouseEvent(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.forwardMouseEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.forwardMouseEvent(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (this.this$0.borderListener != null) {
                this.this$0.borderListener.mousePressed(mouseEvent);
            }
            this.forwardMouseEvent(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.forwardMouseEvent(mouseEvent);
        }

        private Component findComponentAt(Container container, int n2, int n3) {
            if (!container.contains(n2, n3)) {
                return container;
            }
            int n4 = container.getComponentCount();
            Component[] componentArray = container.getComponents();
            for (int i2 = 0; i2 < n4; ++i2) {
                Component component = componentArray[i2];
                Point point = component.getLocation();
                if (component == null || !component.contains(n2 - point.x, n3 - point.y) || !(component.getPeer() instanceof LightweightPeer) || !component.isVisible()) continue;
                if (component instanceof Container) {
                    Container container2 = (Container)component;
                    Point point2 = container2.getLocation();
                    Component component2 = this.findComponentAt(container2, n2 - point2.x, n3 - point2.y);
                    if (component2 == null) continue;
                    return component2;
                }
                return component;
            }
            return container;
        }

        private void retargetMouseEvent(int n2, MouseEvent mouseEvent, Component component) {
            if (component == null) {
                return;
            }
            Point point = SwingUtilities.convertPoint(this.this$0.frame.getLayeredPane(), mouseEvent.getX(), mouseEvent.getY(), component);
            MouseEvent mouseEvent2 = new MouseEvent(component, n2, mouseEvent.getWhen(), mouseEvent.getModifiers() | mouseEvent.getModifiersEx(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            component.dispatchEvent(mouseEvent2);
        }
    }

    class InternalFrameLayout
    implements LayoutManager {
        private final SynthInternalFrameUI this$0;

        InternalFrameLayout(SynthInternalFrameUI synthInternalFrameUI) {
            this.this$0 = synthInternalFrameUI;
        }

        public void removeLayoutComponent(Component component) {
        }

        public void layoutContainer(Container container) {
            Dimension dimension;
            Insets insets = this.this$0.frame.getInsets();
            int n2 = insets.left;
            int n3 = 0;
            int n4 = this.this$0.frame.getWidth() - insets.left - insets.right;
            int n5 = this.this$0.frame.getHeight() - insets.bottom;
            if (this.this$0.getNorthPane() != null) {
                dimension = this.this$0.getNorthPane().getPreferredSize();
                this.this$0.getNorthPane().setBounds(0, 0, this.this$0.frame.getWidth(), dimension.height);
                n3 += dimension.height;
                n5 -= dimension.height;
            }
            if (this.this$0.getSouthPane() != null) {
                dimension = this.this$0.getSouthPane().getPreferredSize();
                this.this$0.getSouthPane().setBounds(n2, this.this$0.frame.getHeight() - insets.bottom - dimension.height, n4, dimension.height);
                n5 -= dimension.height;
            }
            if (this.this$0.getWestPane() != null) {
                dimension = this.this$0.getWestPane().getPreferredSize();
                this.this$0.getWestPane().setBounds(n2, n3, dimension.width, n5);
                n4 -= dimension.width;
                n2 += dimension.width;
            }
            if (this.this$0.getEastPane() != null) {
                dimension = this.this$0.getEastPane().getPreferredSize();
                this.this$0.getEastPane().setBounds(n4 - dimension.width, n3, dimension.width, n5);
                n4 -= dimension.width;
            }
            if (this.this$0.frame.getRootPane() != null) {
                this.this$0.frame.getRootPane().setBounds(n2, n3, n4, n5);
            }
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension = new Dimension();
            if (this.this$0.getNorthPane() != null && this.this$0.getNorthPane() instanceof SynthInternalFrameTitlePane) {
                dimension = new Dimension(this.this$0.getNorthPane().getMinimumSize());
            }
            Insets insets = this.this$0.frame.getInsets();
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            return dimension;
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension;
            Insets insets = this.this$0.frame.getInsets();
            Dimension dimension2 = new Dimension(this.this$0.frame.getRootPane().getPreferredSize());
            dimension2.width += insets.left + insets.right;
            dimension2.height += insets.top + insets.bottom;
            if (this.this$0.getNorthPane() != null) {
                dimension = this.this$0.getNorthPane().getPreferredSize();
                dimension2.width = Math.max(dimension.width, dimension2.width);
                dimension2.height += dimension.height;
            }
            if (this.this$0.getSouthPane() != null) {
                dimension = this.this$0.getSouthPane().getPreferredSize();
                dimension2.width = Math.max(dimension.width, dimension2.width);
                dimension2.height += dimension.height;
            }
            if (this.this$0.getEastPane() != null) {
                dimension = this.this$0.getEastPane().getPreferredSize();
                dimension2.width += dimension.width;
                dimension2.height = Math.max(dimension.height, dimension2.height);
            }
            if (this.this$0.getWestPane() != null) {
                dimension = this.this$0.getWestPane().getPreferredSize();
                dimension2.width += dimension.width;
                dimension2.height = Math.max(dimension.height, dimension2.height);
            }
            return dimension2;
        }
    }

    class InternalFramePropertyChangeListener
    implements PropertyChangeListener {
        private final SynthInternalFrameUI this$0;

        InternalFramePropertyChangeListener(SynthInternalFrameUI synthInternalFrameUI) {
            this.this$0 = synthInternalFrameUI;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            JInternalFrame jInternalFrame = (JInternalFrame)propertyChangeEvent.getSource();
            Object object = propertyChangeEvent.getNewValue();
            Object object2 = propertyChangeEvent.getOldValue();
            if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
                SynthInternalFrameUI.access$000(this.this$0, (JInternalFrame)propertyChangeEvent.getSource());
            }
            if ("closed".equals(string)) {
                if (object == Boolean.TRUE) {
                    if (this.this$0.frame.getParent() != null && SynthInternalFrameUI.access$100(this.this$0)) {
                        this.this$0.frame.getParent().removeComponentListener(this.this$0.componentListener);
                    }
                    this.this$0.closeFrame(jInternalFrame);
                }
            } else if ("maximum".equals(string)) {
                if (object == Boolean.TRUE) {
                    this.this$0.maximizeFrame(jInternalFrame);
                } else {
                    this.this$0.minimizeFrame(jInternalFrame);
                }
            } else if ("icon".equals(string)) {
                if (object == Boolean.TRUE) {
                    this.this$0.iconifyFrame(jInternalFrame);
                } else {
                    this.this$0.deiconifyFrame(jInternalFrame);
                }
            } else if ("selected".equals(string)) {
                Component component = jInternalFrame.getGlassPane();
                if (object == Boolean.TRUE && object2 == Boolean.FALSE) {
                    this.this$0.activateFrame(jInternalFrame);
                    component.setVisible(false);
                } else if (object == Boolean.FALSE && object2 == Boolean.TRUE) {
                    this.this$0.deactivateFrame(jInternalFrame);
                    component.setVisible(true);
                }
            } else if (string.equals("ancestor")) {
                if (this.this$0.frame.getParent() != null) {
                    SynthInternalFrameUI.access$202(this.this$0, jInternalFrame.getParent().getBounds());
                } else {
                    SynthInternalFrameUI.access$202(this.this$0, null);
                }
                if (this.this$0.frame.getParent() != null && !SynthInternalFrameUI.access$100(this.this$0)) {
                    jInternalFrame.getParent().addComponentListener(this.this$0.componentListener);
                    SynthInternalFrameUI.access$102(this.this$0, true);
                } else if (object == null && SynthInternalFrameUI.access$100(this.this$0)) {
                    if (jInternalFrame.getParent() != null) {
                        jInternalFrame.getParent().removeComponentListener(this.this$0.componentListener);
                    }
                    SynthInternalFrameUI.access$102(this.this$0, false);
                }
            } else if ("title".equals(string) || string.equals("closable") || string.equals("iconable") || string.equals("maximizable")) {
                Dimension dimension = this.this$0.frame.getMinimumSize();
                Dimension dimension2 = this.this$0.frame.getSize();
                if (dimension.width > dimension2.width) {
                    this.this$0.frame.setSize(dimension.width, dimension2.height);
                }
            }
        }
    }
}

