/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.ColorType;
import com.sun.java.swing.plaf.gtk.GTKColorType;
import com.sun.java.swing.plaf.gtk.GTKStyle;
import com.sun.java.swing.plaf.gtk.MetacityBluecurve;
import com.sun.java.swing.plaf.gtk.MetacityCrux;
import com.sun.java.swing.plaf.gtk.SynthConstants;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;

abstract class Metacity
implements SynthConstants {
    static Metacity INSTANCE;
    private FrameGeometry geometry;
    private static LayoutManager titlePaneLayout;
    private ColorizeImageFilter imageFilter = new ColorizeImageFilter(this);
    protected String themeDir = null;
    protected SynthContext context;

    static {
        String string = null;
        String string2 = Metacity.getUserTheme();
        if (string2 == null) {
            string2 = "Bluecurve";
            string = Metacity.getThemeDir(string2);
            if (string == null) {
                string2 = "Crux";
                string = Metacity.getThemeDir(string2);
            }
            if (string == null) {
                string2 = null;
            }
        }
        if (string2 != null && string == null) {
            string = Metacity.getThemeDir(string2);
        }
        if (string != null) {
            if (string2.equals("Bluecurve")) {
                INSTANCE = new MetacityBluecurve(string);
            } else if (string2.equals("Crux")) {
                INSTANCE = new MetacityCrux(string);
            }
        }
        if (INSTANCE == null) {
            INSTANCE = new MetacityCrux(null);
        }
        titlePaneLayout = new TitlePaneLayout();
    }

    protected FrameGeometry getFrameGeometry() {
        return this.geometry;
    }

    public static LayoutManager getTitlePaneLayout() {
        return titlePaneLayout;
    }

    private static String getUserTheme() {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    int n2;
                    int n3;
                    String string = System.getProperty("swing.metacitythemename");
                    if (string != null) {
                        return string;
                    }
                    String string2 = System.getProperty("user.home");
                    URL uRL = new URL("file:" + string2 + "/.gconf/apps/metacity/general/%25gconf.xml");
                    InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream(), "ISO-8859-1");
                    char[] cArray = new char[1024];
                    StringBuffer stringBuffer = new StringBuffer();
                    while ((n3 = inputStreamReader.read(cArray)) >= 0) {
                        stringBuffer.append(cArray, 0, n3);
                    }
                    ((Reader)inputStreamReader).close();
                    String string3 = stringBuffer.toString();
                    if (string3 != null && (n2 = string3.toLowerCase().indexOf("<entry name=\"theme\"")) >= 0 && (n2 = string3.toLowerCase().indexOf("<stringvalue>", n2)) > 0) {
                        int n4 = string3.indexOf("<", n2 += "<stringvalue>".length());
                        return string3.substring(n2, n4);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    protected Metacity(String string, FrameGeometry frameGeometry) {
        this.themeDir = string;
        this.geometry = frameGeometry;
    }

    protected void setFrameGeometry(JComponent jComponent, FrameGeometry frameGeometry) {
        this.geometry = frameGeometry;
        if (frameGeometry.top_height == 0) {
            frameGeometry.top_height = jComponent.getHeight();
        }
    }

    protected Color getColor(int n2, ColorType colorType) {
        return ((GTKStyle)this.context.getStyle()).getGTKColor(this.context.getComponent(), this.context.getRegion(), n2, colorType);
    }

    protected static Color shadeColor(Color color, float f2) {
        return GTKColorType.adjustColor(color, 1.0f, f2, f2);
    }

    protected void tintRect(Graphics graphics, int n2, int n3, int n4, int n5, Color color, float f2) {
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, f2);
            graphics2D.setComposite(alphaComposite);
            graphics2D.setColor(color);
            graphics2D.fillRect(n2, n3, n4, n5);
            graphics2D.setComposite(composite);
        }
    }

    abstract void paintButtonBackground(SynthContext var1, Graphics var2, int var3, int var4, int var5, int var6);

    abstract void paintFrameBorder(SynthContext var1, Graphics var2, int var3, int var4, int var5, int var6);

    protected void tileImage(Graphics graphics, Image image, int n2, int n3, int n4, int n5, float[] fArray) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        int n6 = image.getWidth(null);
        int n7 = image.getHeight(null);
        for (int i2 = n3; i2 < n3 + n5; i2 += n7) {
            int n8;
            n7 = Math.min(n7, n3 + n5 - i2);
            for (int i3 = n2; i3 < n2 + n4; i3 += n8) {
                float f2 = ((float)fArray.length - 1.0f) * (float)i3 / (float)(n2 + n4);
                int n9 = (int)f2;
                f2 -= (float)((int)f2);
                float f3 = (1.0f - f2) * fArray[n9] + f2 * fArray[n9 + 1];
                graphics2D.setComposite(AlphaComposite.getInstance(3, f3));
                n8 = Math.min(n6, n2 + n4 - i3);
                graphics.drawImage(image, i3, i2, i3 + n8, i2 + n7, 0, 0, n8, n7, null);
            }
        }
        graphics2D.setComposite(composite);
    }

    private static String getThemeDir(String string) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(string){
            private final String val$theme;

            public Object run() {
                String[] stringArray = new String[]{"/usr/share/themes/" + this.val$theme + "/metacity-1", "/usr/gnome/share/themes/" + this.val$theme + "/metacity-1", "/opt/gnome2/share/themes/" + this.val$theme + "/metacity-1"};
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    if (!new File(stringArray[i2], "metacity-theme-1.xml").canRead()) continue;
                    return stringArray[i2];
                }
                return null;
            }
            {
                this.val$theme = string;
            }
        });
    }

    protected Color blendColor(Color color, Color color2, float f2) {
        return new Color((int)((float)color.getRed() + (float)(color2.getRed() - color.getRed()) * f2), (int)((float)color.getRed() + (float)(color2.getRed() - color.getRed()) * f2), (int)((float)color.getRed() + (float)(color2.getRed() - color.getRed()) * f2));
    }

    protected void drawDiagonalGradient(Graphics graphics, Color color, Color color2, int n2, int n3, int n4, int n5) {
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(new GradientPaint(n2, n3, color, n2 + n4, n3 + n5, color2));
            graphics2D.fillRect(n2, n3, n4, n5);
        }
    }

    protected void drawVerticalGradient(Graphics graphics, Color color, Color color2, int n2, int n3, int n4, int n5) {
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(new GradientPaint(n2, n3, color, n2, n3 + n5, color2));
            graphics2D.fillRect(n2, n3, n4, n5);
        }
    }

    protected void drawDiagonalGradient(Graphics graphics, Color color, Color color2, int n2, int n3, int n4, int n5, float f2) {
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, f2);
            graphics2D.setComposite(alphaComposite);
            graphics2D.setPaint(new GradientPaint(n2, n3, color, n2 + n4, n3 + n5, color2));
            graphics2D.fillRect(n2, n3, n4, n5);
            graphics2D.setComposite(composite);
        }
    }

    protected void drawVerticalGradient(Graphics graphics, Color color, Color color2, int n2, int n3, int n4, int n5, float f2) {
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, f2);
            graphics2D.setComposite(alphaComposite);
            graphics2D.setPaint(new GradientPaint(n2, n3, color, n2, n3 + n5, color2));
            graphics2D.fillRect(n2, n3, n4, n5);
            graphics2D.setComposite(composite);
        }
    }

    protected Image colorizeImage(Image image, Color color) {
        return this.imageFilter.colorize(image, color);
    }

    abstract Insets getBorderInsets(SynthContext var1, Insets var2);

    protected static JComponent findChild(JComponent jComponent, String string) {
        int n2 = jComponent.getComponentCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            JComponent jComponent2 = (JComponent)jComponent.getComponent(i2);
            if (!string.equals(jComponent2.getName())) continue;
            return jComponent2;
        }
        return null;
    }

    protected void drawVerticalGradient(Graphics graphics, Color color, Color color2, Color color3, int n2, int n3, int n4, int n5) {
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(new GradientPaint(n2, n3, color, n2, n3 + n5 / 2, color2));
            graphics2D.fillRect(n2, n3, n4, n5 / 2);
            graphics2D.setPaint(new GradientPaint(n2, n3 + n5 / 2, color2, n2, n3 + n5, color3));
            graphics2D.fillRect(n2, n3 + n5 / 2, n4, n5 / 2);
        }
    }

    private class ColorizeImageFilter
    extends RGBImageFilter {
        double cr;
        double cg;
        double cb;
        private final Metacity this$0;

        public int filterRGB(int n2, int n3, int n4) {
            double d2;
            double d3;
            double d4;
            double d5 = (double)(2 * (n4 & 0xFF)) / 255.0;
            if (d5 <= 1.0) {
                d4 = this.cr * d5;
                d3 = this.cg * d5;
                d2 = this.cb * d5;
            } else {
                d4 = this.cr + (1.0 - this.cr) * (d5 -= 1.0);
                d3 = this.cg + (1.0 - this.cg) * d5;
                d2 = this.cb + (1.0 - this.cb) * d5;
            }
            return (n4 & 0xFF000000) + ((int)(d4 * 255.0) << 16) + ((int)(d3 * 255.0) << 8) + (int)(d2 * 255.0);
        }

        public ColorizeImageFilter(Metacity metacity) {
            this.this$0 = metacity;
            this.canFilterIndexColorModel = true;
        }

        public void setColor(Color color) {
            this.cr = (double)color.getRed() / 255.0;
            this.cg = (double)color.getGreen() / 255.0;
            this.cb = (double)color.getBlue() / 255.0;
        }

        public Image colorize(Image image, Color color) {
            this.setColor(color);
            FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), this);
            return new ImageIcon(this.this$0.context.getComponent().createImage(filteredImageSource)).getImage();
        }
    }

    protected static class FrameGeometry {
        int left_width;
        int right_width;
        int top_height;
        int bottom_height;
        int left_titlebar_edge;
        int right_titlebar_edge;
        float aspect_ratio;
        int title_vertical_pad;
        Insets title_border;
        Insets button_border;

        protected FrameGeometry() {
        }
    }

    protected static class TitlePaneLayout
    implements LayoutManager {
        protected TitlePaneLayout() {
        }

        public void removeLayoutComponent(Component component) {
        }

        public void layoutContainer(Container container) {
            JInternalFrame jInternalFrame;
            JComponent jComponent = (JComponent)container;
            Container container2 = jComponent.getParent();
            if (container2 instanceof JInternalFrame) {
                jInternalFrame = (JInternalFrame)container2;
            } else if (container2 instanceof JInternalFrame.JDesktopIcon) {
                jInternalFrame = ((JInternalFrame.JDesktopIcon)container2).getInternalFrame();
            } else {
                return;
            }
            boolean bl2 = SynthLookAndFeel.isLeftToRight(jInternalFrame);
            FrameGeometry frameGeometry = INSTANCE.getFrameGeometry();
            int n2 = jComponent.getWidth();
            int n3 = jComponent.getHeight();
            JComponent jComponent2 = Metacity.findChild(jComponent, "InternalFrameTitlePane.menuButton");
            JComponent jComponent3 = Metacity.findChild(jComponent, "InternalFrameTitlePane.iconifyButton");
            JComponent jComponent4 = Metacity.findChild(jComponent, "InternalFrameTitlePane.maximizeButton");
            JComponent jComponent5 = Metacity.findChild(jComponent, "InternalFrameTitlePane.closeButton");
            int n4 = 0;
            int n5 = n3 - frameGeometry.title_border.top - frameGeometry.title_border.bottom;
            int n6 = (int)((float)n5 / frameGeometry.aspect_ratio);
            Icon icon = jInternalFrame.getFrameIcon();
            int n7 = icon != null ? icon.getIconHeight() : n5;
            int n8 = bl2 ? frameGeometry.left_titlebar_edge : n2 - n6 - frameGeometry.right_titlebar_edge;
            int n9 = frameGeometry.title_border.top;
            jComponent2.setBounds(n8, n9, n6, n5);
            int n10 = n8 = bl2 ? n2 - n6 - frameGeometry.right_titlebar_edge : frameGeometry.left_titlebar_edge;
            if (jInternalFrame.isClosable()) {
                jComponent5.setBounds(n8, n9, n6, n5);
                n8 += bl2 ? -(n6 + n4) : n6 + n4;
            }
            if (jInternalFrame.isMaximizable()) {
                jComponent4.setBounds(n8, n9, n6, n5);
                n8 += bl2 ? -(n6 + n4) : n6 + n4;
            }
            if (jInternalFrame.isIconifiable()) {
                jComponent3.setBounds(n8, n9, n6, n5);
            }
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            int n2;
            int n3;
            JInternalFrame jInternalFrame;
            JComponent jComponent = (JComponent)container;
            Container container2 = jComponent.getParent();
            if (container2 instanceof JInternalFrame) {
                jInternalFrame = (JInternalFrame)container2;
            } else if (container2 instanceof JInternalFrame.JDesktopIcon) {
                jInternalFrame = ((JInternalFrame.JDesktopIcon)container2).getInternalFrame();
            } else {
                return null;
            }
            FrameGeometry frameGeometry = INSTANCE.getFrameGeometry();
            int n4 = 22;
            if (jInternalFrame.isClosable()) {
                n4 += 19;
            }
            if (jInternalFrame.isMaximizable()) {
                n4 += 19;
            }
            if (jInternalFrame.isIconifiable()) {
                n4 += 19;
            }
            FontMetrics fontMetrics = jComponent.getFontMetrics(jComponent.getFont());
            String string = jInternalFrame.getTitle();
            int n5 = string != null ? fontMetrics.stringWidth(string) : 0;
            int n6 = n3 = string != null ? string.length() : 0;
            n4 = n3 > 3 ? (n4 += n5 < (n2 = fontMetrics.stringWidth(string.substring(0, 3) + "...")) ? n5 : n2) : (n4 += n5);
            Icon icon = jInternalFrame.getFrameIcon();
            int n7 = fontMetrics.getHeight() + frameGeometry.title_vertical_pad + frameGeometry.title_border.top + frameGeometry.title_border.bottom;
            int n8 = 0;
            if (icon != null) {
                n8 = Math.min(icon.getIconHeight(), 16);
            }
            int n9 = Math.max(n7, n8 + 2);
            return new Dimension(n4, n9);
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }
    }
}

